/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.alibaba.fastjson.TypeReference;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.DebugService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.request.BarriergateOperRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.EnterDebugRequest;
import com.icetech.cloudcenter.domain.request.ExitDebugRequest;
import com.icetech.cloudcenter.domain.request.PayDebugRequest;
import com.icetech.cloudcenter.domain.request.ShowSayDebugRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PlateColorEnum;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.flow.p2c.impl.CarExitFlowProcessImpl;
import com.icetech.park.service.handle.showsay.DownShowSayHandle;
import com.icetech.park.service.impl.base.ManageServiceBase;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.park.service.report.p2c.impl.exit.CarExitBaseHandler;
import com.icetech.third.utils.RedisUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DebugServiceImpl
extends ManageServiceBase
implements DebugService {
    private static final Logger log = LoggerFactory.getLogger(DebugServiceImpl.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private CarExitBaseHandler carExitBaseHandler;
    @Autowired
    private CarExitFlowProcessImpl carExitFlowProcess;
    @Autowired
    @Qualifier(value="p2cRemoteSwitchServiceImpl")
    private P2cRemoteSwitchServiceImpl p2c_remoteSwitchService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    protected DownShowSayHandle downShowSayHandle;
    @Autowired
    protected P2cRemoteSwitchServiceImpl remoteSwitchService;

    public ObjectResponse enterDebug(EnterDebugRequest enterDebugRequest, String topic) {
        String msgId;
        String serialNumber;
        String parkCode = enterDebugRequest.getParkCode();
        String plateNum = enterDebugRequest.getPlateNum();
        try {
            serialNumber = this.cacheHandle.getSerialNumber(parkCode, enterDebugRequest.getAisleCode());
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        Long parkId = this.getParkId(parkCode);
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, enterDebugRequest.getAisleCode());
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        ObjectResponse.notError((Response)channelResp);
        if (enterDebugRequest.getType() == 1 && channel.getIsAllowTempcarrun() != null && channel.getIsAllowTempcarrun() == 0) {
            ObjectResponse objectResponse2 = this.downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, enterDebugRequest.getType(), FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, null, serialNumber, 1, enterDebugRequest.getAisleCode(), true);
            if (!ObjectResponse.isSuccess((Response)objectResponse2)) {
                return ObjectResponse.failed((String)"3003");
            }
            return ObjectResponse.success();
        }
        if (enterDebugRequest.getIsOpen().equals(1) && (msgId = this.p2c_remoteSwitchService.open(SwitchTypeEnum.\u5f00\u95f8.getType(), parkId, enterDebugRequest.getParkCode(), serialNumber, enterDebugRequest.getPlateNum())) == null) {
            log.info("<\u5e73\u53f0\u5165\u573a> \u5f00\u95f8\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25");
            return ObjectResponse.failed((String)"3002");
        }
        FlowCondition.ResultCode resultCode = null;
        HashMap<String, Object> para = new HashMap<String, Object>();
        if (enterDebugRequest.getType() == 1) {
            resultCode = FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165;
        } else if (enterDebugRequest.getType() == 2) {
            resultCode = FlowCondition.ResultCode.\u6708\u5361\u8f66;
        } else if (enterDebugRequest.getType() == 3) {
            resultCode = FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165;
        } else if (enterDebugRequest.getType() == 4) {
            resultCode = FlowCondition.ResultCode.VIP\u8f66\u8f86;
        } else {
            para.put("isShow", 1);
            resultCode = FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66;
        }
        ObjectResponse objectResponse = this.downShowSayHandle.showSayExec(parkId, parkCode, channel.getId(), plateNum, enterDebugRequest.getType(), resultCode, para, serialNumber, 1, serialNumber, true);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)"3003");
        }
        DataEnterRequest enterRequest = new DataEnterRequest();
        BeanUtils.copyProperties((Object)enterDebugRequest, (Object)enterRequest);
        enterRequest.setCarType(Integer.valueOf(1));
        enterRequest.setDebug(true);
        ObjectResponse<Void> objectResponse1 = this.enter(enterRequest, parkCode, serialNumber, parkId, plateNum, topic);
        if ("12002".equals(objectResponse1.getCode())) {
            String messageId = objectResponse1.getMsg();
            ObjectResponse objectResponse2 = (ObjectResponse)AsyncNotifyInterface.wait((String)messageId, (Long)4000L, () -> (ObjectResponse)this.redisUtils.get(AsyncNotifyInterface.getMessageKey((String)messageId), (TypeReference)new TypeReference<ObjectResponse<Object>>(){}));
            if (objectResponse2 == null) {
                return ObjectResponse.failed((String)"500", (String)"\u5165\u573a\u5931\u8d25");
            }
            return ObjectResponse.instance((String)objectResponse2.getCode(), (Object)objectResponse2.getMsg());
        }
        return objectResponse1;
    }

    public ObjectResponse exitDebug(ExitDebugRequest exitDebugRequest) {
        String msgId;
        Integer type = exitDebugRequest.getType();
        String parkCode = exitDebugRequest.getParkCode();
        String aisleCode = exitDebugRequest.getAisleCode();
        String plateNum = exitDebugRequest.getPlateNum();
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        Long parkId = park.getId();
        ObjectResponse inOutDeviceByCode = this.parkService.getInOutDeviceByCode(parkId, aisleCode);
        ObjectResponse.notError((Response)inOutDeviceByCode);
        ParkInoutdevice channel = (ParkInoutdevice)inOutDeviceByCode.getData();
        String inandoutName = channel.getInandoutName();
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(parkId);
        if (!ObjectResponse.isSuccess((Response)parkConfigObjectResponse)) {
            return ObjectResponse.failed((String)"500", (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u672a\u4fdd\u5b58");
        }
        String serialNumber = null;
        try {
            serialNumber = this.cacheHandle.getSerialNumber(parkCode, aisleCode);
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        boolean isSpecialCarFree = true;
        ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        if (parkConfig.getIsfreeSpecialcar() == 0) {
            isSpecialCarFree = false;
        }
        FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
        CarExitRequest exitRequest = new CarExitRequest();
        exitRequest.setParkCode(parkCode);
        exitRequest.setInandoutCode(aisleCode);
        exitRequest.setInandoutName(inandoutName);
        exitRequest.setPlateNum(plateNum);
        exitRequest.setParkId(parkId);
        long exitTime = DateTools.unixTimestamp();
        exitRequest.setExitTime(Long.valueOf(exitTime));
        exitRequest.setCarType(Integer.valueOf(1));
        boolean isInPark = true;
        long parkTime = 0L;
        ObjectResponse orderInfoObjectResponse = this.orderService.findInPark(plateNum, parkCode);
        if (ObjectResponse.isSuccess((Response)orderInfoObjectResponse)) {
            OrderInfo orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
            exitRequest.setOrderNum(orderInfo.getOrderNum());
            exitRequest.setCarType(((OrderInfo)orderInfoObjectResponse.getData()).getCarType());
            parkTime = exitTime - orderInfo.getEnterTime();
        } else {
            isInPark = false;
        }
        switch (type) {
            case 1: {
                exitRequest.setType(Integer.valueOf(1));
                this.tempHandle(parkCode, aisleCode, plateNum, parkId, isInPark, (ObjectResponse<OrderInfo>)orderInfoObjectResponse, parkConfig, flowRet);
                break;
            }
            case 2: {
                exitRequest.setType(Integer.valueOf(2));
                flowRet.setResultCode(FlowCondition.ResultCode.\u6708\u5361\u8f66);
                break;
            }
            case 3: {
                exitRequest.setType(Integer.valueOf(3));
                if (isSpecialCarFree) {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u7279\u6b8a\u8f66\u8f86\u514d\u8d39);
                    break;
                }
                this.tempHandle(parkCode, aisleCode, plateNum, parkId, isInPark, (ObjectResponse<OrderInfo>)orderInfoObjectResponse, parkConfig, flowRet);
                break;
            }
            case 4: {
                exitRequest.setType(Integer.valueOf(4));
                if (orderInfoObjectResponse.getData() != null) {
                    ObjectResponse queryOrderFeeResponseObjectResponse = this.orderService.p2cQueryFee((OrderInfo)orderInfoObjectResponse.getData(), parkConfig, channel.getInandoutCode());
                    ObjectResponse.notError((Response)queryOrderFeeResponseObjectResponse);
                    QueryOrderFeeResponse orderFee = (QueryOrderFeeResponse)queryOrderFeeResponseObjectResponse.getData();
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("orderFee", orderFee);
                    String unPayPrice = orderFee.getUnpayPrice();
                    if (Float.parseFloat(unPayPrice) == 0.0f) {
                        String totalAmount = orderFee.getTotalAmount();
                        if (Float.parseFloat(totalAmount) == 0.0f) {
                            flowRet.setResultCode(FlowCondition.ResultCode.\u514d\u8d39\u65f6\u95f4\u5185);
                            paramMap.put("isreleaseFreetm", parkConfig.getIsreleaseFreetm());
                            flowRet.setPara(paramMap);
                            break;
                        }
                        flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
                        flowRet.setPara(paramMap);
                        break;
                    }
                    flowRet.setResultCode(FlowCondition.ResultCode.\u9700\u7f34\u8d39);
                    flowRet.setPara(paramMap);
                    break;
                }
                flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u5165\u573a\u8bb0\u5f55);
                break;
            }
            case 5: {
                exitRequest.setType(Integer.valueOf(1));
                flowRet.setResultCode(FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66);
                break;
            }
        }
        P2cBaseRequest baseRequest = new P2cBaseRequest();
        baseRequest.setBizContent((Object)exitRequest);
        TokenDeviceVo deviceInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(), exitRequest.getInandoutCode(), serialNumber, deviceInfo.getVersion(), exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        P2cBaseResponse<CarEnexResponse> p2cBaseResponse = this.carExitBaseHandler.notOpenedFlowHandle((P2cBaseRequest<CarExitRequest>)baseRequest, paramHolder, flowRet, parkTime);
        CarEnexResponse data = (CarEnexResponse)p2cBaseResponse.getData();
        if (data.getOpenFlag() != null && data.getOpenFlag() == 1 && (msgId = this.remoteSwitchService.open(SwitchTypeEnum.\u5f00\u95f8.getType(), parkId, exitDebugRequest.getParkCode(), serialNumber, exitDebugRequest.getPlateNum())) == null) {
            log.info("<\u8c03\u8bd5\u52a9\u624b-\u5e73\u53f0\u79bb\u573a> \u5f00\u95f8\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            return ObjectResponse.failed((String)"3002");
        }
        ObjectResponse objectResponse = this.downShowSayHandle.fixShowSayExec(parkId, parkCode, channel.getId(), plateNum, data.getShow(), data.getSay(), "", serialNumber, true);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            log.info("<\u8c03\u8bd5\u52a9\u624b-\u5e73\u53f0\u79bb\u573a> \u8bed\u97f3\u663e\u793a\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    private void tempHandle(String parkCode, String aisleCode, String plateNum, Long parkId, boolean isInPark, ObjectResponse<OrderInfo> orderInfoObjectResponse, ParkConfig parkConfig, FlowCondition.FlowRet flowRet) {
        FlowCondition.ResultCode code;
        HashMap<String, Object> para = new HashMap<String, Object>();
        if (isInPark) {
            ObjectResponse queryOrderFeeResponseObjectResponse = this.orderService.p2cQueryFee((OrderInfo)orderInfoObjectResponse.getData(), parkConfig, aisleCode);
            ObjectResponse.notError((Response)queryOrderFeeResponseObjectResponse);
            QueryOrderFeeResponse orderFee = (QueryOrderFeeResponse)queryOrderFeeResponseObjectResponse.getData();
            para.put("orderFee", orderFee);
            String unPayPrice = orderFee.getUnpayPrice();
            code = Float.parseFloat(unPayPrice) == 0.0f ? FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39 : FlowCondition.ResultCode.\u9700\u7f34\u8d39;
        } else {
            float fixedFee = new FlowCondition().fixedFee(parkConfig, 1);
            if (fixedFee == -1.0f) {
                code = FlowCondition.ResultCode.\u65e0\u5165\u573a\u8bb0\u5f55;
            } else {
                long enterTime = DateTools.unixTimestamp();
                ObjectResponse parkResp = this.parkService.findByParkId(parkId);
                QueryOrderFeeResponse queryOrderFeeResponse = this.carExitFlowProcess.fixedFeeHandle(plateNum, (Park)parkResp.getData(), parkCode, aisleCode, PlateColorEnum.BULE.getDesc(), parkConfig, fixedFee, 1, enterTime, null);
                para.put("orderFee", queryOrderFeeResponse);
                code = FlowCondition.ResultCode.\u56fa\u5b9a\u8d39\u7528;
            }
        }
        flowRet.setResultCode(code);
        flowRet.setPara(para);
    }

    public ObjectResponse payDebug(PayDebugRequest payDebugRequest) {
        String serialNumber;
        try {
            serialNumber = this.cacheHandle.getSerialNumber(payDebugRequest.getParkCode(), payDebugRequest.getAisleCode());
        }
        catch (ResponseBodyException e) {
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        Park park = this.getPark(payDebugRequest.getParkCode());
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setParkId(park.getId());
        carEnterRequest.setParkCode(payDebugRequest.getParkCode());
        carEnterRequest.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
        carEnterRequest.setPlateNum(payDebugRequest.getPlateNum());
        carEnterRequest.setType(Integer.valueOf(1));
        carEnterRequest.setCarType(Integer.valueOf(1));
        carEnterRequest.setOpenFlag(Integer.valueOf(1));
        carEnterRequest.setEnterWay(Integer.valueOf(1));
        ObjectResponse objectResponse = this.carOrderEnterService.enter(carEnterRequest);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)"500", (String)"\u8ba2\u5355\u4fdd\u5b58\u9519\u8bef");
        }
        CarEnterResult data = (CarEnterResult)objectResponse.getData();
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        queryOrderFeeResponse.setOrderNum(data.getOrderNum());
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setPlateNum(payDebugRequest.getPlateNum());
        queryOrderFeeResponse.setEnterTime(Long.valueOf(DateTools.unixTimestamp()));
        queryOrderFeeResponse.setCarType(Integer.valueOf(1));
        queryOrderFeeResponse.setQueryTime(Long.valueOf(DateTools.unixTimestamp()));
        queryOrderFeeResponse.setParkTime(Long.valueOf(0L));
        queryOrderFeeResponse.setTotalAmount(String.valueOf(payDebugRequest.getPrice()));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(payDebugRequest.getPrice()));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(Integer.valueOf(2));
        ObjectResponse parkConfigResp = this.parkService.getParkConfig(park.getId());
        if (!ObjectResponse.isSuccess((Response)parkConfigResp)) {
            return ObjectResponse.failed((String)"500", (String)"\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u672a\u4fdd\u5b58");
        }
        queryOrderFeeResponse.setFreeTime(Long.valueOf(((ParkConfig)parkConfigResp.getData()).getIsfreeAfterpay(Integer.valueOf(15)).intValue()));
        CarExitRequest carExitRequest = new CarExitRequest();
        carExitRequest.setParkId(park.getId());
        carExitRequest.setParkCode(payDebugRequest.getParkCode());
        carExitRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
        carExitRequest.setPlateNum(payDebugRequest.getPlateNum());
        carExitRequest.setType(Integer.valueOf(1));
        carExitRequest.setCarType(Integer.valueOf(1));
        carExitRequest.setInandoutCode(payDebugRequest.getAisleCode());
        carExitRequest.setOrderNum(data.getOrderNum());
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("fee", queryOrderFeeResponse.getUnpayPrice());
        para.put("parkTime", queryOrderFeeResponse.getParkTime());
        para.put("orderNum", queryOrderFeeResponse.getOrderNum());
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(park.getId(), payDebugRequest.getAisleCode());
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        this.downShowSayHandle.showSayExec(park.getId(), park.getParkCode(), channel.getId(), payDebugRequest.getPlateNum(), carExitRequest.getType(), FlowCondition.ResultCode.\u9700\u7f34\u8d39, para, serialNumber, 2, serialNumber, false);
        this.cacheHandle.setExit(payDebugRequest.getParkCode(), payDebugRequest.getAisleCode(), carExitRequest);
        this.cacheHandle.setChannelFee(payDebugRequest.getParkCode(), payDebugRequest.getAisleCode(), queryOrderFeeResponse);
        return ObjectResponse.success();
    }

    public ObjectResponse showSayDebug(ShowSayDebugRequest showSayDebugRequest) {
        String plateNum = showSayDebugRequest.getPlateNum();
        String aisleCode = showSayDebugRequest.getAisleCode();
        String parkCode = showSayDebugRequest.getParkCode();
        String show = "\u5c4f\u663e\u6d4b\u8bd5/\u5c4f\u663e\u6d4b\u8bd5/\u5c4f\u663e\u6d4b\u8bd5/\u5c4f\u663e\u6d4b\u8bd5";
        ObjectResponse inoutDeviceByCode = this.parkService.getInoutDeviceByCode(aisleCode);
        String say = "6666";
        if (ObjectResponse.isSuccess((Response)inoutDeviceByCode)) {
            ParkInoutdevice data = (ParkInoutdevice)inoutDeviceByCode.getData();
            if (Integer.valueOf(1).equals(data.getLedLcdSource())) {
                if (Integer.valueOf(0).equals(data.getTtsType())) {
                    say = "<4>6666<4>";
                }
            } else {
                say = "<D3>6666<D3>";
            }
        }
        Long parkId = this.getParkId(parkCode);
        String serialNumber = null;
        try {
            serialNumber = this.cacheHandle.getSerialNumber(parkCode, aisleCode);
        }
        catch (ResponseBodyException e) {
            log.info(e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        ObjectResponse channelResp = this.parkService.getInOutDeviceByCode(parkId, aisleCode);
        ObjectResponse.notError((Response)channelResp);
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        ObjectResponse objectResponse = this.downShowSayHandle.fixShowSayExec(parkId, parkCode, channel.getId(), plateNum, show, say, "", serialNumber, true);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            log.info("<\u8bed\u97f3\u5c4f\u663e\u6d4b\u8bd5> \u8bed\u97f3\u663e\u793a\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.success();
    }

    public ObjectResponse barriergateOper(BarriergateOperRequest barriergateOperRequest) {
        String parkCode = barriergateOperRequest.getParkCode();
        Long parkId = this.getParkId(parkCode);
        String deviceNo = null;
        try {
            deviceNo = this.cacheHandle.getSerialNumber(parkCode, barriergateOperRequest.getAisleCode());
        }
        catch (ResponseBodyException e) {
            log.info(e.getMessage());
            return ObjectResponse.failed((String)e.getErrCode(), (String)e.getMessage());
        }
        ObjectResponse<RemoteSwitchResponse> objectResponse = this.p2c_remoteSwitchService.execute(barriergateOperRequest.getType(), parkId, parkCode, deviceNo, null);
        if (objectResponse != null && objectResponse.getCode().equals("200")) {
            RemoteSwitchResponse remoteSwitchResponse = (RemoteSwitchResponse)objectResponse.getData();
            if (remoteSwitchResponse.getResult().equals(1)) {
                return ObjectResponse.success();
            }
            log.info("\u5f00\u5173\u95f8\u5931\u8d25\uff0c\u8fd4\u56de\uff1a{}", (Object)remoteSwitchResponse);
        } else {
            log.info("<\u624b\u52a8\u5f00\u5173\u95f8> \u5f00\u5173\u95f8\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.failed((String)"3002");
    }

    private Park getPark(String parkCode) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        return (Park)byParkCode.getData();
    }

    protected Long getParkId(String parkCode) {
        ObjectResponse byParkCode = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        return park.getId();
    }
}

