/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.utils.Spring;
import com.icetech.cloudcenter.api.IDataReportService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.request.BaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.ResponseUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.validator.Validator;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.report.pnc.ReportService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataReportServiceImpl
implements IDataReportService {
    private static final Logger log = LoggerFactory.getLogger(DataReportServiceImpl.class);
    @Autowired
    private ParkService parkService;
    private Map<String, Integer> FAIL_CS = new HashMap<String, Integer>();
    private static int FAIL_LIMIT = 5;
    private final String SERVICE_SUFFIX = "ServiceImpl";
    private static String Blacklist_ParkCode = "P12345678";
    private static Map<String, Long> ERROR_PARKS = new HashMap<String, Long>();

    public String report(String args) {
        DataCenterBaseRequest baseRequest = (DataCenterBaseRequest)JsonUtils.parseObject((String)args, DataCenterBaseRequest.class, (Class[])new Class[0]);
        String parkCode = baseRequest.getParkCode();
        if (Blacklist_ParkCode.contains(parkCode)) {
            return ResponseUtils.setResponse((String)"400", (String)CodeConstants.getName((String)"400"));
        }
        if (ERROR_PARKS.get(parkCode) != null) {
            Long lastTime = ERROR_PARKS.get(parkCode);
            long windowTime = DateTools.unixTimestamp() - lastTime;
            if (windowTime < 600L) {
                log.info("{}-{}", (Object)parkCode, (Object)windowTime);
            } else {
                ERROR_PARKS.remove(parkCode);
            }
        }
        if (StringUtils.isBlank((CharSequence)parkCode)) {
            log.info("\u8f66\u573a\u7f16\u53f7\u4e3a\u7a7a");
            return ResponseUtils.setResponse((String)"400", (String)CodeConstants.getName((String)"400"));
        }
        ObjectResponse objectResponse = this.parkService.findByParkCode(baseRequest.getParkCode());
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return JsonUtils.toString((Object)this.dealFailCode(objectResponse, baseRequest));
        }
        Park park = (Park)objectResponse.getData();
        ObjectResponse parkConfigResponse = this.parkService.getParkConfig(parkCode);
        ObjectResponse.notError((Response)parkConfigResponse);
        ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
            try {
                String prefix;
                ReportService reportService;
                ObjectResponse response;
                if (StringUtils.isNotBlank((CharSequence)baseRequest.getVersionNum())) {
                    this.verify(baseRequest, park.getKey());
                }
                if (ObjectResponse.isSuccess((Response)(response = (reportService = this.getServiceBean(prefix = baseRequest.getServiceName())).report(baseRequest, park.getId())))) {
                    return JsonUtils.toString((Object)response);
                }
                return JsonUtils.toString((Object)this.dealFailCode(response, baseRequest));
            }
            catch (ResponseBodyException e) {
                ObjectResponse objectResponse1 = new ObjectResponse(e.getErrCode(), CodeConstants.getName((String)e.getErrCode()) + "," + e.getMessage());
                return JsonUtils.toString((Object)this.dealFailCode(objectResponse1, baseRequest));
            }
            catch (Exception e) {
                log.error("\u7aef\u7f51\u4e91\u4e0a\u62a5\u5904\u7406\u5f02\u5e38", (Throwable)e);
                return JsonUtils.toString((Object)this.dealFailCode(ObjectResponse.failed(), baseRequest));
            }
        }
        ERROR_PARKS.put(parkCode, DateTools.unixTimestamp());
        return ResponseUtils.setResponse((String)"401", (String)(CodeConstants.getName((String)"401") + "\uff0c\u8fde\u63a5\u6a21\u5f0f\u4e0d\u6b63\u786e"));
    }

    private ReportService getServiceBean(String prefix) {
        String serviceName = prefix + "ServiceImpl";
        try {
            return (ReportService)Spring.getBean((String)serviceName);
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    private void verify(DataCenterBaseRequest baseRequest, String secretKey) {
        if (Validator.validate((Object)baseRequest)) {
            boolean verifyResult = SignTools.verifyMD5Sign((BaseRequest)baseRequest, (String)secretKey);
            if (!verifyResult) {
                throw new ResponseBodyException("401", "\u9a8c\u7b7e\u672a\u901a\u8fc7");
            }
        } else {
            throw new ResponseBodyException("400", "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    private ObjectResponse dealFailCode(ObjectResponse objectResponse, DataCenterBaseRequest baseRequest) {
        block6: {
            Object bizContent = baseRequest.getBizContent();
            try {
                if (bizContent == null) {
                    return ObjectResponse.failed((String)"402");
                }
                String md5 = DigestUtils.md5Hex((String)JsonUtils.toString((Object)bizContent)).toUpperCase();
                Integer cs = this.FAIL_CS.get(md5);
                if (cs == null) {
                    this.FAIL_CS.put(md5, 1);
                    break block6;
                }
                if (cs < FAIL_LIMIT) {
                    this.FAIL_CS.put(md5, cs + 1);
                    break block6;
                }
                this.FAIL_CS.remove(md5);
                log.info("<\u901a\u7528\u6570\u636e\u63a5\u53e3> \u4e0a\u4f20\u5931\u8d25\u6b21\u6570\u5df2\u8d85\u8fc7[{}]\u6b21\uff0c\u8fd4\u56de\u6210\u529f\uff0c\u53c2\u6570\uff1a{}\uff0c\u5e94\u8fd4\u56de\uff1a{}", new Object[]{FAIL_LIMIT, JsonUtils.replaceJsonContent((String)JsonUtils.toString((Object)baseRequest), (String[])new String[]{"base64Str"}), objectResponse});
                if (baseRequest.getServiceName().equals("enter") || baseRequest.getServiceName().equals("complateOrder")) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("orderId", (String)((JSONObject)bizContent).get((Object)"orderId"));
                    return ObjectResponse.success(data);
                }
                return new ObjectResponse("200", "\u9650\u5236\u8bbf\u95ee");
            }
            catch (Exception e) {
                log.error(String.valueOf(e.getMessage()), (Throwable)e);
            }
        }
        return objectResponse;
    }
}

