/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.icetech.cloudcenter.api.ICommonService;
import com.icetech.cloudcenter.domain.request.p2c.PropertyInfoRequest;
import com.icetech.cloudcenter.domain.request.p2c.PropertySetRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.p2c.impl.PropertyGetServiceImpl;
import com.icetech.park.service.down.p2c.impl.PropertySetServiceImpl;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.ItcDownHandle;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.handle.MorDownHandle;
import com.icetech.park.service.handle.P2cDownHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements ICommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private PropertySetServiceImpl propertySetService;
    @Autowired
    private PropertyGetServiceImpl propertyGetService;
    @Autowired
    private P2cDownHandle downHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private MorDownHandle morDownHandle;
    @Autowired
    private MorCacheHandle morCacheHandle;
    @Autowired
    private ItcCacheHandle itcCacheHandle;
    @Autowired
    private ItcDownHandle itcDownHandle;

    public ObjectResponse<Void> propertySet(PropertySetRequest propertySetRequest, String sn) {
        return this.propertySetService.send(propertySetRequest, sn);
    }

    public ObjectResponse<PropertyInfoRequest> propertyGet(String sn, String topic) {
        return this.propertyGetService.send(sn, topic);
    }

    public ObjectResponse<Void> down(String sn, Object message, String cmd) {
        TokenDeviceVo tokenInfo = this.cacheHandle.getDeviceInfo(sn);
        boolean success = false;
        if (tokenInfo == null) {
            return ObjectResponse.failed((String)"3003");
        }
        if (tokenInfo.getSource() == 1) {
            P2cBaseRequest p2cBaseRequest = new P2cBaseRequest();
            p2cBaseRequest.setCmd(cmd);
            p2cBaseRequest.setBizContent(message);
            p2cBaseRequest.setMessageId(UUIDTools.getUuid());
            p2cBaseRequest.setTimestamp(Long.valueOf(DateTools.unixTimestamp()));
            p2cBaseRequest.setToken(tokenInfo.getToken());
            String content = JsonUtils.toString((Object)message);
            success = this.downHandle.pushAll(sn, p2cBaseRequest);
            log.info("[\u7aef\u4e91WS\u4e0b\u53d1] \u4e0b\u53d1{}, sn:[{}], \u5185\u5bb9\u4e3a:{}", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", sn, content});
        } else {
            log.warn("[\u7aef\u4e91\u4e0b\u53d1]\u672a\u77e5\u4e0b\u53d1\u901a\u9053[{}], sn[{}], \u5185\u5bb9\u4e3a[{}]", new Object[]{tokenInfo.getSource(), sn, message});
        }
        return success ? ObjectResponse.success() : ObjectResponse.failed((String)"3003");
    }

    public ObjectResponse<Void> commonDown(int deviceType, String sn, Object message, String cmd) {
        TokenDeviceVo tokenInfo = deviceType == 9 ? this.morCacheHandle.getDeviceInfo(sn) : (deviceType == 8 ? this.itcCacheHandle.getDeviceInfo(sn) : this.cacheHandle.getDeviceInfo(sn));
        boolean success = false;
        if (tokenInfo == null) {
            return ObjectResponse.failed((String)"3003");
        }
        P2cBaseRequest p2cBaseRequest = new P2cBaseRequest();
        p2cBaseRequest.setCmd(cmd);
        p2cBaseRequest.setBizContent(message);
        p2cBaseRequest.setMessageId(UUIDTools.getUuid());
        p2cBaseRequest.setTimestamp(Long.valueOf(DateTools.unixTimestamp()));
        p2cBaseRequest.setToken(tokenInfo.getToken());
        String content = JsonUtils.toString((Object)p2cBaseRequest);
        String protocol = "WS";
        if (deviceType == 9) {
            success = this.morDownHandle.pushAll(sn, p2cBaseRequest);
        } else if (deviceType == 8) {
            success = this.itcDownHandle.pushAll(sn, p2cBaseRequest);
        } else if (tokenInfo.getSource() == 1) {
            success = this.downHandle.pushAll(sn, p2cBaseRequest);
        } else {
            protocol = "iot";
        }
        log.info("[\u7aef\u4e91" + protocol + "\u4e0b\u53d1] \u4e0b\u53d1{}, sn:[{}], \u5185\u5bb9\u4e3a:{}", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", sn, content});
        return success ? ObjectResponse.success() : ObjectResponse.failed((String)"3003");
    }
}

