/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.cloudcenter.api.park.ChannelAlarmService;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.ChannelAlarmHandlerVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.dao.other.ChannelAlarmHandlerMapper;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.ChannelAlarmHandler;
import com.icetech.park.service.ChannelAlarmHandlerService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelAlarmHandlerServiceImpl
extends BaseServiceImpl<ChannelAlarmHandlerMapper, ChannelAlarmHandler>
implements ChannelAlarmHandlerService {
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ChannelAlarmService channelAlarmService;
    @Resource
    private OssService ossService;

    @Override
    public ChannelAlarmHandler getChannelAlarmHandlerById(Long id) {
        return (ChannelAlarmHandler)this.getById(id);
    }

    @Override
    public Boolean addChannelAlarmHandler(ChannelAlarmHandler entity) {
        return this.save(entity);
    }

    @Override
    public Boolean modifyChannelAlarmHandler(ChannelAlarmHandler entity) {
        return this.updateById(entity);
    }

    @Override
    public Boolean removeChannelAlarmHandlerById(Long id) {
        return this.removeById(id);
    }

    @Override
    public List<ChannelAlarmHandlerVo> getChannelAlarmHandlerVoList(ManagerInOutRequest managerInOutRequest, String parkIds) {
        return ((ChannelAlarmHandlerMapper)this.baseMapper).selectChannelAlarmHandlerVo(new Page((long)managerInOutRequest.getPageNo().intValue(), (long)managerInOutRequest.getPageSize().intValue()), managerInOutRequest, parkIds);
    }

    @Override
    public ObjectResponse<Boolean> handlerChannelAlarm(String operAccount, Integer parkId, String channelCode) {
        List channelAlarmList = this.channelAlarmService.getChannelAlarmByPark(Long.valueOf(parkId.longValue()), channelCode);
        if (CollectionUtils.isEmpty((Collection)channelAlarmList)) {
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR_404);
        }
        ChannelAlarmHandler channelAlarmHandler = new ChannelAlarmHandler();
        channelAlarmHandler.setParkId(parkId);
        channelAlarmHandler.setChannelCode(channelCode);
        channelAlarmHandler.setImage(((ChannelAlarm)channelAlarmList.get(0)).getImage());
        channelAlarmHandler.setOrderNum(((ChannelAlarm)channelAlarmList.get(0)).getOrderNum());
        channelAlarmHandler.setAlarmTime(((ChannelAlarm)channelAlarmList.get(0)).getCreateTime());
        channelAlarmHandler.setCreateTime(new Date());
        channelAlarmHandler.setUpdateTime(new Date());
        channelAlarmHandler.setRemark(((ChannelAlarm)channelAlarmList.get(0)).getRemark());
        channelAlarmHandler.setOperator(operAccount);
        channelAlarmHandler.setChannelAlarmId(((ChannelAlarm)channelAlarmList.get(0)).getId());
        return ObjectResponse.success((Object)this.addChannelAlarmHandler(channelAlarmHandler));
    }

    @Override
    public ObjectResponse<List<ChannelAlarmHandlerVo>> getHandlerChannelAlarmList(ManagerInOutRequest managerInOutRequest) {
        List<Object> channelAlarmHandlerVoList;
        String[] split = managerInOutRequest.getParkCode().split(",");
        String parkIds = this.parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty((CharSequence)parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        if (CollectionUtils.isNotEmpty(channelAlarmHandlerVoList = this.getChannelAlarmHandlerVoList(managerInOutRequest, parkIds))) {
            channelAlarmHandlerVoList = channelAlarmHandlerVoList.stream().peek(t -> {
                if (StringUtils.isNotEmpty((CharSequence)t.getImage())) {
                    t.setImage(this.ossService.getImageUrl(t.getImage()));
                }
            }).collect(Collectors.toList());
        }
        return ObjectResponse.success(channelAlarmHandlerVoList);
    }
}

