/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.impl;

import cn.hutool.core.util.ReUtil;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.utils.RegStr;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.call.ICallMobileParkService;
import com.icetech.cloudcenter.api.park.ChannelAlarmService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.call.CallMobilePark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.utils.RedisUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmServiceImpl
implements AlarmService {
    private static final Logger log = LoggerFactory.getLogger(AlarmServiceImpl.class);
    @Autowired
    private ChannelAlarmService channelAlarmService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ICallMobileParkService callMobileParkService;
    private static final int threshold = 2;

    public void queryFeeFailHandler(String parkCode, Long parkId, String channelId) {
        String key = "QUERY_FEE_FAIL:" + parkCode + "_" + channelId;
        if (this.redisUtils.exists(key)) {
            int cs = (Integer)this.redisUtils.get(key, Integer.class);
            this.redisUtils.set(key, (Object)(++cs), 180L);
            if (cs == 2) {
                log.info("\u51c6\u5907\u8bb0\u5f55\u51fa\u53e3\u5f02\u5e38\u4e8b\u4ef6...");
                ChannelAlarm channelAlarm = new ChannelAlarm();
                if (parkId == null) {
                    ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
                    if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
                        log.warn("\u8f66\u573a\u7f16\u53f7\u4e0d\u5b58\u5728[{}]", (Object)parkCode);
                        return;
                    }
                    parkId = ((Park)parkObjectResponse.getData()).getId();
                }
                channelAlarm.setParkId(parkId);
                channelAlarm.setChannelCode(channelId);
                channelAlarm.setStatus(Integer.valueOf(1));
                channelAlarm.setAlarmType(Integer.valueOf(1));
                try {
                    this.channelAlarmService.addAlarm(channelAlarm);
                }
                catch (Exception e) {
                    log.error("\u5f02\u5e38", (Throwable)e);
                }
            }
        } else {
            this.redisUtils.set(key, (Object)1, 180L);
        }
    }

    public void switchFailHandler(String parkCode, Long parkId, String channelId) {
        String key = "SWITCH_FAIL:" + parkCode + "_" + channelId;
        if (!this.redisUtils.exists(key)) {
            this.redisUtils.set(key, (Object)1, 180L);
            if (parkId == null) {
                ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
                ObjectResponse.notError((Response)parkObjectResponse);
                parkId = ((Park)parkObjectResponse.getData()).getId();
            }
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(parkId);
            channelAlarm.setChannelCode(channelId);
            channelAlarm.setStatus(Integer.valueOf(1));
            channelAlarm.setAlarmType(Integer.valueOf(2));
            this.channelAlarmService.addAlarm(channelAlarm);
        }
    }

    public void yuneasyCallHandler(String serialNumber) {
        Long channelId = null;
        Long parkId = null;
        if (ReUtil.isMatch((Pattern)RegStr.MOBILE, (CharSequence)serialNumber)) {
            CallMobilePark query = new CallMobilePark();
            query.setMobile(serialNumber);
            ObjectResponse one = this.callMobileParkService.getOne(query);
            if (ObjectResponse.isSuccess((Response)one)) {
                CallMobilePark callMobilePark = (CallMobilePark)one.getData();
                if (callMobilePark.getChannelId() != null) {
                    channelId = (long)callMobilePark.getChannelId();
                }
                if (callMobilePark.getParkId() != null) {
                    parkId = (long)callMobilePark.getParkId();
                }
            }
        } else {
            ObjectResponse parkDeviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
            if (!ObjectResponse.isSuccess((Response)parkDeviceResp)) {
                return;
            }
            ParkDevice parkDevice = (ParkDevice)parkDeviceResp.getData();
            if (parkDevice.getChannelId() != null) {
                channelId = (long)parkDevice.getChannelId();
            }
            parkId = parkDevice.getParkId();
        }
        if (parkId == null) {
            return;
        }
        ParkInoutdevice parkInoutdevice = null;
        if (null != channelId) {
            ObjectResponse inoutDeviceObjectResponse = this.parkService.getInoutDeviceById(channelId);
            if (!ObjectResponse.isSuccess((Response)inoutDeviceObjectResponse)) {
                return;
            }
            parkInoutdevice = (ParkInoutdevice)inoutDeviceObjectResponse.getData();
        }
        ChannelAlarm channelAlarm = new ChannelAlarm();
        channelAlarm.setParkId(parkId);
        channelAlarm.setChannelCode(Objects.isNull(parkInoutdevice) ? null : parkInoutdevice.getInandoutCode());
        channelAlarm.setStatus(Integer.valueOf(1));
        channelAlarm.setAlarmType(Integer.valueOf(3));
        channelAlarm.setRemark(serialNumber);
        this.channelAlarmService.addAlarm(channelAlarm);
    }

    public void aisleDurationAlarm(AisleInfoVo aisleInfoVo) {
        ChannelAlarm channelAlarm = new ChannelAlarm();
        channelAlarm.setParkId(aisleInfoVo.getParkId());
        channelAlarm.setChannelCode(aisleInfoVo.getAisleCode());
        channelAlarm.setOrderNum(aisleInfoVo.getOrderNum());
        channelAlarm.setStatus(Integer.valueOf(1));
        channelAlarm.setAlarmType(Integer.valueOf(4));
        channelAlarm.setImage(aisleInfoVo.getImage());
        this.channelAlarmService.addAlarm(channelAlarm);
    }

    @Deprecated
    public List<ChannelAlarm> getAlarmsByChannelCode(Long parkId, String channelCode) {
        return Collections.emptyList();
    }
}

