/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.month.MonthCarService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.flow.p2c.FlowCondition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ShowSayBaseHandle {
    private static final Logger log = LoggerFactory.getLogger(ShowSayBaseHandle.class);
    @Resource
    private MonthCarService monthCarService;
    @Resource
    private LedService ledSoundService;
    @Resource
    private LcdService lcdService;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderTagsService orderTagsService;
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private VipCarService vipCarService;
    @Resource
    private OrderPayService orderPayService;

    public Integer getMonthCarRemainDays(Long parkId, Long channelId, String plateNum, Map<String, Object> param) {
        Integer days = (Integer)param.get("days");
        if (days != null) {
            return days == -1 || days == -2 ? null : days;
        }
        param.put("days", -1);
        Long regionId = param.get("regionId") == null ? null : (Long)param.get("regionId");
        ObjectResponse infoObjectResponse = this.monthCarService.getMonthCarDetail(parkId, plateNum, regionId);
        if (!ObjectResponse.isSuccess((Response)infoObjectResponse)) {
            return null;
        }
        MonthDetailDto dto = (MonthDetailDto)infoObjectResponse.getData();
        MonthDetailDto.MonthType monthType = dto.getMonthType();
        switch (monthType) {
            case \u975e\u6708\u5361\u8f66: 
            case \u591a\u4f4d\u591a\u8f66\u5360\u7528: {
                param.put("days", -2);
                break;
            }
            case \u6708\u5361\u8f66: {
                param.put("type", 2);
                Integer ledLcdSource = (Integer)param.get("ledLcdSource");
                if (ledLcdSource == null) {
                    param.put("days", dto.getUnexpiredDays() == null ? 0 : dto.getUnexpiredDays());
                    param.put("isMonth", true);
                    break;
                }
                if (Integer.valueOf(2).equals(ledLcdSource)) {
                    ObjectResponse lcdConfigObjectResponse = this.lcdService.getLcdConfigByChannel(channelId);
                    LcdConfig lcdConfig = (LcdConfig)lcdConfigObjectResponse.getData();
                    Integer unexpiredDays = dto.getUnexpiredDays();
                    if (lcdConfig.getRemainDaysMc() != 0 && unexpiredDays > lcdConfig.getRemainDaysMc()) break;
                    param.put("days", unexpiredDays);
                    param.put("isMonth", true);
                    break;
                }
                ObjectResponse ledsoundConfigObjectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
                LedConfig parkLedSoundConfig = (LedConfig)ledsoundConfigObjectResponse.getData();
                Integer unexpiredDays = dto.getUnexpiredDays();
                if (parkLedSoundConfig.getLedRemainDaysMc() != 0 && unexpiredDays > parkLedSoundConfig.getLedRemainDaysMc()) break;
                param.put("days", unexpiredDays);
                param.put("isMonth", true);
                break;
            }
            case \u8fc7\u671f\u4e34\u65f6\u8f66: {
                param.put("days", 0);
                param.put("isMonth", false);
                break;
            }
            case \u8fc7\u671f\u6708\u5361\u8f66: {
                param.put("days", 0);
                param.put("isMonth", true);
                break;
            }
        }
        days = (Integer)param.get("days");
        return days == -1 || days == -2 ? null : days;
    }

    public String getFreeSpaceName(Long parkId, Long channelId, Map<String, Object> param) {
        String freeSpaceName = (String)param.get("freeSpaceName");
        if (freeSpaceName == null) {
            this.getFreeSpace(parkId, channelId, param);
            freeSpaceName = (String)param.get("freeSpaceName");
        }
        return freeSpaceName;
    }

    public Integer getFreeSpace(Long parkId, Long channelId, Map<String, Object> param) {
        Integer freeSpace = (Integer)param.get("freeSpace");
        if (freeSpace != null) {
            return freeSpace;
        }
        String freeSpaceName = "";
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            Park park = (Park)parkObjectResponse.getData();
            if (NumberUtils.toPrimitive((Integer)park.getIsInterior()) == 1) {
                ObjectResponse objectResponse;
                Integer ledLcdSource = this.getLedLcdSource(channelId, param);
                Long regionIdFreeSpace = 0L;
                if (ledLcdSource == 1) {
                    objectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
                    if (ObjectResponse.isSuccess((Response)objectResponse)) {
                        regionIdFreeSpace = ((LedConfig)objectResponse.getData()).getRegionFreeSpace();
                    }
                } else {
                    objectResponse = this.lcdService.getLcdConfigByChannel(channelId);
                    if (ObjectResponse.isSuccess((Response)objectResponse)) {
                        regionIdFreeSpace = ((LcdConfig)objectResponse.getData()).getRegionFreeSpace();
                    }
                }
                if (regionIdFreeSpace == null || regionIdFreeSpace == 0L) {
                    freeSpace = this.parkFreespaceDao.selectParkFree(parkId);
                } else {
                    ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionIdFreeSpace);
                    if (parkRegion != null) {
                        freeSpace = parkRegion.getFreePark();
                        freeSpaceName = parkRegion.getRegionName();
                    }
                }
            } else {
                freeSpace = this.parkFreespaceDao.selectParkFree(parkId);
            }
        }
        if (freeSpace == null) {
            freeSpace = 0;
        }
        if (freeSpace < 0) {
            freeSpace = 0;
        }
        param.put("freeSpace", freeSpace);
        param.put("freeSpaceName", freeSpaceName);
        return freeSpace;
    }

    public Integer setAndGetPlateType(FlowCondition.ResultCode resultCode, Long parkId, Long channelId, String plateNum, Integer currType, Map<String, Object> param) {
        ParkRegion monthCardOtherRegion;
        String replaceContent;
        String otherRegionNameVip;
        String regionName;
        Integer type = (Integer)param.get("type");
        if (type != null) {
            if (param.get("showTypeStr") == null) {
                param.put("showTypeStr", PlateTypeEnum.getName((Integer)type));
                param.put("sayTypeStr", PlateTypeEnum.getName((Integer)type));
            }
            return type;
        }
        if (resultCode.equals((Object)FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66)) {
            param.put("type", 7);
            param.put("showTypeStr", "\u9ed1\u540d\u5355\u8f66");
            param.put("sayTypeStr", "\u9ed1\u540d\u5355\u8f66");
            return 7;
        }
        if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(currType)) {
            if (param.get("carDesc") == null) {
                ObjectResponse recentVipCar = this.vipCarService.getRecentVipCar(parkId, plateNum, null);
                if (ObjectResponse.isSuccess((Response)recentVipCar)) {
                    VipType vipType = (VipType)recentVipCar.getData();
                    param.put("type", 4);
                    param.put("showTypeStr", vipType.getName());
                    param.put("sayTypeStr", vipType.getName());
                    return 4;
                }
            } else {
                param.put("type", 4);
                param.put("showTypeStr", param.get("carDesc"));
                param.put("sayTypeStr", param.get("carDesc"));
                return 4;
            }
        }
        if (resultCode.equals((Object)FlowCondition.ResultCode.\u6708\u5361\u8f66)) {
            param.put("type", 2);
            param.put("showTypeStr", PlateTypeEnum.\u6708\u5361\u8f66.name());
            param.put("sayTypeStr", PlateTypeEnum.\u6708\u5361\u8f66.name());
            return 2;
        }
        String typeName = PlateTypeEnum.getName((Integer)currType);
        if (!PlateTypeEnum.\u4e34\u65f6\u8f66.getType().equals(currType) && !PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(currType)) {
            param.put("type", currType);
            param.put("showTypeStr", typeName);
            param.put("sayTypeStr", typeName);
            return currType;
        }
        String string = regionName = param.get("otherRegionNameMc") == null ? null : param.get("otherRegionNameMc").toString();
        if (regionName != null) {
            param.put("type", 2);
            param.put("showTypeStr", regionName + PlateTypeEnum.\u6708\u5361\u8f66.name());
            param.put("sayTypeStr", regionName + PlateTypeEnum.\u6708\u5361\u8f66.name());
            return 2;
        }
        String string2 = otherRegionNameVip = param.get("otherRegionNameVip") == null ? null : param.get("otherRegionNameVip").toString();
        if (otherRegionNameVip != null) {
            param.put("type", 4);
            param.put("showTypeStr", otherRegionNameVip + param.get("carDesc"));
            param.put("sayTypeStr", otherRegionNameVip + param.get("carDesc"));
            return 4;
        }
        Long regionId = param.get("regionId") == null ? null : (Long)param.get("regionId");
        ObjectResponse infoObjectResponse = this.monthCarService.getMonthCarDetail(parkId, plateNum, regionId);
        if (!ObjectResponse.isSuccess((Response)infoObjectResponse)) {
            param.put("type", currType);
            param.put("showTypeStr", typeName);
            param.put("sayTypeStr", typeName);
            return currType;
        }
        if (FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165.equals((Object)resultCode)) {
            param.put("type", PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
            param.put("showTypeStr", PlateTypeEnum.\u4e34\u65f6\u8f66.name());
            param.putIfAbsent("sayTypeStr", PlateTypeEnum.\u4e34\u65f6\u8f66.name());
            return PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
        }
        MonthDetailDto dto = (MonthDetailDto)infoObjectResponse.getData();
        MonthDetailDto.MonthType monthType = dto.getMonthType();
        String orderNum = (String)param.get("orderNum");
        switch (monthType) {
            case \u975e\u6708\u5361\u8f66: {
                replaceContent = PlateTypeEnum.\u4e34\u65f6\u8f66.name();
                param.put("type", 1);
                break;
            }
            case \u591a\u4f4d\u591a\u8f66\u5360\u7528: {
                OrderTags orderTags;
                if (StringUtils.isNotBlank((CharSequence)orderNum) && (orderTags = this.orderTagsService.getListByOrderNumAndTagId(orderNum, Integer.valueOf(1), regionId)) != null) {
                    replaceContent = PlateTypeEnum.\u4e34\u65f6\u8f66.name() + " " + orderTags.getRemark();
                    param.put("type", 1);
                    param.put("sayTypeStr", PlateTypeEnum.\u4e34\u65f6\u8f66.name());
                    break;
                }
                replaceContent = PlateTypeEnum.\u4e34\u65f6\u8f66.name();
                param.put("type", 1);
                break;
            }
            case \u8fc7\u671f\u6708\u5361\u8f66: {
                if (this.isShowExpireMc(dto, parkId, channelId, param)) {
                    replaceContent = "\u8fc7\u671f\u5361";
                    param.put("type", 8);
                    break;
                }
                replaceContent = PlateTypeEnum.\u6708\u5361\u8f66.name();
                param.put("type", 2);
                break;
            }
            case \u8fc7\u671f\u4e34\u65f6\u8f66: {
                if (this.isShowExpireMc(dto, parkId, channelId, param)) {
                    replaceContent = "\u8fc7\u671f\u5361";
                    param.put("type", 8);
                    break;
                }
                replaceContent = PlateTypeEnum.\u4e34\u65f6\u8f66.name();
                param.put("type", 1);
                break;
            }
            case \u6708\u5361\u8f66: {
                OrderTags orderTags;
                if (StringUtils.isNotBlank((CharSequence)orderNum) && (orderTags = this.orderTagsService.getListByOrderNumAndTagId(orderNum, Integer.valueOf(1), regionId)) != null) {
                    replaceContent = PlateTypeEnum.\u6708\u5361\u8f66.name() + " " + orderTags.getRemark();
                    param.put("type", 2);
                    param.put("sayTypeStr", PlateTypeEnum.\u6708\u5361\u8f66.name());
                    break;
                }
                replaceContent = PlateTypeEnum.\u6708\u5361\u8f66.name();
                param.put("type", 2);
                break;
            }
            default: {
                replaceContent = typeName;
                param.put("type", currType);
            }
        }
        Integer enexType = (Integer)param.get("enexType");
        String channelCode = (String)param.get("channelCode");
        if (NumberUtils.toPrimitive((Integer)enexType) == 1 && channelCode != null && (monthCardOtherRegion = this.monthCarService.findMonthCardOtherRegion(parkId, plateNum, channelCode)) != null) {
            replaceContent = monthCardOtherRegion.getRegionName() + PlateTypeEnum.\u6708\u5361\u8f66.name();
            param.put("type", 2);
        }
        param.put("showTypeStr", replaceContent);
        param.putIfAbsent("sayTypeStr", replaceContent);
        return (Integer)param.get("type");
    }

    private boolean isShowExpireMc(MonthDetailDto monthDetailDto, Long parkId, Long channelId, Map<String, Object> param) {
        Integer ledLcdSource = this.getLedLcdSource(channelId, param);
        if (Integer.valueOf(1).equals(ledLcdSource)) {
            if (!MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66.equals((Object)monthDetailDto.getMonthType()) && !MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66.equals((Object)monthDetailDto.getMonthType())) {
                return false;
            }
            ObjectResponse objectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                return false;
            }
            LedConfig ledConfig = (LedConfig)objectResponse.getData();
            return ledConfig.getLedExpireDaysMc() != null && monthDetailDto.getExpiredDays() != null && ledConfig.getLedExpireDaysMc() >= monthDetailDto.getExpiredDays();
        }
        if (Integer.valueOf(2).equals(ledLcdSource)) {
            if (!MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66.equals((Object)monthDetailDto.getMonthType()) && !MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66.equals((Object)monthDetailDto.getMonthType())) {
                return false;
            }
            ObjectResponse objectResponse = this.lcdService.getLcdConfigByChannel(channelId);
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                return false;
            }
            LcdConfig lcdConfig = (LcdConfig)objectResponse.getData();
            return lcdConfig.getExpireDaysMc() != null && lcdConfig.getExpireDaysMc() >= monthDetailDto.getExpiredDays();
        }
        return false;
    }

    private Integer getLedLcdSource(Long channelId, Map<String, Object> param) {
        Integer ledLcdSource = (Integer)param.get("ledLcdSource");
        if (ledLcdSource == null) {
            ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            ledLcdSource = channel.getLedLcdSource();
            param.put("ledLcdSource", ledLcdSource);
        }
        return ledLcdSource;
    }

    public int getSceneByResultCode(FlowCondition.ResultCode resultCode, int enexType) {
        int scene = 0;
        switch (resultCode) {
            case \u6708\u5361\u8f66: {
                if (enexType == 1) {
                    scene = HintRequest.Scene.MONTH_CAR_ENTER.getVal();
                    break;
                }
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            }
            case \u9ed1\u540d\u5355\u8f66: {
                if (enexType == 1) {
                    scene = HintRequest.Scene.BLACK_NOT_ALLOW_CAR_ENTER.getVal();
                    break;
                }
                scene = HintRequest.Scene.NOT_ALLOW_EXIT.getVal();
                break;
            }
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: {
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: {
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                if (enexType == 1) {
                    scene = HintRequest.Scene.NO_PLATE_ENTER.getVal();
                    break;
                }
                scene = HintRequest.Scene.NO_PLATE_EXIT.getVal();
                break;
            }
            case \u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165: {
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u7279\u6b8a\u8f66\u8f86\u514d\u8d39: 
            case \u514d\u8d39\u65f6\u95f4\u5185: 
            case \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0: 
            case \u9884\u7f34\u8d39\u672a\u8d85\u65f6: 
            case \u65e0\u9700\u7f34\u8d39: {
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            }
            case \u65e0\u5165\u573a\u8bb0\u5f55: {
                scene = HintRequest.Scene.NO_ORDER_EXIT.getVal();
                break;
            }
            case \u56fa\u5b9a\u8d39\u7528: 
            case \u9700\u7f34\u8d39: 
            case \u6b20\u8d39\u8865\u7f34: {
                scene = HintRequest.Scene.NEED_PAY_EXIT.getVal();
                break;
            }
            case VIP\u8f66\u8f86: {
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            }
            case \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a: {
                scene = HintRequest.Scene.FULL_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a: {
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u5185\u90e8\u8f66\u8f86: {
                scene = HintRequest.Scene.MONTH_CAR_ENTER.getVal();
                break;
            }
            case \u8fc7\u671f\u5361: {
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            }
            case \u8f66\u4f4d\u5df2\u5360: {
                scene = HintRequest.Scene.MULTI_SPACE_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5: {
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            }
            case \u8bbf\u5ba2\u8f66: {
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            }
            case \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165: {
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            }
            case \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165: {
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u50a8\u503c\u5361\u8fc7\u671f: {
                scene = HintRequest.Scene.OTHER_CAR_NOT_ALLOW_ENTER.getVal();
                break;
            }
            case \u50a8\u503c\u5361\u8f66: {
                scene = HintRequest.Scene.OTHER_ENTER.getVal();
                break;
            }
            case \u65e0\u5165\u573aVIP\u5168\u514d\u8f66: {
                scene = HintRequest.Scene.NO_FEE_EXIT.getVal();
                break;
            }
            case \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa: {
                scene = HintRequest.Scene.NOT_ALLOW_EXIT.getVal();
                break;
            }
        }
        return scene;
    }

    public String getPayWay(Map<String, Object> param) {
        if (param == null || param.isEmpty()) {
            return null;
        }
        if (param.containsKey("payWay")) {
            return param.get("payWay") == null ? null : param.get("payWay").toString();
        }
        String orderNum = (String)param.get("orderNum");
        if (StringUtils.isEmpty((CharSequence)orderNum)) {
            return null;
        }
        OrderPay orderPayParam = new OrderPay();
        orderPayParam.setOrderNum(orderNum);
        orderPayParam.setPayStatus(Integer.valueOf(2));
        PageQuery orderPayParamPageQuery = new PageQuery();
        orderPayParamPageQuery.setParam((Object)orderPayParam);
        ObjectResponse listObjectResponse = this.orderPayService.findList(orderPayParamPageQuery);
        if (!ObjectResponse.isSuccess((Response)listObjectResponse)) {
            return null;
        }
        List orderPays = (List)listObjectResponse.getData();
        if (orderPays == null || orderPays.size() == 0) {
            return null;
        }
        String payWayStr = "";
        OrderPay orderPay = (OrderPay)orderPays.get(0);
        Integer payWay = orderPay.getPayWay();
        if (payWay == null) {
            return payWayStr;
        }
        switch (payWay) {
            case 1: {
                payWayStr = "\u73b0\u91d1";
                break;
            }
            case 2: {
                payWayStr = "\u5fae\u4fe1";
                break;
            }
            case 3: {
                payWayStr = "\u652f\u4ed8\u5b9d";
                break;
            }
            case 4: {
                payWayStr = "\u94f6\u8054";
                break;
            }
            case 6: {
                payWayStr = "ETC";
                break;
            }
            case 10: {
                payWayStr = "\u4f18\u60e0\u62b5\u6263";
                break;
            }
        }
        return payWayStr;
    }
}

