/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import cn.hutool.core.util.StrUtil;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.IShowVoiceHandle;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LedShowHandle
implements IShowVoiceHandle {
    private static final Logger log = LoggerFactory.getLogger(LedShowHandle.class);
    @Autowired
    private LedService ledSoundService;
    @Value(value="${datacenter.exitPayUrl}")
    private String exitPayUrl;
    @Value(value="${datacenter.enterPayUrl}")
    private String enterPayUrl;
    @Autowired
    private StoreCardService storeCardService;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ParkRegionDao parkRegionDao;
    public static final String ROW1 = "\u6ce8\u610f\u5b89\u5168";
    public static final String ROW2 = "\u4e00\u8f66\u4e00\u6746";
    public static final String ROW3 = "\u51cf\u901f\u6162\u884c";
    public static final String ROW4 = "\u5269\u4f59\u8f66\u4f4d\uff1a%";
    public static final String SPLIT = "/";
    public static final String CUS_ROW1 = "\u4f59\u4f4d%";
    public static final String CUS_ROW2 = "\u4f59\u4f4d\u4f59\u4f4d";
    private static final Integer[] STYLE_ARR = new Integer[]{2, 3};
    private static String line2Parks = "P1574069875, P1574069698, P1574070102, P1573036782,P1576060397,P1574069698,P1574069875,P1574070102,P1576477906,P1576478969,P1576479065,P1576479113,P1576479173,P1576479243,P1576479294,P1576479350,P1576479423,P1576479490";
    @Autowired
    private ParkService parkService;

    public static String complement4Rows(String freeSpace) {
        return LedShowHandle.complement4Rows(null, freeSpace);
    }

    public static String complement2Rows(String freeSpace) {
        String content = "\u4f59\u4f4d%/\u4f59\u4f4d\u4f59\u4f4d/\u4f59\u4f4d%/\u4f59\u4f4d\u4f59\u4f4d";
        return content.replace("%", freeSpace);
    }

    public int getShowType(Long parkId, Long channelId) {
        ObjectResponse parkLedSoundConfigObjectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
        if (ObjectResponse.isSuccess((Response)parkLedSoundConfigObjectResponse)) {
            LedConfig ledConfig = (LedConfig)parkLedSoundConfigObjectResponse.getData();
            Integer ledQrcodeRule = ledConfig.getLedQrcodeRule();
            if (ledQrcodeRule != null && ledQrcodeRule == 1) {
                return ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal();
            }
            return ShowTypeEnum.\u666e\u901a\u6587\u672c.getVal();
        }
        return ShowTypeEnum.\u666e\u901a\u6587\u672c.getVal();
    }

    public static String complement4Rows(String content, String freeSpace) {
        if (content == null || content.trim().length() == 0) {
            return "\u6ce8\u610f\u5b89\u5168/\u4e00\u8f66\u4e00\u6746/\u51cf\u901f\u6162\u884c/" + ROW4.replace("%", freeSpace);
        }
        String[] rowsContent = content.split(SPLIT);
        if (rowsContent.length == 1) {
            content = content + "/\u4e00\u8f66\u4e00\u6746/\u51cf\u901f\u6162\u884c/" + ROW4.replace("%", freeSpace);
        } else if (rowsContent.length == 2) {
            content = content + "/\u51cf\u901f\u6162\u884c/" + ROW4.replace("%", freeSpace);
        } else if (rowsContent.length == 3) {
            content = content + SPLIT + ROW4.replace("%", freeSpace);
        }
        return content;
    }

    public static String needPay(String parkCode, String plateNum, Long parkTime, String unpayPrice) {
        if (line2Parks.contains(parkCode)) {
            return plateNum + "/\u65f6\u957f\uff1a" + DateTools.secondToSecondsTime((int)parkTime.intValue()) + "\uff0c\u8bf7\u7f34\u8d39" + unpayPrice + "\u5143";
        }
        return plateNum + "/\u505c\u8f66" + DateTools.secondToSecondsTime((int)parkTime.intValue()) + "/\u7f34\u8d39" + unpayPrice + "\u5143/\u8bf7\u626b\u7801\u7f34\u8d39";
    }

    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, Map<String, Object> para) {
        if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(type)) {
            return this.enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.\u6708\u5361\u8f66, para);
        }
        return this.enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, para);
    }

    @Override
    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        if (ShowSayConstants.ENTER_QR_RESULT_LIST.contains((Object)resultCode) && this.getShowType(parkId, channelId) == 2) {
            ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
            ObjectResponse.notError((Response)channelResp);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            if (NumberUtils.toPrimitive((Integer)channel.getLedcardType()) == 2 || NumberUtils.toPrimitive((Integer)channel.getLedcardType()) == 4) {
                return StringUtils.joinWith((String)"|", (Object[])new Object[]{this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type), this.enterPayUrl});
            }
            return this.enterPayUrl;
        }
        return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
    }

    @Override
    public String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        if (ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode) && this.getShowType(parkId, channelId) == 2) {
            ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
            ObjectResponse.notError((Response)channelResp);
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            if (NumberUtils.toPrimitive((Integer)channel.getLedcardType()) == 2 || NumberUtils.toPrimitive((Integer)channel.getLedcardType()) == 4) {
                return StringUtils.joinWith((String)"|", (Object[])new Object[]{this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type), this.exitPayUrl});
            }
            return this.exitPayUrl;
        }
        return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
    }

    @Override
    public String enterFreeHandle(Long parkId, Long channelId, Map<String, Object> para) {
        return this.generateContent(parkId, channelId, null, null, null, para, LedShow.DisplayTypeEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.type);
    }

    @Override
    public String exitFreeHandle(Long parkId, Long channelId, Map<String, Object> para) {
        return this.generateContent(parkId, channelId, null, null, null, para, LedShow.DisplayTypeEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.type);
    }

    public String generate4LineContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int displayType) {
        String[] split;
        ObjectResponse ledVoObjectResponse = this.ledSoundService.getLedShowByType(channelId, displayType);
        String content = ((LedShowDto)ledVoObjectResponse.getData()).getContent();
        if (StrUtil.isNotBlank((CharSequence)content) && (split = content.split(SPLIT)).length == 4) {
            String line4 = split[3];
            return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, line4);
        }
        return "";
    }

    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int displayType) {
        ObjectResponse ledVoObjectResponse = this.ledSoundService.getLedShowByType(channelId, displayType);
        String content = ((LedShowDto)ledVoObjectResponse.getData()).getContent();
        return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, content);
    }

    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, String content) {
        String[] dynamicValues;
        for (String value : dynamicValues = StringUtils.findBraceValue((String)content)) {
            Integer days;
            int dynamicValue = Integer.parseInt(value);
            if (dynamicValue == LedShow.VariateEnum.\u505c\u8f66\u573a\u540d\u79f0.type) {
                Object parkName = para.get("parkName");
                if (parkName == null) {
                    ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
                    para.put("parkName", ((Park)parkObjectResponse.getData()).getParkName());
                }
            } else if (dynamicValue == LedShow.VariateEnum.\u6708\u5361\u5269\u4f59\u5929\u6570.type && PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) && (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) {
                content = content.replace("{" + dynamicValue + "}", "");
                if (NumberUtils.toPrimitive((Integer)((Integer)para.get("days"))) != -2) continue;
                type = PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
                continue;
            }
            content = content.replace("{" + dynamicValue + "}", this.getReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
        }
        return content;
    }

    private String getReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 1: {
                Date date = new Date();
                replaceContent = DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm", (Date)date);
                break;
            }
            case 2: {
                ObjectResponse ledsoundConfigObjectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
                LedConfig parkLedSoundConfig = (LedConfig)ledsoundConfigObjectResponse.getData();
                Integer limitType = parkLedSoundConfig.getLimitType();
                int week = Integer.parseInt(DateTools.getWeek());
                if (limitType == 0) {
                    if (week == 1) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum1();
                        break;
                    }
                    if (week == 2) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum2();
                        break;
                    }
                    if (week == 3) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum3();
                        break;
                    }
                    if (week == 4) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum4();
                        break;
                    }
                    if (week == 5) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum5();
                        break;
                    }
                    replaceContent = "\u4e0d\u9650\u884c";
                    break;
                }
                if (week == 0 || week == 6) {
                    replaceContent = "\u4e0d\u9650\u884c";
                    break;
                }
                int day = Integer.parseInt(DateTools.getDay());
                if (day % 2 == 0) {
                    replaceContent = "\u5355\u53f7\u9650\u884c";
                    break;
                }
                replaceContent = "\u53cc\u53f7\u9650\u884c";
                break;
            }
            case 3: {
                int freeSpace = this.showSayBaseHandle.getFreeSpace(parkId, channelId, para);
                if (this.getLedCardType(channelId) == 34 && Arrays.asList(STYLE_ARR).contains(this.getStyle(parkId, channelId))) {
                    replaceContent = String.valueOf(freeSpace);
                    break;
                }
                replaceContent = this.showSayBaseHandle.getFreeSpaceName(parkId, channelId, para) + "\u5269\u4f59\u8f66\u4f4d" + freeSpace;
                break;
            }
            case 4: {
                replaceContent = plateNum;
                break;
            }
            case 5: {
                this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                replaceContent = (String)para.get("showTypeStr");
                break;
            }
            case 6: {
                Integer days;
                if (!PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) && !FlowCondition.ResultCode.\u8fc7\u671f\u5361.equals((Object)resultCode) || (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) break;
                replaceContent = "\u5269\u4f59" + days + "\u5929";
                break;
            }
            case 7: {
                Long parkTime = (Long)para.get("parkTime");
                if (parkTime == null || parkTime == 0L) break;
                replaceContent = "\u505c\u8f66" + DateTools.secondToSecondsTime((int)parkTime.intValue());
                break;
            }
            case 8: {
                if (resultCode.equals((Object)FlowCondition.ResultCode.\u8fc7\u671f\u5361)) {
                    Boolean isMonth = (Boolean)para.get("isMonth");
                    replaceContent = isMonth != null && isMonth != false ? this.enterTips(parkId, channelId, FlowCondition.ResultCode.\u6708\u5361\u8f66) : this.enterTips(parkId, channelId, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    break;
                }
                replaceContent = this.enterTips(parkId, channelId, resultCode);
                break;
            }
            case 9: {
                String prefix = "";
                if (Boolean.TRUE.equals(para.get("hasInnerAreaFee")) && (FlowCondition.ResultCode.\u9700\u7f34\u8d39.equals((Object)resultCode) || FlowCondition.ResultCode.\u56fa\u5b9a\u8d39\u7528.equals((Object)resultCode) || FlowCondition.ResultCode.\u6b20\u8d39\u8865\u7f34.equals((Object)resultCode))) {
                    this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                    if (para.get("regionId") != null && (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(para.get("type")) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(para.get("type")))) {
                        Long regionId = (Long)para.get("regionId");
                        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
                        prefix = parkRegion != null ? parkRegion.getRegionName() : prefix;
                    }
                }
                replaceContent = prefix + this.exitTips(parkId, channelId, resultCode, para);
                break;
            }
            case 10: {
                Object fee = para.get("fee");
                if (this.getLedCardType(channelId) == 34 && Arrays.asList(STYLE_ARR).contains(this.getStyle(parkId, channelId))) {
                    if (fee == null || !(Float.parseFloat((String)fee) > 0.0f)) break;
                    replaceContent = String.valueOf(fee);
                    break;
                }
                if (fee == null || Float.parseFloat((String)fee) <= 0.0f) {
                    if (!ShowSayConstants.NO_FEE_RESULT_LIST.contains((Object)resultCode)) break;
                    replaceContent = "\u65e0\u9700\u7f34\u8d39";
                    break;
                }
                replaceContent = fee + "\u5143";
                break;
            }
            case 11: {
                replaceContent = (String)para.get("parkName");
                break;
            }
            case 12: {
                ObjectResponse storeCardBalance;
                if (!PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType().equals(type) || !ObjectResponse.isSuccess((Response)(storeCardBalance = this.storeCardService.getStoreCardBalance(parkId, plateNum)))) break;
                BigDecimal balance = (BigDecimal)storeCardBalance.getData();
                replaceContent = "\u50a8\u503c\u5361\u4f59\u989d" + balance + "\u5143";
                break;
            }
            case 13: {
                replaceContent = DateTools.getFormat((String)"HH:mm", (Date)new Date());
                break;
            }
            case 14: {
                char ch;
                int week = Integer.parseInt(DateTools.getWeek());
                switch (week) {
                    case 1: {
                        ch = '\u4e00';
                        break;
                    }
                    case 2: {
                        ch = '\u4e8c';
                        break;
                    }
                    case 3: {
                        ch = '\u4e09';
                        break;
                    }
                    case 4: {
                        ch = '\u56db';
                        break;
                    }
                    case 5: {
                        ch = '\u4e94';
                        break;
                    }
                    case 6: {
                        ch = '\u516d';
                        break;
                    }
                    case 0: {
                        ch = '\u65e5';
                        break;
                    }
                    default: {
                        ch = '\u4e00';
                    }
                }
                replaceContent = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date()) + " \u661f\u671f" + ch;
                break;
            }
        }
        return replaceContent;
    }

    private int getLedCardType(Long channelId) {
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess((Response)channelResp)) {
            return 0;
        }
        return NumberUtils.toPrimitive((Integer)((ParkInoutdevice)channelResp.getData()).getLedcardType());
    }

    private int getStyle(Long parkId, Long channelId) {
        ObjectResponse objectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return 0;
        }
        return NumberUtils.toPrimitive((Integer)((LedConfig)objectResponse.getData()).getStyle());
    }

    public String enterTips(Long parkId, Long channelId, FlowCondition.ResultCode resultCode) {
        ObjectResponse specialLedObjectResponse = this.ledSoundService.getLedTipsByChannel(channelId);
        LedTips parkLedTipsConfig = (LedTips)specialLedObjectResponse.getData();
        return this.enterTips(parkLedTipsConfig, resultCode);
    }

    public String enterTips(LedTips ledTips, FlowCondition.ResultCode resultCode) {
        if (resultCode == null) {
            return "";
        }
        switch (resultCode) {
            case \u6708\u5361\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: 
            case VIP\u8f66\u8f86: {
                return ledTips.getEnterMonthVip();
            }
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165: 
            case \u8bbf\u5ba2\u8f66: {
                return ledTips.getEnterTmpSpecial();
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165: {
                return ledTips.getEnterNotAllowTmpRun();
            }
            case \u9ed1\u540d\u5355\u8f66: {
                return ledTips.getEnterBlackCar();
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return ledTips.getEnterNotAllowNocarRun();
            }
            case \u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165: {
                return ledTips.getEnterNotAllowTmpRun();
            }
            case \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a: {
                return ledTips.getEnterNoParkingSpace();
            }
            case \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a: {
                return ledTips.getEnterNotAllowTmpRun();
            }
            case \u8fc7\u671f\u5361: {
                return ledTips.getEnterMonthExpire();
            }
            case \u8f66\u4f4d\u5df2\u5360: {
                return ledTips.getEnterMultiParkCar();
            }
            case \u6b20\u8d39\u8865\u7f34: {
                return ledTips.getEnterUnpaid();
            }
            case \u865a\u5047\u8f66\u724c: {
                return ledTips.getEnterShamPlate() == null ? "" : ledTips.getEnterShamPlate();
            }
        }
        return "";
    }

    public String exitTips(Long parkId, Long channelId, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse specialLedObjectResponse = this.ledSoundService.getLedTipsByChannel(channelId);
        LedTips parkLedTipsConfig = (LedTips)specialLedObjectResponse.getData();
        return this.exitTips(parkLedTipsConfig, resultCode, para);
    }

    public String exitTips(LedTips ledTips, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        if (resultCode == null) {
            return "";
        }
        switch (resultCode) {
            case \u6708\u5361\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: 
            case \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0: 
            case \u514d\u8d39\u65f6\u95f4\u5185: 
            case \u65e0\u9700\u7f34\u8d39: 
            case \u7279\u6b8a\u8f66\u8f86\u514d\u8d39: 
            case \u9884\u7f34\u8d39\u672a\u8d85\u65f6: 
            case \u65e0\u5165\u573aVIP\u5168\u514d\u8f66: {
                String prefix = "";
                String payWay = this.showSayBaseHandle.getPayWay(para);
                if (payWay != null) {
                    prefix = payWay + "\u652f\u4ed8\u6210\u529f ";
                }
                return prefix + ledTips.getExitOpenGate();
            }
            case \u9ed1\u540d\u5355\u8f66: 
            case \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa: {
                return ledTips.getExitNotAllowRun();
            }
            case \u9700\u7f34\u8d39: 
            case \u56fa\u5b9a\u8d39\u7528: {
                return ledTips.getExitPay();
            }
            case \u65e0\u5165\u573a\u8bb0\u5f55: {
                return ledTips.getExitNoEnterinfo();
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return ledTips.getExitNoCarplate();
            }
            case \u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5: {
                String prefix2 = "";
                String payWay2 = this.showSayBaseHandle.getPayWay(para);
                if (payWay2 != null) {
                    prefix2 = payWay2 + "\u652f\u4ed8\u6210\u529f ";
                }
                return prefix2 + ledTips.getExitOpenGate();
            }
            case \u6b20\u8d39\u8865\u7f34: {
                return ledTips.getExitUnpaid();
            }
            case \u865a\u5047\u8f66\u724c: {
                return ledTips.getExitShamPlate() == null ? "" : ledTips.getExitShamPlate();
            }
        }
        return "";
    }

    private boolean isShowExpireMc(MonthDetailDto monthDetailDto, Long parkId, Long channelId) {
        if (!MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66.equals((Object)monthDetailDto.getMonthType()) && !MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66.equals((Object)monthDetailDto.getMonthType())) {
            return false;
        }
        ObjectResponse objectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return false;
        }
        LedConfig ledConfig = (LedConfig)objectResponse.getData();
        return ledConfig.getLedExpireDaysMc() != null && monthDetailDto.getExpiredDays() != null && ledConfig.getLedExpireDaysMc() >= monthDetailDto.getExpiredDays();
    }
}

