/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.service.IShowVoiceHandle;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LedSayHandle
implements IShowVoiceHandle {
    private static final Logger log = LoggerFactory.getLogger(LedSayHandle.class);
    private static String line2Parks = "P1574069875, P1574069698, P1574070102, P1573036782,P1576060397P1574069698,P1574069875,P1574070102,P1576477906,P1576478969,P1576479065,P1576479113,P1576479173,P1576479243,P1576479294,P1576479350,P1576479423,P1576479490";
    @Autowired
    private ParkService parkService;
    @Autowired
    private LedService ledSoundService;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;

    public static String needPay(String parkCode, String plateNum, String unpayPrice, Long parkTime) {
        if (line2Parks.contains(parkCode)) {
            return DateTools.secondToSecondsTime((int)parkTime.intValue()) + "\u3001\u8bf7\u7f34\u8d39" + unpayPrice + "\u5143";
        }
        return "\u8bf7\u626b\u7801\u7f34\u8d39";
    }

    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, Map<String, Object> para) {
        if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(type)) {
            return this.enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.\u6708\u5361\u8f66, para);
        }
        return this.enterHandle(parkId, channelId, plateNum, type, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, para);
    }

    @Override
    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        switch (resultCode) {
            case \u6708\u5361\u8f66: 
            case VIP\u8f66\u8f86: 
            case \u8bbf\u5ba2\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u5165\u573a\u6708\u5361\u8f66_\u5185\u90e8\u8f66\u8f86.type);
            }
            case \u8fc7\u671f\u5361: {
                if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type)) {
                    return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u5165\u573a\u6708\u5361\u8f66_\u5185\u90e8\u8f66\u8f86.type);
                }
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type);
            }
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type);
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type);
            }
            case \u9ed1\u540d\u5355\u8f66: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type);
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u5165\u573a\u65e0\u724c\u8f66.type);
            }
            case \u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type);
            }
            case \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u8f66\u4f4d\u5df2\u6ee1.type);
            }
            case \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type);
            }
            case \u8f66\u4f4d\u5df2\u5360: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u591a\u4f4d\u591a\u8f66\u8f66\u4f4d\u5360\u7528.type);
            }
            case \u6b20\u8d39\u8865\u7f34: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u6536\u8d39\u8f66\u8f86.type);
            }
            case \u865a\u5047\u8f66\u724c: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u5165\u53e3\u865a\u5047\u8f66\u724c.type);
            }
        }
        return "";
    }

    @Override
    public String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        switch (resultCode) {
            case \u6708\u5361\u8f66: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u6708\u5361\u8f66.type);
            }
            case VIP\u8f66\u8f86: 
            case \u5185\u90e8\u8f66\u8f86: 
            case \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0: 
            case \u514d\u8d39\u65f6\u95f4\u5185: 
            case \u65e0\u9700\u7f34\u8d39: 
            case \u7279\u6b8a\u8f66\u8f86\u514d\u8d39: 
            case \u9884\u7f34\u8d39\u672a\u8d85\u65f6: 
            case \u65e0\u5165\u573aVIP\u5168\u514d\u8f66: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u514d\u8d39\u8f66\u8f86_\u4e34\u65f6\u7279\u6b8a.type);
            }
            case \u9ed1\u540d\u5355\u8f66: 
            case \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type);
            }
            case \u6b20\u8d39\u8865\u7f34: 
            case \u9700\u7f34\u8d39: 
            case \u56fa\u5b9a\u8d39\u7528: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u6536\u8d39\u8f66\u8f86.type);
            }
            case \u65e0\u5165\u573a\u8bb0\u5f55: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.type);
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u724c\u8f66.type);
            }
            case \u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u573a\u652f\u4ed8\u6210\u529f.type);
            }
            case \u865a\u5047\u8f66\u724c: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LedSound.SoundTypeEnum.\u51fa\u53e3\u865a\u5047\u8f66\u724c.type);
            }
        }
        return "";
    }

    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int soundType) {
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        ObjectResponse.notError((Response)channelResp);
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        if (channel.getTtsType() == null || channel.getLedcardType() == null) {
            log.info("<\u81ea\u5b9a\u4e49\u8bed\u97f3\u8f6c\u6362> \u672a\u914d\u7f6e\u63a7\u5236\u5361\u7c7b\u578b\u548c\u662f\u5426\u652f\u6301TTS, \u8f66\u573aID\uff1a{}", (Object)parkId);
            throw new ResponseBodyException("400", "\u8bf7\u5148\u914d\u7f6e\u63a7\u5236\u5361\u7c7b\u578b\u548c\u662f\u5426\u652f\u6301TTS");
        }
        para.put("enexType", channel.getInandoutType());
        ObjectResponse soundDtoObjectResponse = this.ledSoundService.getLedSoundDtoByType(channelId, soundType);
        LedSoundDto soundVo = (LedSoundDto)soundDtoObjectResponse.getData();
        String content = soundVo.getContent();
        String[] dynamicValues = StringUtils.findBraceValue((String)content);
        if (channel.getTtsType() == 0) {
            if (soundType == LedSound.SoundTypeEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.type) {
                return "<11/>";
            }
            if (soundType == LedSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type) {
                return "<13/>";
            }
            if (soundType == LedSound.SoundTypeEnum.\u8f66\u4f4d\u5df2\u6ee1.type) {
                return "<12/>";
            }
            if (soundType == LedSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type) {
                return "<13/>";
            }
        }
        for (String value : dynamicValues) {
            Integer days;
            int dynamicValue = Integer.parseInt(value);
            if (dynamicValue == LedSound.VariateEnum.\u6708\u5361\u5269\u4f59\u5929\u6570.type && PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) && (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) {
                content = content.replace("{" + dynamicValue + "}", "");
                if (NumberUtils.toPrimitive((Integer)((Integer)para.get("days"))) != -2) continue;
                type = PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
                continue;
            }
            content = channel.getTtsType() == 1 ? content.replace("{" + dynamicValue + "}", this.getTTSReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para)) : content.replace("{" + dynamicValue + "}", this.getNoTTSReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
        }
        return content.trim();
    }

    private String getTTSReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 1: {
                Date date = new Date();
                replaceContent = DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm", (Date)date);
                break;
            }
            case 2: {
                ObjectResponse ledsoundConfigObjectResponse = this.ledSoundService.getLedConfigByChannel(channelId);
                LedConfig parkLedSoundConfig = (LedConfig)ledsoundConfigObjectResponse.getData();
                Integer limitType = parkLedSoundConfig.getLimitType();
                int week = Integer.parseInt(DateTools.getWeek());
                if (limitType == 0) {
                    if (week == 1) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum1();
                        break;
                    }
                    if (week == 2) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum2();
                        break;
                    }
                    if (week == 3) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum3();
                        break;
                    }
                    if (week == 4) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum4();
                        break;
                    }
                    if (week == 5) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + parkLedSoundConfig.getLimitDriveNum5();
                        break;
                    }
                    replaceContent = "\u4e0d\u9650\u884c";
                    break;
                }
                if (week == 0 || week == 6) {
                    replaceContent = "\u4e0d\u9650\u884c";
                    break;
                }
                int day = Integer.parseInt(DateTools.getDay());
                if (day % 2 == 0) {
                    replaceContent = "\u5355\u53f7\u9650\u884c";
                    break;
                }
                replaceContent = "\u53cc\u53f7\u9650\u884c";
                break;
            }
            case 3: {
                int freeSpace = this.showSayBaseHandle.getFreeSpace(parkId, channelId, para);
                replaceContent = this.showSayBaseHandle.getFreeSpaceName(parkId, channelId, para) + "\u5269\u4f59\u8f66\u4f4d" + freeSpace;
                break;
            }
            case 4: {
                replaceContent = plateNum;
                break;
            }
            case 5: {
                this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                replaceContent = (String)para.getOrDefault("sayTypeStr", para.get("showTypeStr"));
                break;
            }
            case 6: {
                Integer days;
                if (!type.equals(PlateTypeEnum.\u6708\u5361\u8f66.getType()) && !resultCode.equals((Object)FlowCondition.ResultCode.\u6708\u5361\u8f66) && !resultCode.equals((Object)FlowCondition.ResultCode.\u8fc7\u671f\u5361) || (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) break;
                replaceContent = "\u5269\u4f59" + days + "\u5929";
                break;
            }
            case 7: {
                Long parkTime = (Long)para.get("parkTime");
                if (parkTime == null || parkTime == 0L) break;
                replaceContent = "\u505c\u8f66" + DateTools.secondToSecondsTime((int)parkTime.intValue());
                break;
            }
            case 8: {
                LedSoundDto soundVo;
                ObjectResponse soundDtoObjectResponse;
                if (para.get("fee") == null) break;
                replaceContent = "\u8bf7\u7f34\u8d39" + para.get("fee") + "\u5143";
                if (!FlowCondition.ResultCode.\u6b20\u8d39\u8865\u7f34.equals((Object)resultCode)) break;
                Integer enexType = (Integer)para.get("enexType");
                if (NumberUtils.toPrimitive((Integer)enexType) == 1) {
                    soundDtoObjectResponse = this.ledSoundService.getLedSoundDtoByType(channelId, LedSound.SoundTypeEnum.\u5165\u53e3\u6b20\u8d39\u8865\u7f34.type);
                    soundVo = (LedSoundDto)soundDtoObjectResponse.getData();
                } else {
                    soundDtoObjectResponse = this.ledSoundService.getLedSoundDtoByType(channelId, LedSound.SoundTypeEnum.\u51fa\u53e3\u6b20\u8d39\u8865\u7f34.type);
                    soundVo = (LedSoundDto)soundDtoObjectResponse.getData();
                }
                String content = soundVo.getContent();
                replaceContent = replaceContent + " " + content;
                break;
            }
            case 9: {
                String payWay = this.showSayBaseHandle.getPayWay(para);
                if (payWay != null) {
                    replaceContent = payWay + "\u652f\u4ed8\u6210\u529f \u4e00\u8def\u5e73\u5b89";
                    break;
                }
                replaceContent = "\u4e00\u8def\u5e73\u5b89";
                break;
            }
            case 10: {
                replaceContent = "\u6b22\u8fce\u5149\u4e34";
                break;
            }
            case 11: {
                replaceContent = "\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4";
                break;
            }
        }
        return replaceContent;
    }

    private String getNoTTSReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 4: {
                replaceContent = "<4>" + plateNum + "</4>";
                break;
            }
            case 5: {
                this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                Integer realType = (Integer)para.getOrDefault("type", 1);
                if (realType != null && realType == 2) {
                    replaceContent = "<15/>";
                    break;
                }
                if (realType == null || realType != 1) break;
                replaceContent = "<14/>";
                break;
            }
            case 6: {
                Integer days;
                if (!type.equals(PlateTypeEnum.\u6708\u5361\u8f66.getType()) && !resultCode.equals((Object)FlowCondition.ResultCode.\u6708\u5361\u8f66) && !resultCode.equals((Object)FlowCondition.ResultCode.\u8fc7\u671f\u5361) || (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) break;
                replaceContent = "<6>" + days + "</6>";
                break;
            }
            case 7: {
                Long parkTime = (Long)para.get("parkTime");
                if (parkTime == null || parkTime == 0L) break;
                replaceContent = "<7>" + parkTime + "</7>";
                break;
            }
            case 8: {
                if (para.get("fee") == null) break;
                int fee = (int)(Float.parseFloat((String)para.get("fee")) * 10.0f);
                replaceContent = "<8>" + fee + "</8>";
                break;
            }
            case 9: {
                replaceContent = "<9/>";
                break;
            }
            case 10: {
                replaceContent = "<10/>";
                break;
            }
            case 11: {
                replaceContent = "<11/>";
                break;
            }
            case 12: {
                replaceContent = "<12/>";
                break;
            }
            case 13: {
                replaceContent = "<13/>";
                break;
            }
        }
        return replaceContent;
    }
}

