/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.response.LcdDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.IShowVoiceHandle;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LcdShowHandle
implements IShowVoiceHandle {
    private static final Logger log = LoggerFactory.getLogger(LcdShowHandle.class);
    @Autowired
    private LcdService lcdService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private StoreCardService storeCardService;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Override
    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
    }

    @Override
    public String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
    }

    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int displayType) {
        ObjectResponse objectResponse = this.lcdService.getLcdShowByType(channelId, displayType);
        String content = ((LcdDto)objectResponse.getData()).getContent();
        String[] dynamicValues = StringUtils.findBraceValue((String)content);
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        for (String value : dynamicValues) {
            Integer days;
            int dynamicValue = Integer.parseInt(value);
            if (dynamicValue == LcdShow.VariateEnum.\u505c\u8f66\u573a\u540d\u79f0.type) {
                Object parkName = para.get("parkName");
                if (parkName == null) {
                    ObjectResponse parkObjectResponse = this.parkService.findByParkId(parkId);
                    para.put("parkName", ((Park)parkObjectResponse.getData()).getParkName());
                }
            } else if (dynamicValue == LcdShow.VariateEnum.\u6708\u5361\u5269\u4f59\u5929\u6570.type && PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) && (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) {
                content = content.replace("{" + dynamicValue + "}", "");
                if (NumberUtils.toPrimitive((Integer)((Integer)para.get("days"))) != -2) continue;
                type = PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
                continue;
            }
            content = content.replace("{" + dynamicValue + "}", this.getReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
        }
        return content.trim();
    }

    private String getReplaceContent(int dynamicValue, Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case 1: {
                Date date = new Date();
                replaceContent = DateTools.getFormat((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm", (Date)date);
                break;
            }
            case 2: {
                ObjectResponse lcdConfigObjectResponse = this.lcdService.getLcdConfigByChannel(channelId);
                LcdConfig lcdConfig = (LcdConfig)lcdConfigObjectResponse.getData();
                Integer limitType = lcdConfig.getLimitType();
                int week = Integer.parseInt(DateTools.getWeek());
                if (limitType == 0) {
                    if (week == 1) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + lcdConfig.getLimitDriveNum1();
                        break;
                    }
                    if (week == 2) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + lcdConfig.getLimitDriveNum2();
                        break;
                    }
                    if (week == 3) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + lcdConfig.getLimitDriveNum3();
                        break;
                    }
                    if (week == 4) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + lcdConfig.getLimitDriveNum4();
                        break;
                    }
                    if (week == 5) {
                        replaceContent = "\u4eca\u65e5\u9650\u53f7" + lcdConfig.getLimitDriveNum5();
                        break;
                    }
                    replaceContent = "\u4e0d\u9650\u884c";
                    break;
                }
                if (week == 0 || week == 6) {
                    replaceContent = "\u4e0d\u9650\u884c";
                    break;
                }
                int day = Integer.parseInt(DateTools.getDay());
                if (day % 2 == 0) {
                    replaceContent = "\u5355\u53f7\u9650\u884c";
                    break;
                }
                replaceContent = "\u53cc\u53f7\u9650\u884c";
                break;
            }
            case 3: {
                int freeSpace = this.showSayBaseHandle.getFreeSpace(parkId, channelId, para);
                replaceContent = this.showSayBaseHandle.getFreeSpaceName(parkId, channelId, para) + "\u5269\u4f59\u8f66\u4f4d" + freeSpace;
                break;
            }
            case 4: {
                replaceContent = plateNum;
                break;
            }
            case 5: {
                this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                replaceContent = (String)para.get("showTypeStr");
                break;
            }
            case 6: {
                Integer days;
                if (!type.equals(PlateTypeEnum.\u6708\u5361\u8f66.getType()) && !resultCode.equals((Object)FlowCondition.ResultCode.\u8fc7\u671f\u5361) || (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) break;
                replaceContent = "\u5269\u4f59" + days + "\u5929";
                break;
            }
            case 7: {
                Long parkTime = (Long)para.get("parkTime");
                if (parkTime == null || parkTime == 0L) break;
                replaceContent = "\u505c\u8f66" + DateTools.secondToSecondsTime((int)parkTime.intValue());
                break;
            }
            case 8: {
                if (resultCode.equals((Object)FlowCondition.ResultCode.\u8fc7\u671f\u5361)) {
                    Boolean isMonth = (Boolean)para.get("isMonth");
                    replaceContent = isMonth != null && isMonth != false ? this.enterTips(parkId, channelId, FlowCondition.ResultCode.\u6708\u5361\u8f66) : this.enterTips(parkId, channelId, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    break;
                }
                replaceContent = this.enterTips(parkId, channelId, resultCode);
                break;
            }
            case 9: {
                String prefix = "";
                if (Boolean.TRUE.equals(para.get("hasInnerAreaFee")) && (FlowCondition.ResultCode.\u9700\u7f34\u8d39.equals((Object)resultCode) || FlowCondition.ResultCode.\u56fa\u5b9a\u8d39\u7528.equals((Object)resultCode) || FlowCondition.ResultCode.\u6b20\u8d39\u8865\u7f34.equals((Object)resultCode))) {
                    this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                    if (para.get("regionId") != null && (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(para.get("type")) || PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(para.get("type")))) {
                        Long regionId = (Long)para.get("regionId");
                        ParkRegion parkRegion = (ParkRegion)this.parkRegionDao.selectById((Serializable)regionId);
                        prefix = parkRegion != null ? parkRegion.getRegionName() : prefix;
                    }
                }
                replaceContent = prefix + this.exitTips(parkId, channelId, resultCode, para);
                break;
            }
            case 10: {
                Object fee = para.get("fee");
                if (fee == null || Float.parseFloat((String)fee) <= 0.0f) {
                    if (!ShowSayConstants.NO_FEE_RESULT_LIST.contains((Object)resultCode)) break;
                    replaceContent = "\u65e0\u9700\u7f34\u8d39";
                    break;
                }
                replaceContent = fee + "\u5143";
                break;
            }
            case 11: {
                replaceContent = (String)para.get("parkName");
                break;
            }
            case 12: {
                ObjectResponse storeCardBalance;
                if (!PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType().equals(type) || !ObjectResponse.isSuccess((Response)(storeCardBalance = this.storeCardService.getStoreCardBalance(parkId, plateNum)))) break;
                BigDecimal balance = (BigDecimal)storeCardBalance.getData();
                replaceContent = "\u50a8\u503c\u5361\u4f59\u989d" + balance + "\u5143";
                break;
            }
        }
        return replaceContent;
    }

    public String enterTips(Long parkId, Long channelId, FlowCondition.ResultCode resultCode) {
        ObjectResponse objectResponse = this.lcdService.getLcdTipsByChannel(channelId);
        LcdTips lcdTips = (LcdTips)objectResponse.getData();
        switch (resultCode) {
            case \u6708\u5361\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: 
            case VIP\u8f66\u8f86: {
                return lcdTips.getEnterMonthVip();
            }
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165: {
                return lcdTips.getEnterTmpSpecial();
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165: {
                return lcdTips.getEnterNotAllowTmpRun();
            }
            case \u9ed1\u540d\u5355\u8f66: {
                return lcdTips.getEnterBlackCar();
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return lcdTips.getEnterNotAllowNocarRun();
            }
            case \u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165: {
                return lcdTips.getEnterNotAllowNocarRun();
            }
            case \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a: {
                return lcdTips.getEnterNoParkingSpace();
            }
            case \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a: {
                return lcdTips.getEnterNotAllowTmpRun();
            }
            case \u8fc7\u671f\u5361: {
                return lcdTips.getEnterMonthExpire();
            }
            case \u8f66\u4f4d\u5df2\u5360: {
                return lcdTips.getEnterMultiParkCar();
            }
            case \u6b20\u8d39\u8865\u7f34: {
                return lcdTips.getEnterUnpaid();
            }
            case \u865a\u5047\u8f66\u724c: {
                return lcdTips.getEnterShamPlate() == null ? "" : lcdTips.getEnterShamPlate();
            }
        }
        return "";
    }

    public String exitTips(Long parkId, Long channelId, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse objectResponse = this.lcdService.getLcdTipsByChannel(channelId);
        LcdTips lcdTips = (LcdTips)objectResponse.getData();
        switch (resultCode) {
            case \u6708\u5361\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: 
            case \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0: 
            case \u514d\u8d39\u65f6\u95f4\u5185: 
            case \u65e0\u9700\u7f34\u8d39: 
            case \u7279\u6b8a\u8f66\u8f86\u514d\u8d39: 
            case \u9884\u7f34\u8d39\u672a\u8d85\u65f6: 
            case \u65e0\u5165\u573aVIP\u5168\u514d\u8f66: {
                String prefix = "";
                String payWay = this.showSayBaseHandle.getPayWay(para);
                if (payWay != null) {
                    prefix = payWay + "\u652f\u4ed8\u6210\u529f ";
                }
                return prefix + lcdTips.getExitOpenGate();
            }
            case \u9ed1\u540d\u5355\u8f66: 
            case \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa: {
                return lcdTips.getExitNotAllowRun();
            }
            case \u9700\u7f34\u8d39: 
            case \u56fa\u5b9a\u8d39\u7528: {
                return lcdTips.getExitPay();
            }
            case \u65e0\u5165\u573a\u8bb0\u5f55: {
                return lcdTips.getExitNoEnterinfo();
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return lcdTips.getExitNoCarplate();
            }
            case \u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5: {
                String prefix2 = "";
                String payWay2 = this.showSayBaseHandle.getPayWay(para);
                if (payWay2 != null) {
                    prefix2 = payWay2 + "\u652f\u4ed8\u6210\u529f ";
                }
                return prefix2 + lcdTips.getExitOpenGate();
            }
            case \u6b20\u8d39\u8865\u7f34: {
                return lcdTips.getExitUnpaid();
            }
            case \u865a\u5047\u8f66\u724c: {
                return lcdTips.getExitShamPlate() == null ? "" : lcdTips.getExitShamPlate();
            }
        }
        return "";
    }
}

