/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.park.service.IShowVoiceHandle;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LcdSayHandle
implements IShowVoiceHandle {
    private static final Logger log = LoggerFactory.getLogger(LcdSayHandle.class);
    @Autowired
    private LcdService lcdService;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;

    @Override
    public String enterHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        switch (resultCode) {
            case \u6708\u5361\u8f66: 
            case VIP\u8f66\u8f86: 
            case \u8bbf\u5ba2\u8f66: 
            case \u5185\u90e8\u8f66\u8f86: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u5165\u573a\u6708\u5361\u8f66_\u5185\u90e8\u8f66\u8f86.type);
            }
            case \u8fc7\u671f\u5361: {
                if (type.equals(PlateTypeEnum.\u6708\u5361\u8f66.getType())) {
                    return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u5165\u573a\u6708\u5361\u8f66_\u5185\u90e8\u8f66\u8f86.type);
                }
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type);
            }
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u5165\u573a\u4e34\u65f6\u8f66.type);
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: 
            case \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type);
            }
            case \u9ed1\u540d\u5355\u8f66: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type);
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u5165\u573a\u65e0\u724c\u8f66.type);
            }
            case \u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type);
            }
            case \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u8f66\u4f4d\u5df2\u6ee1.type);
            }
            case \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u4e34\u65f6\u8f66\u7981\u6b62\u901a\u884c.type);
            }
            case \u8f66\u4f4d\u5df2\u5360: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u591a\u4f4d\u591a\u8f66\u8f66\u4f4d\u5360\u7528.type);
            }
            case \u6b20\u8d39\u8865\u7f34: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u6536\u8d39\u8f66\u8f86.type);
            }
            case \u865a\u5047\u8f66\u724c: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u5165\u53e3\u865a\u5047\u8f66\u724c.type);
            }
        }
        return "";
    }

    @Override
    public String exitHandle(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        switch (resultCode) {
            case \u6708\u5361\u8f66: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u6708\u5361\u8f66.type);
            }
            case VIP\u8f66\u8f86: 
            case \u5185\u90e8\u8f66\u8f86: 
            case \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0: 
            case \u514d\u8d39\u65f6\u95f4\u5185: 
            case \u65e0\u9700\u7f34\u8d39: 
            case \u7279\u6b8a\u8f66\u8f86\u514d\u8d39: 
            case \u9884\u7f34\u8d39\u672a\u8d85\u65f6: 
            case \u65e0\u5165\u573aVIP\u5168\u514d\u8f66: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u514d\u8d39\u8f66\u8f86_\u4e34\u65f6\u7279\u6b8a.type);
            }
            case \u9ed1\u540d\u5355\u8f66: 
            case \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u9ed1\u540d\u5355\u8f66\u8f86\u8fdb\u51fa\u573a.type);
            }
            case \u6b20\u8d39\u8865\u7f34: 
            case \u9700\u7f34\u8d39: 
            case \u56fa\u5b9a\u8d39\u7528: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u6536\u8d39\u8f66\u8f86.type);
            }
            case \u65e0\u5165\u573a\u8bb0\u5f55: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u65e0\u5165\u573a\u8bb0\u5f55.type);
            }
            case \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u65e0\u724c\u8f66.type);
            }
            case \u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u573a\u652f\u4ed8\u6210\u529f.type);
            }
            case \u865a\u5047\u8f66\u724c: {
                return this.generateContent(parkId, channelId, plateNum, type, resultCode, para, LcdSound.SoundTypeEnum.\u51fa\u53e3\u865a\u5047\u8f66\u724c.type);
            }
        }
        return "";
    }

    private String generateContent(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, int soundType) {
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        ObjectResponse soundDtoObjectResponse = this.lcdService.getSoundConfigByType(channelId, soundType);
        LedSoundDto soundVo = (LedSoundDto)soundDtoObjectResponse.getData();
        String content = soundVo.getContent();
        String[] dynamicValues = content.split(" ");
        String mcDays = "D5";
        for (String dynamicValue : dynamicValues) {
            Integer days;
            if (dynamicValue.equals(mcDays) && PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) && (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) {
                content = content.replace(dynamicValue, "");
                if (NumberUtils.toPrimitive((Integer)((Integer)para.get("days"))) != -2) continue;
                type = PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
                continue;
            }
            content = content.replace(dynamicValue, this.getNoTtsReplaceContent(dynamicValue, parkId, channelId, plateNum, type, resultCode, para));
        }
        return content;
    }

    private String getNoTtsReplaceContent(String dynamicValue, Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        String replaceContent = "";
        switch (dynamicValue) {
            case "D2": {
                int freeSpace = this.showSayBaseHandle.getFreeSpace(parkId, channelId, para);
                replaceContent = "<D2>" + freeSpace + "</D2>";
                break;
            }
            case "D3": {
                replaceContent = "<D3>" + plateNum + "</D3>";
                break;
            }
            case "D4": {
                this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para);
                Integer realType = (Integer)para.getOrDefault("type", 1);
                String newType = realType == 2 ? PlateTypeEnum.\u6708\u5361\u8f66.name() : PlateTypeEnum.\u4e34\u65f6\u8f66.name();
                replaceContent = "<D4>" + newType + "</D4>";
                break;
            }
            case "D5": {
                Integer days;
                if (!PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type) && !resultCode.equals((Object)FlowCondition.ResultCode.\u6708\u5361\u8f66) && !resultCode.equals((Object)FlowCondition.ResultCode.\u8fc7\u671f\u5361) || (days = this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)) == null) break;
                replaceContent = "<D5>" + days + "</D5>";
                break;
            }
            case "D6": {
                Long parkTime = (Long)para.get("parkTime");
                if (parkTime == null || parkTime == 0L) break;
                replaceContent = "<D6>" + parkTime + "</D6>";
                break;
            }
            case "D7": {
                String feeStr = (String)para.get("fee");
                if (feeStr == null) break;
                int fee = (int)(Float.parseFloat(feeStr) * 10.0f);
                replaceContent = "<D7>" + fee + "</D7>";
                break;
            }
            case "D8": {
                replaceContent = "<D8>\u5c0f\u578b\u8f66</D8>";
                break;
            }
            default: {
                replaceContent = "<" + dynamicValue + "/>";
            }
        }
        return replaceContent;
    }
}

