/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.ShowTypeEnum;
import com.icetech.cloudcenter.domain.request.itc.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.LcdHintRequest;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.down.ExHintService;
import com.icetech.park.service.down.itc.impl.ItcHintServiceImpl;
import com.icetech.park.service.down.p2c.impl.LcdHintServiceImpl;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.park.service.handle.showsay.CommonSayHandle;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.park.service.handle.showsay.ShowSayBaseHandle;
import com.icetech.park.service.handle.showsay.ShowSayConstants;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DownShowSayHandle {
    private static final Logger log = LoggerFactory.getLogger(DownShowSayHandle.class);
    @Autowired
    private LcdHintServiceImpl lcdHintService;
    @Autowired
    private CommonShowHandle commonShowHandle;
    @Autowired
    private CommonSayHandle commonSayHandle;
    @Autowired
    private ParkService parkService;
    @Value(value="${web.url}")
    private String webUrl;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected ItcCacheHandle itcCacheHandle;
    @Autowired
    private HintServiceImpl robotHintService;
    @Autowired
    private ShowPayInfoServiceImpl showPayInfoService;
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private ShowSayBaseHandle showSayBaseHandle;
    @Autowired
    private ItcHintServiceImpl itcHintService;
    @Autowired
    private DeviceDownServiceFactory deviceDownServiceFactory;

    public ObjectResponse fixShowSayExec(Long parkId, String parkCode, Long channelId, String plateNum, String show, String say, String qrCodeUrl, String serialNumber, boolean isReachable) {
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess((Response)channelResp)) {
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            if (ledLcdSource == 2) {
                LcdHintRequest lcdHintRequest = new LcdHintRequest();
                lcdHintRequest.setSay(say);
                if ("6666".equals(say)) {
                    lcdHintRequest.setSay("<D3>" + say + "<D3>");
                }
                lcdHintRequest.setShow(show);
                lcdHintRequest.setPlateNum(plateNum);
                lcdHintRequest.setQrCodeUrl(qrCodeUrl);
                if (isReachable) {
                    return this.lcdHintService.execute(parkId, parkCode, serialNumber, lcdHintRequest);
                }
                String msgId = this.lcdHintService.showAndSay(parkId, parkCode, serialNumber, lcdHintRequest);
                if (msgId == null) {
                    log.info("<\u7edf\u4e00\u5c4f\u663e\u8bed\u97f3\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                    return ObjectResponse.failed((String)"3003");
                }
            } else {
                HintRequest hintRequest = new HintRequest();
                hintRequest.setShowTypeByShow(show);
                hintRequest.setSay(say);
                hintRequest.setPlateNum(plateNum);
                hintRequest.setShow(show);
                ExHintService exHintService = this.deviceDownServiceFactory.buildExHintService(parkCode);
                if (isReachable) {
                    return exHintService.execute(parkId, parkCode, serialNumber, hintRequest);
                }
                String msgId = exHintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                if (msgId == null) {
                    log.info("<\u7edf\u4e00\u5c4f\u663e\u8bed\u97f3\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                    return ObjectResponse.failed((String)"3003");
                }
            }
        }
        return ObjectResponse.success();
    }

    public ObjectResponse showSayExec(Long parkId, String parkCode, Long channelId, String plateNum, Integer type, Map<String, Object> para, String serialNumber, int enexType, String channelCode, boolean isReachable) {
        TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        para.put("regionId", tokenDeviceVo.getRegionId());
        para.put("enexType", enexType);
        para.put("channelCode", channelCode);
        if (PlateTypeEnum.\u6708\u5361\u8f66.getType().equals(type)) {
            return this.showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.\u6708\u5361\u8f66, para, serialNumber, enexType, channelCode, isReachable);
        }
        if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(type)) {
            return this.showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.VIP\u8f66\u8f86, para, serialNumber, enexType, channelCode, isReachable);
        }
        if (PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType().equals(type)) {
            return this.showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.\u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165, para, serialNumber, enexType, channelCode, isReachable);
        }
        if (PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType().equals(type)) {
            return this.showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.\u8bbf\u5ba2\u8f66, para, serialNumber, enexType, channelCode, isReachable);
        }
        return this.showSayExec(parkId, parkCode, channelId, plateNum, type, FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165, para, serialNumber, enexType, channelCode, isReachable);
    }

    public ObjectResponse showSayExec(Long parkId, String parkCode, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, String serialNumber, int enexType, String channelCode, boolean isReachable) {
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(serialNumber);
        para.put("enexType", enexType);
        para.put("channelCode", channelCode);
        para.put("regionId", tokenDeviceVo.getRegionId());
        String show = null;
        String say = null;
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess((Response)channelResp)) {
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            if (ledLcdSource == 2) {
                String qrCodeUr;
                LcdHintRequest lcdHintRequest = new LcdHintRequest();
                if (enexType == 1) {
                    show = this.commonShowHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = this.commonSayHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    lcdHintRequest.setSay(say);
                    lcdHintRequest.setShow(show);
                    lcdHintRequest.setPlateNum(plateNum);
                    if (ShowSayConstants.ENTER_QR_RESULT_LIST.contains((Object)resultCode)) {
                        qrCodeUr = this.webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + channelCode;
                        lcdHintRequest.setQrCodeUrl(qrCodeUr);
                    }
                } else {
                    show = this.commonShowHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = this.commonSayHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    lcdHintRequest.setSay(say);
                    lcdHintRequest.setShow(show);
                    lcdHintRequest.setPlateNum(plateNum);
                    if (ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode)) {
                        qrCodeUr = this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode;
                        lcdHintRequest.setQrCodeUrl(qrCodeUr);
                    }
                }
                if (isReachable) {
                    ObjectResponse<Void> objectResponse = this.lcdHintService.execute(parkId, parkCode, serialNumber, lcdHintRequest);
                    if (!ObjectResponse.isSuccess(objectResponse)) {
                        log.info("<LCD\u7edf\u4e00\u5c4f\u663e\u8bed\u97f3\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                        return ObjectResponse.failed((String)"3003");
                    }
                } else {
                    String msgId = this.lcdHintService.showAndSay(parkId, parkCode, serialNumber, lcdHintRequest);
                    if (msgId == null) {
                        log.info("<LCD\u7edf\u4e00\u5c4f\u663e\u8bed\u97f3\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                        return ObjectResponse.failed((String)"3003");
                    }
                }
            } else {
                String extendShow;
                HintRequest hintRequest = new HintRequest();
                if (enexType == 1) {
                    show = this.commonShowHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = this.commonSayHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    hintRequest.setShowTypeByShow(show);
                    if (hintRequest.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal() || hintRequest.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                        show = this.commonShowHandle.replacePara(show, new String[]{parkCode, channelCode});
                        if (hintRequest.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                            extendShow = this.ledShowHandle.generate4LineContent(parkId, channel.getId(), plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
                            hintRequest.setExtendShow(extendShow);
                        }
                    }
                    hintRequest.setShow(show);
                    hintRequest.setSay(say);
                    hintRequest.setPlateNum(plateNum);
                } else {
                    show = this.commonShowHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    say = this.commonSayHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
                    hintRequest.setShowTypeByShow(show);
                    hintRequest.setSay(say);
                    hintRequest.setPlateNum(plateNum);
                    if (hintRequest.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal() || hintRequest.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                        show = this.replacePara(show, new String[]{parkCode, channelCode});
                        extendShow = this.ledShowHandle.generate4LineContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
                        hintRequest.setExtendShow(extendShow);
                    }
                    hintRequest.setShow(show);
                }
                ExHintService exHintService = this.deviceDownServiceFactory.buildExHintService(parkCode);
                if (isReachable) {
                    ObjectResponse<Void> objectResponse = exHintService.execute(parkId, parkCode, serialNumber, hintRequest);
                    if (!ObjectResponse.isSuccess(objectResponse)) {
                        log.info("<LED\u7edf\u4e00\u5c4f\u663e\u8bed\u97f3\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                        return ObjectResponse.failed((String)"3003");
                    }
                } else {
                    String msgId = exHintService.showAndSay(parkId, parkCode, serialNumber, hintRequest);
                    if (msgId == null) {
                        log.info("<LED\u7edf\u4e00\u5c4f\u663e\u8bed\u97f3\u4e0b\u53d1> \u4e0b\u53d1\u5931\u8d25\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
                        return ObjectResponse.failed((String)"3003");
                    }
                }
            }
        }
        String robotSerialNumber = this.cacheHandle.getChannelRobot(parkCode, channelCode);
        String itcSn = this.itcCacheHandle.getSerialNumber(parkCode, channelCode);
        log.info("\u8f66\u573a\uff1a{}\uff0c\u901a\u9053\uff1a{}\u7684\u673a\u5668\u4eba\u5e8f\u5217\u53f7\u4e3a\uff1a{}", new Object[]{parkCode, channelCode, robotSerialNumber});
        if (robotSerialNumber != null) {
            if (ShowSayConstants.PAY_LIST.contains((Object)resultCode)) {
                String fee = (String)para.get("fee");
                String parkTime = DateTools.secondToSecondsTime((int)((int)((Long)para.get("parkTime")).longValue()));
                String orderNum = (String)para.get("orderNum");
                ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
                showPayInfoRequest.setOrderNum(orderNum);
                showPayInfoRequest.setNoticeMsg("\u8bf7\u4f7f\u7528\u5fae\u4fe1\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8");
                showPayInfoRequest.setShow(plateNum + "/" + fee + "\u5143/" + parkTime + "/" + PlateTypeEnum.getName((Integer)type));
                showPayInfoRequest.setQrCodeUrl(this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
                this.showPayInfoService.executeDown(parkId, robotSerialNumber, showPayInfoRequest);
                RobotHintRequest robotHintRequest = new RobotHintRequest();
                robotHintRequest.setPlateNum(plateNum);
                robotHintRequest.setShow("");
                robotHintRequest.setSay(say);
                this.robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
            } else {
                RobotHintRequest robotHintRequest = new RobotHintRequest();
                robotHintRequest.setPlateNum(plateNum);
                robotHintRequest.setShow(show);
                robotHintRequest.setSay(say);
                this.robotHintService.executeDown(parkId, robotSerialNumber, robotHintRequest);
            }
        }
        if (itcSn != null) {
            com.icetech.cloudcenter.domain.request.itc.HintRequest itcHintRequest = com.icetech.cloudcenter.domain.request.itc.HintRequest.builder().scene(Integer.valueOf(this.showSayBaseHandle.getSceneByResultCode(resultCode, enexType))).plateNum(plateNum).type(this.showSayBaseHandle.setAndGetPlateType(resultCode, parkId, channelId, plateNum, type, para)).freeSpace(this.showSayBaseHandle.getFreeSpace(parkId, channelId, para)).remainDaysMc(this.showSayBaseHandle.getMonthCarRemainDays(parkId, channelId, plateNum, para)).unpayPrice(para.get("fee") == null ? null : Integer.valueOf((int)(Float.parseFloat((String)para.get("fee")) * 100.0f))).parkTime((Long)para.get("parkTime")).build();
            if (PlateTypeEnum.VIP\u8f66\u8f86.getType().equals(itcHintRequest.getType())) {
                itcHintRequest.setVipTypeName((String)para.get("carDesc"));
            }
            if (enexType == 2 && ShowSayConstants.QR_RESULT_LIST.contains((Object)resultCode)) {
                itcHintRequest.setQrCodeUrl(this.webUrl + "/h5/pay/exit?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            if (enexType == 1 && (HintRequest.Scene.NO_PLATE_ENTER.getVal() == itcHintRequest.getScene().intValue() || HintRequest.Scene.NEED_PAY_EXIT.getVal() == itcHintRequest.getScene().intValue())) {
                itcHintRequest.setQrCodeUrl(this.webUrl + "/noplate/enter/index?parkCode=" + parkCode + "&channelId=" + channelCode);
            }
            this.itcHintService.execute(parkId, itcSn, itcHintRequest);
        }
        return ObjectResponse.success();
    }

    public ObjectResponse<HintRequest> buildShowSayContent(Long parkId, String parkCode, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Long regionId, int enexType, String channelCode) {
        String say;
        String show;
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        para.put("enexType", enexType);
        para.put("channelCode", channelCode);
        para.put("regionId", regionId);
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (!ObjectResponse.isSuccess((Response)channelResp)) {
            return ObjectResponse.failed((String)channelResp.getCode(), (String)"\u901a\u9053\u4e0d\u5b58\u5728");
        }
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        Integer ledLcdSource = channel.getLedLcdSource();
        HintRequest hintRequest = new HintRequest();
        if (enexType == 1) {
            show = this.commonShowHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            say = this.commonSayHandle.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            hintRequest.setShowTypeByShow(show);
            if (hintRequest.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal() || hintRequest.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                show = this.commonShowHandle.replacePara(show, new String[]{parkCode, channelCode});
                if (hintRequest.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                    String extendShow = this.ledShowHandle.generate4LineContent(parkId, channel.getId(), plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u5165\u573a\u663e\u793a.type);
                    hintRequest.setExtendShow(extendShow);
                }
            }
            hintRequest.setShow(show);
            hintRequest.setSay(say);
            hintRequest.setPlateNum(plateNum);
        } else {
            show = this.commonShowHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            say = this.commonSayHandle.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
            hintRequest.setShowTypeByShow(show);
            hintRequest.setSay(say);
            hintRequest.setPlateNum(plateNum);
            if (hintRequest.getShowType().intValue() == ShowTypeEnum.\u52a8\u6001\u4e8c\u7ef4\u7801.getVal() || hintRequest.getShowType().intValue() == ShowTypeEnum.\u6587\u672c\u548c\u4e8c\u7ef4\u7801.getVal()) {
                show = this.replacePara(show, new String[]{parkCode, channelCode});
                String extendShow = this.ledShowHandle.generate4LineContent(parkId, channelId, plateNum, type, resultCode, para, LedShow.DisplayTypeEnum.\u51fa\u573a\u663e\u793a.type);
                hintRequest.setExtendShow(extendShow);
            }
            hintRequest.setShow(show);
        }
        hintRequest.setShow(show);
        hintRequest.setSay(say);
        return ObjectResponse.success((Object)hintRequest);
    }

    private String replacePara(String exitPayUrl, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            exitPayUrl = exitPayUrl.replace("$" + (i + 1), values[i]);
        }
        return exitPayUrl;
    }
}

