/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.showsay.LcdShowHandle;
import com.icetech.park.service.handle.showsay.LedShowHandle;
import com.icetech.partner.api.LuoGangService;
import com.icetech.partner.api.request.luogang.PayUrlRequest;
import com.icetech.third.domain.entity.third.ThirdInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonShowHandle {
    private static final Logger log = LoggerFactory.getLogger(CommonShowHandle.class);
    @Autowired
    private LedShowHandle ledShowHandle;
    @Autowired
    private LcdShowHandle lcdShowHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    protected ThirdInfoService thirdInfoService;
    @Autowired
    protected LuoGangService luoGangService;
    private static final String LUOGANG_PID = "luoGang";

    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer ledLcdSource) {
        para.put("ledLcdSource", ledLcdSource);
        String content = ledLcdSource == 2 ? this.lcdShowHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para) : this.ledShowHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para);
        return content;
    }

    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess((Response)channelResp)) {
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            return this.enter(parkId, channelId, plateNum, type, resultCode, para, channel.getLedLcdSource());
        }
        log.error("\u672a\u67e5\u8be2\u5230\u9ad8\u7ea7\u914d\u7f6e\uff0c\u8f66\u573aID\uff1a{}", (Object)parkId);
        return "";
    }

    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer ledLcdSource) {
        if (para == null) {
            para = new HashMap<String, Object>();
        }
        para.put("ledLcdSource", ledLcdSource);
        String content = ledLcdSource == 2 ? this.lcdShowHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para) : this.ledShowHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para);
        return content;
    }

    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess((Response)channelResp)) {
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            return this.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
        }
        log.error("\u672a\u67e5\u8be2\u5230\u9ad8\u7ea7\u914d\u7f6e\uff0c\u8f66\u573aID\uff1a{}", (Object)parkId);
        return "";
    }

    public String replacePara(String exitPayUrl, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            exitPayUrl = exitPayUrl.replace("$" + (i + 1), values[i]);
        }
        return exitPayUrl;
    }

    public String getThirdPayUrl(Long parkId, String parkCode, String channelId, String orderNum, String plateNum, Map<String, Object> param) {
        ThirdInfo thirdInfo = this.thirdInfoService.getThirdQrUrl(parkId);
        if (thirdInfo == null) {
            return "";
        }
        if (LUOGANG_PID.equals(thirdInfo.getPid())) {
            try {
                PayUrlRequest payUrlRequest = new PayUrlRequest();
                payUrlRequest.setUnPayPrice((String)param.get("fee"));
                payUrlRequest.setParkCode(parkCode);
                payUrlRequest.setPlateNum(plateNum);
                ObjectResponse mapObjectResponse = this.luoGangService.getPayUrl(payUrlRequest);
                if (mapObjectResponse.getData() != null && ((Map)mapObjectResponse.getData()).get("qrCodeContent") != null) {
                    Map data = (Map)mapObjectResponse.getData();
                    return (String)data.get("qrCodeContent");
                }
            }
            catch (Exception e) {
                log.error("e=", (Throwable)e);
            }
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)thirdInfo.getQrUrl())) {
            return thirdInfo.getQrUrl() + "?parkCode=" + parkCode + "&channelId=" + channelId + "&orderNum=" + orderNum;
        }
        return "";
    }
}

