/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle.showsay;

import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.handle.showsay.LcdSayHandle;
import com.icetech.park.service.handle.showsay.LedSayHandle;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonSayHandle {
    private static final Logger log = LoggerFactory.getLogger(CommonSayHandle.class);
    @Autowired
    private LedSayHandle ledSayHandle;
    @Autowired
    private LcdSayHandle lcdSayHandle;
    @Autowired
    private ParkService parkService;

    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer ledLcdSource) {
        String content = "";
        content = ledLcdSource == 2 ? this.lcdSayHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para) : this.ledSayHandle.enterHandle(parkId, channelId, plateNum, type, resultCode, para);
        return content;
    }

    public String enter(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess((Response)channelResp)) {
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            return this.enter(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
        }
        log.error("\u672a\u67e5\u8be2\u5230\u9ad8\u7ea7\u914d\u7f6e\uff0c\u8f66\u573aID\uff1a{}", (Object)parkId);
        return "";
    }

    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para, Integer displayTerminal) {
        String content = "";
        content = displayTerminal == 2 ? this.lcdSayHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para) : this.ledSayHandle.exitHandle(parkId, channelId, plateNum, type, resultCode, para);
        return content;
    }

    public String exit(Long parkId, Long channelId, String plateNum, Integer type, FlowCondition.ResultCode resultCode, Map<String, Object> para) {
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(channelId);
        if (ObjectResponse.isSuccess((Response)channelResp)) {
            ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
            Integer ledLcdSource = channel.getLedLcdSource();
            return this.exit(parkId, channelId, plateNum, type, resultCode, para, ledLcdSource);
        }
        log.error("\u672a\u67e5\u8be2\u5230\u9ad8\u7ea7\u914d\u7f6e\uff0c\u8f66\u573aID\uff1a{}", (Object)parkId);
        return "";
    }
}

