/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.ops.OpsService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.open.domain.ApiBaseRequest;
import com.icetech.open.domain.request.sms.SmsRequest;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.utils.RedisUtils;
import com.icetech.user.domain.entity.ops.OpsUser;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class PublicHandle {
    private static final Logger log = LoggerFactory.getLogger(PublicHandle.class);
    private static final int INTERVAL = 50;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkService parkService;
    @Value(value="${datacenter.environment}")
    private String environment;
    @Value(value="${datacenter.monitor.notify.phone}")
    private String notifyPhone;
    @Value(value="${datacenter.monitor.notify.enabled}")
    private boolean enabled;
    @Autowired
    private OpsService opsService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Deprecated
    public ObjectResponse<String> getDataFromRedis(String messageId, Long timeOut) {
        return this.getDataFromRedis(messageId, timeOut, false);
    }

    @Deprecated
    public ObjectResponse<String> getDataFromRedis(String messageId, Long timeOut, boolean isTimeoutSend) {
        ObjectResponse objectResponse;
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        long halfTime = currentTimeMillis + timeOut / 2L;
        int n = 1;
        boolean halfFlag = false;
        boolean isOpenWs = false;
        String paraContent = "";
        String parkCode = "";
        while (lastTime > currentTimeMillis) {
            if (this.redisUtils.isValidity()) {
                if (this.redisUtils.exists(messageId)) {
                    ObjectResponse data = (ObjectResponse)this.redisUtils.get(messageId, (TypeReference)new TypeReference<ObjectResponse<String>>(){});
                    log.info("The {}th read from Redis, msgid[{}], return[{}]", new Object[]{n, messageId, data});
                    return data;
                }
                if (isTimeoutSend && halfTime < currentTimeMillis && !halfFlag) {
                    ObjectResponse parkResp;
                    Park park;
                    paraContent = (String)this.redisUtils.get("send_" + messageId, String.class);
                    parkCode = (String)JsonUtils.parseMap((String)paraContent).get("parkCode");
                    Long endtime = (Long)this.redisUtils.get("PNC_HEART_PROFILE_" + parkCode, Long.class);
                    if (!Objects.isNull(endtime)) {
                        if (currentTimeMillis - endtime < 180000L) {
                            log.info("\u5904\u7406\u65f6\u95f4\u5df2\u8fc7\u534a\u672a\u8fd4\u56de\uff0cmsgid\uff1a{} \u5373\u5c06\u5207\u6362\u5907\u7528\u534f\u8bae\u53d1\u9001\u8bf7\u6c42", (Object)messageId);
                            isOpenWs = true;
                            break;
                        }
                        log.info("msgid\uff1a{} 3\u5206\u949f\u672a\u4e0a\u62a5\u5fc3\u8df3\uff0c\u65e0\u6cd5\u5207\u6362\u5907\u7528\u534f\u8bae\uff0c\u5c06\u7ee7\u7eed\u4f7f\u7528\u4e3b\u534f\u8bae\u53d1\u9001\u8bf7\u6c42", (Object)messageId);
                    }
                    if ((park = (Park)(parkResp = this.parkService.findByParkCode(parkCode)).getData()) == null) {
                        log.warn("\u627e\u4e0d\u5230\u8f66\u573a\u4fe1\u606f|{}", (Object)parkCode);
                        break;
                    }
                    String protocol = (String)this.redisUtils.hGet("pnc:protocol", park.getId().toString(), String.class);
                    boolean b = false;
                    if ("1".equals(protocol)) {
                        WebSocketMessage webSocketMessage = WebSocketMessage.buildMessage((String)"pnc", (String)parkCode, (String)paraContent).setProtocolType(Integer.valueOf(1)).setTrace(Slf4jUtils.getTraceId());
                        this.redisUtils.getStringRedisTemplate().convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, (Object)JSON.toJSONString((Object)webSocketMessage));
                        b = true;
                    }
                    log.info("\u5904\u7406\u65f6\u95f4\u5df2\u8fc7\u534a\uff0cmsgid\uff1a{} \u4ecd\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u4fe1\u606f\uff0c\u518d\u6b21\u53d1\u9001mqtt\u6d88\u606f[{}]", (Object)messageId, (Object)b);
                    halfFlag = true;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        if (isOpenWs && !Objects.isNull(objectResponse = this.sendWsMsg(messageId, parkCode, paraContent, timeOut))) {
            return objectResponse;
        }
        log.info("\u8d85\u65f6\u672a\u67e5\u8be2\u5230msgid\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff01", (Object)messageId);
        return null;
    }

    private ObjectResponse sendWsMsg(String messageId, String parkCode, String paraJson, Long timeOut) {
        String clientName = parkCode;
        String[] s = messageId.split("_");
        clientName = s.length > 1 ? clientName + "_" + s[0] : clientName + "_0";
        boolean success = this.pushAll(clientName, paraJson);
        log.info("<\u7aef\u7f51\u4e91WS\u4e0b\u53d1> \u5e7f\u64ad{}\uff0c\u76f8\u673a:[{}]\uff0c\u5185\u5bb9\u4e3a:{}", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", clientName, paraJson});
        String key = "RESP_MSG_" + messageId;
        Long currentTimeMillis = System.currentTimeMillis();
        Long lastTime = currentTimeMillis + 4000L;
        int n = 1;
        while (lastTime > currentTimeMillis && success) {
            if (this.redisUtils.isValidity() && this.redisUtils.exists(key)) {
                ObjectResponse data = (ObjectResponse)this.redisUtils.get(key, ObjectResponse.class);
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff1a{}", new Object[]{n, key, data});
                return data;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        return null;
    }

    public boolean pushAll(String clientName, String content) {
        try {
            content = clientName + content;
            this.stringRedisTemplate.convertAndSend("pncwebsocket", (Object)content);
        }
        catch (Exception e) {
            log.error("<redis\u5e7f\u64ad\u53d1\u9001> clientName\uff1a{} \u5e7f\u64ad\u5931\u8d25", (Object)clientName, (Object)e);
            return false;
        }
        return true;
    }

    public String convert2OrderNum(Long parkId, String orderId) {
        if (orderId == null) {
            return null;
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setLocalOrderNum(orderId);
        ObjectResponse byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
        ObjectResponse.notError((Response)byOrderInfo);
        return ((OrderInfo)byOrderInfo.getData()).getOrderNum();
    }

    public String convert2OrderId(Long parkId, String orderNum) {
        if (orderNum == null) {
            return null;
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setOrderNum(orderNum);
        ObjectResponse byOrderInfo = this.orderService.findByOrderInfo(orderInfo);
        ObjectResponse.notError((Response)byOrderInfo);
        return ((OrderInfo)byOrderInfo.getData()).getLocalOrderNum();
    }

    public int cloudType(String parkCode) {
        ObjectResponse parkConfigResponse = this.parkService.getParkConfig(parkCode);
        ObjectResponse.notError((Response)parkConfigResponse);
        ParkConfig parkConfig = (ParkConfig)parkConfigResponse.getData();
        return parkConfig.getDataCollection();
    }

    public void sendSmg(String content) {
        if (!this.enabled) {
            log.info("<\u77ed\u4fe1\u63d0\u9192> \u529f\u80fd\u672a\u5f00\u542f\uff0c\u8df3\u8fc7\u53d1\u9001\uff01\u5185\u5bb9\uff1a{}", (Object)content);
            return;
        }
        String prefixContent = "\u3010\u4e91\u5e73\u53f0" + this.environment + "\u73af\u5883\u3011";
        ApiBaseRequest baseRequest = new ApiBaseRequest();
        SmsRequest smsRequest = new SmsRequest();
        smsRequest.setDesMobile(this.notifyPhone);
        smsRequest.setContent(prefixContent + content);
        smsRequest.setTimes(Integer.valueOf((int)DateTools.unixTimestamp()));
        baseRequest.setBizContent((Object)smsRequest);
        try {
            log.info("<\u77ed\u4fe1\u63d0\u9192> \u6536\u4fe1\u4eba\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)smsRequest.getDesMobile(), (Object)smsRequest.getContent());
        }
        catch (Exception e) {
            log.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)baseRequest, (Object)e);
        }
    }

    @Deprecated
    public void sendSmgToOpsUser(String content, Long parkId) {
        if (!this.enabled) {
            log.info("<\u77ed\u4fe1\u63d0\u9192> \u529f\u80fd\u672a\u5f00\u542f\uff0c\u8df3\u8fc7\u53d1\u9001\uff01\u5185\u5bb9\uff1a{}", (Object)content);
            return;
        }
        String prefixContent = "";
        ApiBaseRequest baseRequest = new ApiBaseRequest();
        SmsRequest smsRequest = new SmsRequest();
        ObjectResponse userObjectResponse = this.opsService.getPermissionUserByParkId(parkId);
        if (ObjectResponse.isSuccess((Response)userObjectResponse)) {
            OpsUser opsUser = (OpsUser)userObjectResponse.getData();
            smsRequest.setDesMobile(opsUser.getPhone());
            smsRequest.setContent(prefixContent + content);
            smsRequest.setTimes(Integer.valueOf((int)DateTools.unixTimestamp()));
            baseRequest.setBizContent((Object)smsRequest);
            try {
                log.info("<\u77ed\u4fe1\u63d0\u9192> \u6536\u4fe1\u4eba\uff1a{}\uff0c\u5185\u5bb9\uff1a{}", (Object)smsRequest.getDesMobile(), (Object)smsRequest.getContent());
            }
            catch (Exception e) {
                log.warn("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)baseRequest, (Object)e);
            }
        } else {
            log.warn("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u672a\u627e\u5230\u8fd0\u7ef4\u4eba\u5458\uff0c\u8f66\u573aID\uff1a{}", (Object)parkId);
        }
    }
}

