/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.request.pnc.DownBaseRequest;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class PncDownHandle {
    private static final Logger log = LoggerFactory.getLogger(PncDownHandle.class);
    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private static final List<String> SYNC_SERVICE_NAME_LIST = new ArrayList<String>();

    public <T> String signAndSend(String parkCode, String serviceName, T t) {
        return this.signAndSend(parkCode, serviceName, t, null);
    }

    public <T> String signAndSend(String parkCode, String serviceName, T t, Long serviceId) {
        ObjectResponse objectResponse = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        Long parkId = park.getId();
        String key = park.getKey();
        return this.signAndSend(parkId, parkCode, key, serviceName, t, serviceId);
    }

    public <T> String signAndSend(Long parkId, String serviceName, T t) {
        return this.signAndSend(parkId, serviceName, t, null);
    }

    public <T> String signAndSend(Long parkId, String serviceName, T t, Long serviceId) {
        return this.signAndSend(parkId, serviceName, t, serviceId, null);
    }

    public <T> String signAndSend(Long parkId, String serviceName, T t, Long serviceId, String channelId) {
        return this.signAndSend(parkId, serviceName, t, serviceId, channelId, null);
    }

    public <T> String signAndSend(Long parkId, String serviceName, T t, Long serviceId, String channelId, Long recordId) {
        ObjectResponse objectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        String parkCode = park.getParkCode();
        String key = park.getKey();
        return this.signAndSend(parkId, parkCode, key, serviceName, t, serviceId, channelId, recordId, null, null);
    }

    public <T> String signAndSend(Long parkId, String parkCode, String key, String serviceName, T t, Long serviceId) {
        return this.signAndSend(parkId, parkCode, key, serviceName, t, serviceId, null);
    }

    public <T> String signAndSend(Long parkId, String parkCode, String key, String serviceName, T t, Long serviceId, String channelId) {
        return this.signAndSend(parkId, parkCode, key, serviceName, t, serviceId, channelId, null, null, null);
    }

    public <T> String signAndSendAsyncResult(Long parkId, String parkCode, String key, String serviceName, T t, String channelId, String topic, String extraInfo) {
        return this.signAndSend(parkId, parkCode, key, serviceName, t, null, channelId, null, topic, extraInfo);
    }

    public <T> String signAndSendAsyncResult(Long parkId, String parkCode, String key, String serviceName, T t, String topic, String extraInfo) {
        return this.signAndSend(parkId, parkCode, key, serviceName, t, null, null, null, topic, extraInfo);
    }

    public <T> String signAndSendAsyncResult(Long parkId, String serviceName, T t, Long serviceId, String channelId, Long recordId, String topic, String extraInfo) {
        ObjectResponse objectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        String parkCode = park.getParkCode();
        String key = park.getKey();
        return this.signAndSend(parkId, parkCode, key, serviceName, t, serviceId, channelId, recordId, topic, extraInfo);
    }

    public <T> String signAndSendAsyncResult(String parkCode, String serviceName, T t, String topic) {
        ObjectResponse objectResponse = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        Long parkId = park.getId();
        String key = park.getKey();
        return this.signAndSend(parkId, parkCode, key, serviceName, t, null, null, null, topic, null);
    }

    public <T> String signAndSendAsyncResult(Long parkId, String serviceName, T t, String topic) {
        ObjectResponse objectResponse = this.parkService.findByParkId(parkId);
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        String parkCode = park.getParkCode();
        String key = park.getKey();
        return this.signAndSend(parkId, parkCode, key, serviceName, t, null, null, null, topic, null);
    }

    public <T> String signAndSendAsyncResult(String parkCode, String serviceName, T t, String topic, String extraInfo) {
        ObjectResponse objectResponse = this.parkService.findByParkCode(parkCode);
        ObjectResponse.notError((Response)objectResponse);
        Park park = (Park)objectResponse.getData();
        Long parkId = park.getId();
        String key = park.getKey();
        return this.signAndSend(parkId, parkCode, key, serviceName, t, null, null, null, topic, extraInfo);
    }

    public <T> String signAndSend(Long parkId, String parkCode, String key, String serviceName, T t, Long serviceId, String channelId, Long recordId, String topic, String extraInfo) {
        DownBaseRequest baseRequest = new DownBaseRequest();
        baseRequest.setParkCode(parkCode);
        baseRequest.setTimestamp(Long.valueOf(DateTools.unixTimestamp()));
        baseRequest.setServiceName(serviceName);
        boolean isSdk = this.redisUtils.exists("PNC_ONLINE_CHANNEL_" + parkCode);
        if (channelId == null && isSdk) {
            channelId = (String)this.redisUtils.get("PNC_ONLINE_CHANNEL_" + parkCode, String.class);
        }
        String messageId = UUIDTools.getUuid();
        if (isSdk) {
            String messageIdPrefix = channelId == null ? "" : channelId + "_";
            messageId = messageIdPrefix + messageId;
        }
        baseRequest.setMessageId(messageId);
        baseRequest.setBizContent(t);
        boolean success = false;
        try {
            String protocolValue = (String)this.redisUtils.hGet("pnc:protocol", parkId.toString(), String.class);
            if (protocolValue == null) {
                log.warn("\u6d88\u606f\u65e0\u6cd5\u4e0b\u53d1,\u65e0\u6cd5\u786e\u8ba4\u7aef\u7f51\u4e91\u8fde\u63a5\u7c7b\u578b|{}|{}|{}|{}", new Object[]{parkId, parkCode, serviceName, serviceId});
                return null;
            }
            int protocolType = Integer.parseInt(protocolValue);
            Map map = SignTools.convertMap((Object)baseRequest);
            String sign = SignTools.getMySign((Map)map, (String)key);
            baseRequest.setSign(sign);
            String json = JsonUtils.toString((Object)baseRequest);
            if (protocolType != 1) {
                log.warn("\u6d88\u606f\u65e0\u6cd5\u4e0b\u53d1,\u65e0\u6cd5\u786e\u8ba4\u7aef\u7f51\u4e91\u8fde\u63a5\u7c7b\u578b|{}|{}|{}|{}", new Object[]{parkId, parkCode, serviceName, serviceId});
                return null;
            }
            WebSocketMessage message = WebSocketMessage.buildMessage((String)"pnc", (String)parkCode, (String)json).setProtocolType(Integer.valueOf(1)).setTrace(Slf4jUtils.getTraceId());
            this.redisTemplate.convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, (Object)JSON.toJSONString((Object)message));
            log.info("[\u7aef\u7f51\u4e91ws\u4e0b\u53d1] \u53c2\u6570[{}]", (Object)json);
            this.addRecord(parkId, parkCode, serviceName, serviceId, messageId, t, recordId, topic, extraInfo);
            this.redisUtils.set("send_" + messageId, (Object)json, 8L);
            success = true;
            return messageId;
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private <T> void addRecord(Long parkId, String parkCode, String serviceName, Long serviceId, String messageId, T t, Long recordId, String topic, String extraInfo) {
        SendInfoRecord sendinfoRecord = new SendInfoRecord();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkId(parkId);
        sendinfoRecord.setParkCode(parkCode);
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(serviceId);
        sendinfoRecord.setServiceType(DownServiceEnum.getServiceType((String)serviceName));
        sendinfoRecord.setOperType(SendOperTypeEnum.\u8bf7\u6c42.getOperType());
        sendinfoRecord.setRecordId(recordId);
        sendinfoRecord.setTopic(topic);
        sendinfoRecord.setEnv(SpringUtils.getActiveProfile());
        sendinfoRecord.setExtraInfo(extraInfo);
        this.redisUtils.set("MQ_RECORD_" + messageId, (Object)sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT.longValue());
    }

    static {
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u7f34\u8d39\u67e5\u8be2.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u5b9e\u65f6\u901a\u9053\u6570\u636e.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u65e0\u724c\u8f66\u5165\u573a.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u65e0\u724c\u8f66\u79bb\u573a.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u8bed\u97f3\u663e\u793a\u5c4f\u5185\u5bb9.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u8bf7\u6c42\u5165\u573a.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u4fee\u6539\u505c\u8f66\u8d39\u7528.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getServiceName());
        SYNC_SERVICE_NAME_LIST.add(DownServiceEnum.\u9884\u7f34\u8d39.getServiceName());
    }
}

