/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2rCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.impl.TaskCenterServiceImpl;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class P2rMsgHandle {
    private static final Logger log = LoggerFactory.getLogger(P2rMsgHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TaskCenterServiceImpl taskCenterService;
    @Autowired
    private CacheHandle cacheHandle;

    public <T> String send(Long parkId, String serialNumber, Integer cmdType, T t, Long serviceId) {
        return this.send(parkId, serialNumber, cmdType, cmdType, t, serviceId);
    }

    public <T> String send(Long parkId, String serialNumber, Integer reqCmdType, Integer retCmdType, T t, Long serviceId) {
        P2rBaseRequest p2rBaseRequest = new P2rBaseRequest();
        String messageId = UUIDTools.getUuid();
        p2rBaseRequest.setMessageId(messageId);
        String key = "p2r:sn" + serialNumber;
        TokenDeviceVo tokenDeviceVo = (TokenDeviceVo)this.redisUtils.get(key, TokenDeviceVo.class);
        if (tokenDeviceVo == null) {
            log.info("[\u673a\u5668\u4eba\u6d88\u606f\u4e0b\u53d1] \u8bbe\u5907\u4e0d\u5728\u7ebf, serialNumber[{}]", (Object)serialNumber);
            return null;
        }
        p2rBaseRequest.setToken(tokenDeviceVo.getToken());
        p2rBaseRequest.setBizContent(t);
        String paraJson = JsonUtils.toString((Object)p2rBaseRequest);
        ObjectResponse objectResponse = ObjectResponse.success();
        boolean success = ObjectResponse.isSuccess((Response)objectResponse);
        if (success) {
            this.addRequestRecord(parkId, retCmdType, serviceId, messageId, t);
        }
        return success ? messageId : null;
    }

    public <T> String send(Long parkId, String serialNumber, Integer cmdType, T t) {
        return this.send(parkId, serialNumber, cmdType, cmdType, t, null);
    }

    public void dealResponse(P2rBaseResponse p2rBaseResponse, String cmd, String serialNumber) {
        TokenDeviceVo tokenInfo = this.cacheHandle.getRobotDeviceInfo(serialNumber);
        cmd = cmd.substring(0, cmd.indexOf("_resp"));
        Integer cmdType = P2rCmdEnum.getCmdType((String)cmd);
        String messageId = p2rBaseResponse.getMessageId();
        SendInfoRecord sendinfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, SendInfoRecord.class);
        if (sendinfoRecord == null) {
            sendinfoRecord = new SendInfoRecord();
            sendinfoRecord.setServiceType(cmdType);
            sendinfoRecord.setMessageId(messageId);
            sendinfoRecord.setParkId(tokenInfo.getParkId());
        }
        cmdType = sendinfoRecord.getServiceType();
        Integer code = p2rBaseResponse.getCode();
        String msg = p2rBaseResponse.getMsg();
        String data = JsonUtils.toString((Object)p2rBaseResponse.getData());
        String key = "RESP_MSG_" + messageId;
        ObjectResponse retResponse = new ObjectResponse();
        retResponse.setCode(String.valueOf(code));
        retResponse.setMsg(msg);
        retResponse.setData((Object)data);
        if (sendinfoRecord.getServiceId() == null) {
            this.redisUtils.set(key, (Object)retResponse, TimeOutConstants.REDIS_TIMEOUT.longValue());
            log.info("<\u76f8\u673a\u54cd\u5e94\u5904\u7406> \u5199\u5165redis\u6210\u529f\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)retResponse);
        } else {
            Integer serviceId = sendinfoRecord.getServiceId().intValue();
            if (code.equals(CodeEnum.\u6210\u529f.getCode())) {
                this.taskCenterService.notify(cmdType, serviceId);
            } else {
                if (msg == null) {
                    msg = "\u672a\u77e5\u9519\u8bef";
                }
                this.taskCenterService.notify(cmdType, serviceId, msg);
            }
        }
    }

    private <T> void addRequestRecord(Long parkId, Integer cmdType, Long serviceId, String messageId, T t) {
        SendInfoRecord sendinfoRecord = new SendInfoRecord();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkId(parkId);
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(serviceId);
        sendinfoRecord.setServiceType(cmdType);
        sendinfoRecord.setOperType(SendOperTypeEnum.\u8bf7\u6c42.getOperType());
        this.redisUtils.set("MQ_RECORD_" + messageId, (Object)sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT.longValue());
    }
}

