/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.third.utils.RedisUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class P2cOperHandle {
    private static final Logger log = LoggerFactory.getLogger(P2cOperHandle.class);
    @Autowired
    protected ParkDeviceService parkDeviceService;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected CacheHandle cacheHandle;
    @Autowired
    protected RedisUtils redisUtils;

    public TokenDeviceVo getAndCacheDevice(WebSocketMessage message) {
        TokenDeviceVo vo = this.cacheHandle.getDeviceInfo(message.getChannel());
        if (vo != null) {
            boolean update = false;
            if (StringUtils.isNotBlank((CharSequence)message.getOriginalIp()) && !message.getOriginalIp().equals(vo.getOriginalIp())) {
                vo.setOriginalIp(message.getOriginalIp());
                update = true;
            }
            if (StringUtils.isNotBlank((CharSequence)message.getOriginalServer()) && !message.getOriginalServer().equals(vo.getOriginalServer())) {
                vo.setOriginalServer(message.getOriginalServer());
                update = true;
            }
            if (TokenDeviceVo.ProtocolTypeEnum.WS.val != (vo.getSource() == null ? 0 : vo.getSource())) {
                vo.setSource(Integer.valueOf(TokenDeviceVo.ProtocolTypeEnum.WS.val));
                update = true;
            }
            if (update) {
                this.cacheHandle.updateDeviceInfo(message.getChannel(), vo);
            }
            return vo;
        }
        return this.cacheDevice(message.getChannel(), TokenDeviceVo.ProtocolTypeEnum.WS, message.getVersion(), message.getOriginalServer(), message.getOriginalIp());
    }

    public TokenDeviceVo getAndCacheDevice(String serialNumber, TokenDeviceVo.ProtocolTypeEnum protocolType) {
        TokenDeviceVo vo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (vo != null) {
            Integer source = vo.getSource();
            if (protocolType.val != (source == null ? 0 : source)) {
                vo.setSource(Integer.valueOf(protocolType.val));
                this.cacheHandle.updateDeviceInfo(serialNumber, vo);
            }
            return vo;
        }
        return this.cacheDevice(serialNumber, protocolType, null, null, null);
    }

    public TokenDeviceVo cacheDevice(String serialNumber, TokenDeviceVo.ProtocolTypeEnum protocolType, String version, @Nullable String originalServer, @Nullable String originalIp) {
        log.info("[\u8bbe\u5907\u63a5\u5165\u7684\u516c\u5171\u7c7b] \u7f13\u5b58\u5e76\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f, sn[{}]", (Object)serialNumber);
        ObjectResponse parkDeviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = (ParkDevice)parkDeviceResp.getData();
        if (parkDevice == null || parkDevice.getType() != 1) {
            throw new ResponseBodyException("12001", CodeConstants.getName((String)"12001"));
        }
        version = version == null ? (parkDevice.getProtocolVer() == null ? "default" : parkDevice.getProtocolVer()) : version;
        long parkId = parkDevice.getParkId();
        ObjectResponse byParkCode = this.parkService.findByParkId(Long.valueOf(parkId));
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        String parkCode = park.getParkCode();
        ObjectResponse configObjectResponse = this.parkService.getParkConfig(Long.valueOf(parkId));
        ObjectResponse.notError((Response)configObjectResponse);
        ParkConfig parkConfig = (ParkConfig)configObjectResponse.getData();
        if (DataCollectionEnum.\u7aef\u7f51\u4e91.getType().equals(parkConfig.getDataCollection())) {
            throw new ResponseBodyException("12001", "\u8fde\u63a5\u65b9\u5f0f\u4e0d\u6b63\u786e");
        }
        ObjectResponse parkInoutdeviceObjectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().longValue()));
        if (!ObjectResponse.isSuccess((Response)parkInoutdeviceObjectResponse)) {
            throw new ResponseBodyException("44001", CodeConstants.getName((String)"44001"));
        }
        ParkInoutdevice data = (ParkInoutdevice)parkInoutdeviceObjectResponse.getData();
        TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(serialNumber);
        String token = tokenDeviceVo == null || tokenDeviceVo.getToken() == null ? UUIDTools.getUuid() : tokenDeviceVo.getToken();
        Integer inandoutType = data.getInandoutType();
        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setInandoutCode(data.getInandoutCode());
        parkConnectedDeviceVo.setRegionId(data.getRegionId());
        parkConnectedDeviceVo.setInandoutType(inandoutType);
        parkConnectedDeviceVo.setId(data.getId());
        parkConnectedDeviceVo.setMaster(parkDevice.getIsDualcamera() == null || parkDevice.getIsDualcamera() == 0 || parkDevice.getIsMaster() == null || parkDevice.getIsMaster() == 1);
        this.cacheHandle.addParkConnectList(parkCode, parkConnectedDeviceVo);
        TokenDeviceVo tdv = new TokenDeviceVo();
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        tdv.setDeviceNo(serialNumber);
        tdv.setMaster(parkConnectedDeviceVo.isMaster());
        tdv.setVersion(version);
        tdv.setSource(Integer.valueOf(TokenDeviceVo.ProtocolTypeEnum.WS.equals((Object)protocolType) ? 1 : 2));
        tdv.setId(data.getId());
        tdv.setInandoutName(data.getInandoutName());
        tdv.setInandoutCode(data.getInandoutCode());
        tdv.setRegionId(data.getRegionId());
        tdv.setInandoutType(data.getInandoutType());
        tdv.setToken(token);
        tdv.setOriginalServer(originalServer);
        tdv.setOriginalIp(originalIp);
        this.cacheHandle.cacheDeviceInfo(serialNumber, tdv);
        this.cacheHandle.setChannelSn(parkCode, data.getInandoutCode(), serialNumber, parkConnectedDeviceVo.isMaster());
        return tdv;
    }
}

