/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.request.p2c.LcdHintRequest;
import com.icetech.cloudcenter.domain.request.p2c.LedsoundConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.ServiceEnum;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.ReflectUtils;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.oss.OssService;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.service.impl.TaskCenterServiceImpl;
import com.icetech.redis.handle.IceProxyMsgHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class P2cDownHandle {
    private static final Logger log = LoggerFactory.getLogger(P2cDownHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private TaskCenterServiceImpl taskCenterService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OssService ossService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private IceProxyMsgHandle iceProxyMsgHandle;
    @Autowired
    private MqPushService mqPushService;
    private static final String CMD_CLOSE = "CLOSE";
    private static final List<String> SYNC_CMD_LIST = new ArrayList<String>();
    private static final List<Integer> ALL_RET_EXCLUDE_LIST;

    public <T> String[] send2Park(String parkCode, Message<T> message) {
        List<ParkConnectedDeviceVo> list = this.getParkConnectedDevices(parkCode, null);
        return (String[])list.stream().map(vo -> this.send(parkCode, vo.getDeviceNo(), message)).toArray(String[]::new);
    }

    private List<ParkConnectedDeviceVo> getParkConnectedDevices(String parkCode, ConnectedDeviceFilter filter) {
        List<Object> parkConnectList = this.cacheHandle.getParkConnectList(parkCode);
        if (CollectionUtils.isEmpty(parkConnectList)) {
            log.info("\u8f66\u573a\u6ca1\u6709\u5df2\u8fde\u63a5\u7684\u76f8\u673a, parkCode[{}]", (Object)parkCode);
            return new ArrayList<ParkConnectedDeviceVo>();
        }
        if (filter != null) {
            parkConnectList = parkConnectList.stream().filter(vo -> !vo.getDeviceNo().equals(filter.excludeSerialNumber)).filter(vo -> vo.getInandoutType().equals(filter.inandoutType)).collect(Collectors.toList());
        }
        if (parkConnectList.size() == 0) {
            log.info("\u8f66\u573a\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u76f8\u673a, parkCode[{}], filter[{}]", (Object)parkCode, (Object)filter);
        }
        return parkConnectList;
    }

    public <T> String send(String parkCode, String serialNumber, Message<T> message) {
        return this.send(parkCode, serialNumber, message, null);
    }

    public <T> String send(String parkCode, String serialNumber, Message<T> message, String topic) {
        return this.send(parkCode, serialNumber, message, topic, null);
    }

    public <T> String send(String parkCode, String serialNumber, Message<T> message, String topic, String extraInfo) {
        boolean success;
        Integer reqServiceType = message.getReqServiceType();
        T payload = message.getPayload();
        String clientName = parkCode + "_" + serialNumber;
        P2cBaseRequest p2cBaseRequest = new P2cBaseRequest();
        p2cBaseRequest.setCmd(P2cDownCmdEnum.getCmd((Integer)reqServiceType));
        String messageId = UUIDTools.getUuid();
        p2cBaseRequest.setMessageId(messageId);
        TokenDeviceVo tokenInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        log.info("serialNumber[{}] tokenInfo[{}]", (Object)serialNumber, (Object)tokenInfo);
        if (tokenInfo == null) {
            return null;
        }
        p2cBaseRequest.setToken(tokenInfo.getToken());
        p2cBaseRequest.setBizContent(payload);
        if (DingZhiFuncConstants.DZ003_PARKS.contains(parkCode) && DingZhiFuncConstants.DZ003_DEVICES.contains(serialNumber)) {
            if (!P2cDownCmdEnum.\u5269\u4f59\u7a7a\u8f66\u4f4d.getCmdType().equals(reqServiceType) && !P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(reqServiceType)) {
                log.info("\u5929\u753a\u5927\u53a6\u5b9a\u5236\u4e1a\u52a1\uff0c\u8df3\u8fc7\u4e1a\u52a1\u6570\u636e\u7684\u4e0b\u53d1\uff0c\u5e8f\u5217\u53f7\uff1a{}", (Object)serialNumber);
                return messageId;
            }
            if (P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(reqServiceType)) {
                LedsoundConfigRequest ledsoundConfigRequest = (LedsoundConfigRequest)payload;
                List ledConfigs = ledsoundConfigRequest.getLedConfig();
                for (LedsoundConfigRequest.LedConfig ledConfig : ledConfigs) {
                    Integer showScene = ledConfig.getShowScene();
                    if (LedsoundConfigRequest.SceneEnum.\u5165\u53e3\u7a7a\u95f2\u663e\u793a.scene == showScene) {
                        ledConfig.setContent("\u65e0\u4eba\u503c\u5b88\u505c\u8f66\u573a {3}");
                        continue;
                    }
                    if (LedsoundConfigRequest.SceneEnum.\u51fa\u53e3\u7a7a\u95f2\u663e\u793a.scene != showScene) continue;
                    ledConfig.setContent("\u65e0\u4eba\u503c\u5b88\u505c\u8f66\u573a {3}");
                }
            }
        }
        String paraJson = JsonUtils.toString((Object)p2cBaseRequest);
        if (tokenInfo.getSource() == 1) {
            success = this.pushAll(serialNumber, p2cBaseRequest);
            log.info("<\u7aef\u4e91WS\u4e0b\u53d1> \u5e7f\u64ad{}\uff0c\u76f8\u673a:[{}]\uff0c\u5185\u5bb9\u4e3a:{}", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", clientName, paraJson});
        } else {
            success = false;
            log.warn("<\u7aef\u4e91\u4e0b\u53d1> \u672a\u77e5\u4e0b\u53d1\u901a\u9053[{}]\uff0c\u76f8\u673a:[{}]\uff0c\u5185\u5bb9\u4e3a:{}", new Object[]{tokenInfo.getSource(), clientName, paraJson});
        }
        if (success) {
            this.addRequestRecord(message, parkCode, messageId, payload, serialNumber, topic, extraInfo);
            if (P2cDownCmdEnum.\u5c4f\u663e\u4fe1\u606f.getCmdType().equals(reqServiceType)) {
                this.mqPushService.pushP2cLedScreen(message.getParkId(), serialNumber, (HintRequest)message.getPayload());
            } else if (P2cDownCmdEnum.LCD\u5c4f\u663e\u8bed\u97f3\u4fe1\u606f.getCmdType().equals(reqServiceType)) {
                this.mqPushService.pushP2cLcdScreen(message.getParkId(), serialNumber, (LcdHintRequest)message.getPayload());
            }
        }
        return success ? messageId : null;
    }

    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, Integer serviceType) {
        String messageId = p2cBaseResponse.getMessageId();
        SendInfoRecord sendinfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, SendInfoRecord.class);
        if (sendinfoRecord == null) {
            sendinfoRecord = new SendInfoRecord();
            sendinfoRecord.setServiceType(serviceType);
            sendinfoRecord.setMessageId(messageId);
            sendinfoRecord.setParkId(parkId);
        }
        serviceType = sendinfoRecord.getServiceType();
        Integer code = p2cBaseResponse.getCode();
        String cmd = p2cBaseResponse.getCmd();
        String msg = p2cBaseResponse.getMsg();
        cmd = cmd.substring(0, cmd.indexOf("_resp"));
        String data = (String)p2cBaseResponse.getData();
        String key = "RESP_MSG_" + messageId;
        if (SYNC_CMD_LIST.contains(cmd) && sendinfoRecord.getServiceId() == null) {
            ObjectResponse retResponse = new ObjectResponse();
            retResponse.setCode(String.valueOf(code));
            retResponse.setMsg(msg);
            if (code.equals(CodeEnum.\u6210\u529f.getCode()) && StringUtils.isNotEmpty((CharSequence)p2cBaseResponse.getResultPath())) {
                File oss2File = this.ossService.getOSS2File(p2cBaseResponse.getResultPath());
                data = FileUtil.readString((File)oss2File, (String)"utf-8");
            }
            retResponse.setData((Object)data);
            this.redisUtils.set(key, (Object)retResponse, TimeOutConstants.REDIS_TIMEOUT.longValue());
            try {
                NotifyService notifyService = SendServiceFactory.getP2cBean(cmd, NotifyService.class);
                sendinfoRecord.setParams(JSONObject.parseObject((String)JsonUtils.toString((Object)sendinfoRecord.getParams()), (Type)ReflectUtils.getInterfaceGenericTypes(NotifyService.class, (Object)notifyService)[0], (Feature[])new Feature[0]));
                notifyService.notify(messageId, retResponse, sendinfoRecord);
            }
            catch (Exception e) {
                log.warn("{} Bean error", (Object)cmd, (Object)e);
            }
            int valueLen = retResponse.toString().length();
            log.info("[\u76f8\u673a\u54cd\u5e94\u5904\u7406] \u5199\u5165redis\u6210\u529f,key[{}],value[{}]", (Object)key, (Object)(valueLen > 1024 ? retResponse.toString().substring(0, 1024) + "..." : retResponse));
        } else {
            Long serviceId = sendinfoRecord.getServiceId();
            if (serviceId != null) {
                NotifyRequest notifyRequest = new NotifyRequest();
                notifyRequest.setTargetService(ServiceEnum.Data.getType());
                notifyRequest.setOne(sendinfoRecord.getTarget());
                notifyRequest.setServiceId(serviceId);
                notifyRequest.setServiceType(serviceType);
                notifyRequest.setTaskId(sendinfoRecord.getTaskId());
                notifyRequest.setRecordId(sendinfoRecord.getRecordId());
                if (code.equals(CodeEnum.\u6210\u529f.getCode()) || code == 405) {
                    notifyRequest.setSuccess(true);
                    SendRequest sendRequest = new SendRequest();
                    sendRequest.setParkId(parkId);
                    sendRequest.setServiceId(serviceId);
                    sendRequest.setServiceType(serviceType);
                    sendRequest.setTaskId(sendinfoRecord.getTaskId());
                    sendRequest.setRecordId(sendinfoRecord.getRecordId());
                    if (ALL_RET_EXCLUDE_LIST.contains(serviceType)) {
                        this.taskCenterService.notify(notifyRequest);
                    } else {
                        boolean isAllRet = this.cacheHandle.retSendDevice(sendRequest, sendinfoRecord.getTarget());
                        if (isAllRet) {
                            log.info("\u51c6\u5907\u901a\u77e5TaskCenter\uff1a{}", (Object)notifyRequest);
                            this.taskCenterService.notify(notifyRequest);
                        }
                    }
                } else {
                    notifyRequest.setSuccess(false);
                    if (msg == null) {
                        msg = "\u672a\u77e5\u9519\u8bef";
                    }
                    notifyRequest.setCause(msg);
                    this.taskCenterService.notify(notifyRequest);
                }
            }
        }
    }

    private <T> void addRequestRecord(Message<T> message, String parkCode, String messageId, Object t, String serialNumber, String topic, String extraInfo) {
        SendInfoRecord sendinfoRecord = new SendInfoRecord();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkCode(parkCode);
        sendinfoRecord.setParkId(message.getParkId());
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(message.getServiceId());
        sendinfoRecord.setServiceType(message.getServiceType());
        sendinfoRecord.setTarget(serialNumber);
        sendinfoRecord.setOperType(SendOperTypeEnum.\u8bf7\u6c42.getOperType());
        sendinfoRecord.setTaskId(message.getTaskId());
        sendinfoRecord.setRecordId(message.getRecordId());
        sendinfoRecord.setTopic(topic);
        sendinfoRecord.setEnv(SpringUtils.getActiveProfile());
        sendinfoRecord.setExtraInfo(extraInfo);
        this.redisUtils.set("MQ_RECORD_" + messageId, (Object)sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT.longValue());
    }

    public <T> String[] send2ParkOtherDevice(String parkCode, String serialNumber, Message<T> message) {
        ConnectedDeviceFilter filter = new ConnectedDeviceFilter();
        filter.setExcludeSerialNumber(serialNumber);
        return this.sendArray(parkCode, filter, message);
    }

    public <T> String[] send2ParkOtherExit(String parkCode, String serialNumber, Message<T> message) {
        ConnectedDeviceFilter filter = new ConnectedDeviceFilter();
        filter.setExcludeSerialNumber(serialNumber);
        filter.setInandoutType(2);
        return this.sendArray(parkCode, filter, message);
    }

    private <T> String[] sendArray(String parkCode, ConnectedDeviceFilter filter, Message<T> message) {
        List<ParkConnectedDeviceVo> list = this.getParkConnectedDevices(parkCode, filter);
        return (String[])list.stream().map(vo -> this.send(parkCode, vo.getDeviceNo(), message)).toArray(String[]::new);
    }

    public <T> String[] send2Exit(String parkCode, Message<T> message) {
        ConnectedDeviceFilter filter = new ConnectedDeviceFilter();
        filter.setInandoutType(2);
        return this.sendArray(parkCode, filter, message);
    }

    public <T> String[] send2Enter(String parkCode, Message<T> message) {
        ConnectedDeviceFilter filter = new ConnectedDeviceFilter();
        filter.setInandoutType(1);
        return this.sendArray(parkCode, filter, message);
    }

    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest) {
        return this.pushAll(sn, p2cBaseRequest, "p2c");
    }

    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest, String module) {
        try {
            WebSocketMessage message = WebSocketMessage.buildMessage((String)(StringUtils.isEmpty((CharSequence)module) ? "p2c" : module), (String)sn, (String)JSON.toJSONString(p2cBaseRequest)).setProtocolType(Integer.valueOf(1)).setTrace(Slf4jUtils.getTraceId());
            return (Boolean)this.iceProxyMsgHandle.sendSocketMsg(message).getData();
        }
        catch (Exception e) {
            log.error("[redis\u5e7f\u64ad\u53d1\u9001] clientName[{}]\u5e7f\u64ad\u5931\u8d25", (Object)sn, (Object)e);
            return false;
        }
    }

    public boolean pushAllOld(String clientName, String content) {
        try {
            content = clientName + content;
            this.stringRedisTemplate.convertAndSend("websocket", (Object)content);
        }
        catch (Exception e) {
            log.error("[redis\u5e7f\u64ad\u53d1\u9001] clientName[{}]\u5e7f\u64ad\u5931\u8d25", (Object)clientName, (Object)e);
            return false;
        }
        return true;
    }

    public boolean closeAll(String sn) {
        try {
            WebSocketMessage message = WebSocketMessage.buildClose((String)"p2c", (String)sn).setProtocolType(Integer.valueOf(1)).setTrace(Slf4jUtils.getTraceId());
            log.warn("<redis\u5e7f\u64ad\u5173\u95ed> clientName\uff1a{} ", (Object)sn);
            return (Boolean)this.iceProxyMsgHandle.sendSocketMsg(message).getData();
        }
        catch (Exception e) {
            log.error("<redis\u5e7f\u64ad\u5173\u95ed> clientName\uff1a{} \u5e7f\u64ad\u5931\u8d25", (Object)sn, (Object)e);
            return false;
        }
    }

    public boolean closeAllOld(String clientName) {
        try {
            log.warn("<redis\u5e7f\u64ad\u5173\u95ed> clientName\uff1a{} ", (Object)clientName);
            this.stringRedisTemplate.convertAndSend("websocket", (Object)("CLOSE:" + clientName));
        }
        catch (Exception e) {
            log.error("<redis\u5e7f\u64ad\u5173\u95ed> clientName\uff1a{} \u5e7f\u64ad\u5931\u8d25", (Object)clientName, (Object)e);
            return false;
        }
        return true;
    }

    static {
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u5c4f\u663e\u4fe1\u606f.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u51fa\u573a\u6570\u636e\u540c\u6b65.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u5165\u573a\u6570\u636e\u540c\u6b65.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u67e5\u8be2.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u5728\u573a\u8f66\u8f86\u6e05\u9664.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.LCD\u5c4f\u663e\u8bed\u97f3\u4fe1\u606f.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u6279\u91cf\u4e0b\u53d1.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u5347\u7ea7\u6307\u4ee4\u4e0b\u53d1.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u8f66\u961f\u6a21\u5f0f\u4e0b\u53d1.getCmd());
        SYNC_CMD_LIST.add(P2cDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmd());
        ALL_RET_EXCLUDE_LIST = new ArrayList<Integer>();
        ALL_RET_EXCLUDE_LIST.add(P2cDownCmdEnum.\u901a\u9053\u6743\u9650\u4e0b\u53d1.getCmdType());
        ALL_RET_EXCLUDE_LIST.add(P2cDownCmdEnum.\u8f66\u573a\u6743\u9650\u4e0b\u53d1.getCmdType());
        ALL_RET_EXCLUDE_LIST.add(P2cDownCmdEnum.\u9065\u63a7\u5668\u5bf9\u5e94\u5173\u7cfb.getCmdType());
        ALL_RET_EXCLUDE_LIST.add(P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType());
        ALL_RET_EXCLUDE_LIST.add(P2cDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
    }

    public static class ConnectedDeviceFilter {
        public String excludeSerialNumber;
        public Integer inandoutType;

        public String getExcludeSerialNumber() {
            return this.excludeSerialNumber;
        }

        public Integer getInandoutType() {
            return this.inandoutType;
        }

        public void setExcludeSerialNumber(String excludeSerialNumber) {
            this.excludeSerialNumber = excludeSerialNumber;
        }

        public void setInandoutType(Integer inandoutType) {
            this.inandoutType = inandoutType;
        }

        public String toString() {
            return "P2cDownHandle.ConnectedDeviceFilter(excludeSerialNumber=" + this.getExcludeSerialNumber() + ", inandoutType=" + this.getInandoutType() + ")";
        }
    }
}

