/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.third.utils.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MorOperHandle {
    private static final Logger log = LoggerFactory.getLogger(MorOperHandle.class);
    @Autowired
    protected ParkDeviceService parkDeviceService;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected MorCacheHandle cacheHandle;
    @Autowired
    protected RedisUtils redisUtils;

    public TokenDeviceVo getAndCacheDevice(String serialNumber) {
        TokenDeviceVo vo = this.cacheHandle.getDeviceInfo(serialNumber);
        if (vo != null) {
            this.cacheHandle.expireDeviceInfo(serialNumber);
            this.cacheHandle.setChannelSn(vo.getParkCode(), vo.getInandoutCode(), serialNumber);
            this.cacheHandle.updateLastConnTime(serialNumber, DateTools.unixTimestamp());
            return vo;
        }
        return this.cacheDevice(serialNumber, null);
    }

    public TokenDeviceVo cacheDevice(String serialNumber, String version) {
        log.info("[\u7aef\u4e91\u76d1\u63a7\u76f8\u673a\u63a5\u5165\u7684\u516c\u5171\u7c7b]\u7f13\u5b58\u5e76\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f, sn[{}]", (Object)serialNumber);
        ObjectResponse parkDeviceResp = this.parkDeviceService.getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = (ParkDevice)parkDeviceResp.getData();
        if (parkDevice == null || parkDevice.getType() != 9) {
            throw new ResponseBodyException("12001", CodeConstants.getName((String)"12001"));
        }
        version = version == null ? (parkDevice.getProtocolVer() == null ? "default" : parkDevice.getProtocolVer()) : version;
        long parkId = parkDevice.getParkId();
        ObjectResponse byParkCode = this.parkService.findByParkId(Long.valueOf(parkId));
        ObjectResponse.notError((Response)byParkCode);
        Park park = (Park)byParkCode.getData();
        String parkCode = park.getParkCode();
        ObjectResponse parkInoutdeviceObjectResponse = this.parkService.getInoutDeviceById(Long.valueOf(parkDevice.getChannelId().longValue()));
        if (!ObjectResponse.isSuccess((Response)parkInoutdeviceObjectResponse)) {
            throw new ResponseBodyException("44001", CodeConstants.getName((String)"44001"));
        }
        ParkInoutdevice data = (ParkInoutdevice)parkInoutdeviceObjectResponse.getData();
        TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(serialNumber);
        String token = tokenDeviceVo == null || tokenDeviceVo.getToken() == null ? UUIDTools.getUuid() : tokenDeviceVo.getToken();
        TokenDeviceVo tdv = new TokenDeviceVo();
        tdv.setParkId(park.getId());
        tdv.setParkCode(parkCode);
        tdv.setDeviceNo(serialNumber);
        tdv.setVersion(version);
        tdv.setId(data.getId());
        tdv.setInandoutName(data.getInandoutName());
        tdv.setInandoutCode(data.getInandoutCode());
        tdv.setRegionId(data.getRegionId());
        tdv.setInandoutType(data.getInandoutType());
        tdv.setToken(token);
        this.cacheHandle.cacheDeviceInfo(serialNumber, tdv);
        this.cacheHandle.setChannelSn(parkCode, data.getInandoutCode(), serialNumber);
        this.cacheHandle.updateLastConnTime(serialNumber, DateTools.unixTimestamp());
        ParkConnectedDeviceVo parkConnectedDeviceVo = new ParkConnectedDeviceVo();
        parkConnectedDeviceVo.setDeviceNo(serialNumber);
        parkConnectedDeviceVo.setId(data.getId());
        parkConnectedDeviceVo.setInandoutType(data.getInandoutType());
        parkConnectedDeviceVo.setRegionId(data.getRegionId());
        parkConnectedDeviceVo.setInandoutCode(data.getInandoutCode());
        this.cacheHandle.addParkConnectList(parkCode, parkConnectedDeviceVo);
        return tdv;
    }
}

