/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.icetech.cloudcenter.domain.enumeration.MorDownCmdEnum;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.BaseDownHandle;
import com.icetech.park.service.handle.MorCacheHandle;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MorDownHandle
extends BaseDownHandle {
    private static final Logger log = LoggerFactory.getLogger(MorDownHandle.class);
    @Autowired
    private MorCacheHandle cacheHandle;
    private static final String productKey = "05422AF9FC1CF378";
    public static final String DEVICE_PROFILE = "mor";
    private static final List<String> SYNC_CMD_LIST = new ArrayList<String>();

    @Override
    public String send(String serialNumber, Message message) {
        Integer reqServiceType = message.getReqServiceType();
        Object payload = message.getPayload();
        P2cBaseRequest p2cBaseRequest = new P2cBaseRequest();
        p2cBaseRequest.setCmd(MorDownCmdEnum.getCmd((Integer)reqServiceType));
        String messageId = UUIDTools.getUuid();
        p2cBaseRequest.setMessageId(messageId);
        TokenDeviceVo tokenInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        log.info("serialNumber[{}] tokenInfo[{}]", (Object)serialNumber, (Object)tokenInfo);
        if (tokenInfo == null) {
            return null;
        }
        p2cBaseRequest.setBizContent(payload);
        String paraJson = JsonUtils.toString((Object)p2cBaseRequest);
        boolean success = this.pushAll(serialNumber, p2cBaseRequest, DEVICE_PROFILE);
        log.info("[\u76d1\u63a7\u76f8\u673aWS\u4e0b\u53d1] \u5e7f\u64ad{}, \u8bbe\u5907[{}], \u5185\u5bb9[{}]", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", serialNumber, paraJson});
        if (success) {
            this.addRequestRecord(message, messageId, payload, serialNumber);
        }
        return success ? messageId : null;
    }

    @Override
    protected List<String> getSyncCmdList() {
        return SYNC_CMD_LIST;
    }

    @Override
    protected String getDeviceProfile() {
        return DEVICE_PROFILE;
    }

    static {
        SYNC_CMD_LIST.add(MorDownCmdEnum.\u6807\u8bb0\u7591\u4f3c\u8ddf\u8f66.getCmd());
        SYNC_CMD_LIST.add(MorDownCmdEnum.\u8bf7\u6c42\u8f66\u8f86\u89c6\u9891.getCmd());
        SYNC_CMD_LIST.add(MorDownCmdEnum.OSS\u914d\u7f6e\u4e0b\u53d1.getCmd());
    }
}

