/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.ItcDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.P2cBaseMsg;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.oss.OssService;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.ItcCacheHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ItcDownHandle {
    private static final Logger log = LoggerFactory.getLogger(ItcDownHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ItcCacheHandle cacheHandle;
    @Autowired
    private OssService ossService;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String productKey = "6C13146A58DB24DA";
    private static final List<String> SYNC_CMD_LIST = new ArrayList<String>();

    public String send(String serialNumber, Message message) {
        Integer reqServiceType = message.getReqServiceType();
        Object payload = message.getPayload();
        P2cBaseRequest p2cBaseRequest = new P2cBaseRequest();
        p2cBaseRequest.setCmd(P2cDownCmdEnum.getCmd((Integer)reqServiceType));
        String messageId = UUIDTools.getUuid();
        p2cBaseRequest.setMessageId(messageId);
        TokenDeviceVo tokenInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        log.info("serialNumber[{}] tokenInfo[{}]", (Object)serialNumber, (Object)tokenInfo);
        if (tokenInfo == null) {
            return null;
        }
        p2cBaseRequest.setProductKey(productKey);
        p2cBaseRequest.setBizContent(payload);
        String paraJson = JsonUtils.toString((Object)p2cBaseRequest);
        boolean success = this.pushAll(serialNumber, p2cBaseRequest);
        log.info("[\u7aef\u4e91\u7acb\u67f1WS\u4e0b\u53d1] \u5e7f\u64ad{}, \u8bbe\u5907[{}], \u5185\u5bb9[{}]", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", serialNumber, paraJson});
        if (success) {
            this.addRequestRecord(message, messageId, payload, serialNumber);
        }
        return success ? messageId : null;
    }

    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, Integer serviceType) {
        String messageId = p2CBaseResponse.getMessageId();
        SendInfoRecord sendinfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, SendInfoRecord.class);
        if (sendinfoRecord == null) {
            sendinfoRecord = new SendInfoRecord();
            sendinfoRecord.setServiceType(serviceType);
            sendinfoRecord.setMessageId(messageId);
            sendinfoRecord.setParkId(parkId);
        }
        Integer code = p2CBaseResponse.getCode();
        String cmd = p2CBaseResponse.getCmd();
        String msg = p2CBaseResponse.getMsg();
        cmd = cmd.substring(0, cmd.indexOf("_resp"));
        String data = (String)p2CBaseResponse.getData();
        String key = "RESP_MSG_" + messageId;
        if (SYNC_CMD_LIST.contains(cmd)) {
            ObjectResponse retResponse = new ObjectResponse();
            retResponse.setCode(String.valueOf(code));
            retResponse.setMsg(msg);
            if (code.equals(CodeEnum.\u6210\u529f.getCode()) && StringUtils.isNotEmpty((CharSequence)p2CBaseResponse.getResultPath())) {
                File oss2File = this.ossService.getOSS2File(p2CBaseResponse.getResultPath());
                data = FileUtil.readString((File)oss2File, (String)"utf-8");
            }
            retResponse.setData((Object)data);
            this.redisUtils.set(key, (Object)retResponse, TimeOutConstants.REDIS_TIMEOUT.longValue());
            int valueLen = retResponse.toString().length();
            log.info("[\u7acb\u67f1\u54cd\u5e94\u5904\u7406] \u5199\u5165redis\u6210\u529f,key[{}],value[{}]", (Object)key, (Object)(valueLen > 1024 ? retResponse.toString().substring(0, 1024) + "..." : retResponse));
        }
    }

    private void addRequestRecord(Message message, String messageId, Object t, String serialNumber) {
        SendInfoRecord sendinfoRecord = new SendInfoRecord();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkId(message.getParkId());
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(message.getServiceId());
        sendinfoRecord.setServiceType(message.getServiceType());
        sendinfoRecord.setTarget(serialNumber);
        sendinfoRecord.setOperType(SendOperTypeEnum.\u8bf7\u6c42.getOperType());
        sendinfoRecord.setTaskId(message.getTaskId());
        sendinfoRecord.setRecordId(message.getRecordId());
        this.redisUtils.set("MQ_RECORD_" + messageId, (Object)sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT.longValue());
    }

    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest) {
        return this.pushAll(sn, p2cBaseRequest, "common");
    }

    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest, String module) {
        try {
            P2cBaseMsg p2cBaseMsg = new P2cBaseMsg();
            BeanUtils.copyProperties(p2cBaseRequest, (Object)p2cBaseMsg);
            p2cBaseMsg.setSn(sn);
            p2cBaseMsg.setModule(StringUtils.isEmpty((CharSequence)module) ? "common" : module);
            this.redisTemplate.convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, (Object)JSON.toJSONString((Object)p2cBaseMsg));
            return true;
        }
        catch (Exception e) {
            log.error("[redis\u5e7f\u64ad\u53d1\u9001] clientName[{}]\u5e7f\u64ad\u5931\u8d25", (Object)sn, (Object)e);
            return false;
        }
    }

    static {
        SYNC_CMD_LIST.add(ItcDownCmdEnum.\u5c4f\u663e\u4fe1\u606f.getCmd());
    }
}

