/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.alibaba.fastjson.TypeReference;
import com.icetech.cloudcenter.domain.vo.p2c.ParkConnectedDeviceVo;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ItcCacheHandle {
    private static final Logger log = LoggerFactory.getLogger(ItcCacheHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    private static final int INTERVAL = 50;
    private static final int EXPIRE_TIME = 108000;

    public boolean closeForClearCache(String sn) {
        TokenDeviceVo tokenInfo = this.getDeviceInfo(sn);
        if (tokenInfo != null) {
            return this.closeForClearCache(tokenInfo.getParkCode(), sn, tokenInfo.getInandoutCode());
        }
        return false;
    }

    public boolean closeForClearCache(String parkCode, String serialNumber, String inandoutCode) {
        String key2;
        String key1 = "itc:sn:" + serialNumber;
        if (this.redisUtils.exists(key1)) {
            this.redisUtils.remove(key1);
        }
        if (this.redisUtils.exists(key2 = "itc:channel:sn:" + parkCode + "_" + inandoutCode)) {
            this.redisUtils.remove(key2);
        }
        String key = "itc:park:connected:devices:" + parkCode;
        List list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        for (ParkConnectedDeviceVo vo : list) {
            if (vo.getInandoutCode() == null || vo.getDeviceNo() == null) {
                this.redisUtils.lRemove(key, 0L, (Object)vo);
            }
            if (!vo.getDeviceNo().equals(serialNumber)) continue;
            this.redisUtils.lRemove(key, 0L, (Object)vo);
        }
        log.info("\u7f13\u5b58\u6e05\u9664\u6210\u529f\uff0cserialNumber[{}]", (Object)serialNumber);
        return true;
    }

    public void cacheDeviceInfo(String sn, TokenDeviceVo vo) {
        String key = "itc:sn:" + sn;
        this.redisUtils.set(key, (Object)vo, 108000L);
    }

    public void updateDeviceInfo(String sn, TokenDeviceVo vo) {
        String key = "itc:sn:" + sn;
        this.redisUtils.set(key, (Object)vo, 108000L);
    }

    public void expireDeviceInfo(String sn) {
        String key = "itc:sn:" + sn;
        this.redisUtils.expire(key, 108000L);
    }

    public TokenDeviceVo getDeviceInfo(String sn) {
        String key = "itc:sn:" + sn;
        return (TokenDeviceVo)this.redisUtils.get(key, TokenDeviceVo.class);
    }

    public <T> T getDataFromRedis(String messageId, long timeOut, Class<T> clazz) {
        String key = messageId;
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        int n = 1;
        while (lastTime > currentTimeMillis) {
            Object data = this.redisUtils.get(key, clazz);
            if (data != null) {
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff1a{}", new Object[]{n, key, data});
                return (T)data;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        log.info("\u65f6\u9650\u5185\u672a\u67e5\u8be2\u5230key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff01", (Object)key);
        return null;
    }

    public ObjectResponse<String> getResponseFromRedis(String messageId, Long timeOut) {
        String key = "RESP_MSG_" + messageId;
        long currentTimeMillis = System.currentTimeMillis();
        long lastTime = currentTimeMillis + timeOut;
        int n = 1;
        while (lastTime > currentTimeMillis) {
            if (this.redisUtils.exists(key)) {
                ObjectResponse data = (ObjectResponse)this.redisUtils.get(key, (TypeReference)new TypeReference<ObjectResponse<String>>(){});
                log.info("\u7b2c{}\u6b21\u4eceredis\u4e2d\u8bfb\u53d6\u5230\u4e86key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff1a{}", new Object[]{n, key, data});
                return data;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            }
            currentTimeMillis = System.currentTimeMillis();
            ++n;
        }
        log.info("\u65f6\u9650\u5185\u672a\u67e5\u8be2\u5230key\uff1a{}\u54cd\u5e94\u7684\u4fe1\u606f\uff01", (Object)key);
        return null;
    }

    public String getSerialNumber(String parkCode, String channelCode) {
        return (String)this.redisUtils.get("itc:channel:sn:" + parkCode + "_" + channelCode, String.class);
    }

    public boolean setChannelSn(String parkCode, String channelCode, String sn) {
        String key = "itc:channel:sn:" + parkCode + "_" + channelCode;
        try {
            return this.redisUtils.set(key, (Object)sn, 108000L);
        }
        catch (Exception e) {
            log.error("<\u7f13\u5b58\u64cd\u4f5c-\u901a\u9053\u76f8\u673a\u5e8f\u5217\u53f7> redis\u5199\u5165\u5f02\u5e38\uff0ckey\uff1a{}\uff0cvalue\uff1a{}", (Object)key, (Object)sn);
            return false;
        }
    }

    @Deprecated
    public boolean expireChannelSn(String parkCode, String channelCode) {
        String key = "itc:channel:sn:" + parkCode + "_" + channelCode;
        log.info("[\u901a\u9053\u7acb\u67f1\u6807\u8bc6] key[{}], expire[{}]", (Object)key, (Object)108000);
        this.redisUtils.expire(key, 90000L);
        return true;
    }

    public void updateLastConnTime(String sn, Long connTime) {
        this.redisUtils.hPut("itc:heartbeat:time", sn, (Object)connTime);
    }

    public void addParkConnectList(String parkCode, ParkConnectedDeviceVo parkConnectedDeviceVo) {
        String key = "itc:park:connected:devices:" + parkCode;
        ArrayList<ParkConnectedDeviceVo> list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        if (list.isEmpty()) {
            list = new ArrayList<ParkConnectedDeviceVo>();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            if (!vo.getDeviceNo().equals(parkConnectedDeviceVo.getDeviceNo())) continue;
            this.redisUtils.lRemove(key, 0L, (Object)vo);
            iterator.remove();
        }
        list.add(parkConnectedDeviceVo);
        log.info("[\u6ce8\u518c\u8bbe\u5907] \u8f66\u573a[{}]\u5f53\u524d\u5728\u7ebf\u8bbe\u5907[{}]\u53f0\uff0c\u5206\u522b\u662f[{}]", new Object[]{parkCode, list.size(), list});
        this.redisUtils.lRightPush(key, (Object)parkConnectedDeviceVo);
    }

    public List<ParkConnectedDeviceVo> getParkConnectList(String parkCode) {
        String key = "itc:park:connected:devices:" + parkCode;
        List list = this.redisUtils.lRange(key, 0L, -1L, ParkConnectedDeviceVo.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ParkConnectedDeviceVo vo = (ParkConnectedDeviceVo)iterator.next();
            TokenDeviceVo deviceInfo = this.getDeviceInfo(vo.getDeviceNo());
            if (deviceInfo != null && parkCode.equals(deviceInfo.getParkCode())) continue;
            this.redisUtils.lRemove(key, 0L, (Object)vo);
            iterator.remove();
            log.info("[\u83b7\u53d6\u6700\u65b0\u5728\u7ebf\u5217\u8868] parkCode[{}], \u79fb\u9664\u4e0d\u5728\u7ebf\u8bbe\u5907[{}]", (Object)parkCode, (Object)vo);
        }
        log.info("[\u83b7\u53d6\u6700\u65b0\u5728\u7ebf\u5217\u8868] parkCode[{}], \u8bbe\u5907\u5217\u8868[{}]", (Object)parkCode, (Object)list);
        return list;
    }
}

