/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.request.NotifyRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.constants.ServiceEnum;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.ReflectUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fullcloud.api.DownMsgService;
import com.icetech.park.domain.dto.full.RequestDTO;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.factory.SendServiceFactory;
import com.icetech.park.service.impl.TaskCenterServiceImpl;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FullCloudDownHandle {
    private static final Logger log = LoggerFactory.getLogger(FullCloudDownHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private TaskCenterServiceImpl taskCenterService;
    @Autowired
    private DownMsgService downMsgService;
    private static final List<String> SYNC_CMD_LIST = new ArrayList<String>();
    private static final List<Integer> ALL_RET_EXCLUDE_LIST;

    public <T> String send(String parkCode, String serialNumber, Message<T> message) {
        return this.send(parkCode, serialNumber, message, null);
    }

    public <T> String send(String parkCode, String serialNumber, Message<T> message, String topic) {
        return this.send(parkCode, serialNumber, message, topic, null);
    }

    public <T> String send(String parkCode, String serialNumber, Message<T> message, String topic, String extraInfo) {
        Integer reqServiceType = message.getReqServiceType();
        T payload = message.getPayload();
        String clientName = parkCode + "_" + serialNumber;
        RequestDTO requestDTO = new RequestDTO();
        requestDTO.setType(FullCloudDownCmdEnum.getCmd((Integer)reqServiceType));
        requestDTO.setBody(payload);
        TokenDeviceVo tokenInfo = this.cacheHandle.getDeviceInfo(serialNumber);
        log.info("serialNumber[{}] tokenInfo[{}]", (Object)serialNumber, (Object)tokenInfo);
        if (tokenInfo == null) {
            return null;
        }
        ObjectResponse objectResponse = StringUtils.isNotBlank((CharSequence)message.getMessageId()) ? this.downMsgService.sendDownMessage(requestDTO, serialNumber, message.getMessageId()) : this.downMsgService.sendDownMessage(requestDTO, serialNumber);
        boolean success = ObjectResponse.isSuccess((Response)objectResponse);
        String messageId = success ? (String)objectResponse.getData() : null;
        log.info("[\u7eaf\u4e91MQTT] \u4e0b\u53d1{}\uff0c\u76f8\u673a:[{}]\uff0c\u5185\u5bb9\u4e3a:{}, \u8fd4\u56de[{}]", new Object[]{success ? "\u6210\u529f" : "\u5931\u8d25", clientName, JsonUtils.toString((Object)requestDTO), messageId});
        if (success) {
            this.addRequestRecord(message, parkCode, messageId, payload, serialNumber, topic, extraInfo);
        }
        return messageId;
    }

    public void dealResponse(P2cBaseResponse<String> p2cBaseResponse, Long parkId, Integer serviceType) {
        String messageId = p2cBaseResponse.getMessageId();
        SendInfoRecord sendinfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, SendInfoRecord.class);
        if (sendinfoRecord == null) {
            sendinfoRecord = new SendInfoRecord();
            sendinfoRecord.setServiceType(serviceType);
            sendinfoRecord.setMessageId(messageId);
            sendinfoRecord.setParkId(parkId);
        }
        if (sendinfoRecord.getNextPayLoad() != null) {
            Message<Object> message = new Message<Object>();
            BeanUtils.copyProperties((Object)sendinfoRecord, message);
            message.setPayload(sendinfoRecord.getNextPayLoad());
            message.setNextPayLoad(null);
            message.setMessageId(sendinfoRecord.getMessageId());
            this.send(sendinfoRecord.getParkCode(), sendinfoRecord.getTarget(), message, sendinfoRecord.getTopic(), sendinfoRecord.getExtraInfo());
            return;
        }
        serviceType = sendinfoRecord.getServiceType();
        Integer code = p2cBaseResponse.getCode();
        String cmd = p2cBaseResponse.getCmd();
        String msg = p2cBaseResponse.getMsg();
        String data = (String)p2cBaseResponse.getData();
        String key = "RESP_MSG_" + messageId;
        if (SYNC_CMD_LIST.contains(cmd) && sendinfoRecord.getServiceId() == null) {
            ObjectResponse retResponse = new ObjectResponse();
            retResponse.setCode(String.valueOf(code));
            retResponse.setMsg(msg);
            retResponse.setData((Object)data);
            this.redisUtils.set(key, (Object)retResponse, TimeOutConstants.REDIS_TIMEOUT.longValue());
            try {
                NotifyService notifyService = SendServiceFactory.getFullCloudBean(cmd, NotifyService.class);
                sendinfoRecord.setParams(JSONObject.parseObject((String)JsonUtils.toString((Object)sendinfoRecord.getParams()), (Type)ReflectUtils.getInterfaceGenericTypes(NotifyService.class, (Object)notifyService)[0], (Feature[])new Feature[0]));
                notifyService.notify(messageId, retResponse, sendinfoRecord);
            }
            catch (ResponseBodyException | ClassCastException notifyService) {
            }
            catch (Exception e) {
                log.warn("{} Bean error", (Object)cmd, (Object)e);
            }
            int valueLen = retResponse.toString().length();
            log.info("[\u76f8\u673a\u54cd\u5e94\u5904\u7406] \u5199\u5165redis\u6210\u529f,key[{}],value[{}]", (Object)key, (Object)(valueLen > 1024 ? retResponse.toString().substring(0, 1024) + "..." : retResponse));
        } else {
            Long serviceId = sendinfoRecord.getServiceId();
            if (serviceId != null) {
                NotifyRequest notifyRequest = new NotifyRequest();
                notifyRequest.setTargetService(ServiceEnum.Data.getType());
                notifyRequest.setOne(sendinfoRecord.getTarget());
                notifyRequest.setServiceId(serviceId);
                notifyRequest.setServiceType(serviceType);
                notifyRequest.setTaskId(sendinfoRecord.getTaskId());
                notifyRequest.setRecordId(sendinfoRecord.getRecordId());
                if (code.equals(CodeEnum.\u6210\u529f.getCode()) || code == 405) {
                    notifyRequest.setSuccess(true);
                    SendRequest sendRequest = new SendRequest();
                    sendRequest.setParkId(parkId);
                    sendRequest.setServiceId(serviceId);
                    sendRequest.setServiceType(serviceType);
                    sendRequest.setTaskId(sendinfoRecord.getTaskId());
                    sendRequest.setRecordId(sendinfoRecord.getRecordId());
                    if (ALL_RET_EXCLUDE_LIST.contains(serviceType)) {
                        this.taskCenterService.notify(notifyRequest);
                    } else {
                        boolean isAllRet = this.cacheHandle.retSendDevice(sendRequest, sendinfoRecord.getTarget());
                        if (isAllRet) {
                            log.info("\u51c6\u5907\u901a\u77e5TaskCenter\uff1a{}", (Object)notifyRequest);
                            this.taskCenterService.notify(notifyRequest);
                        }
                    }
                } else {
                    notifyRequest.setSuccess(false);
                    if (msg == null) {
                        msg = "\u672a\u77e5\u9519\u8bef";
                    }
                    notifyRequest.setCause(msg);
                    this.taskCenterService.notify(notifyRequest);
                }
            }
        }
    }

    private <T> void addRequestRecord(Message<T> message, String parkCode, String messageId, Object t, String serialNumber, String topic, String extraInfo) {
        SendInfoRecord sendinfoRecord = new SendInfoRecord();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkCode(parkCode);
        sendinfoRecord.setParkId(message.getParkId());
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(message.getServiceId());
        sendinfoRecord.setServiceType(message.getServiceType());
        sendinfoRecord.setReqServiceType(message.getReqServiceType());
        sendinfoRecord.setTarget(serialNumber);
        sendinfoRecord.setOperType(SendOperTypeEnum.\u8bf7\u6c42.getOperType());
        sendinfoRecord.setTaskId(message.getTaskId());
        sendinfoRecord.setRecordId(message.getRecordId());
        sendinfoRecord.setTopic(topic);
        sendinfoRecord.setEnv(SpringUtils.getActiveProfile());
        sendinfoRecord.setExtraInfo(extraInfo);
        sendinfoRecord.setNextPayLoad(message.getNextPayLoad());
        this.redisUtils.set("MQ_RECORD_" + messageId, (Object)sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT.longValue());
    }

    static {
        SYNC_CMD_LIST.add(FullCloudDownCmdEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getCmd());
        SYNC_CMD_LIST.add(FullCloudDownCmdEnum.\u767d\u540d\u5355\u6570\u636e\u67e5\u8be2.getCmd());
        SYNC_CMD_LIST.add(FullCloudDownCmdEnum.\u56fe\u7247\u6293\u62cd.getCmd());
        SYNC_CMD_LIST.add(FullCloudDownCmdEnum.\u5c4f\u663e\u4fe1\u606f\u4e0b\u53d1.getCmd());
        ALL_RET_EXCLUDE_LIST = new ArrayList<Integer>();
        ALL_RET_EXCLUDE_LIST.add(FullCloudDownCmdEnum.\u540d\u5355\u6570\u636e\u6e05\u7a7a.getCmdType());
    }
}

