/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import com.icetech.cloudcenter.domain.response.UpgradeProgressResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.park.dao.FirmwareUpgradeDao;
import com.icetech.park.domain.entity.FirmwareUpgrade;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceUpgradeHandle {
    private static final Logger log = LoggerFactory.getLogger(DeviceUpgradeHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private FirmwareUpgradeDao firmwareUpgradeDao;

    public UpgradeProgressResponse progress(String taskId) {
        Integer stepStatus;
        Long sendTime;
        FirmwareUpgrade firmwareUpgrade = this.firmwareUpgradeDao.selectByTaskId(taskId);
        if (firmwareUpgrade == null) {
            return null;
        }
        UpgradeProgressResponse upgradeProgressResponse = new UpgradeProgressResponse();
        String key = "upgrade:task:" + taskId;
        if (this.redisUtils.exists(key)) {
            Map objectObjectMap = this.redisUtils.hGetAll(key, Object.class);
            log.info("[\u5347\u7ea7\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2] redis\u7684\u60c5\u51b5[{}]", (Object)objectObjectMap);
            sendTime = ((Integer)objectObjectMap.get("sendTime")).longValue();
            upgradeProgressResponse.setTaskStep((Integer)objectObjectMap.get("step"));
            stepStatus = (Integer)objectObjectMap.get("stepStatus");
            if (stepStatus != 1) {
                upgradeProgressResponse.setResultTime((String)objectObjectMap.get("updateTime"));
            }
            upgradeProgressResponse.setStepStatus(stepStatus);
        } else {
            sendTime = firmwareUpgrade.getActionTime().getTime() / 1000L;
            upgradeProgressResponse.setTaskStep(Integer.valueOf(3));
            upgradeProgressResponse.setStepStatus(Integer.valueOf(1));
            Integer status = firmwareUpgrade.getStatus();
            if (status == 3) {
                upgradeProgressResponse.setStepStatus(Integer.valueOf(2));
            }
            if (status == 4) {
                upgradeProgressResponse.setStepStatus(Integer.valueOf(3));
            }
            if (upgradeProgressResponse.getStepStatus() == 1) {
                upgradeProgressResponse.setResultTime(null);
            } else if (status == 3) {
                upgradeProgressResponse.setResultTime(DateTools.getFormat((Date)firmwareUpgrade.getSuccessTime()));
            } else {
                upgradeProgressResponse.setResultTime(DateTools.getFormat((Date)firmwareUpgrade.getUpdateTime()));
            }
        }
        Integer taskStep = upgradeProgressResponse.getTaskStep();
        stepStatus = upgradeProgressResponse.getStepStatus();
        if (stepStatus == 1 && this.validTimeout(sendTime, taskStep)) {
            firmwareUpgrade.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u5931\u8d25.status));
            firmwareUpgrade.setReason("\u8bbe\u5907\u54cd\u5e94\u8d85\u65f6");
            firmwareUpgrade.setUpdateTime(new Date());
            this.firmwareUpgradeDao.updateById(firmwareUpgrade);
            String resultTime = DateTools.Date();
            if (this.redisUtils.exists(key)) {
                this.redisUtils.hPut(key, "stepStatus", (Object)3);
                this.redisUtils.hPut(key, "updateTime", (Object)resultTime);
            }
            upgradeProgressResponse.setStepStatus(Integer.valueOf(3));
            upgradeProgressResponse.setResultTime(resultTime);
        }
        return upgradeProgressResponse;
    }

    private boolean validTimeout(Long sendTime, Integer taskStep) {
        long now = DateTools.unixTimestamp();
        return taskStep == 1 ? now - sendTime > 60L : now - sendTime > 600L;
    }

    public void versionModify(String sn, String newVer) {
        if (sn == null || newVer == null) {
            return;
        }
        FirmwareUpgrade firmwareUpgrade = this.firmwareUpgradeDao.selectTaskBySnAndStatus(sn, FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u4e2d.status);
        if (firmwareUpgrade == null) {
            return;
        }
        String targetVer = firmwareUpgrade.getTargetVer();
        String key = "upgrade:task:" + firmwareUpgrade.getTaskId();
        if (newVer.equals(targetVer)) {
            log.info("[\u8bbe\u5907\u56fa\u4ef6\u7248\u672c\u53f7\u53d8\u66f4] \u5347\u7ea7\u6210\u529f,taskId[{}]sn[{}]\u5f53\u524d\u7248\u672c[{}]", new Object[]{firmwareUpgrade.getTaskId(), sn, newVer});
            firmwareUpgrade.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u6210\u529f.status));
            firmwareUpgrade.setSuccessTime(new Date());
            if (this.redisUtils.exists(key)) {
                this.redisUtils.hPut(key, "step", (Object)3);
                this.redisUtils.hPut(key, "stepStatus", (Object)2);
                this.redisUtils.hPut(key, "updateTime", (Object)DateTools.Date());
            }
        } else {
            log.warn("[\u8bbe\u5907\u56fa\u4ef6\u7248\u672c\u53f7\u53d8\u66f4] \u5347\u7ea7\u5931\u8d25,\u65b0\u7248\u672c\u53f7\u4e0e\u5347\u7ea7\u7248\u672c\u53f7\u4e0d\u4e00\u81f4,taskId[{}]sn[{}]\u5f53\u524d\u7248\u672c[{}]\u76ee\u6807\u5347\u7ea7\u7248\u672c[{}]", new Object[]{firmwareUpgrade.getTaskId(), sn, newVer, targetVer});
            firmwareUpgrade.setStatus(Integer.valueOf(FirmwareUpgrade.StatusEnum.\u5347\u7ea7\u5931\u8d25.status));
            firmwareUpgrade.setReason("\u65b0\u7248\u672c\u53f7\u4e0e\u5347\u7ea7\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
            if (this.redisUtils.exists(key)) {
                this.redisUtils.hPut(key, "step", (Object)3);
                this.redisUtils.hPut(key, "stepStatus", (Object)3);
                this.redisUtils.hPut(key, "updateTime", (Object)DateTools.Date());
            }
        }
        firmwareUpgrade.setUpdateTime(new Date());
        this.firmwareUpgradeDao.updateById(firmwareUpgrade);
    }
}

