/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import cn.hutool.core.util.StrUtil;
import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.constants.BatchDownMsgConstants;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.LcdConfigRequest;
import com.icetech.cloudcenter.domain.request.p2c.LedsoundConfigRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.utils.DateTools;
import com.icetech.park.dao.BatchsendTaskDao;
import com.icetech.park.dao.BatchsendTaskSubDao;
import com.icetech.park.domain.entity.BatchsendTask;
import com.icetech.park.domain.entity.BatchsendTaskSub;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.handle.BatchDownUtils;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchDownConfigHandle<T> {
    private static final Logger log = LoggerFactory.getLogger(BatchDownConfigHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private BatchsendTaskDao batchsendTaskDao;
    @Autowired
    private BatchsendTaskSubDao batchsendTaskSubDao;
    @Autowired
    private P2cDownHandle p2CDownHandle;
    @Autowired
    private SendInfoService sendInfoService;
    @Autowired
    private CacheHandle cacheHandle;

    public void batchDown(BatchSendVO vo, T data, int cmdType) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        List subTaskInfos = vo.getSubTaskInfos();
        int size = 1;
        Message<Object> message = new Message<T>(parkId, cmdType, data);
        for (int i = 0; i < subTaskInfos.size(); ++i) {
            String version;
            BatchSendVO.SubTaskInfo subTaskInfo = (BatchSendVO.SubTaskInfo)subTaskInfos.get(i);
            Integer subTaskId = subTaskInfo.getSubTaskId();
            String subTaskKey = "batchdown:task:sub:" + subTaskId;
            this.redisUtils.hPut(subTaskKey, "totalNum", (Object)size);
            String sn = subTaskInfo.getSn();
            if (StrUtil.isBlank((CharSequence)sn)) {
                this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.NO_CAMERA);
                this.finishErrorTask(size, subTaskId, BatchDownMsgConstants.NO_CAMERA);
                continue;
            }
            TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(sn);
            String string = version = tokenDeviceVo == null ? null : tokenDeviceVo.getVersion();
            if ((P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(cmdType) || P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(cmdType) || P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType().equals(cmdType)) && version != null && P2cVersionEnum.getIndex((String)version) < P2cVersionEnum.\u7248\u672c4.getIndex()) {
                String error = "\u76f8\u673a\u7248\u672c\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u4e0b\u53d1";
                this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
                this.finishErrorTask(size, subTaskId, error);
                continue;
            }
            if (P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(cmdType)) {
                LedsoundConfigRequest ledsoundConfigRequest = (LedsoundConfigRequest)data;
                message = new Message<LedsoundConfigRequest>(parkId, cmdType, ledsoundConfigRequest);
            } else if (P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(cmdType)) {
                LcdConfigRequest lcdConfigRequest = (LcdConfigRequest)data;
                message = new Message<LcdConfigRequest>(parkId, cmdType, lcdConfigRequest);
            }
            if (tokenDeviceVo != null && tokenDeviceVo.getVersion() != null) {
                Object payload = message.getPayload();
                if (payload instanceof List) {
                    List list = (List)payload;
                    Object object = list.get(0);
                    if (object instanceof Request) {
                        for (Object o : list) {
                            Request request = (Request)o;
                            request.buildByVersion(tokenDeviceVo.getVersion());
                        }
                    }
                } else if (payload instanceof Request) {
                    Request request = (Request)payload;
                    request.buildByVersion(tokenDeviceVo.getVersion());
                }
            }
            String messageId = this.p2CDownHandle.send(parkCode, sn, message);
            this.redisUtils.set("batchdown:open:" + parkId + ":" + cmdType, (Object)1, 600L);
            if (messageId == null) {
                this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.DEVICE_OFF_LINE);
                this.finishErrorTask(size, subTaskId, BatchDownMsgConstants.DEVICE_OFF_LINE);
                continue;
            }
            this.redisUtils.hPut(subTaskKey, "status", (Object)2);
            this.redisUtils.set("batchdown:msgid:" + messageId, (Object)subTaskId, 10L);
        }
    }

    public void repeatBatch(BatchSendRepeatVO vo, T data, int cmdType) {
        String version;
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        Integer subTaskId = vo.getSubTaskId();
        String sn = vo.getSn();
        int size = 1;
        Message<T> message = new Message<T>(parkId, cmdType, data);
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        this.redisUtils.expire(subTaskKey, 3600L);
        this.redisUtils.hPut(subTaskKey, "startTime", (Object)DateTools.unixTimestamp());
        TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(sn);
        String string = version = tokenDeviceVo == null ? null : tokenDeviceVo.getVersion();
        if ((P2cDownCmdEnum.LCD\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(cmdType) || P2cDownCmdEnum.\u81ea\u5b9a\u4e49\u8bed\u97f3\u5c4f\u663e\u914d\u7f6e.getCmdType().equals(cmdType) || P2cDownCmdEnum.\u8ba1\u8d39\u89c4\u5219.getCmdType().equals(cmdType)) && version != null && P2cVersionEnum.getIndex((String)version) < P2cVersionEnum.\u7248\u672c4.getIndex()) {
            String error = "\u76f8\u673a\u7248\u672c\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u4e0b\u53d1";
            this.redisUtils.hPut(subTaskKey, "status", (Object)3);
            this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
            this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
            this.finishErrorTask(size, subTaskId, error);
            return;
        }
        String messageId = this.p2CDownHandle.send(parkCode, sn, message);
        this.redisUtils.set("batchdown:open:" + parkId + ":" + cmdType, (Object)1, 600L);
        String reason = (String)this.redisUtils.hGet(subTaskKey, "reason", String.class);
        if (messageId == null) {
            String error = BatchDownUtils.convertMsgAndGetNewMsg(reason, BatchDownMsgConstants.DEVICE_OFF_LINE);
            this.redisUtils.hPut(subTaskKey, "status", (Object)3);
            this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
            this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
            this.finishErrorTask(size, subTaskId, error);
        } else {
            this.redisUtils.hPut(subTaskKey, "status", (Object)2);
            this.redisUtils.set("batchdown:msgid:" + messageId, (Object)subTaskId, 60L);
        }
    }

    private void finishErrorTask(int size, Integer subTaskId, String reason) {
        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setId(subTaskId);
        batchsendTaskSub.setStatus(Integer.valueOf(3));
        batchsendTaskSub.setTotalNum(Integer.valueOf(1));
        batchsendTaskSub.setFailNum(Integer.valueOf(size));
        batchsendTaskSub.setReason(reason);
        this.batchsendTaskSubDao.updateById(batchsendTaskSub);
    }

    public void dealBatchResponse(P2cBaseResponse<String> p2CBaseResponse, Integer subTaskId, Long parkId) {
        Integer code = p2CBaseResponse.getCode();
        Integer cmdType = P2cDownCmdEnum.getCmdType((String)p2CBaseResponse.getCmd().replace("_resp", ""));
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        if (code.equals(CodeEnum.\u6210\u529f.getCode())) {
            log.info("[\u6279\u91cf\u914d\u7f6e\u4e0b\u53d1\u54cd\u5e94]\u5b50\u4efb\u52a1ID\u5904\u7406\u6210\u529f[{}]", (Object)subTaskId);
            this.redisUtils.hPut(subTaskKey, "status", (Object)3);
            this.redisUtils.hPut(subTaskKey, "successNum", (Object)1);
            this.redisUtils.hPut(subTaskKey, "failNum", (Object)0);
            this.redisUtils.hDelete(subTaskKey, new String[]{"reason"});
        } else {
            this.redisUtils.hPut(subTaskKey, "status", (Object)3);
            this.redisUtils.hPut(subTaskKey, "failNum", (Object)1);
            this.redisUtils.hPut(subTaskKey, "successNum", (Object)0);
            this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownUtils.convertMsg(p2CBaseResponse.getMsg()));
        }
        this.finishSubTask(subTaskId, parkId, cmdType, subTaskKey);
    }

    private void finishSubTask(Integer subTaskId, Long parkId, Integer cmdType, String subTaskKey) {
        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setId(subTaskId);
        batchsendTaskSub.setStatus(Integer.valueOf(3));
        batchsendTaskSub.setSuccessNum(Integer.valueOf(1));
        batchsendTaskSub.setFailNum(Integer.valueOf(0));
        batchsendTaskSub.setTotalNum((Integer)this.redisUtils.hGet(subTaskKey, "totalNum", Integer.class));
        this.batchsendTaskSubDao.updateById(batchsendTaskSub);
        ArrayList<Long> idLongList = new ArrayList<Long>();
        idLongList.add(parkId);
        this.sendInfoService.updateSuccessByServiceIds(idLongList, cmdType, TextConstant.getSuccessDefaultMessage((String)"1"));
        log.info("[\u6279\u91cf\u914d\u7f6e\u4e0b\u53d1\u54cd\u5e94]\u66f4\u65b0\u4e0b\u53d1\u8868\u72b6\u6001\u6210\u529f,\u4e1a\u52a1\u7c7b\u578b[{}],id\u96c6\u5408[{}]", (Object)cmdType, idLongList);
        String taskId = (String)this.redisUtils.hGet(subTaskKey, "taskId", String.class);
        Integer currDataType = (Integer)this.redisUtils.hGet(subTaskKey, "serviceType", Integer.class);
        this.dealOtherSubTask(parkId, cmdType, taskId, currDataType);
    }

    private void dealOtherSubTask(Long parkId, Integer cmdType, String taskId, Integer currDataType) {
        String taskIdKey = "batchdown:task:" + taskId;
        List subTaskList = this.redisUtils.lRange(taskIdKey, 0L, -1L, Integer.class);
        if (subTaskList != null && subTaskList.size() > 0) {
            boolean isAllDataTypeOK = true;
            boolean isAllOk = true;
            for (int i = 0; i < subTaskList.size(); ++i) {
                Integer subT = (Integer)subTaskList.get(i);
                Integer status = (Integer)this.redisUtils.hGet("batchdown:task:sub:" + subT, "status", Integer.class);
                Integer dataType = (Integer)this.redisUtils.hGet("batchdown:task:sub:" + subT, "serviceType", Integer.class);
                if (status == 3) continue;
                isAllOk = false;
                if (!currDataType.equals(dataType)) break;
                isAllDataTypeOK = false;
                break;
            }
            if (isAllOk) {
                BatchsendTask batchsendTask = new BatchsendTask();
                batchsendTask.setTaskId(taskId);
                batchsendTask = this.batchsendTaskDao.selectOneByEntity(batchsendTask);
                batchsendTask.setStatus(Integer.valueOf(3));
                this.batchsendTaskDao.updateById(batchsendTask);
            }
            if (isAllDataTypeOK) {
                this.redisUtils.remove("batchdown:open:" + parkId + ":" + cmdType);
                log.info("[\u6279\u91cf\u914d\u7f6e\u4e0b\u53d1\u54cd\u5e94]\u6240\u6709\u4e0b\u53d1\u914d\u7f6e\u90fd\u5df2\u7ed3\u675f[{}],dataType[{}]", (Object)taskId, (Object)currDataType);
            }
        }
    }
}

