/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import cn.hutool.core.util.StrUtil;
import com.icetech.cloudcenter.domain.constants.BatchDownMsgConstants;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.cloudcenter.domain.request.p2c.BizBatchDownRequest;
import com.icetech.cloudcenter.domain.vo.BatchSendRepeatVO;
import com.icetech.cloudcenter.domain.vo.BatchSendVO;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.park.dao.BatchsendTaskSubDao;
import com.icetech.park.domain.entity.BatchsendTaskSub;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.down.Message;
import com.icetech.park.service.down.upload.IDataUploadService;
import com.icetech.park.service.handle.BatchDownUtils;
import com.icetech.park.service.handle.P2cDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BatchDownBizHandle<T> {
    private static final Logger log = LoggerFactory.getLogger(BatchDownBizHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private BatchsendTaskSubDao batchsendTaskSubDao;
    @Autowired
    @Qualifier(value="uploadMonthCards")
    private IDataUploadService<T> uploadMonthCards;
    @Autowired
    @Qualifier(value="uploadVips")
    private IDataUploadService<T> uploadVips;
    @Autowired
    @Qualifier(value="uploadBlacklist")
    private IDataUploadService<T> uploadBlacklist;
    @Autowired
    private P2cDownHandle p2CDownHandle;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    int DATA_LIST_EXPIRE = 3600;
    String[] oldVIPHeaders = new String[]{"id", "vipId", "vipTypeName", "plateNum", "phone", "startDate", "endDate", "discountType", "discountNumber", "billtypecode"};

    public void batchDown(BatchSendVO vo, List<T> dataList, List<Object> idList, String[] headers, int cmdType) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        String taskId = vo.getTaskId();
        List subTaskInfos = vo.getSubTaskInfos();
        int size = dataList.size();
        VersionFile versionFile = new VersionFile();
        int dataType = 0;
        if (P2cDownCmdEnum.\u6708\u5361.getCmdType().equals(cmdType)) {
            versionFile = new VersionFile(this.uploadMonthCards, parkCode, taskId, cmdType);
            dataType = 1;
        } else if (P2cDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType().equals(cmdType)) {
            versionFile = new VersionFile(this.uploadBlacklist, parkCode, taskId, cmdType);
            dataType = 2;
        } else if (P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType().equals(cmdType)) {
            versionFile = new VersionFile(this.uploadVips, parkCode, taskId, cmdType);
            dataType = 3;
        }
        log.info("[\u6570\u636e\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1] \u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210, \u53c2\u6570[{}]", (Object)vo);
        BizBatchDownRequest bizBatchDownRequest = new BizBatchDownRequest();
        bizBatchDownRequest.setDataType(Integer.valueOf(dataType));
        bizBatchDownRequest.setIsClear(Integer.valueOf(1));
        bizBatchDownRequest.setTotalNum(Integer.valueOf(size));
        for (int i = 0; i < subTaskInfos.size(); ++i) {
            String version;
            BatchSendVO.SubTaskInfo subTaskInfo = (BatchSendVO.SubTaskInfo)subTaskInfos.get(i);
            Integer subTaskId = subTaskInfo.getSubTaskId();
            bizBatchDownRequest.setSubTaskId(String.valueOf(subTaskId));
            this.redisUtils.lRightPushAll("batchdown:task:data:" + subTaskId + ":" + cmdType, idList);
            this.redisUtils.expire("batchdown:task:data:" + subTaskId + ":" + cmdType, (long)this.DATA_LIST_EXPIRE);
            String subTaskKey = "batchdown:task:sub:" + subTaskId;
            this.redisUtils.hPut(subTaskKey, "totalNum", (Object)size);
            String sn = subTaskInfo.getSn();
            if (StrUtil.isBlank((CharSequence)sn)) {
                this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.NO_CAMERA);
                this.finishErrorTask(size, subTaskId, BatchDownMsgConstants.NO_CAMERA);
                continue;
            }
            TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(sn);
            String string = version = tokenDeviceVo == null ? null : tokenDeviceVo.getVersion();
            if (version != null && P2cVersionEnum.getIndex((String)version) < P2cVersionEnum.\u7248\u672c6.getIndex()) {
                String error = "\u76f8\u673a\u7248\u672c\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u4e0b\u53d1";
                this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
                this.finishErrorTask(size, subTaskId, error);
                continue;
            }
            if (P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType().equals(cmdType) && P2cVersionEnum.getIndex((String)version) < P2cVersionEnum.\u7248\u672c9.getIndex()) {
                List<T> dl = dataList;
                dl.removeIf(vip -> !Integer.valueOf(1).equals(vip.getDiscountType()));
                size = dl.size();
                this.redisUtils.hPut(subTaskKey, "totalNum", (Object)size);
                if (size == 0) {
                    String error = "\u76f8\u673a\u7248\u672c\u8fc7\u4f4e\uff0c\u975e\u5168\u514dVIP\u65e0\u9700\u4e0b\u53d1";
                    this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                    this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                    this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
                    this.finishErrorTask(size, subTaskId, error);
                    continue;
                }
                bizBatchDownRequest.setBizDataPath(versionFile.getFilePathByVersion(dataList, cmdType + "_old", this.oldVIPHeaders));
            } else {
                bizBatchDownRequest.setBizDataPath(versionFile.getFilePathByVersion(dataList, String.valueOf(cmdType), headers));
            }
            Message<BizBatchDownRequest> message = new Message<BizBatchDownRequest>(parkId, P2cDownCmdEnum.\u6279\u91cf\u4e0b\u53d1.getCmdType(), bizBatchDownRequest);
            String messageId = this.p2CDownHandle.send(parkCode, sn, message);
            this.redisUtils.set("batchdown:open:" + parkId + ":" + cmdType, (Object)1, 600L);
            Integer finalSize = size;
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                if (messageId == null) {
                    this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                    this.redisUtils.hPut(subTaskKey, "failNum", (Object)finalSize);
                    this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.DEVICE_OFF_LINE);
                    this.finishErrorTask(finalSize, subTaskId, BatchDownMsgConstants.DEVICE_OFF_LINE);
                } else {
                    ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis(messageId, 4000L);
                    if (ObjectResponse.isSuccess(response)) {
                        this.redisUtils.hPut(subTaskKey, "status", (Object)2);
                    } else {
                        String msg = BatchDownUtils.convertMsgAndGetNewMsg(null, response == null ? BatchDownMsgConstants.DEVICE_TIMEOUT : response.getMsg());
                        this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                        this.redisUtils.hPut(subTaskKey, "failNum", (Object)finalSize);
                        this.redisUtils.hPut(subTaskKey, "reason", (Object)msg);
                        this.finishErrorTask(finalSize, subTaskId, msg);
                    }
                }
            }));
        }
    }

    public void repeatBatch(BatchSendRepeatVO vo, List<T> dataList, List<Object> idList, String[] headers, int cmdType) {
        String parkCode = vo.getParkCode();
        Long parkId = vo.getParkId();
        String taskId = vo.getTaskId();
        String sn = vo.getSn();
        int size = dataList.size();
        VersionFile versionFile = new VersionFile();
        int dataType = 0;
        if (P2cDownCmdEnum.\u6708\u5361.getCmdType().equals(cmdType)) {
            versionFile = new VersionFile(this.uploadMonthCards, parkCode, taskId, cmdType);
            dataType = 1;
        } else if (P2cDownCmdEnum.\u9ed1\u540d\u5355\u4e0b\u53d1.getCmdType().equals(cmdType)) {
            versionFile = new VersionFile(this.uploadBlacklist, parkCode, taskId, cmdType);
            dataType = 2;
        } else if (P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType().equals(cmdType)) {
            versionFile = new VersionFile(this.uploadVips, parkCode, taskId, cmdType);
            dataType = 3;
        }
        log.info("[\u6570\u636e\u6279\u91cf\u4e0b\u53d1\u4e1a\u52a1-\u91cd\u53d1] \u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210, \u53c2\u6570[{}]", (Object)vo);
        BizBatchDownRequest bizBatchDownRequest = new BizBatchDownRequest();
        bizBatchDownRequest.setDataType(Integer.valueOf(dataType));
        bizBatchDownRequest.setIsClear(Integer.valueOf(dataList.size() == vo.getOldTotalNum().intValue() ? 1 : 0));
        bizBatchDownRequest.setTotalNum(Integer.valueOf(size));
        Integer subTaskId = vo.getSubTaskId();
        bizBatchDownRequest.setSubTaskId(String.valueOf(subTaskId));
        String dataListKey = "batchdown:task:data:" + subTaskId + ":" + cmdType;
        this.redisUtils.remove(dataListKey);
        this.redisUtils.lRightPushAll(dataListKey, idList);
        this.redisUtils.expire(dataListKey, (long)this.DATA_LIST_EXPIRE);
        String subTaskKey = "batchdown:task:sub:" + subTaskId;
        this.redisUtils.expire(subTaskKey, 3600L);
        this.redisUtils.hPut(subTaskKey, "startTime", (Object)DateTools.unixTimestamp());
        if (StrUtil.isBlank((CharSequence)sn)) {
            this.redisUtils.hPut(subTaskKey, "status", (Object)3);
            this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
            this.redisUtils.hPut(subTaskKey, "reason", (Object)BatchDownMsgConstants.NO_CAMERA);
            this.finishErrorTask(size, subTaskId, BatchDownMsgConstants.NO_CAMERA);
        } else {
            String version;
            TokenDeviceVo tokenDeviceVo = this.cacheHandle.getDeviceInfo(sn);
            String string = version = tokenDeviceVo == null ? null : tokenDeviceVo.getVersion();
            if (version != null && P2cVersionEnum.getIndex((String)version) < P2cVersionEnum.\u7248\u672c6.getIndex()) {
                String error = "\u76f8\u673a\u7248\u672c\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u4e0b\u53d1";
                this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
                this.finishErrorTask(size, subTaskId, error);
                return;
            }
            if (P2cDownCmdEnum.VIP\u8f66\u8f86.getCmdType().equals(cmdType) && P2cVersionEnum.getIndex((String)version) < P2cVersionEnum.\u7248\u672c9.getIndex()) {
                bizBatchDownRequest.setBizDataPath(versionFile.getRepeatFilePathByVersion(dataList, cmdType + "_old", this.oldVIPHeaders));
            } else {
                bizBatchDownRequest.setBizDataPath(versionFile.getRepeatFilePathByVersion(dataList, String.valueOf(cmdType), headers));
            }
            Message<BizBatchDownRequest> message = new Message<BizBatchDownRequest>(parkId, P2cDownCmdEnum.\u6279\u91cf\u4e0b\u53d1.getCmdType(), bizBatchDownRequest);
            String messageId = this.p2CDownHandle.send(parkCode, sn, message);
            this.redisUtils.set("batchdown:open:" + parkId + ":" + cmdType, (Object)1, 600L);
            this.asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                String reason = (String)this.redisUtils.hGet(subTaskKey, "reason", String.class);
                if (messageId == null) {
                    String error = BatchDownUtils.convertMsgAndGetNewMsg(reason, BatchDownMsgConstants.DEVICE_OFF_LINE);
                    this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                    this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                    this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
                    this.finishErrorTask(size, subTaskId, error);
                } else {
                    ObjectResponse<String> response = this.cacheHandle.getResponseFromRedis(messageId, 4000L);
                    if (ObjectResponse.isSuccess(response)) {
                        this.redisUtils.hPut(subTaskKey, "status", (Object)2);
                    } else {
                        String error = BatchDownUtils.convertMsgAndGetNewMsg(reason, response == null ? BatchDownMsgConstants.DEVICE_TIMEOUT : response.getMsg());
                        this.redisUtils.hPut(subTaskKey, "status", (Object)3);
                        this.redisUtils.hPut(subTaskKey, "failNum", (Object)size);
                        this.redisUtils.hPut(subTaskKey, "reason", (Object)error);
                        this.finishErrorTask(size, subTaskId, error);
                    }
                }
            }));
        }
    }

    private void finishErrorTask(int size, Integer subTaskId, String reason) {
        BatchsendTaskSub batchsendTaskSub = new BatchsendTaskSub();
        batchsendTaskSub.setId(subTaskId);
        batchsendTaskSub.setStatus(Integer.valueOf(3));
        batchsendTaskSub.setTotalNum(Integer.valueOf(size));
        batchsendTaskSub.setFailNum(Integer.valueOf(size));
        batchsendTaskSub.setReason(reason);
        this.batchsendTaskSubDao.updateById(batchsendTaskSub);
    }

    class VersionFile {
        public Map<String, Object> para = new ConcurrentHashMap<String, Object>();
        public Map<String, Object> repeatPara = new ConcurrentHashMap<String, Object>();
        private IDataUploadService dataUploadService;
        private String parkCode;
        private int cmdType;
        private String taskId;
        private int index = 0;

        public VersionFile() {
        }

        public VersionFile(IDataUploadService dataUploadService, String parkCode, String taskId, int cmdType) {
            this.dataUploadService = dataUploadService;
            this.parkCode = parkCode;
            this.cmdType = cmdType;
            this.taskId = taskId;
        }

        public String getFilePathByVersion(List<T> dataList, String typeFlag, String[] header) {
            if (this.para.get(typeFlag) != null) {
                return (String)this.para.get(typeFlag);
            }
            String date = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
            String[] ymd = date.split("-");
            String filePath = new StringBuffer(this.parkCode).append("/biz_data/").append(ymd[0] + ymd[1]).append("/" + this.taskId + "_" + this.cmdType + "_" + dataList.size() + "_" + this.index++ + RandomUtils.nextInt((int)10000, (int)99999) + ".csv").toString();
            this.dataUploadService.upload(dataList, header, filePath);
            this.para.put(typeFlag, filePath);
            return filePath;
        }

        public String getRepeatFilePathByVersion(List<T> dataList, String typeFlag, String[] header) {
            if (this.repeatPara.get(typeFlag) != null) {
                return (String)this.repeatPara.get(typeFlag);
            }
            String date = DateTools.getFormat((String)"yyyy-MM-dd", (Date)new Date());
            String[] ymd = date.split("-");
            String filePath = new StringBuffer(this.parkCode).append("/biz_data/").append(ymd[0] + ymd[1]).append("/" + this.taskId + "_" + this.cmdType + "_" + dataList.size() + "_repeat.csv").toString();
            this.dataUploadService.upload(dataList, header, filePath);
            this.repeatPara.put(typeFlag, filePath);
            return filePath;
        }
    }
}

