/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.handle;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.enumeration.SendOperTypeEnum;
import com.icetech.cloudcenter.domain.response.p2c.P2cBaseResponse;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.constants.TimeOutConstants;
import com.icetech.common.domain.P2cBaseMsg;
import com.icetech.common.domain.request.P2cBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.oss.OssService;
import com.icetech.park.service.down.Message;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class BaseDownHandle {
    private static final Logger log = LoggerFactory.getLogger(BaseDownHandle.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OssService ossService;
    @Autowired
    private RedisTemplate redisTemplate;

    protected List<String> getSyncCmdList() {
        return new ArrayList<String>();
    }

    public String send(String serialNumber, Message message) {
        return null;
    }

    protected String getDeviceProfile() {
        return "common";
    }

    public void dealResponse(P2cBaseResponse<String> p2CBaseResponse, Long parkId, Integer serviceType) {
        String messageId = p2CBaseResponse.getMessageId();
        SendInfoRecord sendinfoRecord = (SendInfoRecord)this.redisUtils.get("MQ_RECORD_" + messageId, SendInfoRecord.class);
        if (sendinfoRecord == null) {
            sendinfoRecord = new SendInfoRecord();
            sendinfoRecord.setServiceType(serviceType);
            sendinfoRecord.setMessageId(messageId);
            sendinfoRecord.setParkId(parkId);
        }
        Integer code = p2CBaseResponse.getCode();
        String cmd = p2CBaseResponse.getCmd();
        String msg = p2CBaseResponse.getMsg();
        cmd = cmd.substring(0, cmd.indexOf("_resp"));
        String data = (String)p2CBaseResponse.getData();
        String key = "RESP_MSG_" + messageId;
        if (this.getSyncCmdList().contains(cmd)) {
            ObjectResponse retResponse = new ObjectResponse();
            retResponse.setCode(String.valueOf(code));
            retResponse.setMsg(msg);
            if (CodeEnum.\u6210\u529f.getCode().equals(code) && StringUtils.isNotEmpty((CharSequence)p2CBaseResponse.getResultPath())) {
                File oss2File = this.ossService.getOSS2File(p2CBaseResponse.getResultPath());
                data = FileUtil.readString((File)oss2File, (String)"utf-8");
            }
            retResponse.setData((Object)data);
            this.redisUtils.set(key, (Object)retResponse, TimeOutConstants.REDIS_TIMEOUT.longValue());
            int valueLen = retResponse.toString().length();
            log.info("[\u76d1\u63a7\u76f8\u673a\u54cd\u5e94\u5904\u7406] \u5199\u5165redis\u6210\u529f,key[{}],value[{}]", (Object)key, (Object)(valueLen > 1024 ? retResponse.toString().substring(0, 1024) + "..." : retResponse));
        }
    }

    protected void addRequestRecord(Message message, String messageId, Object t, String serialNumber) {
        SendInfoRecord sendinfoRecord = new SendInfoRecord();
        sendinfoRecord.setMessageId(messageId);
        sendinfoRecord.setParkId(message.getParkId());
        sendinfoRecord.setParams(t);
        sendinfoRecord.setServiceId(message.getServiceId());
        sendinfoRecord.setServiceType(message.getServiceType());
        sendinfoRecord.setTarget(serialNumber);
        sendinfoRecord.setOperType(SendOperTypeEnum.\u8bf7\u6c42.getOperType());
        sendinfoRecord.setTaskId(message.getTaskId());
        sendinfoRecord.setRecordId(message.getRecordId());
        this.redisUtils.set("MQ_RECORD_" + messageId, (Object)sendinfoRecord, TimeOutConstants.REDIS_TIMEOUT.longValue());
    }

    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest) {
        return this.pushAll(sn, p2cBaseRequest, this.getDeviceProfile());
    }

    public boolean pushAll(String sn, P2cBaseRequest<?> p2cBaseRequest, String module) {
        try {
            P2cBaseMsg p2cBaseMsg = new P2cBaseMsg();
            BeanUtils.copyProperties(p2cBaseRequest, (Object)p2cBaseMsg);
            p2cBaseMsg.setSn(sn);
            p2cBaseMsg.setModule(StringUtils.isEmpty((CharSequence)module) ? this.getDeviceProfile() : module);
            String message = JSON.toJSONString((Object)p2cBaseMsg);
            log.info("[redis\u5e7f\u64ad\u53d1\u9001] {}", (Object)message);
            this.redisTemplate.convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, (Object)message);
            return true;
        }
        catch (Exception e) {
            log.error("[redis\u5e7f\u64ad\u53d1\u9001] clientName[{}]\u5e7f\u64ad\u5931\u8d25", (Object)sn, (Object)e);
            return false;
        }
    }
}

