/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.flow.p2c.impl;

import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.constants.DingZhiFuncConstants;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.ThirdFeeRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.p2c.CarEnterResult;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.impl.QueryThirdFeeServiceImpl;
import com.icetech.park.service.order.impl.enter.CarOrderEnterServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.partner.api.ThirdAutoPayService;
import com.icetech.third.domain.entity.third.ThirdInfo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class CarExitFlowProcessImpl
extends FlowCondition {
    private static final Logger log = LoggerFactory.getLogger(CarExitFlowProcessImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private CarOrderEnterServiceImpl carOrderEnterService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    protected ThirdAutoPayService thirdAutoPayService;
    @Autowired
    private ThirdInfoService thirdInfoService;
    @Autowired
    private QueryThirdFeeServiceImpl queryThirdFeeService;
    @Autowired
    private OrderTagsService orderTagsService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Value(value="${exit.secondRec.freeTime:300}")
    private Integer exitSecondRecFreeTime;

    public FlowCondition.FlowRet flowHandle(OrderInfo orderInfo, CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        String plateNum = exitRequest.getPlateNum();
        FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        if (this.filter(exitRequest.getParkCode(), exitRequest.getParkId(), exitRequest.getPlateNum(), parkConfig, exitRequest.getInandoutCode(), 2, exitRequest.getOriginalExitTime())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u79bb\u573a\u9650\u5236);
        } else if (this.hasPlate(plateNum)) {
            flowRet = this.hasPlateResultCode(orderInfo, exitRequest, paramHolder);
        } else if (Integer.valueOf(0).equals(parkInoutdevice.getIsAllowTempcarrun())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa);
        } else {
            FlowCondition.ResultCode code = this.getNoPlateResultCode(paramHolder);
            flowRet.setResultCode(code);
        }
        log.info("[\u79bb\u573a\u6d41\u7a0b\u5904\u7406] \u8f66\u724c\u53f7[{}], \u5224\u65ad\u7ed3\u679c\u4e3a[{}]", (Object)plateNum, (Object)flowRet.getResultCode().name());
        return flowRet;
    }

    private FlowCondition.FlowRet hasPlateResultCode(OrderInfo orderInfo, CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        if (orderInfo != null) {
            return this.hasEnter(orderInfo, exitRequest, paramHolder);
        }
        return this.noEnter(exitRequest, paramHolder);
    }

    private FlowCondition.FlowRet hasEnter(OrderInfo orderInfo, CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        Long exitTime = exitRequest.getExitTime();
        FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String parkCode = paramHolder.getParkCode();
        Integer type = orderInfo.getType();
        String channelId = exitRequest.getInandoutCode();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        Park park = paramHolder.getParkInfo();
        exitRequest.setType(type);
        if (this.isBlacklist(paramHolder) && parkInoutdevice.getIsAllowBackCar() == 0) {
            this.queryFeeHandle(orderInfo, exitTime, flowRet, paramMap, parkCode, channelId, parkConfig);
            if (this.isShowBlackCar(paramHolder)) {
                paramMap.put("isShow", 1);
            } else {
                paramMap.put("isShow", 0);
            }
            flowRet.setPara(paramMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66);
            return flowRet;
        }
        if (this.isWhitelist(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u5185\u90e8\u8f66\u8f86);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if ((NumberUtils.toPrimitive((Integer)park.getIsInterior()) == 0 || NumberUtils.toPrimitive((Integer)parkInoutdevice.getIsMaster()) == 0) && type == 2 && NumberUtils.toPrimitive((Long)orderInfo.getSwitchTime()) == 0L && this.isAllDayMonthCard(paramHolder, orderInfo, exitRequest.getExitTime())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u6708\u5361\u8f66);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if ((NumberUtils.toPrimitive((Integer)park.getIsInterior()) == 0 || NumberUtils.toPrimitive((Integer)parkInoutdevice.getIsMaster()) == 0) && type == 1 && this.inParkCreateInvalidCard(paramHolder, orderInfo, exitTime)) {
            exitRequest.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
            orderInfo.setType(PlateTypeEnum.\u6708\u5361\u8f66.getType());
            flowRet.setResultCode(FlowCondition.ResultCode.\u6708\u5361\u8f66);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.isSpecial(type) && this.isSpecialFree(parkConfig)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u7279\u6b8a\u8f66\u8f86\u514d\u8d39);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.isFreeOfficialCars(parkConfig, exitRequest.getPlateNum())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u7279\u6b8a\u8f66\u8f86\u514d\u8d39);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.isInnerCar(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u5185\u90e8\u8f66\u8f86);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (PlateTypeEnum.\u4e34\u65f6\u8f66.getType().equals(type) && Integer.valueOf(0).equals(parkInoutdevice.getIsAllowTempcarrun())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (NumberUtils.toPrimitive((Integer)park.getIsInterior()) == 1 && NumberUtils.toPrimitive((Integer)parkInoutdevice.getIsFee()) == 0) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        this.queryFeeHandle(orderInfo, exitTime, flowRet, paramMap, parkCode, channelId, parkConfig);
        return flowRet;
    }

    public void queryFeeHandle(OrderInfo orderInfo, Long exitTime, FlowCondition.FlowRet flowRet, Map<String, Object> paramMap, String parkCode, String channelId, ParkConfig parkConfig) {
        this.getThirdReduces(orderInfo, parkCode);
        orderInfo.setExitTime(exitTime);
        ObjectResponse queryOrderFeeResponseObjectResponse = this.orderService.p2cQueryFee(orderInfo, parkConfig, channelId);
        if (!ObjectResponse.isSuccess((Response)queryOrderFeeResponseObjectResponse)) {
            throw new ResponseBodyException(queryOrderFeeResponseObjectResponse.getCode(), queryOrderFeeResponseObjectResponse.getMsg());
        }
        QueryOrderFeeResponse orderFee = (QueryOrderFeeResponse)queryOrderFeeResponseObjectResponse.getData();
        paramMap.put("orderFee", orderFee);
        String unPayPrice = orderFee.getUnpayPrice();
        if (Float.parseFloat(unPayPrice) == 0.0f) {
            String totalAmount = orderFee.getTotalAmount();
            if (Float.parseFloat(totalAmount) == 0.0f) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u514d\u8d39\u65f6\u95f4\u5185);
                paramMap.put("isreleaseFreetm", parkConfig.getIsreleaseFreetm());
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
            }
        } else {
            flowRet.setResultCode(FlowCondition.ResultCode.\u9700\u7f34\u8d39);
        }
        flowRet.setPara(paramMap);
    }

    private FlowCondition.FlowRet noEnter(CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        String plateNum = exitRequest.getPlateNum();
        Long exitTime = exitRequest.getExitTime();
        FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Long parkId = paramHolder.getParkId();
        String parkCode = paramHolder.getParkCode();
        Integer type = exitRequest.getType();
        Integer carType = exitRequest.getCarType();
        String channelId = exitRequest.getInandoutCode();
        String channelName = exitRequest.getInandoutName();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        if (this.isBlacklist(paramHolder) && parkInoutdevice.getIsAllowBackCar() == 0) {
            this.fixedFeeHandle(exitRequest, paramHolder, plateNum, exitTime, flowRet, paramMap, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), parkConfig);
            if (this.isShowBlackCar(paramHolder)) {
                paramMap.put("isShow", 1);
            } else {
                paramMap.put("isShow", 0);
            }
            flowRet.setPara(paramMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66);
            return flowRet;
        }
        if (this.isWhitelist(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u5185\u90e8\u8f66\u8f86);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.isMonthCard(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u6708\u5361\u8f66);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.isSpecial(type) && this.isSpecialFree(parkConfig)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u7279\u6b8a\u8f66\u8f86\u514d\u8d39);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.isFreeOfficialCars(parkConfig, exitRequest.getPlateNum())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u7279\u6b8a\u8f66\u8f86\u514d\u8d39);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (PlateTypeEnum.\u4e34\u65f6\u8f66.getType().equals(type) && Integer.valueOf(0).equals(parkInoutdevice.getIsAllowTempcarrun())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        VipType vipCar = this.getVipCar(paramHolder);
        if (vipCar != null && Integer.valueOf(1).equals(vipCar.getType())) {
            log.info("\u65e0\u5165\u573a\u8bb0\u5f55, \u5168\u514dVIP\u8f66\u724c\u53f7[{}]", (Object)plateNum);
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u5165\u573aVIP\u5168\u514d\u8f66);
            paramMap.put("carDesc", vipCar.getName());
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (NumberUtils.toPrimitive((Integer)parkConfig.getVisitIscharge()) == 0 && this.isVisitList(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
            return flowRet;
        }
        ObjectResponse validExistedDisCountDay = this.merchantDiscountService.findValidExistedDisCountDay(plateNum, parkId);
        if (ObjectResponse.isSuccess((Response)validExistedDisCountDay)) {
            log.info("\u65e0\u5165\u573a\u8bb0\u5f55, \u6309\u5929\u4f18\u514d\u8f66\u724c\u53f7[{}]", (Object)plateNum);
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (this.secRec(parkId, exitTime, plateNum)) {
            log.info("\u7591\u4f3c\u51fa\u573a\u672a\u62ac\u6746\uff0c\u53c8\u4e00\u6b21\u8bc6\u522b\u4e86\u79bb\u573a\uff0c\u8f66\u724c\u53f7\uff1a{}", (Object)plateNum);
            if (DingZhiFuncConstants.DZ006_PARKS.contains(parkCode)) {
                paramMap.put("isDo", 0);
            }
            flowRet.setResultCode(FlowCondition.ResultCode.\u9884\u7f34\u8d39\u672a\u8d85\u65f6);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        ThirdInfo payUrlThirdInfo = this.thirdInfoService.getThirdFeeUrl(parkConfig.getParkId());
        if (payUrlThirdInfo == null) {
            this.fixedFeeHandle(exitRequest, paramHolder, plateNum, exitTime, flowRet, paramMap, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), parkConfig);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        ThirdFeeRequest thirdFeeRequest = this.transformationThirdFeeRequest(plateNum, parkCode, channelId, carType, exitTime);
        ObjectResponse<QueryOrderFeeResponse> queryOrderFeeResponseObjectResponse = this.queryThirdFeeService.getThirdFeeFromUrl(payUrlThirdInfo, thirdFeeRequest);
        if ("3007".equals(queryOrderFeeResponseObjectResponse.getCode())) {
            this.fixedFeeHandle(exitRequest, paramHolder, plateNum, exitTime, flowRet, paramMap, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), parkConfig);
            flowRet.setPara(paramMap);
            return flowRet;
        }
        if (!ObjectResponse.isSuccess(queryOrderFeeResponseObjectResponse)) {
            throw new ResponseBodyException(queryOrderFeeResponseObjectResponse.getCode(), queryOrderFeeResponseObjectResponse.getMsg());
        }
        QueryOrderFeeResponse orderFee = (QueryOrderFeeResponse)queryOrderFeeResponseObjectResponse.getData();
        String unPayPrice = orderFee.getUnpayPrice();
        this.replenishOrder(plateNum, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), DateTools.unixTimestamp(), orderFee.getOrderNum(), paramHolder);
        paramMap.put("orderFee", orderFee);
        if (Float.parseFloat(unPayPrice) == 0.0f) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
        } else {
            flowRet.setResultCode(FlowCondition.ResultCode.\u56fa\u5b9a\u8d39\u7528);
        }
        flowRet.setPara(paramMap);
        exitRequest.setOrderNum(orderFee.getOrderNum());
        paramHolder.setOrderNum(orderFee.getOrderNum());
        return flowRet;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixedFeeHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, String plateNum, Long exitTime, FlowCondition.FlowRet flowRet, Map<String, Object> paramMap, Long parkId, String parkCode, Integer carType, String channelId, String channelName, ParkConfig parkConfig) {
        float fixedFee = -1.0f;
        int handleType = NumberUtils.toPrimitive((Integer)parkConfig.getNoenterHandleType());
        if (handleType == 2) {
            int days = NumberUtils.toPrimitive((Integer)parkConfig.getRelLastenterRange());
            if (days > 0) {
                OrderInfo lastEnterOrder = this.getLastEnterOrder(parkId, plateNum, exitTime - (long)days * 3600L * 24L);
                if (lastEnterOrder == null || NumberUtils.parseDouble((Object)lastEnterOrder.getTotalPrice()) > 0.0 || Integer.valueOf(1).equals(lastEnterOrder.getNoneEnterFlag())) {
                    fixedFee = this.fixedFee(parkConfig, carType);
                } else {
                    String orderNum = CodeTools.GenerateOrderNum();
                    ObjectResponse infoObjectResponse = this.orderCarInfoService.getCarInfo(orderNum, parkId);
                    this.replenishOrder(plateNum, parkId, parkCode, carType, channelId, exitRequest.getPlateColor(), lastEnterOrder.getEnterTime(), orderNum, paramHolder, false, (OrderCarInfo)infoObjectResponse.getData());
                    OrderTags orderTags = OrderTags.builder().orderNum(orderNum).parkId(parkId).tagId(Integer.valueOf(2)).exitTime(lastEnterOrder.getExitTime()).remark(lastEnterOrder.getOrderNum()).build();
                    this.orderTagsService.addOrderTags(orderTags);
                    this.queryFeeHandle(paramHolder.getReplenishOrder(), exitTime, flowRet, paramMap, parkCode, channelId, parkConfig);
                    exitRequest.setOrderNum(orderNum);
                    if (paramHolder.getReplenishOrder() != null) {
                        exitRequest.setType(paramHolder.getReplenishOrder().getType());
                    }
                    paramHolder.setOrderNum(orderNum);
                    return;
                }
            }
        } else if (handleType == 3) {
            fixedFee = (carType == 1 ? parkConfig.getFixedfeevalue() : parkConfig.getFixedFeeValueBig()).intValue();
        } else if (handleType != 1) {
            log.warn("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e, \u8d70\u65e7\u7684\u914d\u7f6e[{}]", (Object)plateNum);
            fixedFee = this.fixedFee(parkConfig, carType);
        }
        if (fixedFee == -1.0f) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u5165\u573a\u8bb0\u5f55);
            return;
        }
        QueryOrderFeeResponse queryOrderFeeResponse = this.fixedFeeHandle(plateNum, paramHolder.getParkInfo(), parkCode, channelId, exitRequest.getPlateColor(), parkConfig, fixedFee, carType, exitRequest.getExitTime(), paramHolder);
        paramMap.put("orderFee", queryOrderFeeResponse);
        exitRequest.setOrderNum(queryOrderFeeResponse.getOrderNum());
        paramHolder.setOrderNum(queryOrderFeeResponse.getOrderNum());
        if (fixedFee == 0.0f) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u65e0\u9700\u7f34\u8d39);
            return;
        }
        flowRet.setResultCode(FlowCondition.ResultCode.\u56fa\u5b9a\u8d39\u7528);
    }

    private String replenishOrder(String plateNum, Long parkId, String parkCode, Integer carType, String channelId, String plateColor, Long enterTime, String orderNum, ReportParamHolder reportParamHolder) {
        return this.replenishOrder(plateNum, parkId, parkCode, carType, channelId, plateColor, enterTime, orderNum, reportParamHolder, true, null);
    }

    private String replenishOrder(String plateNum, Long parkId, String parkCode, Integer carType, String channelId, String plateColor, Long enterTime, String orderNum, ReportParamHolder reportParamHolder, boolean noneEnter, OrderCarInfo orderCarInfo) {
        ObjectResponse<CarEnterResult> objectResponse;
        CarEnterRequest carEnterRequest = new CarEnterRequest();
        carEnterRequest.setPlateNum(plateNum);
        carEnterRequest.setType(Integer.valueOf(1));
        carEnterRequest.setEnterTime(enterTime);
        carEnterRequest.setCarType(carType);
        carEnterRequest.setInandoutCode(channelId);
        carEnterRequest.setPlateColor(plateColor);
        carEnterRequest.setOpenFlag(Integer.valueOf(1));
        carEnterRequest.setTriggerType(Integer.valueOf(2));
        carEnterRequest.setProperty(Integer.valueOf(2));
        carEnterRequest.setParkId(parkId);
        carEnterRequest.setParkCode(parkCode);
        carEnterRequest.setEnterWay(Integer.valueOf(1));
        carEnterRequest.setNoneEnterFlag(noneEnter);
        carEnterRequest.setOrderNum(orderNum);
        carEnterRequest.setReplenishOrder(true);
        if (orderCarInfo != null) {
            carEnterRequest.setMaxImage(carEnterRequest.getMaxImage());
            carEnterRequest.setSmallImage(carEnterRequest.getSmallImage());
            carEnterRequest.setEnterWay(orderCarInfo.getEnterWay());
            carEnterRequest.setCarBrand(orderCarInfo.getCarBrand());
            carEnterRequest.setCarColor(orderCarInfo.getCarColor());
            carEnterRequest.setPlateColor(orderCarInfo.getPlateColor());
        }
        if (ObjectResponse.isSuccess(objectResponse = this.carOrderEnterService.enter(carEnterRequest, reportParamHolder))) {
            return ((CarEnterResult)objectResponse.getData()).getOrderNum();
        }
        return null;
    }

    private ThirdFeeRequest transformationThirdFeeRequest(String plateNum, String parkCode, String channelId, Integer carType, Long exitTime) {
        ThirdFeeRequest thirdFeeRequest = new ThirdFeeRequest();
        thirdFeeRequest.setOrderNum(CodeTools.GenerateOrderNum());
        thirdFeeRequest.setCarType(carType);
        thirdFeeRequest.setChannelCode(channelId);
        thirdFeeRequest.setParkCode(parkCode);
        thirdFeeRequest.setExitTime(exitTime);
        thirdFeeRequest.setPlateNum(plateNum);
        return thirdFeeRequest;
    }

    public QueryOrderFeeResponse fixedFeeHandle(String plateNum, Park park, String parkCode, String channelId, String plateColor, ParkConfig parkConfig, float fixedFee, Integer carType, Long enterTime, ReportParamHolder paramHolder) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        String orderNum = this.replenishOrder(plateNum, park.getId(), parkCode, carType, channelId, plateColor, enterTime, null, paramHolder);
        queryOrderFeeResponse.setOrderNum(orderNum);
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setPlateNum(plateNum);
        queryOrderFeeResponse.setEnterTime(enterTime);
        queryOrderFeeResponse.setCarType(carType);
        queryOrderFeeResponse.setQueryTime(Long.valueOf(DateTools.unixTimestamp()));
        queryOrderFeeResponse.setParkTime(Long.valueOf(0L));
        queryOrderFeeResponse.setTotalAmount(String.valueOf(fixedFee));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(fixedFee));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(Integer.valueOf(2));
        queryOrderFeeResponse.setFreeTime(Long.valueOf(parkConfig.getIsfreeAfterpay(Integer.valueOf(15)).intValue()));
        return queryOrderFeeResponse;
    }

    private boolean secRec(Long parkId, Long exitTime, String plateNum) {
        OrderInfo orderInfoPara = new OrderInfo();
        orderInfoPara.setParkId(parkId);
        orderInfoPara.setPlateNum(plateNum);
        orderInfoPara.setServiceStatus(Integer.valueOf(2));
        ObjectResponse objectResponse = this.orderService.findByOrderInfo(orderInfoPara);
        return ObjectResponse.isSuccess((Response)objectResponse) && ((OrderInfo)objectResponse.getData()).getExitTime() != null && exitTime - ((OrderInfo)objectResponse.getData()).getExitTime() <= (long)this.exitSecondRecFreeTime.intValue();
    }

    private ObjectResponse getThirdReduces(OrderInfo orderInfo, String parkCode) {
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeRequest.setParkCode(parkCode);
        queryOrderFeeRequest.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeRequest.setCarType(orderInfo.getCarType());
        try {
            return this.thirdAutoPayService.downReduces(queryOrderFeeRequest);
        }
        catch (Exception e) {
            log.error("e=", (Throwable)e);
            return ObjectResponse.failed();
        }
    }
}

