/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.flow.p2c.impl;

import com.google.common.collect.Maps;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.QueryNotPayResponse;
import com.icetech.cloudcenter.domain.response.VipDetailDto;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.park.domain.dto.TagsDto;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.flow.p2c.FlowCondition;
import com.icetech.park.service.report.ReportParamHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CarEnterFlowProcessImpl
extends FlowCondition {
    private static final Logger log = LoggerFactory.getLogger(CarEnterFlowProcessImpl.class);
    private static final Integer FIX_ONE = 1;
    private List<String> CHARGE_COLORS = Arrays.asList("\u7eff\u8272", "\u9ec4\u7eff\u8272");

    public FlowCondition.FlowRet flowHandle(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        String plateNum = enterRequest.getPlateNum();
        Long parkId = enterRequest.getParkId();
        FlowCondition.FlowRet flowRet = new FlowCondition.FlowRet();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        if (this.hasPlate(plateNum)) {
            if (this.filter(enterRequest.getParkCode(), parkId, plateNum, parkConfig, enterRequest.getInandoutCode(), 1, enterRequest.getEnterTime())) {
                FlowCondition.ResultCode code = FlowCondition.ResultCode.\u5165\u573a\u9650\u5236;
                flowRet.setResultCode(code);
            } else {
                this.hasPlateHandle(enterRequest, paramHolder, flowRet);
            }
        } else {
            this.checkParkingAvailability(paramHolder, "\u84dd\u8272", flowRet);
            if (flowRet.getResultCode() == FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a) {
                return flowRet;
            }
            FlowCondition.ResultCode code = this.getNoPlateResultCode(paramHolder);
            flowRet.setResultCode(code);
        }
        log.info("[\u5165\u573a\u6d41\u7a0b\u5904\u7406] \u8f66\u724c\u53f7[{}], \u5224\u65ad\u7ed3\u679c\u4e3a[{}]", (Object)plateNum, (Object)flowRet.getResultCode().name());
        return flowRet;
    }

    private void hasPlateHandle(CarEnterRequest enterRequest, ReportParamHolder paramHolder, FlowCondition.FlowRet flowRet) {
        VipDetailDto otherRegionVipDetailDto;
        MonthDetailDto monthDetail;
        String plateNum = enterRequest.getPlateNum();
        String plateColor = enterRequest.getPlateColor();
        ParkConfig parkConfig = paramHolder.getParkConfig();
        HashMap retMap = Maps.newHashMap();
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        boolean isMonthCardOccupy = false;
        boolean isBlackCar = false;
        QueryNotPayResponse queryNotPayResponse = paramHolder.queryNotPayFee();
        if (NumberUtils.parseDouble((Object)queryNotPayResponse.getTotalNotPayPrice()) > 0.0) {
            retMap.put("notPayFee", queryNotPayResponse);
            flowRet.setPara(retMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u6b20\u8d39\u8865\u7f34);
            return;
        }
        this.checkParkingAvailability(paramHolder, plateColor, flowRet);
        if (flowRet.getResultCode() == FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a) {
            return;
        }
        if (this.isBlacklist(paramHolder)) {
            isBlackCar = true;
            if (parkInoutdevice.getIsAllowBackCar() == 0) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u9ed1\u540d\u5355\u8f66);
                if (this.isShowBlackCar(paramHolder)) {
                    retMap.put("isShow", 1);
                } else {
                    retMap.put("isShow", 0);
                }
                flowRet.setPara(retMap);
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            }
        } else if (this.isWhitelist(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u5185\u90e8\u8f66\u8f86);
        } else if (this.isMonthCard(paramHolder)) {
            Integer isAllowMonthCar = parkInoutdevice.getIsAllowMonthCar();
            if (Objects.nonNull(isAllowMonthCar) && parkInoutdevice.getIsAllowMonthCar() == 1) {
                if (this.freeCarRepeatEntry(enterRequest, flowRet, plateNum, paramHolder.getParkConfig())) {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6708\u5361\u8f66);
                    Integer unExpiredDays = paramHolder.getMonthDetail().getUnexpiredDays();
                    Integer remainDaysMc = this.getRemainDaysMc(paramHolder);
                    if (remainDaysMc == 0 || unExpiredDays <= remainDaysMc) {
                        retMap.put("days", unExpiredDays);
                        flowRet.setPara(retMap);
                    }
                }
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            }
        } else if (this.isOtherRegionMonthCard(paramHolder)) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            monthDetail = paramHolder.getOtherRegionMonthDetail();
            if (monthDetail.getParkRegion() != null) {
                retMap.put("otherRegionNameMc", monthDetail.getParkRegion().getRegionName());
            }
            flowRet.setPara(retMap);
        } else if (this.isVipCar(paramHolder)) {
            Boolean flag = Boolean.FALSE;
            VipType vipCar = this.getVipCar(paramHolder);
            if (FIX_ONE.equals(parkInoutdevice.getIsAllowVipCar())) {
                String[] vipCarIds;
                String vipCarTypeId = parkInoutdevice.getVipCarTypeId();
                if (Objects.nonNull(vipCar) && StringUtils.isNotEmpty((CharSequence)vipCarTypeId) && Arrays.asList(vipCarIds = vipCarTypeId.split(",")).contains(String.valueOf(vipCar.getId()))) {
                    flag = Boolean.TRUE;
                }
            }
            if (flag.booleanValue()) {
                if (!DiscountTypeEnum.\u5168\u514d.getType().equals(vipCar.getType())) {
                    this.vipAllowEnter(flowRet, vipCar);
                } else if (this.freeCarRepeatEntry(enterRequest, flowRet, plateNum, paramHolder.getParkConfig())) {
                    this.vipAllowEnter(flowRet, vipCar);
                }
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            }
        } else if (this.isOtherRegionVipCar(paramHolder)) {
            otherRegionVipDetailDto = paramHolder.getOtherRegionVipDetailDto();
            VipType vipCar = otherRegionVipDetailDto.getVipType();
            List entranceChannelList = otherRegionVipDetailDto.getEntranceChannelList();
            if (CollectionUtils.isNotEmpty((Collection)entranceChannelList)) {
                boolean flag = Boolean.FALSE;
                for (ParkInoutdevice inoutdevice : entranceChannelList) {
                    String[] vipCarIds;
                    if (!FIX_ONE.equals(inoutdevice.getIsAllowVipCar())) continue;
                    String vipCarTypeId = inoutdevice.getVipCarTypeId();
                    if (!Objects.nonNull(vipCar) || !StringUtils.isNotEmpty((CharSequence)vipCarTypeId) || !Arrays.asList(vipCarIds = vipCarTypeId.split(",")).contains(String.valueOf(vipCar.getId()))) continue;
                    flag = Boolean.TRUE;
                    break;
                }
                if (flag) {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    retMap.put("carDesc", vipCar.getName());
                    retMap.put("otherRegionNameVip", otherRegionVipDetailDto.getParkRegion().getRegionName());
                    flowRet.setPara(retMap);
                } else {
                    log.info("[\u5165\u573a\u6d41\u7a0b\u5904\u7406] \u5176\u4ed6\u533a\u57dfVIP, [{}]\u4e0d\u5141\u8bb8[{}]\u7c7b\u578b\u8fdb\u573a", (Object)plateNum, (Object)vipCar.getName());
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                retMap.put("carDesc", vipCar.getName());
                retMap.put("otherRegionNameVip", otherRegionVipDetailDto.getParkRegion().getRegionName());
                flowRet.setPara(retMap);
            }
        } else if (this.isVisitList(paramHolder)) {
            if (FIX_ONE.equals(parkInoutdevice.getIsAllowVisitCar())) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u8bbf\u5ba2\u8f66);
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            }
        } else if (this.isInnerCar(paramHolder)) {
            if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar())) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u5185\u90e8\u8f66\u8f86);
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            }
        } else if (this.isStoreCardCar(paramHolder)) {
            if (parkInoutdevice.getIsAllowStoredCar() != null && parkInoutdevice.getIsAllowStoredCar() == 1) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165);
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165);
            }
        } else if (FIX_ONE.equals(parkInoutdevice.getIsAllowTempcarrun())) {
            if (this.bluecarrun(plateColor, parkInoutdevice) || this.yellowcarrun(plateColor, parkInoutdevice) || this.greencarrun(plateColor, parkInoutdevice)) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            } else if ("\u84dd\u8272".equals(plateColor) || "\u7eff\u8272".equals(plateColor) || "\u9ec4\u7eff\u8272".equals(plateColor)) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            } else if ("\u9ec4\u8272".equals(plateColor)) {
                flowRet.setResultCode(FlowCondition.ResultCode.\u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a);
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            }
            this.replaceCardCode(paramHolder, flowRet);
            monthDetail = paramHolder.getMonthDetail();
            if (monthDetail != null && (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66 || monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66)) {
                int diff;
                int n = diff = monthDetail.getMonthInfo() != null ? DateTools.differentDays((Date)monthDetail.getMonthInfo().getEndTime(), (Date)new Date()) : -1;
                if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar()) && FIX_ONE.equals(parkConfig.getIsAllowOvertimeCar()) && diff <= NumberUtils.toPrimitive((Integer)parkConfig.getOverTimeDay())) {
                    retMap.put("days", 0);
                    retMap.put("isMonth", false);
                    if (parkConfig.getExpireMcDays() != null && diff != -1 && diff <= parkConfig.getExpireMcDays() && FIX_ONE.equals(parkConfig.getIsExpireMc())) {
                        retMap.put("isMonth", true);
                    }
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(FlowCondition.ResultCode.\u8fc7\u671f\u5361);
                }
            } else if (paramHolder.getMonthDetail() != null && paramHolder.getMonthDetail().getMonthType() == MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528) {
                isMonthCardOccupy = true;
                enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
                MonthAbDto monthAbDto = paramHolder.getMonthDetail().getMonthAbDto();
                ArrayList<TagsDto> tagsDtos = new ArrayList<TagsDto>();
                TagsDto tagsDto = TagsDto.builder().tagId(Integer.valueOf(1)).regionId(parkInoutdevice.getRegionId()).remark(monthAbDto.getPlotCount() + "\u4f4d" + monthAbDto.getPlateNumCount() + "\u8f66\u7b2c" + monthAbDto.getIndex() + "\u8f66").build();
                tagsDtos.add(tagsDto);
                enterRequest.setTags(tagsDtos);
                if (parkInoutdevice.getIsAllowAbcar() == 1) {
                    if (parkInoutdevice.getIsAllowMonthCar() == 1) {
                        flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    }
                } else {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
            }
        } else {
            monthDetail = paramHolder.getMonthDetail();
            if (monthDetail != null && (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66 || monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66)) {
                MonthInfo data = monthDetail.getMonthInfo();
                int diff = DateTools.differentDays((Date)data.getEndTime(), (Date)new Date());
                if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar()) && FIX_ONE.equals(parkConfig.getIsAllowOvertimeCar()) && diff <= NumberUtils.toPrimitive((Integer)parkConfig.getOverTimeDay())) {
                    retMap.put("days", 0);
                    if (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66) {
                        retMap.put("isMonth", true);
                    } else {
                        retMap.put("isMonth", false);
                    }
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(FlowCondition.ResultCode.\u8fc7\u671f\u5361);
                } else {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
            } else if (paramHolder.getMonthDetail() != null && paramHolder.getMonthDetail().getMonthType() == MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528) {
                isMonthCardOccupy = true;
                enterRequest.setType(PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
                MonthAbDto monthAbDto = paramHolder.getMonthDetail().getMonthAbDto();
                ArrayList<TagsDto> tagsDtos = new ArrayList<TagsDto>();
                TagsDto tagsDto = TagsDto.builder().tagId(Integer.valueOf(1)).regionId(parkInoutdevice.getRegionId()).remark(monthAbDto.getPlotCount() + "\u4f4d" + monthAbDto.getPlateNumCount() + "\u8f66\u7b2c" + monthAbDto.getIndex() + "\u8f66").build();
                tagsDtos.add(tagsDto);
                enterRequest.setTags(tagsDtos);
                if (parkInoutdevice.getIsAllowAbcar() == 1) {
                    if (parkInoutdevice.getIsAllowMonthCar() == 1) {
                        flowRet.setPara(retMap);
                        flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    } else {
                        flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    }
                } else {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
            } else {
                flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                this.replaceCardCode(paramHolder, flowRet);
            }
            MonthDetailDto otherRegionMonthDetail = paramHolder.getOtherRegionMonthDetail();
            if (FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165.equals((Object)flowRet.getResultCode()) && otherRegionMonthDetail != null && (otherRegionMonthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66 || otherRegionMonthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u4e34\u65f6\u8f66)) {
                MonthInfo data = otherRegionMonthDetail.getMonthInfo();
                int diff = DateTools.differentDays((Date)data.getEndTime(), (Date)new Date());
                if (FIX_ONE.equals(parkInoutdevice.getIsAllowMonthCar()) && FIX_ONE.equals(parkConfig.getIsAllowOvertimeCar()) && diff <= NumberUtils.toPrimitive((Integer)parkConfig.getOverTimeDay())) {
                    retMap.put("days", 0);
                    if (otherRegionMonthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66) {
                        retMap.put("isMonth", true);
                    } else {
                        retMap.put("isMonth", false);
                    }
                    if (otherRegionMonthDetail.getParkRegion() != null) {
                        retMap.put("otherRegionNameMc", otherRegionMonthDetail.getParkRegion().getRegionName());
                    }
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(FlowCondition.ResultCode.\u8fc7\u671f\u5361);
                } else {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
            }
        }
        if (!flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165)) {
            ParkFreespace parkFreespace = paramHolder.getParkFreeSpace();
            ParkRegion parkRegion = paramHolder.getParkRegion();
            if (parkFreespace != null && parkRegion != null) {
                Integer freeSpace = parkFreespace.getFreeSpace();
                Integer fullEmptynum = parkRegion.getFullEmptynum();
                if (Objects.isNull(fullEmptynum) || Objects.isNull(freeSpace)) {
                    return;
                }
                if (fullEmptynum >= freeSpace) {
                    this.fullForbidEnter(paramHolder, flowRet, plateNum, parkRegion, retMap, isBlackCar, parkFreespace);
                }
            }
        }
        if ((flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165) || flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a)) && (retMap.get("otherRegionNameMc") != null || retMap.get("otherRegionNameVip") != null)) {
            otherRegionVipDetailDto = paramHolder.getOtherRegionVipDetailDto();
            MonthDetailDto otherRegionMonthDetail = paramHolder.getOtherRegionMonthDetail();
            ParkRegion otherParkRegion = otherRegionVipDetailDto == null ? null : otherRegionVipDetailDto.getParkRegion();
            ParkRegion otherParkRegion2 = otherRegionMonthDetail == null ? null : otherRegionMonthDetail.getParkRegion();
            ParkRegion parkRegion = otherParkRegion = otherParkRegion == null ? otherParkRegion2 : otherParkRegion;
            if (otherParkRegion != null) {
                Integer freeSpace = otherParkRegion.getRealFreePark();
                Integer fullEmptynum = otherParkRegion.getFullEmptynum();
                if (Objects.isNull(fullEmptynum) || Objects.isNull(freeSpace)) {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                    return;
                }
                if (fullEmptynum >= freeSpace) {
                    this.fullForbidEnterOtherRegion(paramHolder, flowRet, plateNum, otherParkRegion, retMap);
                } else {
                    flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
                }
            }
        }
        if (flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165) && isMonthCardOccupy) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u5360);
        }
    }

    private void fullForbidEnter(ReportParamHolder paramHolder, FlowCondition.FlowRet flowRet, String plateNum, ParkRegion parkRegion, Map<String, Object> retMap, boolean isBlackCar, ParkFreespace parkFreespace) {
        log.info("\u8f66\u724c\u53f7:{}, \u533a\u57df\u914d\u7f6e:{}", (Object)plateNum, (Object)parkRegion);
        Integer freeSpace = parkFreespace.getFreeSpace();
        Integer fullEmptynum = parkRegion.getFullEmptynum();
        if (FIX_ONE.equals(parkRegion.getIsFullForbidenter()) && flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165)) {
            log.info("\u4e34\u65f6\u8f66-\u8f66\u724c\u53f7 \u8f66\u724c\u53f7:{},\u7a7a\u8f66\u4f4d\u6570:{},\u5269\u4f59{}\u7a7a\u8f66\u4f4d\u65f6", new Object[]{plateNum, freeSpace, fullEmptynum});
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
            retMap.put("type", PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
            flowRet.setPara(retMap);
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidMonthEnter()) && flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u6708\u5361\u8f66)) {
            log.info("\u6708\u5361\u8f66-\u8f66\u724c\u53f7 \u8f66\u724c\u53f7:{},\u7a7a\u8f66\u4f4d\u6570:{},\u5269\u4f59{}\u7a7a\u8f66\u4f4d\u65f6", new Object[]{plateNum, freeSpace, fullEmptynum});
            retMap.put("type", PlateTypeEnum.\u6708\u5361\u8f66.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidReservEnter()) && flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u8bbf\u5ba2\u8f66)) {
            log.info("\u8bbf\u5ba2\u8f66-\u8f66\u724c\u53f7 \u8f66\u724c\u53f7:{},\u7a7a\u8f66\u4f4d\u6570:{},\u5269\u4f59{}\u7a7a\u8f66\u4f4d\u65f6", new Object[]{plateNum, freeSpace, fullEmptynum});
            retMap.put("type", PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidStoreEnter()) && flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.\u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165)) {
            log.info("\u50a8\u503c\u5361\u8f66-\u8f66\u724c\u53f7 \u8f66\u724c\u53f7:{},\u7a7a\u8f66\u4f4d\u6570:{},\u5269\u4f59{}\u7a7a\u8f66\u4f4d\u65f6", new Object[]{plateNum, freeSpace, fullEmptynum});
            retMap.put("type", PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
        }
        if (flowRet.getResultCode().equals((Object)FlowCondition.ResultCode.VIP\u8f66\u8f86)) {
            if (FIX_ONE.equals(parkRegion.getIsFullForbidVIPEnter())) {
                log.info("VIP\u8f66-\u8f66\u724c\u53f7:{},\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a", (Object)plateNum);
                retMap.put("type", PlateTypeEnum.VIP\u8f66\u8f86.getType());
                flowRet.setPara(retMap);
                flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
            } else {
                VipType vipCar = this.getVipCar(paramHolder);
                if (vipCar != null && parkRegion.getVipCarTypeId() != null && !parkRegion.getVipCarTypeId().contains(String.valueOf(vipCar.getId()))) {
                    retMap.put("type", PlateTypeEnum.VIP\u8f66\u8f86.getType());
                    flowRet.setPara(retMap);
                    flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
                }
            }
        }
        if (FIX_ONE.equals(parkRegion.getIsFullForbidblackenter()) && isBlackCar) {
            log.info("\u9ed1\u540d\u5355\u8f66-\u8f66\u724c\u53f7:{},\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a", (Object)plateNum);
            retMap.put("type", PlateTypeEnum.\u4e34\u65f6\u8f66.getType());
            flowRet.setPara(retMap);
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
        }
    }

    private void fullForbidEnterOtherRegion(ReportParamHolder paramHolder, FlowCondition.FlowRet flowRet, String plateNum, ParkRegion otherParkRegion, Map<String, Object> retMap) {
        VipType vipCar;
        VipDetailDto otherRegionVipDetailDto;
        log.info("\u8f66\u724c\u53f7:{}, \u533a\u57df\u914d\u7f6e:{}", (Object)plateNum, (Object)otherParkRegion);
        if (retMap.get("otherRegionNameMc") != null && Integer.valueOf(0).equals(otherParkRegion.getIsFullForbidMonthEnter())) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
        }
        if (retMap.get("otherRegionNameVip") != null && Integer.valueOf(0).equals(otherParkRegion.getIsFullForbidVIPEnter()) && (otherRegionVipDetailDto = paramHolder.getOtherRegionVipDetailDto()) != null && (vipCar = otherRegionVipDetailDto.getVipType()) != null && otherParkRegion.getVipCarTypeId() != null && Arrays.asList(otherParkRegion.getVipCarTypeId().split(",")).contains(String.valueOf(vipCar.getId()))) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
        }
    }

    private void vipAllowEnter(FlowCondition.FlowRet flowRet, VipType vipCar) {
        flowRet.setResultCode(FlowCondition.ResultCode.VIP\u8f66\u8f86);
        HashMap retMap = Maps.newHashMap();
        retMap.put("carDesc", vipCar.getName());
        flowRet.setPara(retMap);
    }

    private boolean freeCarRepeatEntry(CarEnterRequest enterRequest, FlowCondition.FlowRet flowRet, String plateNum, ParkConfig parkConfig) {
        ObjectResponse infoObjectResponse;
        if (Integer.valueOf(0).equals(parkConfig.getFreeCarReenter()) && ObjectResponse.isSuccess((Response)(infoObjectResponse = this.orderService.findInPark(plateNum, enterRequest.getParkCode())))) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165);
            return false;
        }
        return true;
    }

    public void checkParkingAvailability(ReportParamHolder paramHolder, String plateColor, FlowCondition.FlowRet flowRet) {
        ParkRegion parkRegion;
        Park park = paramHolder.getParkInfo();
        if (Objects.nonNull(park) && (park.getIsInterior() == null || park.getIsInterior() == 0) && (parkRegion = paramHolder.getParkRegion()) != null) {
            boolean chargeFlag = this.CHARGE_COLORS.contains(plateColor);
            if (parkRegion.getOilCarFullFlag() == 1 && parkRegion.getChargeCarFullFlag() == 1) {
                if (chargeFlag) {
                    this.checkChargeCarSpace(paramHolder, parkRegion, flowRet);
                } else {
                    this.checkOilCarSpace(paramHolder, parkRegion, flowRet);
                }
            }
            if (parkRegion.getOilCarFullFlag() == 1 && !chargeFlag) {
                this.checkOilCarSpace(paramHolder, parkRegion, flowRet);
            }
            if (parkRegion.getChargeCarFullFlag() == 1 && chargeFlag) {
                this.checkChargeCarSpace(paramHolder, parkRegion, flowRet);
            }
        }
    }

    private void checkOilCarSpace(ReportParamHolder paramHolder, ParkRegion parkRegion, FlowCondition.FlowRet flowRet) {
        Integer oilCarSpace = parkRegion.getOilCarSpace();
        Integer oilLiveCount = paramHolder.getOilLiveCount();
        if (oilCarSpace != null && oilLiveCount >= oilCarSpace) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
        }
    }

    private void checkChargeCarSpace(ReportParamHolder paramHolder, ParkRegion parkRegion, FlowCondition.FlowRet flowRet) {
        Integer chargeCarSpace = parkRegion.getChargeCarSpace();
        Integer chargeLiveCount = paramHolder.getChargeLiveCount();
        if (chargeCarSpace != null && chargeLiveCount >= chargeCarSpace) {
            flowRet.setResultCode(FlowCondition.ResultCode.\u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a);
        }
    }
}

