/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.flow.p2c;

import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.city.common.api.BlacklistApi;
import com.icetech.city.common.domain.entity.common.Blacklist;
import com.icetech.city.common.domain.entity.common.BlacklistPark;
import com.icetech.cloudcenter.api.lcd.LcdService;
import com.icetech.cloudcenter.api.lcd.LedService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.user.VehicleService;
import com.icetech.cloudcenter.domain.constants.DataCommonConstants;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.VipDetailDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.utils.RedisUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowCondition {
    private static final Logger log = LoggerFactory.getLogger(FlowCondition.class);
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected VehicleService vehicleService;
    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected LedService ledSoundService;
    @Autowired
    protected ParkVisitService parkVisitService;
    @Autowired
    protected LcdService lcdService;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private CacheHandle cacheHandle;
    public static final Integer YES = 1;
    public static final Integer NO = 0;
    @Autowired
    protected StoreCardService storeCardService;
    @Autowired
    private BlacklistApi cityBlacklistApi;

    public boolean hasPlate(String plateNum) {
        return !DataCommonConstants.isNoPlate((String)plateNum);
    }

    public Integer getTypeByPlateNum(ReportParamHolder paramHolder, Integer type) {
        if (this.isMonthCard(paramHolder)) {
            return PlateTypeEnum.\u6708\u5361\u8f66.getType();
        }
        if (this.isVipCar(paramHolder)) {
            return PlateTypeEnum.VIP\u8f66\u8f86.getType();
        }
        if (this.isInnerCar(paramHolder)) {
            return PlateTypeEnum.VIP\u8f66\u8f86.getType();
        }
        if (this.isVisitList(paramHolder)) {
            return PlateTypeEnum.\u8bbf\u5ba2\u8f66\u8f86.getType();
        }
        if (this.isStoreCardCar(paramHolder)) {
            return PlateTypeEnum.\u50a8\u503c\u5361\u8f66.getType();
        }
        if (NumberUtils.toPrimitive((Integer)type) == 3) {
            return PlateTypeEnum.\u7279\u6b8a\u8f66\u8f86.getType();
        }
        return PlateTypeEnum.\u4e34\u65f6\u8f66.getType();
    }

    public boolean isMonthCard(ReportParamHolder paramHolder) {
        MonthDetailDto monthDetail = paramHolder.getMonthDetail();
        return monthDetail != null && monthDetail.getMonthType() == MonthDetailDto.MonthType.\u6708\u5361\u8f66;
    }

    public boolean isOtherRegionMonthCard(ReportParamHolder paramHolder) {
        MonthDetailDto monthDetail = paramHolder.getOtherRegionMonthDetail();
        return monthDetail != null && (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u6708\u5361\u8f66 || monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66);
    }

    public boolean isOtherRegionVip(ReportParamHolder paramHolder) {
        MonthDetailDto monthDetail = paramHolder.getOtherRegionMonthDetail();
        return monthDetail != null && (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u6708\u5361\u8f66 || monthDetail.getMonthType() == MonthDetailDto.MonthType.\u8fc7\u671f\u6708\u5361\u8f66);
    }

    public boolean isAllDayMonthCard(ReportParamHolder paramHolder, OrderInfo orderInfo, Long exitTime) {
        MonthDetailDto monthDetail = this.getMonthCarDetail(paramHolder);
        if (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u6708\u5361\u8f66 && orderInfo != null) {
            Long enterTime = orderInfo.getEnterTime();
            MonthInfo monthInfo = monthDetail.getMonthInfo();
            if (monthInfo != null && monthInfo.getStartTime().getTime() / 1000L <= enterTime && this.completeConvert(monthInfo.getEndTime()) >= exitTime) {
                return monthDetail.getMonthProduct().getCardType() == 1 && NumberUtils.toPrimitive((Integer)monthDetail.getMonthProduct().getDiffWorkday()) == 0;
            }
        }
        return false;
    }

    public boolean inParkCreateInvalidCard(ReportParamHolder paramHolder, OrderInfo orderInfo, Long exitTime) {
        MonthDetailDto monthDetail = this.getMonthCarDetail(paramHolder);
        if (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u6708\u5361\u8f66 && monthDetail.getMonthProduct().getCardType() == 1 && NumberUtils.toPrimitive((Integer)monthDetail.getMonthProduct().getDiffWorkday()) == 0) {
            MonthInfo monthInfo = monthDetail.getMonthInfo();
            Calendar instance = Calendar.getInstance();
            instance.setTime(monthInfo.getEndTime());
            instance.set(11, 23);
            instance.set(12, 59);
            instance.set(13, 59);
            return monthInfo.getStartTime().getTime() / 1000L < orderInfo.getEnterTime() && instance.getTime().getTime() / 1000L >= exitTime;
        }
        return false;
    }

    public MonthInfo getMonthCard(ReportParamHolder paramHolder) {
        MonthDetailDto monthDetail = this.getMonthCarDetail(paramHolder);
        if (monthDetail.getMonthType() == MonthDetailDto.MonthType.\u6708\u5361\u8f66) {
            return monthDetail.getMonthInfo();
        }
        return null;
    }

    public MonthInfo getMonthCardAndExpire(ReportParamHolder paramHolder) {
        return this.getMonthCarDetail(paramHolder).getMonthInfo();
    }

    public boolean isMonthCardByOccupy(ReportParamHolder paramHolder) {
        return this.getMonthCarDetail(paramHolder).getMonthType() == MonthDetailDto.MonthType.\u591a\u4f4d\u591a\u8f66\u5360\u7528;
    }

    public MonthDetailDto getMonthCarDetail(ReportParamHolder paramHolder) {
        return paramHolder.getMonthDetail();
    }

    public boolean isBlacklist(ReportParamHolder paramHolder) {
        ObjectResponse<com.icetech.basics.domain.entity.Blacklist> validBlack = paramHolder.getBlacklistResp();
        if (validBlack != null && validBlack.getCode().equals("200")) {
            return true;
        }
        Integer type = this.cityBlacklistApi.getPlateType(paramHolder.getPlateNum(), BlacklistPark.PARK_TYPE_PARK, paramHolder.getParkId());
        return Blacklist.PLATE_TYPE_BLACK.equals(type);
    }

    public boolean isWhitelist(ReportParamHolder paramHolder) {
        Integer type = this.cityBlacklistApi.getPlateType(paramHolder.getPlateNum(), BlacklistPark.PARK_TYPE_PARK, paramHolder.getParkId());
        return Blacklist.PLATE_TYPE_WHITE.equals(type);
    }

    public boolean isVisitList(ReportParamHolder paramHolder) {
        ObjectResponse<ParkVisit> objectResponse = paramHolder.getParkVisitResp();
        if (!ObjectResponse.isSuccess(objectResponse)) {
            return false;
        }
        ParkVisit visit = (ParkVisit)objectResponse.getData();
        Integer inoutNum = visit.getInoutNum();
        Integer inoutMore = visit.getInoutMore();
        if (ParkVisitMoreType.ONE.getType().equals(inoutMore) && Objects.nonNull(inoutNum) && inoutNum > 0) {
            return true;
        }
        if (ParkVisitMoreType.MANY.getType().equals(inoutMore)) {
            return true;
        }
        return ParkVisitMoreType.CUSTOM.getType().equals(inoutMore) && inoutNum > 0;
    }

    public boolean allowTempEnter(ParkInoutdevice data) {
        return data.getIsAllowTempcarrun() != null && data.getIsAllowTempcarrun() == 1;
    }

    public boolean allowNoplateScan(ParkInoutdevice data) {
        return data.getIsOpenQrcodetype() == 1;
    }

    public boolean allowNoplate(ParkInoutdevice data) {
        return NumberUtils.toPrimitive((Integer)data.getIsAllowTempcarrun()) == 1 && NumberUtils.toPrimitive((Integer)data.getIsAllowNocardrun()) == 1;
    }

    public boolean isSpecial(Integer type) {
        return type == 3;
    }

    public boolean isSpecialFree(ParkConfig parkConfig) {
        return parkConfig.getIsfreeSpecialcar() == 1;
    }

    public boolean isFreeOfficialCars(ParkConfig parkConfig, String plateNum) {
        return NumberUtils.toPrimitive((Integer)parkConfig.getFreeOfficialCars()) == 1 && PlateTypeDto.officialCar((String)plateNum);
    }

    public float fixedFee(ParkConfig parkConfig, Integer carType) {
        Integer val = 1;
        if (parkConfig != null && val.equals(parkConfig.getIsfixedfees()) && parkConfig.getFixedfeevalue() != null) {
            return (carType == 1 ? parkConfig.getFixedfeevalue() : parkConfig.getFixedFeeValueBig()).intValue();
        }
        return -1.0f;
    }

    protected ResultCode getNoPlateResultCode(ReportParamHolder paramHolder) {
        ParkInoutdevice data = paramHolder.getParkChannel();
        ResultCode code = this.allowNoplate(data) ? ResultCode.\u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa : ResultCode.\u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165;
        return code;
    }

    public boolean yellowcarrun(String plateColor, ParkInoutdevice data) {
        return "\u9ec4\u8272".equals(plateColor) && data.getIsAllowTempcarrun() == 1 && data.getIsAllowYellowcarrun() == 1;
    }

    public boolean bluecarrun(String plateColor, ParkInoutdevice data) {
        return "\u84dd\u8272".equals(plateColor) && data.getIsAllowTempcarrun() == 1 && data.getIsAllowBluerun() == 1;
    }

    public boolean greencarrun(String plateColor, ParkInoutdevice data) {
        return ("\u9ec4\u7eff\u8272".equals(plateColor) || "\u7eff\u8272".equals(plateColor)) && data.getIsAllowTempcarrun() == 1 && data.getIsAllowNewenergycarrun() == 1;
    }

    protected boolean isVipCar(ReportParamHolder paramHolder) {
        ObjectResponse<VipType> validVipCar = paramHolder.getVipTypeResp();
        return ObjectResponse.isSuccess(validVipCar);
    }

    protected boolean isOtherRegionVipCar(ReportParamHolder paramHolder) {
        VipDetailDto vipDetailDto = paramHolder.getOtherRegionVipDetailDto();
        return vipDetailDto != null;
    }

    protected boolean isInnerCar(ReportParamHolder paramHolder) {
        ObjectResponse<VehiclePlate> vehiclePlateObjectResponse = paramHolder.getVehiclePlateResp();
        return ObjectResponse.isSuccess(vehiclePlateObjectResponse);
    }

    protected VipType getVipCar(ReportParamHolder paramHolder) {
        ObjectResponse<VipType> validVipCar = paramHolder.getVipTypeResp();
        if (ObjectResponse.isSuccess(validVipCar)) {
            return (VipType)validVipCar.getData();
        }
        return null;
    }

    protected boolean isShowBlackCar(ReportParamHolder paramHolder) {
        ParkInoutdevice channel = paramHolder.getParkChannel();
        if (channel != null && channel.getLedLcdSource() != null && channel.getLedLcdSource() == 2) {
            ObjectResponse<LcdConfig> objectResponse = paramHolder.getLcdConfigResp();
            LcdConfig lcdConfig = (LcdConfig)objectResponse.getData();
            return lcdConfig.getBlackCar() != 1;
        }
        ObjectResponse<LedConfig> ledConfigObjectResponse = paramHolder.getLedConfigResp();
        LedConfig parkLedSoundConfig = (LedConfig)ledConfigObjectResponse.getData();
        return parkLedSoundConfig.getLedBlackCar() != 1;
    }

    protected Integer getRemainDaysMc(ReportParamHolder paramHolder) {
        ParkInoutdevice channel = paramHolder.getParkChannel();
        if (channel != null && channel.getLedLcdSource() != null && channel.getLedLcdSource() == 2) {
            ObjectResponse<LcdConfig> objectResponse = paramHolder.getLcdConfigResp();
            LcdConfig lcdConfig = (LcdConfig)objectResponse.getData();
            return lcdConfig.getRemainDaysMc();
        }
        ObjectResponse<LedConfig> ledConfigObjectResponse = paramHolder.getLedConfigResp();
        LedConfig parkLedSoundConfig = (LedConfig)ledConfigObjectResponse.getData();
        return parkLedSoundConfig.getLedRemainDaysMc();
    }

    public boolean isStoreCardCar(ReportParamHolder paramHolder) {
        ObjectResponse<StoreCard> objectResponse = paramHolder.getStoreCardResp();
        return ObjectResponse.isSuccess(objectResponse);
    }

    public void replaceCardCode(ReportParamHolder paramHolder, FlowRet flowRet) {
        boolean isStoreCard = this.isStoreCardCar(paramHolder);
        if (!isStoreCard) {
            return;
        }
        switch (flowRet.getResultCode()) {
            case \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: {
                flowRet.setResultCode(ResultCode.\u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165);
                break;
            }
            case \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165: {
                flowRet.setResultCode(ResultCode.\u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165);
                break;
            }
        }
    }

    public ResultCode tempPlateHandle(ReportParamHolder paramHolder, String plateColor) {
        ParkInoutdevice data = paramHolder.getParkChannel();
        if (!this.yellowcarrun(plateColor, data)) {
            return ResultCode.\u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a;
        }
        ResultCode code = this.allowTempEnter(data) ? ResultCode.\u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165 : ResultCode.\u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165;
        return code;
    }

    protected boolean filter(String parkCode, Long parkId, String plateNum, ParkConfig parkConfig, String channelCode, int exType, long eventTime) {
        if (NumberUtils.toPrimitive((Integer)parkConfig.getFilterTime()) > 0) {
            CarExitRequest exit;
            CarEnterRequest entrance;
            Integer filterTime = parkConfig.getFilterTime();
            if (exType == 1 && (entrance = this.cacheHandle.getEntrance(parkCode, channelCode)) != null) {
                if (entrance.getEnterTime() != null && plateNum.equals(entrance.getPlateNum())) {
                    Long lastEnterTime = entrance.getEnterTime();
                    return lastEnterTime + (long)filterTime.intValue() >= eventTime;
                }
                return false;
            }
            if (exType == 2 && (exit = this.cacheHandle.getExit(parkCode, channelCode)) != null) {
                if (exit.getExitTime() != null && plateNum.equals(exit.getPlateNum())) {
                    Long lastExitTime = exit.getExitTime();
                    return lastExitTime + (long)filterTime.intValue() >= eventTime;
                }
                return false;
            }
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setParkId(parkId);
            orderInfo.setPlateNum(plateNum);
            OrderInfo orderInfoRet = this.orderInfoDao.selectLimitOneByIdDesc(orderInfo);
            if (orderInfoRet != null) {
                long lastEnterTime = NumberUtils.toPrimitive((Long)orderInfoRet.getEnterTime());
                long lastExitTime = NumberUtils.toPrimitive((Long)orderInfoRet.getExitTime());
                if (NumberUtils.toPrimitive((Integer)parkConfig.getPlateFilterType()) == 1) {
                    boolean result;
                    boolean bl = result = lastExitTime + (long)filterTime.intValue() >= eventTime || lastEnterTime + (long)filterTime.intValue() >= eventTime;
                    if (result) {
                        log.info("\u8f66\u573a\u8fc7\u6ee4\u9650\u5236, \u91cd\u590d\u7684\u8ba2\u5355{}", (Object)orderInfoRet);
                    }
                    return result;
                }
                OrderCarInfo orderCarInfo = this.orderCarInfoDao.selectByOrderNum(orderInfoRet.getOrderNum());
                if (orderCarInfo == null) {
                    return false;
                }
                if (exType == 1 && orderCarInfo.getEnterChannelId() != null && orderCarInfo.getEnterChannelId().equals(channelCode)) {
                    boolean result;
                    boolean bl = result = lastEnterTime + (long)filterTime.intValue() >= eventTime;
                    if (result) {
                        log.info("\u901a\u9053\u8fc7\u6ee4\u9650\u5236, \u91cd\u590d\u7684\u8ba2\u5355{}", (Object)orderInfoRet);
                    }
                    return result;
                }
                if (exType == 2 && orderCarInfo.getExitChannelId() != null && orderCarInfo.getExitChannelId().equals(channelCode)) {
                    return lastExitTime + (long)filterTime.intValue() >= eventTime;
                }
            }
        }
        return false;
    }

    protected OrderInfo getLastEnterOrder(Long parkId, String plateNum, long startTime) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setPlateNum(plateNum);
        OrderInfo orderInfoRet = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoRet != null && startTime <= orderInfoRet.getEnterTime()) {
            return orderInfoRet;
        }
        return null;
    }

    private long completeConvert(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(11, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        return instance.getTime().getTime() / 1000L;
    }

    public static class FlowRet {
        private ResultCode resultCode;
        private Map<String, Object> para;

        public void setResultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
        }

        public void setPara(Map<String, Object> para) {
            this.para = para;
        }

        public ResultCode getResultCode() {
            return this.resultCode;
        }

        public Map<String, Object> getPara() {
            return this.para;
        }

        public String toString() {
            return "FlowCondition.FlowRet(resultCode=" + (Object)((Object)this.getResultCode()) + ", para=" + this.getPara() + ")";
        }
    }

    public static enum ResultCode {
        \u6708\u5361\u8f66(10),
        \u9ed1\u540d\u5355\u8f66(11),
        \u6709\u724c\u8f66\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165(12),
        \u6709\u724c\u8f66\u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u8fdb\u5165(13),
        \u65e0\u724c\u8f66\u5141\u8bb8\u8fdb\u51fa(14),
        \u65e0\u724c\u8f66\u4e0d\u5141\u8bb8\u8fdb\u5165(17),
        \u7279\u6b8a\u8f66\u8f86\u514d\u8d39(18),
        \u514d\u8d39\u65f6\u95f4\u5185(19),
        \u65e0\u5165\u573a\u6709\u5168\u514d\u4f18\u60e0(20),
        \u9884\u7f34\u8d39\u672a\u8d85\u65f6(21),
        \u65e0\u9700\u7f34\u8d39(22),
        \u65e0\u5165\u573a\u8bb0\u5f55(23),
        \u56fa\u5b9a\u8d39\u7528(24),
        \u9700\u7f34\u8d39(25),
        VIP\u8f66\u8f86(26),
        \u8f66\u4f4d\u5df2\u6ee1\u7981\u6b62\u5165\u573a(27),
        \u9ec4\u724c\u8f66\u7981\u6b62\u5165\u573a(28),
        \u5165\u573a\u9650\u5236(29),
        \u79bb\u573a\u9650\u5236(30),
        \u5185\u90e8\u8f66\u8f86(31),
        \u8fc7\u671f\u5361(32),
        \u8f66\u4f4d\u5df2\u5360(33),
        \u7f34\u8d39\u540e\u5c4f\u663e\u64ad\u62a5(34),
        \u8bbf\u5ba2\u8f66(35),
        \u50a8\u503c\u5361\u8f66\u5141\u8bb8\u8fdb\u5165(36),
        \u50a8\u503c\u5361\u8f66\u7981\u6b62\u8fdb\u5165(37),
        \u50a8\u503c\u5361\u8fc7\u671f(38),
        \u50a8\u503c\u5361\u8f66(39),
        \u65e0\u5165\u573aVIP\u5168\u514d\u8f66(40),
        \u4e0d\u5141\u8bb8\u4e34\u65f6\u8f66\u51fa(41),
        \u6b20\u8d39\u8865\u7f34(42),
        \u865a\u5047\u8f66\u724c(43);

        private Integer code;

        private ResultCode(int code) {
            this.code = code;
        }

        public Integer getCode() {
            return this.code;
        }

        public static ResultCode getInstance(int code) {
            for (ResultCode resultCode : ResultCode.values()) {
                if (resultCode.code != code) continue;
                return resultCode;
            }
            return null;
        }

        public String toString() {
            return "FlowCondition.ResultCode." + this.name() + "(code=" + this.getCode() + ")";
        }
    }
}

