/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.factory;

import com.icetech.basics.utils.Spring;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.FullCloudDownCmdEnum;
import com.icetech.cloudcenter.domain.enumeration.P2cDownCmdEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.down.p2c.DownService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(SendServiceFactory.class);
    private static final String SERVICE_SUFFIX = "ServiceImpl";

    public static DownSendService createSendService(Integer serviceType) {
        String serviceName = DownServiceEnum.getServiceName((Integer)serviceType);
        DownSendService downSendService = SendServiceFactory.getServiceBean(serviceName);
        return downSendService;
    }

    public static NotifyService createNotifyService(String serviceName) {
        return SendServiceFactory.getNotifyServiceBean(serviceName);
    }

    public static DownService createP2cSendService(Integer cmdType) {
        String cmd = P2cDownCmdEnum.getCmd((Integer)cmdType);
        if (cmd == null) {
            log.info("\u7aef\u4e91\u65e0\u9700\u4e0b\u53d1\uff0ccmdType\uff1a{}", (Object)cmdType);
            throw new ResponseBodyException("406", "\u7aef\u4e91\u65e0\u9700\u4e0b\u53d1");
        }
        DownService sendService = SendServiceFactory.getP2cBean(cmd, DownService.class);
        return sendService;
    }

    public static DownService createFullCloudSendService(Integer cmdType) {
        String cmd = FullCloudDownCmdEnum.getCmd((Integer)cmdType);
        if (cmd == null) {
            log.info("\u7aef\u4e91\u65e0\u9700\u4e0b\u53d1\uff0ccmdType\uff1a{}", (Object)cmdType);
            throw new ResponseBodyException("406", "\u7eaf\u4e91\u65e0\u9700\u4e0b\u53d1");
        }
        return SendServiceFactory.getFullCloudBean(cmd, DownService.class);
    }

    public static <T> T getP2cBean(String cmd, Class<T> cla) {
        String serviceName = "p2c";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    public static <T> T getFullCloudBean(String cmd, Class<T> cla) {
        String serviceName = "fullCloud";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    public static <T> T getIotBean(String cmd, Class<T> cla) {
        String serviceName = "iot";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    public static <T> T getItcBean(String cmd, Class<T> cla) {
        String serviceName = "itc";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    public static <T> T getMorBean(String cmd, Class<T> cla) {
        String serviceName = "mor";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    public static <T> T getP2rBean(String cmd, Class<T> cla) {
        if (cmd != null) {
            cmd = cmd.replaceAll("_resp", "");
        }
        String serviceName = "p2r";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    public static <T> T getRobotPncBean(String cmd) {
        String serviceName = "pnc";
        if (cmd.contains("_")) {
            String[] s;
            for (String element : s = cmd.split("_")) {
                serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)element);
            }
        } else {
            serviceName = serviceName + StringUtils.toUpperCaseFirstOne((String)cmd);
        }
        try {
            return (T)Spring.getBean((String)(serviceName + SERVICE_SUFFIX));
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", CodeConstants.getName((String)"404"));
        }
    }

    private static DownSendService getServiceBean(String prefix) {
        String serviceName = prefix + SERVICE_SUFFIX;
        try {
            return (DownSendService)Spring.getBean((String)serviceName);
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", "\u6ca1\u6709\u4e0b\u53d1\u5b9e\u73b0\u7c7b");
        }
    }

    private static NotifyService getNotifyServiceBean(String prefix) {
        String serviceName = prefix + SERVICE_SUFFIX;
        try {
            return (NotifyService)Spring.getBean((String)serviceName);
        }
        catch (RuntimeException e) {
            throw new ResponseBodyException("404", "\u6ca1\u6709\u56de\u8c03\u5b9e\u73b0\u7c7b");
        }
    }
}

