/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.month.VipRegionService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.RegionBillContent;
import com.icetech.cloudcenter.domain.request.pnc.VipCarTypeRequest;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.fee.domain.entity.vip.VipRegion;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipCarTypeServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(VipCarTypeServiceImpl.class);
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private VipCarService vipCarService;
    @Autowired
    private VipRegionService vipRegionService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ChargeService chargeService;

    public ObjectResponse send(SendRequest sendRequest) {
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c5.getIndex()) {
            log.info("\u83b7\u53d6\u5230\u8f66\u573a[{}]\u7248\u672c: [{}] -> [{}]", new Object[]{sendRequest.getParkId(), version, PncVersionEnum.getIndex((String)version)});
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c5.getVersion()));
        }
        Long vipTypeId = sendRequest.getServiceId();
        try {
            String messageId;
            int type = Integer.parseInt(sendRequest.getInclude());
            VipCarTypeRequest request = null;
            if (type == 3) {
                request = new VipCarTypeRequest();
                request.setVipCarTypeId(Integer.valueOf(vipTypeId.intValue()));
                request.setOperTime(Long.valueOf(System.currentTimeMillis()));
            } else {
                ObjectResponse vipTypeResp = this.vipCarService.getVipTypeById(Integer.valueOf(vipTypeId.intValue()));
                if (!ObjectResponse.isSuccess((Response)vipTypeResp)) {
                    return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u83b7\u53d6VIP\u7c7b\u578b\u4fe1\u606f\u5931\u8d25"));
                }
                request = this.buildRequest((VipTypeDto)vipTypeResp.getData());
            }
            request.setOperType(Integer.valueOf(type));
            List vipRegionList = this.vipRegionService.getVipRegionsListByVipTypeId(Integer.valueOf(vipTypeId.intValue()));
            if (CollectionUtils.isNotEmpty((Collection)vipRegionList)) {
                VipRegion vipRegion = vipRegionList.stream().filter(v -> v.getRegionId() == 0L).findFirst().orElse(null);
                if (vipRegion == null) {
                    request.setRegionRange(Integer.valueOf(2));
                    List contents = vipRegionList.stream().filter(Objects::nonNull).map(v -> RegionBillContent.builder().regionCode(this.getRegionCode(v.getRegionId())).regionBillTypeCode(this.getParkChargeConfigCode(v.getBillId())).build()).collect(Collectors.toList());
                    request.setRegionBillContent(contents);
                    request.setBilltypeCode(contents.stream().filter(Objects::nonNull).map(RegionBillContent::getRegionBillTypeCode).filter(StringUtils::isNotEmpty).findFirst().orElse(""));
                } else {
                    request.setRegionRange(Integer.valueOf(1));
                    request.setBilltypeCode(this.getParkChargeConfigCode(vipRegion.getBillId()));
                }
            }
            if ((messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.VIP\u8f66\u8f86\u7c7b\u578b.getServiceName(), request, vipTypeId)) == null) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
            return ObjectResponse.success();
        }
        catch (ResponseBodyException e) {
            log.warn("\u4e0b\u53d1VIP\u8f66\u8f86\u7c7b\u578b\u5931\u8d25: {}, {}", new Object[]{e.getErrCode(), e.getMessage(), e});
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4e0b\u53d1VIP\u8f66\u8f86\u7c7b\u578b\u5931\u8d25"));
        }
        catch (Exception e) {
            log.error("\u4e0b\u53d1VIP\u8f66\u8f86\u7c7b\u578b\u5931\u8d25", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u83b7\u53d6VIP\u8f66\u8f86\u4fe1\u606f\u5931\u8d25"));
        }
    }

    public String getRegionCode(Long id) {
        ObjectResponse regionResponse = this.parkService.getParkRegionById(id);
        if (ObjectResponse.isSuccess((Response)regionResponse)) {
            ParkRegion parkRegion = (ParkRegion)regionResponse.getData();
            return parkRegion.getRegionCode();
        }
        return "";
    }

    public String getParkChargeConfigCode(Integer id) {
        ParkChargeconfig chargeConfig = this.chargeService.getParkChargeConfigById(id);
        if (chargeConfig == null || StringUtils.isEmpty((CharSequence)chargeConfig.getBilltypecode())) {
            return "";
        }
        return chargeConfig.getBilltypecode();
    }

    private VipCarTypeRequest buildRequest(VipTypeDto vipType) {
        VipCarTypeRequest request = new VipCarTypeRequest();
        request.setOperTime(Long.valueOf(vipType.getUpdateTime().getTime() / 1000L));
        request.setVipCarTypeId(vipType.getId());
        request.setVipCarTypeName(vipType.getName());
        request.setDiscountType(vipType.getType());
        request.setDiscountNumber(vipType.getAmount());
        request.setBilltypeCode(vipType.getBilltypecode());
        return request;
    }
}

