/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.request.pnc.VipCarInfoRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.fee.dao.vip.VipRecordDao;
import com.icetech.fee.domain.entity.vip.VipPlate;
import com.icetech.fee.domain.entity.vip.VipRecord;
import com.icetech.fee.domain.vo.VipInfoDetail;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VipCarInfoServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(VipCarInfoServiceImpl.class);
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private VipCarService vipCarService;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private VipRecordDao vipRecordDao;

    public ObjectResponse send(SendRequest sendRequest) {
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c5.getIndex()) {
            log.info("\u83b7\u53d6\u5230\u8f66\u573a[{}]\u7248\u672c: [{}] -> [{}]", new Object[]{sendRequest.getParkId(), version, PncVersionEnum.getIndex((String)version)});
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c5.getVersion()));
        }
        Long recordId = sendRequest.getServiceId();
        try {
            VipCarInfoRequest request;
            ObjectResponse vipRecordResp = this.vipCarService.getOperatorRecordById(recordId);
            ObjectResponse.notError((Response)vipRecordResp);
            VipRecord vipRecord = (VipRecord)vipRecordResp.getData();
            if (vipRecord.getOperType() == 3) {
                request = new VipCarInfoRequest();
                request.setVipInfoId(vipRecord.getVipId());
            } else {
                ObjectResponse vipInfoResp = this.vipCarService.getVipInfoDetailById(vipRecord.getVipId().intValue());
                ObjectResponse.notError((Response)vipInfoResp);
                VipInfoDetail vipInfo = (VipInfoDetail)vipInfoResp.getData();
                ObjectResponse vipPlatesResp = this.vipCarService.getVipPlatesByInfoId((long)vipInfo.getId().intValue());
                ObjectResponse.notError((Response)vipPlatesResp);
                String plateNums = ((List)vipPlatesResp.getData()).stream().map(VipPlate::getPlateNum).collect(Collectors.joining("/")).replace("\u3001", "/");
                request = this.buildRequest(vipRecord, vipInfo);
                request.setPlateNums(plateNums);
            }
            request.setOperType(vipRecord.getOperType());
            String messageId = this.downHandle.signAndSend(vipRecord.getParkId().longValue(), DownServiceEnum.VIP\u8f66\u8f86\u4fe1\u606f.getServiceName(), request, recordId);
            if (messageId == null) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
            return ObjectResponse.success();
        }
        catch (ResponseBodyException e) {
            log.warn("\u4e0b\u53d1VIP\u8f66\u8f86\u4fe1\u606f\u5931\u8d25: {}, {}", new Object[]{e.getErrCode(), e.getMessage(), e});
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u4e0b\u53d1VIP\u8f66\u8f86\u4fe1\u606f\u5931\u8d25"));
        }
        catch (Exception e) {
            log.error("\u4e0b\u53d1VIP\u8f66\u8f86\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u83b7\u53d6VIP\u8f66\u8f86\u4fe1\u606f\u5931\u8d25"));
        }
    }

    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List ids = sendRequestList.stream().map(SendRequest::getServiceId).collect(Collectors.toList());
        List list = this.vipRecordDao.getRecordListByIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ObjectResponse.failed((String)"402");
        }
        List vipIdList = list.stream().map(VipRecord::getVipId).map(String::valueOf).collect(Collectors.toList());
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(Integer.valueOf(3));
        batchDelBizRequest.setIdList(vipIdList);
        batchDelBizRequest.setServiceIds(ids);
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        AssertTools.notNull((Object)messageId, (String)"500", (String)"\u4e0b\u53d1\u5931\u8d25");
        return ObjectResponse.success();
    }

    private VipCarInfoRequest buildRequest(VipRecord vipRecord, VipInfoDetail vipInfo) {
        VipCarInfoRequest request = new VipCarInfoRequest();
        request.setOperTime(Long.valueOf(vipRecord.getOperTime().getTime() / 1000L));
        request.setVipCarTypeId(vipInfo.getTypeId());
        request.setVipCarTypeName(vipInfo.getVipTypeName());
        request.setVipInfoId(vipInfo.getId());
        request.setStartDate(DateFormatUtils.format((Date)vipInfo.getStartTime(), (String)"yyyy-MM-dd"));
        request.setEndDate(DateFormatUtils.format((Date)vipInfo.getEndTime(), (String)"yyyy-MM-dd"));
        request.setOwner(vipInfo.getOwner() == null ? "" : vipInfo.getOwner());
        request.setPhone(vipInfo.getPhone() == null ? "" : vipInfo.getPhone());
        return request;
    }
}

