/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.StoreCardRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.storecard.StoreCardRecord;
import com.icetech.fee.domain.entity.storecard.StoreCardUsed;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoredCardServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(StoredCardServiceImpl.class);
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private StoreCardService storeCardService;
    @Resource
    private RedisUtils redisUtils;

    public ObjectResponse send(SendRequest sendRequest) {
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.\u7248\u672c5.getIndex()) {
            log.info("\u83b7\u53d6\u5230\u8f66\u573a[{}]\u7248\u672c: [{}] -> [{}]", new Object[]{sendRequest.getParkId(), version, PncVersionEnum.getIndex((String)version)});
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c5.getVersion()));
        }
        Long serviceId = sendRequest.getServiceId();
        try {
            StoreCardRequest request = null;
            if ("use".equals(sendRequest.getInclude())) {
                ObjectResponse usedResp = this.storeCardService.getStoreCardUsedById(serviceId.longValue());
                if (!ObjectResponse.isSuccess((Response)usedResp)) {
                    return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u50a8\u503c\u5361\u4f7f\u7528\u8bb0\u5f55\u672a\u627e\u5230"));
                }
                StoreCardUsed cardUsed = (StoreCardUsed)usedResp.getData();
                request = new StoreCardRequest();
                request.setOperType(Integer.valueOf(4));
                request.setCardId(cardUsed.getCardId());
                request.setBalance(cardUsed.getCardAfterAmount().toString());
                request.setOperTime(Long.valueOf(cardUsed.getPayTime().getTime() / 1000L));
            } else {
                ObjectResponse recordResp = this.storeCardService.getStoreCardRecordById(serviceId.longValue());
                if (!ObjectResponse.isSuccess((Response)recordResp)) {
                    return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u50a8\u503c\u5361\u64cd\u4f5c\u8bb0\u5f55\u672a\u627e\u5230"));
                }
                StoreCardRecord record = (StoreCardRecord)recordResp.getData();
                int operaType = this.convertOperaType(record.getCardOperType());
                if (operaType == 3) {
                    request = new StoreCardRequest();
                } else {
                    ObjectResponse storeCardResp = this.storeCardService.getStoreCardDetail(Integer.valueOf(record.getCardId().intValue()));
                    if (!ObjectResponse.isSuccess((Response)recordResp)) {
                        return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u50a8\u503c\u5361\u4fe1\u606f\u672a\u627e\u5230"));
                    }
                    StoreCard storeCard = (StoreCard)storeCardResp.getData();
                    request = this.buildRequest(storeCard);
                }
                request.setOperType(Integer.valueOf(operaType));
                request.setCardId(record.getCardId());
                request.setPlateNums(record.getPlateNum().replace(",", "/"));
                request.setOperTime(Long.valueOf(record.getUpdateTime().getTime() / 1000L));
            }
            String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u50a8\u503c\u5361\u8f66\u8f86\u4fe1\u606f.getServiceName(), request, serviceId);
            if (messageId == null) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
            return ObjectResponse.success();
        }
        catch (ResponseBodyException e) {
            log.warn("\u4e0b\u53d1\u50a8\u503c\u5361\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25: {}, {}", new Object[]{e.getErrCode(), e.getMessage(), e});
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        catch (Exception e) {
            log.error("\u4e0b\u53d1\u50a8\u503c\u5361\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)"\u4e0b\u53d1\u50a8\u503c\u5361\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25");
        }
    }

    private StoreCardRequest buildRequest(StoreCard storeCard) {
        StoreCardRequest request = new StoreCardRequest();
        request.setCardNum(storeCard.getCardsNum());
        request.setOwner(storeCard.getCardOwner());
        request.setPhone(storeCard.getPhone());
        request.setAddress(storeCard.getAddress());
        request.setStartDate(DateFormatUtils.format((Date)storeCard.getStartTime(), (String)"yyyy-MM-dd"));
        request.setEndDate(DateFormatUtils.format((Date)storeCard.getEndTime(), (String)"yyyy-MM-dd"));
        request.setBalance(storeCard.getBalance().toString());
        return request;
    }

    private int convertOperaType(int operaType) {
        if (operaType == 3) {
            return 2;
        }
        if (operaType == 4) {
            return 3;
        }
        return operaType;
    }
}

