/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.VoiceReportRequest;
import com.icetech.cloudcenter.domain.request.pnc.ShowAndSayRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShowAndSayServiceImpl
implements NotifyService<ShowAndSayRequest> {
    private static final Logger log = LoggerFactory.getLogger(ShowAndSayServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Autowired
    private OrderInfoDao orderInfoDao;

    public ObjectResponse<Void> execute(VoiceReportRequest voiceReportRequest) {
        ShowAndSayRequest showAndSayRequest = new ShowAndSayRequest();
        showAndSayRequest.setChannelId(voiceReportRequest.getAisleCode());
        showAndSayRequest.setType(Integer.valueOf(1));
        showAndSayRequest.setInoutEvent(voiceReportRequest.getExitWay());
        showAndSayRequest.setOperAccount(voiceReportRequest.getOperAccount());
        showAndSayRequest.setExTerminal(voiceReportRequest.getExitTerminal());
        if (voiceReportRequest.isHasNotPay()) {
            List orderInfos;
            showAndSayRequest.setHasNotPay(Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)voiceReportRequest.getOrderNums()) && CollectionUtils.isNotEmpty((Collection)(orderInfos = this.orderInfoDao.selectList((Wrapper)Wrappers.lambdaQuery(OrderInfo.class).in(OrderInfo::getOrderNum, (Collection)voiceReportRequest.getOrderNums()))))) {
                showAndSayRequest.setOrderIds(orderInfos.stream().map(OrderInfo::getLocalOrderNum).filter(Objects::nonNull).collect(Collectors.joining(",")));
            }
        } else {
            showAndSayRequest.setHasNotPay(Integer.valueOf(0));
        }
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("plateNum", voiceReportRequest.getPlateNum());
        String orderNum = voiceReportRequest.getOrderNum();
        OrderInfo orderInfo = this.orderInfoDao.selectByOrderNum(orderNum);
        if (Objects.nonNull(orderInfo)) {
            Long enterTime = orderInfo.getEnterTime();
            content.put("queryTime", enterTime + voiceReportRequest.getParkTime());
        } else if (NumberUtils.toPrimitive((Long)voiceReportRequest.getParkTime()) == 0L) {
            content.put("queryTime", DateTools.unixTimestamp());
        } else {
            return ObjectResponse.failed((String)"402");
        }
        showAndSayRequest.setContent(content);
        String messageId = this.downHandle.signAndSendAsyncResult(voiceReportRequest.getParkCode(), DownServiceEnum.\u8bed\u97f3\u663e\u793a\u5c4f\u5185\u5bb9.getServiceName(), showAndSayRequest, voiceReportRequest.getTopic());
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<ShowAndSayRequest> sendInfoRecord) {
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }
}

