/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.DataEnterRequest;
import com.icetech.cloudcenter.domain.request.pnc.ReqEnterRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReqEnterServiceImpl
implements NotifyService<ReqEnterRequest> {
    @Autowired
    private PncDownHandle downHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> execute(DataEnterRequest enterRequest) {
        ReqEnterRequest reqEnterRequest = new ReqEnterRequest();
        reqEnterRequest.setPlateNum(enterRequest.getPlateNum());
        reqEnterRequest.setChannelId(enterRequest.getAisleCode());
        reqEnterRequest.setCarType(enterRequest.getCarType());
        reqEnterRequest.setEnterTime(enterRequest.getEnterTime());
        reqEnterRequest.setCarDesc(enterRequest.getSpecialCar());
        reqEnterRequest.setRemark(enterRequest.getRemark());
        reqEnterRequest.setInoutEvent(enterRequest.getEnterWay());
        reqEnterRequest.setOperAccount(enterRequest.getOperaUser());
        reqEnterRequest.setExTerminal(enterRequest.getEnterTerminal());
        String messageId = this.downHandle.signAndSendAsyncResult(enterRequest.getParkCode(), DownServiceEnum.\u8bf7\u6c42\u5165\u573a.getServiceName(), reqEnterRequest, enterRequest.getTopic());
        if (messageId == null) {
            return ObjectResponse.failed((String)"3003");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<ReqEnterRequest> sendInfoRecord) {
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }
}

