/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.QueryFeeService;
import com.icetech.cloudcenter.api.order.OrderEnterService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.cloudcenter.domain.request.QueryFeeRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.cloudcenter.domain.response.NotPayDetail;
import com.icetech.cloudcenter.domain.response.PullfeeResponse;
import com.icetech.cloudcenter.domain.response.QueryFeeRegionDetail;
import com.icetech.cloudcenter.domain.response.QueryFeeResponse;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.constant.RedisDiscountKeyConstant;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class QueryFeeServiceImpl
implements QueryFeeService,
NotifyService<QueryFeeRequest> {
    private static final Logger log = LoggerFactory.getLogger(QueryFeeServiceImpl.class);
    @Resource
    private PncDownHandle downHandle;
    @Resource
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Resource
    private OrderDiscountDao orderDiscountDao;
    @Resource
    private OrderPayDao orderPayDao;
    @Resource
    private OrderEnterService orderEnterService;
    @Resource
    private OrderInfoDao orderInfoDao;
    @Resource
    private ParkService parkService;
    @Resource
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private CacheHandle cacheHandle;
    @Resource
    private VipTypeDao vipTypeDao;
    @Value(value="${pay.etc.lock:120}")
    private Integer etcLock;

    public ObjectResponse<Void> queryFee(QueryFeeRequest queryFeeRequest) {
        String key = queryFeeRequest.getKey();
        Long parkId = queryFeeRequest.getParkId();
        QueryFeeRequest feeRequest = this.buildRequest(parkId, queryFeeRequest);
        String messageId = this.downHandle.signAndSendAsyncResult(parkId, queryFeeRequest.getParkCode(), key, DownServiceEnum.\u7f34\u8d39\u67e5\u8be2.getServiceName(), feeRequest, queryFeeRequest.getChannelId(), queryFeeRequest.getTopic(), queryFeeRequest.getExtraInfo());
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            this.alarmService.queryFeeFailHandler(queryFeeRequest.getParkCode(), parkId, queryFeeRequest.getChannelId());
            return ObjectResponse.failed((String)"3001", (String)"\u4e0b\u53d1\u6d88\u606f\u5931\u8d25");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<QueryFeeRequest> sendInfoRecord) {
        QueryFeeResponse queryFeeResponse = (QueryFeeResponse)JsonUtils.parseObject((String)((String)response.getData()), QueryFeeResponse.class, (Class[])new Class[0]);
        QueryFeeRequest queryFeeRequest = (QueryFeeRequest)sendInfoRecord.getParams();
        if (queryFeeRequest == null) {
            queryFeeRequest = new QueryFeeRequest();
        }
        ObjectResponse objectResponse = new ObjectResponse();
        if (response.getCode().equals("3004") || response.getCode().equals("3007") || response.getCode().equals("3008") || response.getCode().equals("3010")) {
            objectResponse.setCode(response.getCode());
            objectResponse.setMsg(response.getMsg());
            objectResponse.setTraceId(response.getTraceId());
        } else if (ObjectResponse.isSuccess(response)) {
            try {
                QueryOrderFeeResponse queryOrderFeeResponse = this.getQueryOrderFeeResponse(sendInfoRecord, queryFeeResponse, queryFeeRequest);
                objectResponse = ObjectResponse.success((Object)queryOrderFeeResponse);
            }
            catch (ResponseBodyException e) {
                objectResponse.setCode(e.getErrCode());
                objectResponse.setMsg(e.getMessage());
            }
        } else {
            objectResponse.setCode("3001");
            objectResponse.setMsg(response.getMsg());
        }
        if (QueryFeeRequest.ExtraInfoEnum.PULL_FEE.val.equals(sendInfoRecord.getExtraInfo())) {
            PullfeeResponse pullfeeResponse = new PullfeeResponse();
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                QueryOrderFeeResponse data = (QueryOrderFeeResponse)objectResponse.getData();
                String discountPrice = data.getDiscountPrice();
                String unpayPrice = data.getUnpayPrice();
                String discountAmount = data.getDiscountAmount();
                pullfeeResponse.setTotalPrice(data.getTotalAmount());
                pullfeeResponse.setDiscountPrice(NumberUtils.decimalAdd((Object)discountPrice, (Object[])new Object[]{discountAmount}).toString());
                pullfeeResponse.setCurrentDiscountPrice(discountPrice);
                pullfeeResponse.setPaidPrice(data.getPaidAmount());
                pullfeeResponse.setNeedPayPrice(unpayPrice);
                pullfeeResponse.setQueryTime(data.getQueryTime());
                pullfeeResponse.setLastPayTime(data.getPayTime());
                pullfeeResponse.setOrderNum(data.getOrderNum());
                pullfeeResponse.setInsideDetails(data.getInsideDetails());
                this.cacheHandle.setChannelFee(queryFeeRequest.getParkCode(), queryFeeRequest.getChannelId(), data);
            } else if (objectResponse.getCode().equals("3004")) {
                QueryOrderFeeResponse data = this.cacheHandle.getChannelFee(queryFeeRequest.getParkCode(), queryFeeRequest.getChannelId());
                if (data == null) {
                    log.info("[\u4eba\u5de5\u67e5\u8be2\u8d39\u7528] \u67e5\u8be2\u6700\u65b0\u8d39\u7528\u5931\u8d25\uff0c\u8f66\u8f86\u5df2\u79bb\u573a[{}]", (Object)queryFeeRequest);
                } else {
                    String discountPrice = data.getDiscountPrice();
                    String discountAmount = data.getDiscountAmount();
                    pullfeeResponse.setTotalPrice(data.getTotalAmount());
                    pullfeeResponse.setDiscountPrice(NumberUtils.decimalAdd((Object)discountPrice, (Object[])new Object[]{discountAmount}).toString());
                    pullfeeResponse.setCurrentDiscountPrice(discountPrice);
                    pullfeeResponse.setPaidPrice(NumberUtils.decimalAdd((Object)data.getPaidAmount(), (Object[])new Object[]{data.getUnpayPrice()}).toString());
                    pullfeeResponse.setNeedPayPrice("0.00");
                    pullfeeResponse.setLastPayTime(data.getPayTime());
                    pullfeeResponse.setOrderNum(data.getOrderNum());
                    pullfeeResponse.setInsideDetails(data.getInsideDetails());
                    this.cacheHandle.setChannelFee(queryFeeRequest.getParkCode(), queryFeeRequest.getChannelId(), data);
                }
            } else {
                objectResponse = ObjectResponse.failed((String)"3001");
            }
            objectResponse.setData((Object)pullfeeResponse);
        }
        ObjectResponse finalObjectResponse = objectResponse;
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), finalObjectResponse);
    }

    private QueryOrderFeeResponse getQueryOrderFeeResponse(SendInfoRecord<QueryFeeRequest> sendInfoRecord, QueryFeeResponse queryFeeResponse, QueryFeeRequest queryFeeRequest) {
        OrderDiscount orderDiscount;
        if (queryFeeResponse.getPlateNum() == null && queryFeeRequest.getPlateNum() != null) {
            queryFeeResponse.setPlateNum(queryFeeRequest.getPlateNum());
        }
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        BeanUtils.copyProperties((Object)queryFeeResponse, (Object)queryOrderFeeResponse);
        List notPayDetails = queryFeeResponse.getNotPayDetails();
        if (CollectionUtils.isNotEmpty((Collection)notPayDetails)) {
            List localOrderIds = notPayDetails.stream().map(NotPayDetail::getOrderId).filter(Objects::nonNull).collect(Collectors.toList());
            List orderInfos = this.orderInfoDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderInfo.class).eq(OrderInfo::getParkId, (Object)sendInfoRecord.getParkId())).in(OrderInfo::getLocalOrderNum, localOrderIds));
            if (CollectionUtils.isNotEmpty((Collection)orderInfos)) {
                Map map = orderInfos.stream().collect(Collectors.toMap(OrderInfo::getLocalOrderNum, Function.identity(), (older, newer) -> newer));
                List payDetails = notPayDetails.stream().peek(a -> {
                    OrderInfo orderInfo = (OrderInfo)map.get(a.getOrderId());
                    if (orderInfo != null) {
                        a.setOrderNum(orderInfo.getOrderNum());
                    }
                }).collect(Collectors.toList());
                queryOrderFeeResponse.setNotPayDetails(payDetails);
            }
        }
        int isInside = 0;
        String localOrderNum = queryFeeResponse.getOrderId();
        boolean hasNotPay = CollectionUtils.isNotEmpty((Collection)queryFeeResponse.getNotPayDetails());
        if (StringUtils.isBlank((CharSequence)localOrderNum) && !hasNotPay) {
            log.warn("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u7f34\u8d39\u67e5\u8be2\u8fd4\u56de\u4fe1\u606f\u6709\u8bef, orderId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)queryFeeRequest);
            throw new ResponseBodyException("3001", "\u67e5\u8be2\u7ed3\u679c\u6709\u8bef");
        }
        ObjectResponse parkObjectResponse = this.parkService.findByParkId(sendInfoRecord.getParkId());
        if (!ObjectResponse.isSuccess((Response)parkObjectResponse)) {
            log.warn("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u8f66\u573a\u4e0d\u5b58\u5728, parkId[{}]", (Object)sendInfoRecord.getParkId());
            throw new ResponseBodyException("3001", "\u8f66\u573a\u4e0d\u5b58\u5728");
        }
        ObjectResponse parkConfigObjectResponse = this.parkService.getParkConfig(sendInfoRecord.getParkId());
        if (!ObjectResponse.isSuccess((Response)parkConfigObjectResponse)) {
            log.warn("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728, parkId[{}]", (Object)sendInfoRecord.getParkId());
            throw new ResponseBodyException("3001", "\u8f66\u573a\u9ad8\u7ea7\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        Park park = (Park)parkObjectResponse.getData();
        ParkConfig parkConfig = (ParkConfig)parkConfigObjectResponse.getData();
        OrderInfo orderInfo = null;
        if (StringUtils.isNotBlank((CharSequence)localOrderNum)) {
            OrderInfo orderInfoParam = new OrderInfo();
            orderInfoParam.setLocalOrderNum(localOrderNum);
            orderInfoParam.setParkId(park.getId());
            orderInfo = this.orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfoParam);
        }
        if (orderInfo == null) {
            log.info("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u4e91\u5e73\u53f0\u672a\u67e5\u8be2\u5230\u5728\u573a\u8bb0\u5f55, \u672c\u5730\u8ba2\u5355\u53f7[{}], \u8f66\u724c[{}]", (Object)localOrderNum, (Object)queryOrderFeeResponse.getPlateNum());
            orderInfo = new OrderInfo();
            orderInfo.setPlateNum(queryOrderFeeResponse.getPlateNum());
            if (!hasNotPay) {
                isInside = 1;
            }
        }
        if (StringUtils.isBlank((CharSequence)orderInfo.getOrderNum()) && !hasNotPay) {
            try {
                ObjectResponse objectResponse;
                orderInfo.setParkId(park.getId());
                Long enterTime = queryFeeResponse.getEnterTime();
                orderInfo.setEnterTime(Long.valueOf(enterTime == null ? DateTools.unixTimestamp() : enterTime));
                EnterRequest enterRequest = new EnterRequest();
                enterRequest.setParkId(park.getId());
                enterRequest.setOrderId(localOrderNum);
                enterRequest.setPlateNum(queryFeeResponse.getPlateNum());
                enterRequest.setType(Integer.valueOf(1));
                enterRequest.setCarType(Integer.valueOf(1));
                enterRequest.setEnterTime(Long.valueOf(enterTime == null ? DateTools.unixTimestamp() : enterTime));
                enterRequest.setChannelId(queryFeeRequest.getChannelId());
                enterRequest.setIsInside(Integer.valueOf(isInside));
                enterRequest.setNoneEnterFlag(true);
                if (queryFeeRequest.getChannelId() != null && Integer.valueOf(1).equals(parkConfig.getEntryPayFlag())) {
                    ObjectResponse channelInfo = this.parkService.getInOutDeviceByCode(park.getId(), queryFeeRequest.getChannelId());
                    ParkInoutdevice parkInoutdevice = (ParkInoutdevice)channelInfo.getData();
                    if (Integer.valueOf(1).equals(parkInoutdevice.getInandoutType())) {
                        enterRequest.setNoneEnterFlag(false);
                    }
                }
                AtomicReference regionIdAto = new AtomicReference();
                if (enterRequest.getChannelId() == null && ObjectResponse.isSuccess((Response)(objectResponse = this.parkService.getChannelByType(park.getId(), Integer.valueOf(1))))) {
                    Optional<ParkInoutdevice> optional = ((List)objectResponse.getData()).stream().filter(pd -> Integer.valueOf(1).equals(pd.getIsMaster())).findAny();
                    optional.ifPresent(pd -> {
                        regionIdAto.set(pd.getRegionId());
                        enterRequest.setChannelId(pd.getInandoutCode());
                        log.info("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u8865\u8ba2\u5355\u7684\u5165\u573a\u901a\u9053\u7f16\u53f7[{}]", (Object)pd.getInandoutCode());
                    });
                }
                log.info("[\u7aef\u7f51\u4e91\u67e5\u8d39]\u65e0\u5165\u573a\u8bb0\u5f55\u8fd4\u56de\u56fa\u5b9a\u6536\u8d39, \u5e73\u53f0\u6a21\u62df\u5165\u573a\u53c2\u6570[{}]", (Object)enterRequest);
                ObjectResponse enterObjectResponse = this.orderEnterService.enter(enterRequest, park.getParkCode());
                if (ObjectResponse.isSuccess((Response)enterObjectResponse)) {
                    ObjectResponse channelInfo;
                    ParkInoutdevice parkInoutdevice;
                    Map objectMap = (Map)enterObjectResponse.getData();
                    orderInfo.setOrderNum((String)objectMap.get("orderNum"));
                    if (regionIdAto.get() != null) {
                        orderInfo.setRegionId((Long)regionIdAto.get());
                    } else if (enterRequest.getChannelId() != null && (parkInoutdevice = (ParkInoutdevice)(channelInfo = this.parkService.getInOutDeviceByCode(park.getId(), enterRequest.getChannelId())).getData()) != null) {
                        orderInfo.setRegionId(parkInoutdevice.getRegionId());
                    }
                }
            }
            catch (Exception e) {
                log.error("[\u7aef\u7f51\u4e91\u67e5\u8d39]\u65e0\u5165\u573a\u8bb0\u5f55\u67e5\u8be2\u8d39\u7528\uff0c\u4fdd\u5b58\u4e3b\u8ba2\u5355\u4fe1\u606f\u5931\u8d25.\u8bf7\u6c42\u53c2\u6570[{}]", (Object)queryFeeRequest, (Object)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)orderInfo.getOrderNum())) {
            this.dealHistoryMoney(orderInfo.getOrderNum(), park, queryOrderFeeResponse);
        }
        float paidAmount = NumberUtils.parseFloat((Object)queryOrderFeeResponse.getPaidAmount());
        float unPayPrice = NumberUtils.parseFloat((Object)queryOrderFeeResponse.getUnpayPrice());
        float discountPrice = NumberUtils.parseFloat((Object)queryOrderFeeResponse.getDiscountPrice());
        float discountAmount = NumberUtils.parseFloat((Object)queryOrderFeeResponse.getDiscountAmount());
        float totalAmount = NumberUtils.parseFloat((Object)queryOrderFeeResponse.getTotalAmount());
        Long payTime = queryOrderFeeResponse.getPayTime();
        if (payTime != null && 0L == payTime) {
            log.info("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u672c\u5730\u8fd4\u56de\u7ed3\u679c\u7ea0\u6b63\uff0c\u5220\u9664pay_time\uff0c\u53c2\u6570=[{}]\uff0c \u67e5\u8be2\u7ed3\u679c=[{}]", (Object)queryFeeRequest, (Object)queryFeeResponse);
            queryOrderFeeResponse.setPayTime(null);
        }
        int status = this.getFeeStatus(Float.valueOf(paidAmount), Float.valueOf(unPayPrice), Float.valueOf(discountPrice), Float.valueOf(discountAmount), Float.valueOf(totalAmount));
        queryOrderFeeResponse.setStatus(Integer.valueOf(status));
        status = queryOrderFeeResponse.getStatus();
        queryOrderFeeResponse.setEnterTime(Long.valueOf(orderInfo.getEnterTime() == null ? DateTools.unixTimestamp() : orderInfo.getEnterTime()));
        queryOrderFeeResponse.setParkName(park.getParkName());
        queryOrderFeeResponse.setOrderNum(orderInfo.getOrderNum() == null ? "E" + CodeTools.GenerateOrderNum() : orderInfo.getOrderNum());
        queryOrderFeeResponse.setCarType(queryFeeRequest.getCarType());
        if (park.getId() != null) {
            if (parkConfig != null) {
                queryOrderFeeResponse.setFreeTime(Long.valueOf(parkConfig.getIsfreeAfterpay(Integer.valueOf(15)).intValue()));
            } else {
                queryOrderFeeResponse.setFreeTime(Long.valueOf(0L));
            }
        }
        if (StringUtils.isBlank((CharSequence)orderInfo.getOrderNum())) {
            return queryOrderFeeResponse;
        }
        if (status == 2 || status == 4) {
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(orderInfo.getParkId());
            orderPay.setOrderNum(orderInfo.getOrderNum());
            orderPay.setPayStatus(Integer.valueOf(2));
            OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null && orderSumFeeDto.getPaidPrice() > 0.0f) {
                float paidPrice = orderSumFeeDto.getPaidPrice();
                float discountPrice1 = orderSumFeeDto.getDiscountPrice();
                if (status == 2 && NumberUtils.parseDecimal((Object)Float.valueOf(unPayPrice)).compareTo(NumberUtils.parseDecimal((Object)Float.valueOf(paidPrice))) == 0 || status == 4 && totalAmount == NumberUtils.decimalAdd((Object)Float.valueOf(discountPrice1), (Object[])new Object[]{Float.valueOf(paidPrice), Float.valueOf(discountPrice)}).floatValue()) {
                    log.info("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u672c\u5730\u672a\u5237\u65b0\u5df2\u7f34\u8d39, \u8f66\u724c\u53f7[{}]", (Object)queryOrderFeeResponse.getPlateNum());
                    queryOrderFeeResponse.setUnpayPrice("0.00");
                    queryOrderFeeResponse.setPaidAmount(String.valueOf(paidPrice));
                    queryOrderFeeResponse.setDiscountAmount(String.valueOf(discountPrice1));
                    queryOrderFeeResponse.setDiscountPrice("0.00");
                    queryOrderFeeResponse.setPayTime(orderSumFeeDto.getLastPayTime());
                    queryOrderFeeResponse.setStatus(Integer.valueOf(3));
                }
            }
        }
        queryOrderFeeResponse.setInsideDetails(this.handleInsideDetails(queryOrderFeeResponse, orderInfo, queryFeeRequest.getChannelId() != null, Integer.valueOf(1).equals(park.getIsInterior())));
        if (NumberUtils.parseDouble((Object)queryFeeResponse.getDiscountPrice()) > 0.0 && StringUtils.isBlank((CharSequence)queryFeeResponse.getDiscountNos()) && (orderDiscount = (OrderDiscount)this.orderDiscountDao.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getOrderNum, (Object)orderInfo.getOrderNum())).in(OrderDiscount::getStatus, Arrays.asList(0, 3))).last("limit 1"))) != null) {
            queryFeeResponse.setDiscountNos(orderDiscount.getDiscountNo());
            log.info("[\u7aef\u7f51\u4e91\u67e5\u8d39] \u672c\u5730\u6ca1\u6709\u4e0a\u62a5\u4f18\u60e0\u5238\u7f16\u53f7, orderNum[{}], discountNo[{}]", (Object)orderDiscount.getOrderNum(), (Object)orderDiscount.getDiscountNo());
        }
        if (NumberUtils.parseDouble((Object)queryFeeResponse.getDiscountPrice()) > 0.0) {
            List orderDiscounts;
            String discountNos = queryFeeResponse.getDiscountNos();
            if (StringUtils.isNotBlank((CharSequence)discountNos) && (orderDiscounts = this.orderDiscountDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderDiscount.class).eq(OrderDiscount::getParkId, (Object)park.getId())).in(OrderDiscount::getDiscountNo, Arrays.asList(discountNos.split(","))))).size() > 0) {
                OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo = OrderPayDiscount.getMerchantCouponsInfo((List)orderDiscounts, (BigDecimal)NumberUtils.parseDecimal((Object)queryFeeResponse.getMerchantDiscountPrice()));
                OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo = OrderPayDiscount.getThirdCouponsInfo((List)orderDiscounts, (BigDecimal)NumberUtils.parseDecimal((Object)queryFeeResponse.getThirdDiscountPrice()));
                if (merchantCouponsInfo != null) {
                    this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.MERCHANT_COUPONS.getDesc(), (Object)merchantCouponsInfo, 86400L);
                }
                if (thirdCouponsInfo != null) {
                    this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.THIRD_COUPONS.getDesc(), (Object)thirdCouponsInfo, 86400L);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)queryFeeResponse.getVipTypeId())) {
                OrderPayDiscount.VipCouponsInfo vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
                for (Integer typeId : queryFeeResponse.getVipTypeId()) {
                    this.setVipCouponsInfo(typeId, NumberUtils.parseDecimal((Object)queryFeeResponse.getVipDiscountPrice()), vipCouponsInfo);
                }
                this.redisUtils.hPut(RedisDiscountKeyConstant.PAY_DISCOUNT_PRE + park.getId() + ":" + orderInfo.getOrderNum(), OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc(), (Object)vipCouponsInfo, 86400L);
            }
        }
        this.redisUtils.set(RedisDiscountKeyConstant.DISCOUNT_USE_PRE + park.getId() + ":" + orderInfo.getOrderNum(), (Object)queryFeeResponse.getDiscountNos(), 86400L);
        return queryOrderFeeResponse;
    }

    private List<QueryFeeRegionDetail> handleInsideDetails(QueryOrderFeeResponse response, OrderInfo mainOrder, boolean isChannelQueryFee, boolean isInterior) {
        ArrayList<QueryFeeRegionDetail> validInsideDetails = new ArrayList<QueryFeeRegionDetail>(2);
        if (CollectionUtils.isEmpty((Collection)response.getInsideDetails())) {
            if (!isInterior) {
                return null;
            }
            QueryFeeRegionDetail insideDetail = new QueryFeeRegionDetail(null, NumberUtils.decimalAdd((Object)response.getUnpayPrice(), (Object[])new Object[]{response.getDiscountPrice()}).toString(), NumberUtils.parseDecimal((Object)response.getDiscountPrice()).toString(), null, NumberUtils.parseDecimal((Object)response.getUnpayPrice()).toString(), NumberUtils.parseDecimal((Object)response.getUnpayPrice()).toString(), mainOrder.getRegionId(), null, mainOrder.getEnterTime(), isChannelQueryFee ? response.getQueryTime() : null, response.getPlateNum(), null);
            validInsideDetails.add(insideDetail);
            log.info("\u5b50\u8d26\u5355\u4fe1\u606f{}", validInsideDetails);
            return validInsideDetails;
        }
        Set regionCodes = response.getInsideDetails().stream().map(QueryFeeRegionDetail::getRegionCode).collect(Collectors.toSet());
        Map<String, Long> parkRegionMap = this.parkRegionDao.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkRegion.class).eq(ParkRegion::getParkId, (Object)mainOrder.getParkId())).in(ParkRegion::getRegionCode, regionCodes)).stream().collect(Collectors.toMap(ParkRegion::getRegionCode, ParkRegion::getId));
        if (parkRegionMap.isEmpty()) {
            log.info("\u5206\u8d26\u4fe1\u606f\u533a\u57df\u65e0\u6548\u6216\u65e0\u5bf9\u8c61\u5b50\u8ba2\u5355");
            return null;
        }
        Map orderSonInfoMap = this.orderSonInfoService.getInfosByOrderNum(mainOrder.getParkId(), mainOrder.getOrderNum()).stream().collect(Collectors.toMap(OrderInfo::getRegionId, Function.identity()));
        ArrayList updated = new ArrayList(orderSonInfoMap.size());
        BigDecimal totalPrice = NumberUtils.decimalAdd((Object)response.getUnpayPrice(), (Object[])new Object[]{response.getDiscountPrice()});
        BigDecimal discountPrice = NumberUtils.parseDecimal((Object)response.getDiscountPrice());
        BigDecimal unpaidPrice = NumberUtils.parseDecimal((Object)response.getUnpayPrice());
        for (QueryFeeRegionDetail insideDetail : response.getInsideDetails()) {
            double insideTotalAmount = NumberUtils.parseDouble((Object)insideDetail.getTotalAmount());
            if (insideTotalAmount <= 0.0) {
                log.info("\u533a\u57df\u91d1\u989d\u4e3a0, \u6682\u4e0d\u8bb0\u5f55\u660e\u7ec6\u4fe1\u606f|{}|{}", (Object)mainOrder.getOrderNum(), (Object)insideDetail.getRegionCode());
                continue;
            }
            totalPrice = NumberUtils.decimalSubtract((Object)totalPrice, (Object[])new Object[]{insideDetail.getTotalAmount()});
            discountPrice = NumberUtils.decimalSubtract((Object)discountPrice, (Object[])new Object[]{insideDetail.getDiscountPrice()});
            unpaidPrice = NumberUtils.decimalSubtract((Object)unpaidPrice, (Object[])new Object[]{insideDetail.getUnpayPrice()});
            Long regionId = parkRegionMap.get(insideDetail.getRegionCode());
            if (regionId == null) {
                log.info("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u533a\u57df\u4fe1\u606f|{}|{}", (Object)mainOrder.getOrderNum(), (Object)insideDetail.getRegionCode());
                continue;
            }
            insideDetail.setRegionId(regionId);
            insideDetail.setPlateNum(response.getPlateNum());
            if (!orderSonInfoMap.isEmpty()) {
                OrderSonInfo orderSonInfo = (OrderSonInfo)orderSonInfoMap.get(regionId);
                if (orderSonInfo == null) {
                    log.info("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u533a\u57df\u5b50\u8ba2\u5355\u4fe1\u606f|{}|{}|{}", new Object[]{mainOrder.getOrderNum(), insideDetail.getRegionCode(), regionId});
                    insideDetail.setEnterTime(mainOrder.getEnterTime());
                    continue;
                }
                insideDetail.setOrderSonId(orderSonInfo.getId());
                insideDetail.setEnterTime(orderSonInfo.getEnterTime());
                if (orderSonInfo.getExitTime() != null) {
                    insideDetail.setExitTime(orderSonInfo.getExitTime());
                }
            } else {
                insideDetail.setEnterTime(mainOrder.getEnterTime());
            }
            validInsideDetails.add(insideDetail);
        }
        OrderSonInfo orderSonInfo = (OrderSonInfo)orderSonInfoMap.get(mainOrder.getRegionId());
        if (orderSonInfo == null) {
            log.info("\u65e0\u6cd5\u627e\u5230\u4e3b\u8ba2\u5355\u5bf9\u5e94\u5b50\u8ba2\u5355\u4fe1\u606f|{}|{}", (Object)mainOrder.getOrderNum(), (Object)mainOrder.getRegionId());
        } else {
            QueryFeeRegionDetail insideDetail;
            insideDetail = new QueryFeeRegionDetail(null, totalPrice.toString(), discountPrice.toString(), null, unpaidPrice.toString(), unpaidPrice.toString(), orderSonInfo.getRegionId(), orderSonInfo.getId(), orderSonInfo.getEnterTime(), isChannelQueryFee ? response.getQueryTime() : null, response.getPlateNum(), null);
            validInsideDetails.add(insideDetail);
        }
        log.info("\u5b50\u8d26\u5355\u4fe1\u606f{}", validInsideDetails);
        return validInsideDetails;
    }

    private Integer getFeeStatus(Float paidAmount, Float unPayPrice, Float discountPrice, Float discountAmount, Float totalAmount) {
        log.info("\u5224\u65ad\u8d39\u7528\u72b6\u6001\u53c2\u6570\uff1a{}\uff0c{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{paidAmount, unPayPrice, discountPrice, discountAmount, totalAmount});
        if (totalAmount.floatValue() == 0.0f) {
            return 1;
        }
        if (discountAmount.equals(totalAmount)) {
            return 3;
        }
        if ((unPayPrice.floatValue() > 0.0f || discountPrice.floatValue() >= totalAmount.floatValue()) && paidAmount.floatValue() == 0.0f && discountAmount.floatValue() == 0.0f) {
            return 2;
        }
        if (unPayPrice.floatValue() == 0.0f && paidAmount.floatValue() > 0.0f) {
            return 3;
        }
        if (unPayPrice.floatValue() > 0.0f && (paidAmount.floatValue() > 0.0f || discountAmount.floatValue() > 0.0f)) {
            return 4;
        }
        if (unPayPrice.floatValue() > 0.0f) {
            return 2;
        }
        return 1;
    }

    private void dealHistoryMoney(String orderNum, Park park, QueryOrderFeeResponse queryOrderFeeResponse) {
        if (StringUtils.isBlank((CharSequence)queryOrderFeeResponse.getTotalAmount()) || StringUtils.isBlank((CharSequence)queryOrderFeeResponse.getPaidAmount()) || StringUtils.isBlank((CharSequence)queryOrderFeeResponse.getDiscountAmount())) {
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(park.getId());
            orderPay.setOrderNum(orderNum);
            orderPay.setPayStatus(Integer.valueOf(2));
            OrderSumFeeDto orderSumFeeDto = this.orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null) {
                BigDecimal totalPrice = NumberUtils.decimalAdd((Object)Float.valueOf(orderSumFeeDto.getTotalPrice()), (Object[])new Object[]{queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getDiscountPrice()});
                queryOrderFeeResponse.setTotalAmount(String.valueOf(totalPrice));
                queryOrderFeeResponse.setPaidAmount(String.valueOf(orderSumFeeDto.getPaidPrice()));
                queryOrderFeeResponse.setDiscountAmount(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                queryOrderFeeResponse.setPayTime(orderSumFeeDto.getLastPayTime());
            } else {
                BigDecimal totalPrice = NumberUtils.decimalAdd((Object)queryOrderFeeResponse.getUnpayPrice(), (Object[])new Object[]{queryOrderFeeResponse.getDiscountPrice()});
                queryOrderFeeResponse.setTotalAmount(String.valueOf(totalPrice));
                queryOrderFeeResponse.setPaidAmount("0.00");
                queryOrderFeeResponse.setDiscountAmount("0.00");
            }
        }
    }

    public QueryFeeRequest buildRequest(Long parkId, QueryFeeRequest queryFeeRequest) {
        QueryFeeRequest feeRequest = new QueryFeeRequest();
        BeanUtils.copyProperties((Object)queryFeeRequest, (Object)feeRequest);
        feeRequest.setKey(null);
        feeRequest.setParkId(null);
        feeRequest.setTopic(null);
        feeRequest.setExtraInfo(null);
        String key = "PNC_EXIT_ORDER_PAY_" + parkId + "_" + queryFeeRequest.getOrderId();
        if (this.redisUtils.exists(key)) {
            ExitPayCautionRequest exitPayCautionRequest = (ExitPayCautionRequest)this.redisUtils.get(key, ExitPayCautionRequest.class);
            log.info("<\u7aef\u7f51\u4e91-\u7f34\u8d39\u67e5\u8be2> \u901a\u9053\u6709\u5f85\u7f34\u8d39\u8f66\u8f86\uff0c\u53c2\u6570\uff1a{}", (Object)exitPayCautionRequest);
            if (exitPayCautionRequest != null && exitPayCautionRequest.getPlateNum().equals(queryFeeRequest.getPlateNum())) {
                feeRequest.setChannelId(exitPayCautionRequest.getChannelId());
                feeRequest.setPlateNum(null);
                feeRequest.setOrderId(null);
            }
        }
        return feeRequest;
    }

    private void setVipCouponsInfo(Integer vipTypeId, BigDecimal discountPrice, OrderPayDiscount.VipCouponsInfo vipCouponsInfo) {
        VipTypeDto vipTypeDto = this.vipTypeDao.selectById(vipTypeId);
        if (vipTypeDto == null) {
            return;
        }
        vipCouponsInfo.addTypeId(vipTypeId);
        vipCouponsInfo.addDiscountType(vipTypeDto.getType());
        vipCouponsInfo.setDiscountPrice(discountPrice);
    }
}

