/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.TicketGotRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncGetticketSuccessRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncTicketGotServiceImpl
extends AbstractService
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(PncTicketGotServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        TicketGotRequest ticketGotRequest = (TicketGotRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), TicketGotRequest.class);
        this.verifyParams(ticketGotRequest);
        PncGetticketSuccessRequest pncGetticketSuccessRequest = new PncGetticketSuccessRequest();
        pncGetticketSuccessRequest.setChannelId(tokenDeviceVo.getInandoutCode());
        pncGetticketSuccessRequest.setOrderId(ticketGotRequest.getOrderNum());
        String messageId = this.downHandle.signAndSend(tokenDeviceVo.getParkCode(), DownServiceEnum.\u5c0f\u7968\u9886\u53d6\u4e0b\u53d1.getServiceName(), pncGetticketSuccessRequest);
        AssertTools.notNull((Object)messageId, (String)"3003", (String)"\u4e0b\u53d1\u5c0f\u7968\u9886\u53d6\u6210\u529f\u901a\u77e5\u5931\u8d25");
        return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest);
    }
}

