/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.CloseBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpenBrakeRequest;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.cloudcenter.domain.request.RemoteSwitchRequest;
import com.icetech.cloudcenter.domain.response.p2c.RemoteSwitchResponse;
import com.icetech.common.constants.LogWarnTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.impl.AlarmServiceImpl;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncRemoteSwitchServiceImpl
implements NotifyService<RemoteSwitchRequest> {
    private static final Logger log = LoggerFactory.getLogger(PncRemoteSwitchServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AlarmServiceImpl alarmService;
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkService parkService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> remoteSwitch(RemoteSwitchRequest remoteSwitchRequest, String topic, RemoteSwitchRequest.ExtraInfo extraInfo) {
        String parkCode = remoteSwitchRequest.getParkCode();
        remoteSwitchRequest.setParkCode(null);
        String messageId = this.downHandle.signAndSendAsyncResult(parkCode, DownServiceEnum.\u8fdc\u7a0b\u5f00\u5173\u95f8.getServiceName(), remoteSwitchRequest, topic, JsonUtils.toString((Object)extraInfo));
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            this.alarmService.switchFailHandler(parkCode, null, remoteSwitchRequest.getChannelId());
            return ObjectResponse.failed((String)"500", (String)"\u4e0b\u53d1\u6d88\u606f\u5931\u8d25");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> objectResponse, SendInfoRecord<RemoteSwitchRequest> sendInfoRecord) {
        Integer resultStatus;
        RemoteSwitchRequest remoteSwitchRequest = (RemoteSwitchRequest)sendInfoRecord.getParams();
        boolean success = false;
        Map stringObjectMap = null;
        if (ObjectResponse.isSuccess(objectResponse) && (stringObjectMap = JsonUtils.parseMap((String)((String)objectResponse.getData()))) != null && (resultStatus = (Integer)stringObjectMap.get("resultStatus")) != 3 && resultStatus != 4) {
            success = true;
        }
        if (!success) {
            log.warn("[\u76d1\u63a7\u57cb\u70b9] alarmType:[{}],keyword1:[{}],keyword2:[{}]", new Object[]{LogWarnTypeEnum.\u5f00\u95f8\u5931\u8d25.name() + "-\u7aef\u7f51\u4e91", remoteSwitchRequest, objectResponse});
            this.alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), remoteSwitchRequest.getChannelId());
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"3002"));
            return;
        }
        RemoteSwitchResponse remoteSwitchResponse = new RemoteSwitchResponse();
        Object executeTime = stringObjectMap.get("executeTime");
        String image = (String)stringObjectMap.get("image");
        remoteSwitchResponse.setExecuteTime(Long.valueOf(executeTime == null ? DateTools.unixTimestamp() : (long)((Integer)executeTime).intValue()));
        if (image == null) {
            image = (String)this.redisUtils.get("PNC_FILEID_PROFILE_" + sendInfoRecord.getParkCode() + messageId, String.class);
        }
        remoteSwitchResponse.setImage(image);
        RemoteSwitchRequest.ExtraInfo extraInfo = (RemoteSwitchRequest.ExtraInfo)JsonUtils.parseObject((String)sendInfoRecord.getExtraInfo(), RemoteSwitchRequest.ExtraInfo.class, (Class[])new Class[0]);
        if (RemoteSwitchRequest.ExtraInfoEnum.CLOSE.val.equals(extraInfo.getBiz())) {
            CloseBrakeRequest closeBrakeRequest = (CloseBrakeRequest)JsonUtils.parseObject((String)JsonUtils.toString((Object)extraInfo.getRequestVO()), CloseBrakeRequest.class, (Class[])new Class[0]);
            OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
            BeanUtils.copyProperties((Object)closeBrakeRequest, (Object)openingDtoRequest);
            openingDtoRequest.setImgUrl(closeBrakeRequest.getImagePath() == null ? remoteSwitchResponse.getImage() : closeBrakeRequest.getImagePath() + "," + remoteSwitchResponse.getImage());
            openingDtoRequest.setExecuteTime(remoteSwitchResponse.getExecuteTime());
            openingDtoRequest.setSourcegate(Integer.valueOf(4));
            this.parkService.saveOpeningRecord(openingDtoRequest);
        } else if (RemoteSwitchRequest.ExtraInfoEnum.OPEN.val.equals(extraInfo.getBiz())) {
            this.addOpeningRecord(JsonUtils.parseObject((String)JsonUtils.toString((Object)extraInfo.getRequestVO()), OpenBrakeRequest.class, (Class[])new Class[0]), image, remoteSwitchResponse.getExecuteTime());
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(sendInfoRecord.getParkId());
            channelAlarm.setChannelCode(remoteSwitchRequest.getChannelId());
            channelAlarm.setStatus(Integer.valueOf(ChannelAlarm.Status.\u5df2\u5904\u7406.getStatus()));
            this.channelAlarmDao.update(channelAlarm);
        }
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
    }

    public void addOpeningRecord(Object openBrakeRequest, String image, Long executeTime) {
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        BeanUtils.copyProperties((Object)openBrakeRequest, (Object)openingDtoRequest);
        openingDtoRequest.setImgUrl(image);
        openingDtoRequest.setExecuteTime(executeTime);
        this.parkService.saveOpeningRecord(openingDtoRequest);
    }
}

