/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.RecCashRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncCashMsgReqeust;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncRecCashServiceImpl
extends AbstractService
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(PncRecCashServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        RecCashRequest recCashRequest = (RecCashRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), RecCashRequest.class);
        this.verifyParams(recCashRequest);
        PncCashMsgReqeust pncCashMsgReqeust = new PncCashMsgReqeust();
        pncCashMsgReqeust.setOrderId(recCashRequest.getOrderNum());
        pncCashMsgReqeust.setChannelId(tokenDeviceVo.getInandoutCode());
        pncCashMsgReqeust.setExpectCash(recCashRequest.getExpectCash());
        pncCashMsgReqeust.setTotalCashAmount(recCashRequest.getTotalCashAmount());
        pncCashMsgReqeust.setTotalCashNum(recCashRequest.getTotalCashNum());
        pncCashMsgReqeust.setDetails(recCashRequest.getDetails());
        String messageId = this.downHandle.signAndSend(tokenDeviceVo.getParkCode(), DownServiceEnum.\u63a5\u6536\u73b0\u91d1\u4e0b\u53d1.getServiceName(), pncCashMsgReqeust);
        AssertTools.notNull((Object)messageId, (String)"3003", (String)"\u4e0b\u53d1\u73b0\u91d1\u6536\u8d39\u901a\u77e5\u6d88\u606f\u5931\u8d25");
        return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest);
    }
}

