/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.DownPayCodeRequest;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.cloudcenter.domain.request.p2r.PayCodeRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncPayCodeRequest;
import com.icetech.cloudcenter.domain.response.p2c.P2rBaseResponse;
import com.icetech.cloudcenter.domain.vo.p2c.TokenDeviceVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.report.p2r.IRobotEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncPayCodeServiceImpl
extends AbstractService
implements IRobotEventService {
    private static final Logger log = LoggerFactory.getLogger(PncPayCodeServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;

    @Override
    public P2rBaseResponse executeEvent(P2rBaseRequest p2rBaseRequest, String cmd, TokenDeviceVo tokenDeviceVo) {
        PayCodeRequest payCodeRequest = (PayCodeRequest)JsonUtils.convert2bean((Object)p2rBaseRequest.getBizContent(), PayCodeRequest.class);
        this.verifyParams(payCodeRequest);
        PncPayCodeRequest pncPayCodeRequest = new PncPayCodeRequest();
        pncPayCodeRequest.setChannelId(tokenDeviceVo.getInandoutCode());
        pncPayCodeRequest.setOrderId(payCodeRequest.getOrderNum());
        pncPayCodeRequest.setPayCode(payCodeRequest.getPayCode());
        String messageId = this.downHandle.signAndSend(tokenDeviceVo.getParkCode(), cmd, pncPayCodeRequest);
        AssertTools.notNull((Object)messageId, (String)"3003", (String)"\u4e0b\u53d1\u652f\u4ed8\u7801\u63a8\u9001\u5931\u8d25");
        return P2rBaseResponse.success((P2rBaseRequest)p2rBaseRequest);
    }

    public ObjectResponse<String> downPayCode(DownPayCodeRequest downPayCodeRequest, String parkCode) {
        log.info("[\u7aef\u7f51\u4e91]\u4e0b\u53d1\u652f\u4ed8\u7801\u63a8\u9001,parkCode[{}],payCode[{}],channelId[{}],orderNum[{}]", new Object[]{parkCode, downPayCodeRequest.getPayCode(), downPayCodeRequest.getChannelId(), downPayCodeRequest.getOrderNum()});
        PncPayCodeRequest pncPayCodeRequest = new PncPayCodeRequest();
        pncPayCodeRequest.setChannelId(downPayCodeRequest.getChannelId());
        pncPayCodeRequest.setOrderId(downPayCodeRequest.getOrderNum());
        pncPayCodeRequest.setPayCode(downPayCodeRequest.getPayCode());
        String messageId = this.downHandle.signAndSend(parkCode, DownServiceEnum.\u652f\u4ed8\u7801\u4e0b\u53d1.getServiceName(), pncPayCodeRequest);
        AssertTools.notNull((Object)messageId, (String)"3003", (String)"\u4e0b\u53d1\u652f\u4ed8\u7801\u63a8\u9001\u5931\u8d25");
        return ObjectResponse.success();
    }
}

