/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NoplateExitService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncNoplateExitRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncNoplateExitServiceImpl
implements NoplateExitService,
NotifyService<NoplateExitRequest> {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> noplateExit(NoplateExitRequest noplateExitRequest) {
        String parkCode = noplateExitRequest.getParkCode();
        noplateExitRequest.setParkCode(null);
        PncNoplateExitRequest pncNoplateExitRequest = new PncNoplateExitRequest();
        BeanUtils.copyProperties((Object)noplateExitRequest, (Object)pncNoplateExitRequest);
        pncNoplateExitRequest.setInoutEvent(noplateExitRequest.getExitWay());
        pncNoplateExitRequest.setExTerminal(noplateExitRequest.getExitTerminal());
        pncNoplateExitRequest.setOperAccount(noplateExitRequest.getOperAccount());
        ObjectResponse parkObjectResponse = this.parkService.findByParkCode(parkCode);
        Park park = (Park)parkObjectResponse.getData();
        OrderInfo orderInfoParm = new OrderInfo();
        if (noplateExitRequest.getOrderNum() == null) {
            orderInfoParm.setPlateNum(pncNoplateExitRequest.getPlateNum());
        }
        orderInfoParm.setOrderNum(noplateExitRequest.getOrderNum());
        orderInfoParm.setParkId(park.getId());
        ObjectResponse orderInfoObjectResponse = this.orderService.findByOrderInfo(orderInfoParm);
        if (ObjectResponse.isSuccess((Response)orderInfoObjectResponse)) {
            OrderInfo orderInfo = (OrderInfo)orderInfoObjectResponse.getData();
            pncNoplateExitRequest.setOrderId(orderInfo.getLocalOrderNum());
            String messageId = this.downHandle.signAndSendAsyncResult(park.getId(), parkCode, park.getKey(), DownServiceEnum.\u65e0\u724c\u8f66\u79bb\u573a.getServiceName(), pncNoplateExitRequest, pncNoplateExitRequest.getChannelId(), noplateExitRequest.getTopic(), null);
            if (messageId != null) {
                return ObjectResponse.failed((String)"12002", (String)messageId);
            }
        } else {
            this.alarmService.switchFailHandler(parkCode, park.getId(), noplateExitRequest.getChannelId());
            return ObjectResponse.failed((String)"3002", (String)"\u5f53\u524d\u8f66\u8f86\u4e0d\u5728\u573a\u5185");
        }
        this.alarmService.switchFailHandler(parkCode, park.getId(), noplateExitRequest.getChannelId());
        return ObjectResponse.failed((String)"3002");
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<NoplateExitRequest> sendInfoRecord) {
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }
}

