/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.NoplateEnterService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NoplateEnterRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncNoplateEnterServiceImpl
implements NoplateEnterService,
NotifyService<NoplateEnterRequest> {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private AlarmService alarmService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> noplateEnter(NoplateEnterRequest noplateEnterRequest) {
        String parkCode = noplateEnterRequest.getParkCode();
        noplateEnterRequest.setParkCode(null);
        String messageId = this.downHandle.signAndSendAsyncResult(parkCode, DownServiceEnum.\u65e0\u724c\u8f66\u5165\u573a.getServiceName(), noplateEnterRequest, noplateEnterRequest.getTopic());
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            this.alarmService.switchFailHandler(parkCode, null, noplateEnterRequest.getChannelId());
            return ObjectResponse.failed((String)"500", (String)"\u4e0b\u53d1\u6d88\u606f\u5931\u8d25");
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<NoplateEnterRequest> sendInfoRecord) {
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
    }
}

