/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.ChannelRuleExtendRequest;
import com.icetech.cloudcenter.domain.request.pnc.ChannelRulesRequest;
import com.icetech.cloudcenter.domain.request.pnc.DeviceRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkConfigRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.domain.entity.park.ChannelRuleExtend;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.pnc.impl.ParkConfigServiceImpl;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.park.ChannelRuleExtendService;
import com.icetech.third.utils.RedisUtils;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PassageWayConfServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(PassageWayConfServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkConfigServiceImpl parkConfigDownService;
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private ChannelRuleExtendService channelRuleExtendService;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        int versionIndex = PncVersionEnum.getIndex((String)version);
        if (versionIndex < PncVersionEnum.\u7248\u672c4.getIndex()) {
            log.info("\u7aef\u7f51\u4e91\u8f66\u573a[{}]\u7248\u672c\u8fc7\u4f4e: [{}] -> [{}]", new Object[]{sendRequest.getParkId(), version, versionIndex});
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c4.getVersion()));
        }
        ObjectResponse channelResp = this.parkService.getInoutDeviceById(serviceId);
        if (!ObjectResponse.isSuccess((Response)channelResp)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u672a\u627e\u5230\u901a\u9053\u4fe1\u606f"));
        }
        ParkInoutdevice channel = (ParkInoutdevice)channelResp.getData();
        log.debug("\u6839\u636e\u901a\u9053ID[{}]\u67e5\u8be2\u5230\u901a\u9053\u4fe1\u606f\uff1a{}", (Object)serviceId, (Object)channel);
        ParkConfig parkConfig = null;
        ChannelRulesRequest channelRulesRequest = new ChannelRulesRequest();
        if (channel.getStatus() == 1) {
            channelRulesRequest.setOperType(Integer.valueOf(3));
            channelRulesRequest.setInandoutCode(channel.getInandoutCode());
        } else {
            ObjectResponse configObjectResponse;
            ObjectResponse parkRegionById;
            channelRulesRequest.setInandoutCode(channel.getInandoutCode());
            if (channel.getRegionId() != null && ObjectResponse.isSuccess((Response)(parkRegionById = this.parkService.getParkRegionById(channel.getRegionId())))) {
                ParkRegion data = (ParkRegion)parkRegionById.getData();
                channelRulesRequest.setRegionCode(data.getRegionCode());
            }
            if (!ObjectResponse.isSuccess((Response)(configObjectResponse = this.parkService.getParkConfig(sendRequest.getParkId())))) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8f66\u573a\u914d\u7f6e\u672a\u627e\u5230"));
            }
            parkConfig = (ParkConfig)configObjectResponse.getData();
            int rangeType = NumberUtils.toPrimitive((Integer)channel.getRangeType(), (int)1);
            channelRulesRequest.setRangeType(Integer.valueOf(rangeType));
            channelRulesRequest.setDiffWorkDay(Integer.valueOf(NumberUtils.toPrimitive((Integer)channel.getDiffWorkDay(), (int)0)));
            channelRulesRequest.setIsMaster(channel.getIsMaster());
            channelRulesRequest.setInandoutName(channel.getInandoutName());
            channelRulesRequest.setIsOpenVaguetype(channel.getIsOpenVaguetype());
            channelRulesRequest.setVagueType(channel.getVaguetype());
            channelRulesRequest.setInandoutType(channel.getInandoutType());
            channelRulesRequest.setIsCharge(channel.getIsFee());
            if (rangeType == 1) {
                channelRulesRequest.setIsAllowTempcarrun(channel.getIsAllowTempcarrun());
                channelRulesRequest.setIsAllowNocardrun(channel.getIsAllowNocardrun());
                channelRulesRequest.setIsAllowYellowcarrun(channel.getIsAllowYellowcarrun());
                channelRulesRequest.setIsAllowNewenergycarrun(channel.getIsAllowNewenergycarrun());
                channelRulesRequest.setIsAllowVisitCar(channel.getIsAllowVisitCar());
                channelRulesRequest.setIsAllowMonthCar(channel.getIsAllowMonthCar());
                if (channel.getIsAllowMonthCar() != null && channel.getIsAllowMonthCar() == 1) {
                    channelRulesRequest.setOverTimeDay(parkConfig.getOverTimeDay());
                    channelRulesRequest.setIsOverTimeMonth(parkConfig.getIsAllowOvertimeCar());
                }
                channelRulesRequest.setOverTimeMonthlyCard(parkConfig.getIsExpireMc());
                channelRulesRequest.setExpireMcDays(parkConfig.getExpireMcDays());
                channelRulesRequest.setIsAllowBackCar(channel.getIsAllowBackCar());
                channelRulesRequest.setIsAllowABcar(channel.getIsAllowAbcar());
                channelRulesRequest.setIsAllowBluerun(channel.getIsAllowBluerun());
                channelRulesRequest.setIsAllowStoredCar(channel.getIsAllowStoredCar());
                channelRulesRequest.setIsVipCar(channel.getIsAllowVipCar());
                if (channel.getIsAllowVipCar() != null && channel.getIsAllowVipCar() == 1) {
                    channelRulesRequest.setVipCarType(channel.getVipCarTypeId());
                }
            } else {
                List<ChannelRuleExtend> channelRuleExtends = this.channelRuleExtendService.getChannelRuleExtendsByChannelId(channel.getId());
                ArrayList<ChannelRuleExtendRequest> channelRuleExtendRequests = new ArrayList<ChannelRuleExtendRequest>();
                for (ChannelRuleExtend channelRuleExtend : channelRuleExtends) {
                    ChannelRuleExtendRequest channelRuleExtendRequest = new ChannelRuleExtendRequest();
                    BeanUtils.copyProperties((Object)channelRuleExtend, (Object)channelRuleExtendRequest);
                    if (channelRuleExtend.getStartDate() != null) {
                        channelRuleExtendRequest.setStartDate(DateTools.getFormat((String)"yyyy-MM-dd", (Date)channelRuleExtend.getStartDate()));
                    }
                    if (channelRuleExtend.getEndDate() != null) {
                        channelRuleExtendRequest.setEndDate(DateTools.getFormat((String)"yyyy-MM-dd", (Date)channelRuleExtend.getEndDate()));
                    }
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
                    if (channelRuleExtend.getStartTime() != null) {
                        channelRuleExtendRequest.setStartTime(channelRuleExtend.getStartTime().format(dtf));
                    }
                    if (channelRuleExtend.getEndTime() != null) {
                        channelRuleExtendRequest.setEndTime(channelRuleExtend.getEndTime().format(dtf));
                    }
                    channelRuleExtendRequest.setIsVipCar(channelRuleExtend.getIsAllowVipCar());
                    channelRuleExtendRequest.setVipCarType(channelRuleExtend.getVipCarTypeId());
                    channelRuleExtendRequest.setIsAllowABcar(channelRuleExtend.getIsAllowAbcar());
                    if (channelRuleExtend.getIsAllowMonthCar() != null && channelRuleExtend.getIsAllowMonthCar() == 1) {
                        channelRuleExtendRequest.setOverTimeDay(parkConfig.getOverTimeDay());
                        channelRuleExtendRequest.setIsOverTimeMonth(parkConfig.getIsAllowOvertimeCar());
                    }
                    channelRulesRequest.setOverTimeMonthlyCard(parkConfig.getIsExpireMc());
                    channelRulesRequest.setExpireMcDays(parkConfig.getExpireMcDays());
                    channelRuleExtendRequests.add(channelRuleExtendRequest);
                }
                channelRulesRequest.setChannelRules(channelRuleExtendRequests);
            }
            channelRulesRequest.setScreenType(channel.getDisplayTerminal());
            if (channel.getDisplayTerminal() == 2) {
                channelRulesRequest.setIsSupportTTS(Integer.valueOf(1));
            } else if (channel.getTtsType() == 1) {
                channelRulesRequest.setIsSupportTTS(Integer.valueOf(1));
            } else {
                channelRulesRequest.setIsSupportTTS(Integer.valueOf(2));
            }
            channelRulesRequest.setCtrlCardModel(channel.getLedcardType());
            ObjectResponse deviceListByChannelId = this.parkDeviceService.getDeviceListByChannelId(channel.getId(), null);
            if (ObjectResponse.isSuccess((Response)deviceListByChannelId)) {
                ArrayList<DeviceRequest> list = new ArrayList<DeviceRequest>();
                List data = (List)deviceListByChannelId.getData();
                for (int i = 0; i < data.size(); ++i) {
                    ParkDevice parkDevice = (ParkDevice)data.get(i);
                    DeviceRequest deviceRequest = null;
                    if (parkDevice.getType() == 1) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 2) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 3) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 5) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                        deviceRequest.setPort(Integer.valueOf(parkDevice.getPort()));
                        deviceRequest.setIsMaster(parkDevice.getIsMaster());
                    } else if (parkDevice.getType() == 8) {
                        deviceRequest = new DeviceRequest();
                        deviceRequest.setDeviceCode(parkDevice.getDeviceNo());
                        deviceRequest.setType(parkDevice.getType());
                        deviceRequest.setIp(parkDevice.getIp());
                    }
                    if (Objects.isNull(deviceRequest)) continue;
                    list.add(deviceRequest);
                }
                channelRulesRequest.setDevices(list);
            }
        }
        String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceName(), channelRulesRequest, serviceId);
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        if (sendRequest.getTaskId() != null && versionIndex < PncVersionEnum.\u7248\u672c2400.getIndex() && channel.getStatus() != 1 && parkConfig != null) {
            ObjectResponse parkResp = this.parkService.findByParkId(parkConfig.getParkId());
            Park park = (Park)parkResp.getData();
            ParkConfigRequest parkConfigRequest = this.parkConfigDownService.buildRequest(park, parkConfig, channel);
            messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceName(), parkConfigRequest, serviceId);
            if (StringUtils.isEmpty((CharSequence)messageId)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
        }
        return ObjectResponse.success();
    }
}

