/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.ParkRegionRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.utils.RedisUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParkRegionServiceImpl
extends AbstractService
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(ParkRegionServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ChargeService chargeService;
    @Autowired
    private RedisUtils redisUtils;

    public ObjectResponse send(SendRequest sendRequest) {
        String messageId;
        Long serviceId = sendRequest.getServiceId();
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.getIndex((String)PncVersionEnum.\u7248\u672c4.getVersion())) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c4.getVersion()));
        }
        ObjectResponse parkRegionById = this.parkService.getParkRegionById(serviceId);
        if (!ObjectResponse.isSuccess((Response)parkRegionById)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8f66\u573a\u533a\u57df\u672a\u627e\u5230"));
        }
        ParkRegionRequest parkRegionRequest = new ParkRegionRequest();
        ParkRegion region = (ParkRegion)parkRegionById.getData();
        parkRegionRequest.setRegionCode(region.getRegionCode());
        parkRegionRequest.setRegionName(region.getRegionName());
        parkRegionRequest.setOperType(Integer.valueOf(1));
        parkRegionRequest.setIsNewEnergyDiffBill(Integer.valueOf(region.getIsNewEnergyDiffBill() == null ? 0 : region.getIsNewEnergyDiffBill()));
        if (region.getStatus() == 1) {
            parkRegionRequest.setOperType(Integer.valueOf(3));
        }
        parkRegionRequest.setRegionTotalPark(region.getRegionPark());
        parkRegionRequest.setFreeSpace(region.getFreePark());
        parkRegionRequest.setIsSonRegion(Integer.valueOf(region.getRegionType() == null ? 2 : region.getRegionType()));
        if (region.getFatherRelationId() == 0L) {
            parkRegionRequest.setRegionType(Integer.valueOf(0));
        } else {
            parkRegionRequest.setRegionType(Integer.valueOf(1));
            ObjectResponse parkRegionById1 = this.parkService.getParkRegionById(region.getFatherRelationId());
            if (ObjectResponse.isSuccess((Response)parkRegionById1)) {
                ParkRegion data1 = (ParkRegion)parkRegionById1.getData();
                parkRegionRequest.setParentCode(data1.getRegionCode());
            }
        }
        parkRegionRequest.setIsFullForbidEnter(region.getIsFullForbidenter());
        parkRegionRequest.setIsFullForbidMonthEnter(region.getIsFullForbidMonthEnter());
        parkRegionRequest.setIsFullForbidVIPEnter(region.getIsFullForbidVIPEnter());
        parkRegionRequest.setVipCarType(region.getVipCarTypeId());
        parkRegionRequest.setIsFullForbidReservEnter(region.getIsFullForbidReservEnter());
        parkRegionRequest.setIsFullForbidBlackEnter(region.getIsFullForbidblackenter());
        parkRegionRequest.setIsFullForbidStoreEnter(region.getIsFullForbidStoreEnter());
        parkRegionRequest.setFullEmptyNum(region.getFullEmptynum());
        ObjectResponse configs = this.chargeService.getRegionConfigs(sendRequest.getParkId());
        if (ObjectResponse.isSuccess((Response)configs)) {
            List list = (List)configs.getData();
            for (int i = 0; i < list.size(); ++i) {
                RegionChargeconfig parkChargeconfig = (RegionChargeconfig)list.get(i);
                if (parkChargeconfig.getRegionId().intValue() != region.getId().intValue()) continue;
                if (parkChargeconfig.getLicensePlateType() == 0) {
                    parkRegionRequest.setDefaultBill(parkChargeconfig.getBilltypecode());
                    continue;
                }
                if (parkChargeconfig.getLicensePlateType() == 3) {
                    parkRegionRequest.setBlueCarBill(parkChargeconfig.getBilltypecode());
                    continue;
                }
                if (parkChargeconfig.getLicensePlateType() == 1) {
                    parkRegionRequest.setNewEnergyCarBill(parkChargeconfig.getBilltypecode());
                    continue;
                }
                if (parkChargeconfig.getLicensePlateType() == 5) {
                    parkRegionRequest.setFixedCarBill(parkChargeconfig.getBilltypecode());
                    continue;
                }
                if (parkChargeconfig.getLicensePlateType() == 4) {
                    parkRegionRequest.setYellowCarBill(parkChargeconfig.getBilltypecode());
                    continue;
                }
                if (parkChargeconfig.getLicensePlateType() == 6) {
                    parkRegionRequest.setStoredCardBill(parkChargeconfig.getBilltypecode());
                    continue;
                }
                if (parkChargeconfig.getLicensePlateType() != 7) continue;
                parkRegionRequest.setNewEnergyPureEleCarBill(parkChargeconfig.getBilltypecode());
            }
        }
        if (StringUtils.isEmpty((CharSequence)(messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u533a\u57df\u4fe1\u606f\u548c\u8ba1\u8d39\u89c4\u5219\u5173\u8054\u5173\u7cfb.getServiceName(), parkRegionRequest, serviceId)))) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }
}

