/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.pnc.ParkConfigRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.park.service.down.pnc.impl.PassageWayConfServiceImpl;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.RedisUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class ParkConfigServiceImpl
extends AbstractService
implements DownSendService {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private PassageWayConfServiceImpl passageWayConfServiceImpl;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Value(value="${notpay.tag.days:7}")
    private Integer notPayTagDaysConfig = 7;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        String version = (String)this.redisUtils.hGet("pnc:version", String.valueOf(sendRequest.getParkId()), String.class);
        if (version == null) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u627e\u4e0d\u5230\u8f66\u573a\u7248\u672c"));
        }
        if (PncVersionEnum.getIndex((String)version) < PncVersionEnum.getIndex((String)PncVersionEnum.\u7248\u672c4.getVersion())) {
            return ObjectResponse.failed((String)"407", (String)TextConstant.getVersionMessage((String)version, (String)PncVersionEnum.\u7248\u672c4.getVersion()));
        }
        ObjectResponse parkResp = this.parkService.findByParkId(sendRequest.getParkId());
        if (!ObjectResponse.isSuccess((Response)parkResp)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u672a\u627e\u5230\u8f66\u573a"));
        }
        Park park = (Park)parkResp.getData();
        ParkConfigRequest parkConfigRequest = this.buildRequest(park);
        if (parkConfigRequest != null) {
            String messageId = this.downHandle.signAndSend(sendRequest.getParkId(), DownServiceEnum.\u8f66\u573a\u914d\u7f6e.getServiceName(), parkConfigRequest, serviceId);
            if (Objects.isNull(messageId)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
            }
            List parkInoutDevices = this.parkInoutdeviceDao.selectByParkId(park.getId());
            if (CollectionUtils.isNotEmpty((Collection)parkInoutDevices)) {
                parkInoutDevices.forEach(parkInoutDevice -> {
                    SendRequest inoutDeviceRequest = new SendRequest();
                    inoutDeviceRequest.setServiceId(parkInoutDevice.getId());
                    inoutDeviceRequest.setParkId(park.getId());
                    inoutDeviceRequest.setServiceType(DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType());
                    this.passageWayConfServiceImpl.send(inoutDeviceRequest);
                });
            }
        }
        return ObjectResponse.success();
    }

    protected ParkConfigRequest buildRequest(Park park) {
        ObjectResponse parkConfigResp = this.parkService.getParkConfig(park.getParkCode());
        if (!ObjectResponse.isSuccess((Response)parkConfigResp)) {
            return null;
        }
        ParkConfig parkConfig = (ParkConfig)parkConfigResp.getData();
        SendInfo sendInfo = this.sendinfoDao.selectLastSend(parkConfig.getParkId().longValue(), DownServiceEnum.\u901a\u9053\u4fe1\u606f.getServiceType().intValue());
        ParkInoutdevice channel = null;
        if (sendInfo != null) {
            ObjectResponse channelResp = this.parkService.getInoutDeviceById(sendInfo.getServiceId());
            channel = (ParkInoutdevice)channelResp.getData();
        }
        if (channel == null || channel.getStatus() != 0) {
            channel = (ParkInoutdevice)this.parkInoutdeviceDao.selectLimitOne((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ParkInoutdevice.class).eq(ParkInoutdevice::getParkId, (Object)parkConfig.getParkId())).eq(ParkInoutdevice::getStatus, (Object)0)).orderByDesc(ParkInoutdevice::getId));
        }
        return this.buildRequest(park, parkConfig, channel);
    }

    protected ParkConfigRequest buildRequest(Park park, ParkConfig parkConfig, ParkInoutdevice channel) {
        Optional<ParkRegion> first;
        List parkRegions;
        ParkConfigRequest parkConfigRequest = new ParkConfigRequest();
        parkConfigRequest.setIsMidfield(park.getIsInterior());
        parkConfigRequest.setSwitchFeeTime(park.getSwitchFeeTime());
        parkConfigRequest.setProvinceName(park.getProvinceAbbr());
        parkConfigRequest.setParkName(park.getParkName());
        ObjectResponse parkSpaceResponse = this.parkService.getParkSpace(parkConfig.getParkId());
        if (ObjectResponse.isSuccess((Response)parkSpaceResponse)) {
            ParkFreespace parkFreespace = (ParkFreespace)parkSpaceResponse.getData();
            parkConfigRequest.setTotalPark(parkFreespace.getTotalNum());
            parkConfigRequest.setFreePark(Integer.valueOf(Math.toIntExact(parkFreespace.getFreeSpace().intValue())));
        }
        if (CollectionUtils.isNotEmpty((Collection)(parkRegions = this.parkRegionDao.selectByParkid(park.getId()))) && (first = parkRegions.stream().filter(parkRegion -> Long.valueOf(0L).equals(parkRegion.getFatherRelationId())).findFirst()).isPresent()) {
            ParkRegion parkRegion2 = first.get();
            parkConfigRequest.setIsFullForbidEnter(parkRegion2.getIsFullForbidenter());
            parkConfigRequest.setIsFullForbidMonthEnter(parkRegion2.getIsFullForbidMonthEnter());
            parkConfigRequest.setIsFullForbidVIPEnter(parkRegion2.getIsFullForbidVIPEnter());
            parkConfigRequest.setIsFullForbidReservEnter(parkRegion2.getIsFullForbidReservEnter());
            parkConfigRequest.setIsFullForbidStoreEnter(parkRegion2.getIsFullForbidStoreEnter());
            parkConfigRequest.setFullEmptyNum(parkRegion2.getFullEmptynum());
            String collect = parkRegions.stream().map(ParkRegion::getVipCarTypeId).collect(Collectors.joining(","));
            collect = Arrays.stream(collect.split(",")).distinct().collect(Collectors.joining(","));
            parkConfigRequest.setVipCarType(collect);
            parkConfigRequest.setIsFullForbidBlackEnter(parkRegion2.getIsFullForbidblackenter());
        }
        parkConfigRequest.setFreeTimeStatus(parkConfig.getFreetimeStatus());
        parkConfigRequest.setBilPrecision(parkConfig.getBillPrecision());
        parkConfigRequest.setIsFillTime(parkConfig.getIsFilltime());
        parkConfigRequest.setIsRounding(parkConfig.getIsnotgetsmallchange());
        parkConfigRequest.setIsFreeAfterPay(parkConfig.getIsfreeAfterpay(Integer.valueOf(15)));
        parkConfigRequest.setOverTimeBillType(parkConfig.getOvertimeBillType());
        parkConfigRequest.setIsAllowFreeTmonce(parkConfig.getIsallowfreetmonce());
        parkConfigRequest.setIsFixedFee(parkConfig.getIsfixedfees());
        parkConfigRequest.setIsVisit(parkConfig.getIsVisit());
        parkConfigRequest.setVisitIscharge(parkConfig.getVisitIscharge());
        parkConfigRequest.setIsMultipleVehicles(parkConfig.getIssupAbmanage());
        parkConfigRequest.setMultipleBillType(parkConfig.getSwitchType());
        if (channel == null) {
            if (parkConfig.getDisplayTerminal() == 2) {
                parkConfigRequest.setIsSupportTTS(Integer.valueOf(1));
            } else if (parkConfig.getTtsType() == 1) {
                parkConfigRequest.setIsSupportTTS(Integer.valueOf(1));
            } else {
                parkConfigRequest.setIsSupportTTS(Integer.valueOf(2));
            }
            parkConfigRequest.setCtrlCardModel(parkConfig.getLedcardType());
            parkConfigRequest.setScreenType(parkConfig.getDisplayTerminal());
        } else {
            if (channel.getDisplayTerminal() == 2) {
                parkConfigRequest.setIsSupportTTS(Integer.valueOf(1));
            } else if (channel.getTtsType() == 1) {
                parkConfigRequest.setIsSupportTTS(Integer.valueOf(1));
            } else {
                parkConfigRequest.setIsSupportTTS(Integer.valueOf(2));
            }
            parkConfigRequest.setCtrlCardModel(channel.getLedcardType());
            parkConfigRequest.setScreenType(channel.getDisplayTerminal());
        }
        parkConfigRequest.setMultipleTime(parkConfig.getSwitchTm());
        if (!Objects.isNull(parkConfig.getIsfixedfees()) && parkConfig.getIsfixedfees() == 1) {
            parkConfigRequest.setFixedFeeValue(parkConfig.getFixedfeevalue());
        }
        if (parkConfig.getIsEpayment() == 1) {
            parkConfigRequest.setIsEpayMent(Integer.valueOf(1));
            if (parkConfig.getEPayment().contains("WX")) {
                parkConfigRequest.setEpayMentType(Integer.valueOf(1));
            } else if (parkConfig.getEPayment().contains("CMBC")) {
                parkConfigRequest.setEpayMentType(Integer.valueOf(2));
            } else if (parkConfig.getEPayment().contains("CCB_PAY")) {
                parkConfigRequest.setEpayMentType(Integer.valueOf(3));
            } else if (parkConfig.getEPayment().contains("ABC")) {
                parkConfigRequest.setEpayMentType(Integer.valueOf(4));
            } else if (!parkConfig.getEPayment().contains("YZ") && parkConfig.getEPayment().contains("PARKING")) {
                parkConfigRequest.setEpayMentType(Integer.valueOf(6));
            }
        } else {
            parkConfigRequest.setIsEpayMent(Integer.valueOf(0));
        }
        if (parkConfig.getIsNosenpayment() == 1) {
            parkConfigRequest.setIsNosenPayMent(Integer.valueOf(1));
            String noSenPayment = parkConfig.getNoSenPayment();
            if (noSenPayment.contains("UNION")) {
                parkConfigRequest.setNosenPayMentType(Integer.valueOf(0));
            } else if (noSenPayment.contains("CCB")) {
                parkConfigRequest.setNosenPayMentType(Integer.valueOf(1));
            } else if (noSenPayment.contains("ABC")) {
                parkConfigRequest.setNosenPayMentType(Integer.valueOf(2));
            }
        } else {
            parkConfigRequest.setIsNosenPayMent(Integer.valueOf(0));
        }
        parkConfigRequest.setMonetaryUnit(parkConfig.getMoneyunitType());
        parkConfigRequest.setIsReleaseFreetm(parkConfig.getIsreleaseFreetm());
        parkConfigRequest.setIsFreeSpecialCar(parkConfig.getIsfreeSpecialcar());
        parkConfigRequest.setIsCarDcount(parkConfig.getIsCardcount());
        parkConfigRequest.setVisitIscharge(parkConfig.getVisitIscharge());
        parkConfigRequest.setIsNoplateRepeatenter(parkConfig.getIsNoplateRepeatenter());
        parkConfigRequest.setIsUpImage(parkConfig.getIsupimage());
        parkConfigRequest.setIsSynDataToOut(parkConfig.getIsSync());
        parkConfigRequest.setDualCameraTime(parkConfig.getDualcameraTime());
        if (NumberUtils.toPrimitive((Integer)parkConfig.getFilterTime()) > 0) {
            parkConfigRequest.setFilterTime(parkConfig.getFilterTime());
            parkConfigRequest.setPlateFilterType(parkConfig.getPlateFilterType());
            if (NumberUtils.toPrimitive((Integer)parkConfig.getPlateFilterType(), (int)1) == 1) {
                parkConfigRequest.setIsInOutPass(Integer.valueOf(1));
                parkConfigRequest.setEnexMinTime(parkConfig.getFilterTime());
                parkConfigRequest.setExenMinTime(parkConfig.getFilterTime());
            } else {
                parkConfigRequest.setIsInOutPass(Integer.valueOf(2));
            }
        } else {
            parkConfigRequest.setIsInOutPass(Integer.valueOf(2));
        }
        parkConfigRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig());
        parkConfigRequest.setBillVersion(Integer.valueOf(parkConfig.getChargeVersionNum() == null ? 1 : parkConfig.getChargeVersionNum() + 1));
        parkConfigRequest.setIsNocardCheck(parkConfig.getIsNocardCheck());
        parkConfigRequest.setFreeCarReenter(parkConfig.getFreeCarReenter());
        parkConfigRequest.setCalcSpaceMethod(Integer.valueOf(parkConfig.getCalcSpaceMethod(Integer.valueOf(1))));
        parkConfigRequest.setDelOrderCalcSpaceFlag(Integer.valueOf(parkConfig.getDelOrderCalcSpaceFlag(Integer.valueOf(0))));
        parkConfigRequest.setCarenexTimelong(parkConfig.getCarenexTimelong());
        parkConfigRequest.setRetentionAlarmMethod(parkConfig.getRetentionAlarmMethod());
        parkConfigRequest.setRetentionIntervalTime(parkConfig.getRetentionIntervalTime());
        parkConfigRequest.setRetentionCancelTime(parkConfig.getRetentionCancelTime());
        ParkDiscountUsercharge parkDiscountUsercharge = this.parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkConfig.getParkId());
        parkConfigRequest.setPlateGetCoupons(Integer.valueOf(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getPlateGetCoupons() : 1));
        parkConfigRequest.setSupportStackeUsage(Integer.valueOf(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getSupportStackeUsage() : 2));
        parkConfigRequest.setThirdpartyStackeUsage(Integer.valueOf(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getThirdpartyStackeUsage() : 1));
        parkConfigRequest.setUserMultipleTimes(Integer.valueOf(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getUserMultipleTimes() : 2));
        parkConfigRequest.setSametypeTogetherUser(Objects.nonNull(parkDiscountUsercharge) ? parkDiscountUsercharge.getSametypeTogetherUser() : null);
        parkConfigRequest.setInparkRenewType(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getInparkRenewType(), (int)1)));
        parkConfigRequest.setTimeoutRenewType(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getTimeoutRenewType(), (int)1)));
        parkConfigRequest.setDeniedAddOrder(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getDeniedAddOrder(), (int)0)));
        if (NumberUtils.toPrimitive((Integer)parkConfig.getEnableReenterBlack()) == 1) {
            parkConfigRequest.setReenterBlackTime(parkConfig.getReenterBlackTime());
        }
        parkConfigRequest.setEnterpayType(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getEnterpayType(), (int)0)));
        parkConfigRequest.setEnterpayRangeDay(parkConfig.getEnterpayRangeDay());
        parkConfigRequest.setNoenterHandleType(parkConfig.getNoenterHandleType());
        if (Objects.nonNull(parkConfig.getNoenterHandleType())) {
            if (parkConfig.getNoenterHandleType() == 2 && parkConfig.getIsfixedfees() != null && parkConfig.getIsfixedfees() == 1) {
                parkConfigRequest.setIsFixedFee(Integer.valueOf(1));
                parkConfigRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig());
                parkConfigRequest.setFixedFeeValue(parkConfig.getFixedfeevalue());
            }
            if (parkConfig.getNoenterHandleType() == 3) {
                parkConfigRequest.setIsFixedFee(Integer.valueOf(1));
                parkConfigRequest.setFixedFeeValue(parkConfig.getFixedfeevalue());
                parkConfigRequest.setFixedFeeValueBig(parkConfig.getFixedFeeValueBig());
            }
        }
        parkConfigRequest.setRelLastenterRange(parkConfig.getRelLastenterRange());
        parkConfigRequest.setExitpayType(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getExitpayType(), (int)0)));
        parkConfigRequest.setExitpayRangeDay(parkConfig.getExitpayRangeDay());
        parkConfigRequest.setNotpayTagDays(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getNotpayTagDays(), (int)this.notPayTagDaysConfig)));
        boolean isOpenFlag = Integer.valueOf(1).equals(parkConfig.getIsNewenergyCharge());
        if (isOpenFlag) {
            parkConfigRequest.setNewEnergyDiscountMinutes(Integer.valueOf(NumberUtils.toPrimitive((Integer)parkConfig.getNewEnergyDiscountMinutes(), (int)0)));
        }
        return parkConfigRequest;
    }
}

