/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.OrderEnterService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.OrderEnterRequest;
import com.icetech.cloudcenter.domain.request.pnc.BatchDelBizRequest;
import com.icetech.cloudcenter.domain.response.ParkVisitDto;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderEnterServiceImpl
implements OrderEnterService,
DownSendService {
    private static final Logger log = LoggerFactory.getLogger(OrderEnterServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private ParkVisitService parkVisitService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkVisitDao parkVisitDao;

    public ObjectResponse orderEnter(OrderEnterRequest orderEnterRequest) {
        try {
            String parkCode = orderEnterRequest.getParkCode();
            orderEnterRequest.setParkCode(null);
            String messageId = this.downHandle.signAndSend(parkCode, DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceName(), orderEnterRequest);
            AssertTools.notNull((Object)messageId, (String)"410", (String)"\u8ba2\u5355\u5165\u573a\u5931\u8d25");
            return ObjectResponse.success();
        }
        catch (ResponseBodyException responseBodyException) {
            return ObjectResponse.failed((String)responseBodyException.getErrCode());
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)"500");
        }
    }

    public ObjectResponse send(SendRequest sendRequest) {
        if (StringUtils.isNotEmpty((CharSequence)sendRequest.getInclude()) && "2".equals(sendRequest.getInclude())) {
            return this.batchSend(Collections.singletonList(sendRequest), sendRequest.getParkId(), null);
        }
        try {
            ObjectResponse objectResponse = this.parkVisitService.selectVisitByid(sendRequest.getServiceId());
            if (!ObjectResponse.isSuccess((Response)objectResponse)) {
                return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u672a\u627e\u5230\u9884\u7ea6\u8f66\u4fe1\u606f"));
            }
            if (ObjectResponse.isSuccess((Response)objectResponse)) {
                ParkVisitDto parkVisitDto = (ParkVisitDto)objectResponse.getData();
                String[] split = parkVisitDto.getPlateNums().split(",");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ObjectResponse parkConfig = this.parkService.getParkConfig(parkVisitDto.getParkCode());
                if (!ObjectResponse.isSuccess((Response)parkConfig)) {
                    return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8f66\u573a\u914d\u7f6e\u672a\u627e\u5230"));
                }
                Integer visitIscharge = 0;
                if (ObjectResponse.isSuccess((Response)parkConfig)) {
                    visitIscharge = ((ParkConfig)parkConfig.getData()).getVisitIscharge();
                }
                for (int i = 0; i < split.length; ++i) {
                    OrderEnterRequest orderEnterRequest = new OrderEnterRequest();
                    orderEnterRequest.setVisitId(parkVisitDto.getId());
                    orderEnterRequest.setParkCode(null);
                    orderEnterRequest.setIsFree(Integer.valueOf(visitIscharge == 1 ? 0 : 1));
                    orderEnterRequest.setPlateNum(split[i]);
                    orderEnterRequest.setStartTime(Long.valueOf(simpleDateFormat.parse(parkVisitDto.getStartTime()).getTime() / 1000L));
                    orderEnterRequest.setEndTime(Long.valueOf(simpleDateFormat.parse(parkVisitDto.getEndTime()).getTime() / 1000L));
                    orderEnterRequest.setIsAllowManyTimes(parkVisitDto.getInoutMore());
                    if (ParkVisitMoreType.CUSTOM.getType().equals(parkVisitDto.getInoutMore())) {
                        orderEnterRequest.setAllowVisitNum(parkVisitDto.getInoutNum());
                    }
                    System.out.println("\u8bf7\u6c42\u6570\u636e" + JsonUtils.toString((Object)orderEnterRequest));
                    String messageId = this.downHandle.signAndSend(parkVisitDto.getParkCode(), DownServiceEnum.\u8f66\u8f86\u9884\u7ea6.getServiceName(), orderEnterRequest, sendRequest.getServiceId());
                    if (!StringUtils.isEmpty((CharSequence)messageId)) continue;
                    return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
                }
            }
        }
        catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), (Throwable)e);
            return ObjectResponse.failed((String)"410", (String)"\u8f66\u8f86\u9884\u7ea6\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
    }

    public ObjectResponse batchSend(List<SendRequest> sendRequestList, Long parkId, String parkCode) {
        List<Long> ids = sendRequestList.stream().map(SendRequest::getServiceId).filter(Objects::nonNull).collect(Collectors.toList());
        List<ParkVisit> lists = this.parkVisitDao.findAllByIds(ids, Boolean.TRUE);
        if (CollectionUtils.isEmpty(lists)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u672a\u627e\u5230\u8bbf\u5ba2\u8f66\u8f86\u4fe1\u606f"));
        }
        BatchDelBizRequest batchDelBizRequest = new BatchDelBizRequest();
        batchDelBizRequest.setServiceType(Integer.valueOf(5));
        batchDelBizRequest.setServiceIds(ids);
        batchDelBizRequest.setIdList(lists.stream().map(a -> String.valueOf(a.getId())).collect(Collectors.toList()));
        String messageId = this.downHandle.signAndSend(parkId, DownServiceEnum.\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e.getServiceName(), batchDelBizRequest);
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8bbf\u5ba2\u8f66\u8f86\u6279\u91cf\u4e0b\u53d1\u5931\u8d25"));
        }
        return ObjectResponse.success();
    }
}

