/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.NoplateExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.cloudcenter.domain.request.pnc.NotifyPrepayRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.Response;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.ToolsUtil;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.down.pnc.impl.PncNoplateExitServiceImpl;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.third.utils.RedisUtils;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotifyPrepayServiceImpl
implements DownSendService,
NotifyService<NotifyPrepayRequest> {
    private static final Logger log = LoggerFactory.getLogger(NotifyPrepayServiceImpl.class);
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private PncNoplateExitServiceImpl pncNoplateExitService;
    @Autowired
    private MerchantDiscountService merchantDiscountService;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private ParkService parkService;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;
    @Autowired
    private OrderNotpayService orderNotpayService;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        OrderPay orderPay = new OrderPay();
        orderPay.setId(serviceId);
        ObjectResponse objectResponse = this.orderPayService.findOne(orderPay);
        if (!ObjectResponse.isSuccess((Response)objectResponse)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u8ba2\u5355\u4ea4\u6613\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        ObjectResponse.notError((Response)objectResponse);
        OrderPay orderPayRes = (OrderPay)objectResponse.getData();
        ObjectResponse parkResponse = this.parkService.findByParkId(orderPayRes.getParkId());
        String orderId = this.publicHandle.convert2OrderId(sendRequest.getParkId(), orderPayRes.getOrderNum());
        NotifyPrepayRequest notifyPrepayRequest = this.buildRequest(orderPayRes, orderId);
        String channelId = orderPayRes.getChannelId();
        boolean isWait = false;
        String key = "PNC_EXIT_ORDER_PAY_" + sendRequest.getParkId() + "_" + orderId;
        if (StringUtils.isBlank((CharSequence)channelId) && this.redisUtils.exists(key)) {
            ExitPayCautionRequest exitPayCautionRequest = (ExitPayCautionRequest)this.redisUtils.get(key, ExitPayCautionRequest.class);
            log.info("<\u7aef\u7f51\u4e91-\u9884\u7f34\u8d39\u901a\u77e5> \u5b58\u5728\u51fa\u53e3\u9884\u7f34\u8d39\uff0c\u51c6\u5907\u4e0b\u53d1\u51fa\u573a\u62ac\u6746\uff0c\u53c2\u6570\uff1a{}", (Object)exitPayCautionRequest);
            if (exitPayCautionRequest != null) {
                isWait = true;
                channelId = exitPayCautionRequest.getChannelId();
            }
        }
        if (isWait) {
            NotifyPrepayRequest.ExtraInfo extraInfo = NotifyPrepayRequest.ExtraInfo.builder().plateNum(notifyPrepayRequest.getPlateNum()).orderId(orderId).channelId(channelId).build();
            String messageId = this.downHandle.signAndSendAsyncResult(orderPayRes.getParkId(), DownServiceEnum.\u9884\u7f34\u8d39.getServiceName(), notifyPrepayRequest, serviceId, channelId, sendRequest.getRecordId(), sendRequest.getTopic(), JsonUtils.toString((Object)extraInfo));
            if (StringUtils.isEmpty((CharSequence)messageId)) {
                if (StringUtils.isNotEmpty((CharSequence)channelId)) {
                    this.alarmService.switchFailHandler(((Park)parkResponse.getData()).getParkCode(), sendRequest.getParkId(), channelId);
                }
                return ObjectResponse.failed((String)"410", (String)"\u7f34\u8d39\u901a\u77e5\u4e0b\u53d1\u5931\u8d25");
            }
            return ObjectResponse.failed((String)"12002", (String)messageId);
        }
        String messageId = this.downHandle.signAndSend(orderPayRes.getParkId(), DownServiceEnum.\u9884\u7f34\u8d39.getServiceName(), notifyPrepayRequest, serviceId, channelId, sendRequest.getRecordId());
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            if (StringUtils.isNotEmpty((CharSequence)channelId)) {
                this.alarmService.switchFailHandler(((Park)parkResponse.getData()).getParkCode(), sendRequest.getParkId(), channelId);
            }
            return ObjectResponse.failed((String)"410", (String)"\u7f34\u8d39\u901a\u77e5\u4e0b\u53d1\u5931\u8d25");
        }
        return ObjectResponse.success();
    }

    private NotifyPrepayRequest buildRequest(OrderPay orderPay, String orderId) {
        NotifyPrepayRequest notifyPrepayRequest = new NotifyPrepayRequest();
        notifyPrepayRequest.setOrderId(orderId);
        ObjectResponse objectResponse = this.orderService.findByOrderNum(orderPay.getOrderNum());
        if ("200".equals(objectResponse.getCode())) {
            OrderNotpay notPayOrder;
            ObjectResponse validDiscountDay;
            OrderInfo orderInfo = (OrderInfo)objectResponse.getData();
            notifyPrepayRequest.setPlateNum(orderInfo.getPlateNum());
            notifyPrepayRequest.setType(orderInfo.getType());
            notifyPrepayRequest.setCarType(orderInfo.getCarType());
            Long payTime = orderPay.getPayTime();
            Long enterTime = orderInfo.getEnterTime();
            notifyPrepayRequest.setParkTime(Long.valueOf(payTime - enterTime));
            if (StringUtils.isNotBlank((CharSequence)orderPay.getChannelId())) {
                notifyPrepayRequest.setChannelId(orderPay.getChannelId());
            }
            notifyPrepayRequest.setTradeNo(orderPay.getTradeNo());
            notifyPrepayRequest.setTotalPrice(orderPay.getTotalPrice());
            notifyPrepayRequest.setPrepay(orderPay.getPaidPrice());
            notifyPrepayRequest.setDiscountPrice(orderPay.getDiscountPrice());
            ObjectResponse objectResponse2 = this.orderDiscountService.findDiscountNos(orderPay.getTradeNo(), orderPay.getParkId());
            if ("200".equals(objectResponse2.getCode())) {
                notifyPrepayRequest.setDiscountNos((String)((Map)objectResponse2.getData()).get("discountNos"));
            } else if (ToolsUtil.parseFloat((Object)orderPay.getDiscountPrice()).floatValue() > 0.0f && ObjectResponse.isSuccess((Response)(validDiscountDay = this.merchantDiscountService.findValidDiscountDay(orderInfo.getPlateNum(), orderInfo.getParkId(), DateTools.getFormat((Date)orderPay.getPayDate()))))) {
                DiscountDay data = (DiscountDay)validDiscountDay.getData();
                log.info("<\u7aef\u7f51\u4e91-\u9884\u7f34\u8d39\u901a\u77e5> \u4f7f\u7528\u7684\u6309\u5929\u4f18\u514d\u4f18\u60e0\u7f16\u53f7\uff1a{}", (Object)data.getDiscountNo());
                notifyPrepayRequest.setDiscountNos(data.getDiscountNo());
            }
            notifyPrepayRequest.setPayWay(orderPay.getPayWay());
            notifyPrepayRequest.setPayChannel(orderPay.getPayChannel());
            notifyPrepayRequest.setPayTerminal(orderPay.getPayTerminal());
            notifyPrepayRequest.setPayTime(orderPay.getPayTime());
            notifyPrepayRequest.setMerchantTradeNo(orderPay.getThirdTradeNo());
            if (Integer.valueOf(1).equals(orderPay.getPayType()) && (notPayOrder = this.orderNotpayService.getOrderNotpayByOrderNum(orderInfo.getOrderNum())) != null && notPayOrder.getMendPayType() != null) {
                notifyPrepayRequest.setMendPayType(notPayOrder.getMendPayType());
            }
            return notifyPrepayRequest;
        }
        log.info("Dubbo\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u672a\u627e\u5230\u8bb0\u5f55\uff0c\u8ba2\u5355\u53f7\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)orderPay.getOrderNum(), (Object)objectResponse);
        throw new ResponseBodyException(objectResponse.getCode(), "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<NotifyPrepayRequest> sendInfoRecord) {
        NotifyPrepayRequest.ExtraInfo extraInfo = (NotifyPrepayRequest.ExtraInfo)JsonUtils.parseObject((String)sendInfoRecord.getExtraInfo(), NotifyPrepayRequest.ExtraInfo.class, (Class[])new Class[0]);
        if (extraInfo == null) {
            log.info("\u65e0\u9700\u5f02\u6b65\u5904\u7406\uff0c\u76f4\u63a5\u8fd4\u56de\uff0c\u53c2\u6570[{}]", sendInfoRecord);
            return;
        }
        if (!ObjectResponse.isSuccess(response) && extraInfo.getChannelId() != null) {
            this.alarmService.switchFailHandler(sendInfoRecord.getParkCode(), sendInfoRecord.getParkId(), extraInfo.getChannelId());
        }
        NoplateExitRequest noplateExitRequest = new NoplateExitRequest();
        noplateExitRequest.setParkCode(sendInfoRecord.getParkCode());
        noplateExitRequest.setChannelId(extraInfo.getChannelId());
        noplateExitRequest.setExitTime(Long.valueOf(DateTools.unixTimestamp()));
        noplateExitRequest.setPlateNum(extraInfo.getPlateNum());
        try {
            this.pncNoplateExitService.noplateExit(noplateExitRequest);
        }
        catch (ResponseBodyException e) {
            log.info("[\u7aef\u7f51\u4e91-\u9884\u7f34\u8d39\u901a\u77e5] \u51fa\u573a\u62ac\u6746\u5931\u8d25\uff0cmsg\uff1a{}", (Object)e.getMessage());
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"410", (String)"\u51fa\u573a\u62ac\u6746\u5931\u8d25"));
            return;
        }
        this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.success());
    }
}

