/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.DownSendService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.IssuedCardRequest;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.more.MoreMonthInfo;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.more.MoreMonthPlate;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.more.MoreMonthInfoService;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.more.MoreMonthPlateService;
import com.icetech.third.utils.JsonUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MoreMonthCardServiceImpl
implements DownSendService {
    private static final Logger log = LoggerFactory.getLogger(MoreMonthCardServiceImpl.class);
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private MoreMonthInfoService moreMonthInfoService;
    @Autowired
    private MoreMonthParkService moreMonthParkService;
    @Autowired
    private MoreMonthPlateService moreMonthPlateService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    public static final String MORE_MONTH_CARD_PREFIX = "more:month:card:";
    private static final long EXPIRE_TIME_SEND_DEVICES_ = 88860L;

    public ObjectResponse send(SendRequest sendRequest) {
        Long serviceId = sendRequest.getServiceId();
        MoreMonthInfo moreMonthInfo = (MoreMonthInfo)this.moreMonthInfoService.getById(serviceId);
        if (moreMonthInfo == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u591a\u8f66\u573a\u6708\u5361\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        if (StringUtils.isEmpty((CharSequence)sendRequest.getInclude()) && moreMonthInfo.getCardStatus() == 3) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u591a\u8f66\u573a\u6708\u5361\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        List<MoreMonthPark> monthParks = this.moreMonthParkService.getMonthParkByMoreMonthId(serviceId);
        if (CollectionUtils.isEmpty(monthParks)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u591a\u8f66\u573a\u6708\u5361\u6ca1\u6709\u5173\u8054\u8f66\u573a"));
        }
        List<MoreMonthPlate> moreMonthPlates = this.moreMonthPlateService.getMoreMonthPlateByMoreMonthId(serviceId);
        if (CollectionUtils.isEmpty(moreMonthPlates)) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getDefaultMessage((String)"2", (String)"\u591a\u8f66\u573a\u6708\u5361\u6ca1\u6709\u5173\u8054\u8f66\u724c\u53f7"));
        }
        String plateNums = moreMonthPlates.stream().map(MoreMonthPlate::getPlateNum).filter(Objects::nonNull).collect(Collectors.joining(","));
        IssuedCardRequest request = new IssuedCardRequest();
        request.setProdName("\u591a\u8f66\u573a\u6708\u5361");
        request.setProdDuration(Integer.valueOf(1));
        request.setCardId(String.valueOf(serviceId));
        request.setPlateNum(plateNums);
        request.setPhone(moreMonthInfo.getPhone());
        request.setCardOwner(moreMonthInfo.getCardOwner());
        request.setCardProperty(moreMonthInfo.getCardProperty());
        request.setStartDate(DateFormatUtils.format((Date)moreMonthInfo.getStartTime(), (String)"yyyy-MM-dd"));
        request.setEndDate(DateFormatUtils.format((Date)moreMonthInfo.getEndTime(), (String)"yyyy-MM-dd"));
        request.setCardType(Integer.valueOf(1));
        request.setCardOperType(Integer.valueOf(1));
        request.setPlotCount(moreMonthInfo.getPlotCount());
        request.setPayMoney("0.00");
        request.setOperAccount(moreMonthInfo.getOperAccount());
        request.setOperTime(Long.valueOf(moreMonthInfo.getCreateTime().getTime() / 1000L));
        if (StringUtils.isNotEmpty((CharSequence)sendRequest.getInclude())) {
            request.setCardOperType(Integer.valueOf(4));
        }
        log.info("[\u7aef\u7f51\u4e91]\u591a\u8f66\u573a\u6708\u5361\u4e0b\u53d1\u53c2\u6570[{}]", (Object)JsonUtils.toJson((Object)request));
        List<String> parkIds = monthParks.stream().map(MoreMonthPark::getParkId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
        String key = MORE_MONTH_CARD_PREFIX + sendRequest.getTaskId();
        if (!this.stringRedisTemplate.hasKey((Object)key).booleanValue()) {
            this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])parkIds.toArray(new String[0]));
            this.stringRedisTemplate.expire((Object)key, 88860L, TimeUnit.SECONDS);
        }
        for (MoreMonthPark monthPark : monthParks) {
            String messageId = this.downHandle.signAndSend(monthPark.getParkId(), DownServiceEnum.\u591a\u8f66\u573a\u6708\u5361.getServiceName(), request, serviceId, null, sendRequest.getTaskId());
            if (!StringUtils.isEmpty((CharSequence)messageId)) continue;
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.success();
    }
}

