/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.park.service.down.pnc.impl;

import com.icetech.basics.constants.TextConstant;
import com.icetech.cloudcenter.api.NotifyService;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.ModifyFeeRequest;
import com.icetech.cloudcenter.domain.vo.UpdateFeeVo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.component.AsyncNotifyClient;
import com.icetech.park.service.handle.PncDownHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.third.domain.entity.third.SendInfoRecord;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyFeeServiceImpl
implements NotifyService<ModifyFeeRequest> {
    @Autowired
    private PncDownHandle downHandle;
    @Autowired
    private PublicHandle publicHandle;
    @Resource
    private AsyncNotifyClient asyncNotifyClient;

    public ObjectResponse<Void> execute(UpdateFeeVo updateFeeVo) {
        ModifyFeeRequest modifyFeeRequest = new ModifyFeeRequest();
        modifyFeeRequest.setPlateNum(updateFeeVo.getPlateNum());
        modifyFeeRequest.setNewUnpayPrice(updateFeeVo.getNewUnpayPrice());
        modifyFeeRequest.setChannelId(updateFeeVo.getChannelId());
        String orderNum = updateFeeVo.getOrderNum();
        String orderId = this.publicHandle.convert2OrderId(updateFeeVo.getParkId(), orderNum);
        modifyFeeRequest.setOrderId(orderId);
        String messageId = this.downHandle.signAndSendAsyncResult(updateFeeVo.getParkId(), DownServiceEnum.\u4fee\u6539\u505c\u8f66\u8d39\u7528.getServiceName(), modifyFeeRequest, updateFeeVo.getTopic());
        if (messageId == null) {
            return ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection());
        }
        return ObjectResponse.failed((String)"12002", (String)messageId);
    }

    public void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<ModifyFeeRequest> sendInfoRecord) {
        if (ObjectResponse.isSuccess(response)) {
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), response);
        } else {
            this.asyncNotifyClient.callBack(messageId, sendInfoRecord.getTopic(), sendInfoRecord.getEnv(), ObjectResponse.failed((String)"410", (String)TextConstant.getUnEstablishConnection()));
        }
    }
}

